/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.codeInsight.daemon.impl.quickfix.AddUsesDirectiveFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.java.codeserver.core.JavaServiceProviderUtil;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class Java9UndeclaredServiceUsageInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.MODULES);
        if (set == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                Java9UndeclaredServiceUsageInspection.checkMethodCall(expression, holder);
                super.visitMethodCallExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/java19api/Java9UndeclaredServiceUsageInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static void checkMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull ProblemsHolder holder) {
        PsiClass containingClass;
        PsiMethod method;
        String referenceName;
        if (methodCall == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(3);
        }
        if (JavaServiceProviderUtil.JAVA_UTIL_SERVICE_LOADER_METHODS.contains(referenceName = methodCall.getMethodExpression().getReferenceName()) && (method = methodCall.resolveMethod()) != null && method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && "java.util.ServiceLoader".equals(containingClass.getQualifiedName())) {
            Java9UndeclaredServiceUsageInspection.checkServiceUsage(methodCall, holder);
        }
    }

    private static void checkServiceUsage(@NotNull PsiMethodCallExpression methodCall, @NotNull ProblemsHolder holder) {
        PsiJavaModule module;
        String qualifiedName;
        PsiClass psiClass;
        if (methodCall == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(5);
        }
        PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
        PsiExpression argument = null;
        JavaReflectionReferenceUtil.ReflectiveType serviceType = null;
        for (int i = 0; i < arguments.length && serviceType == null; ++i) {
            argument = arguments[i];
            serviceType = JavaReflectionReferenceUtil.getReflectiveType((PsiExpression)argument);
        }
        if (serviceType != null && serviceType.isExact() && (psiClass = serviceType.getPsiClass()) != null && (qualifiedName = psiClass.getQualifiedName()) != null && (module = JavaPsiModuleUtil.findDescriptorByElement((PsiElement)argument)) != null && Java9UndeclaredServiceUsageInspection.isUndeclaredUsage(module, psiClass)) {
            holder.problem((PsiElement)argument, JavaBundle.message((String)"inspection.undeclared.service.usage.message", (Object[])new Object[]{qualifiedName})).fix((ModCommandAction)new AddUsesDirectiveFix(module, qualifiedName)).register();
        }
    }

    private static boolean isUndeclaredUsage(PsiJavaModule module, @NotNull PsiClass serviceClass) {
        if (serviceClass == null) {
            Java9UndeclaredServiceUsageInspection.$$$reportNull$$$0(6);
        }
        for (PsiUsesStatement usesStatement : module.getUses()) {
            PsiClassType usedClass = usesStatement.getClassType();
            if (usedClass == null || !serviceClass.equals((Object)usedClass.resolve())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19api/Java9UndeclaredServiceUsageInspection";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19api/Java9UndeclaredServiceUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodCall";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceUsage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUndeclaredUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

