/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.codeInspection.java19api.ModuleNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

record ModuleInfo(@NotNull PsiDirectory rootDir, @NotNull ModuleNode node) {
    @NotNull
    private final PsiDirectory rootDir;
    @NotNull
    private final ModuleNode node;

    ModuleInfo(@NotNull PsiDirectory rootDir, @NotNull ModuleNode node) {
        if (rootDir == null) {
            ModuleInfo.$$$reportNull$$$0(0);
        }
        if (node == null) {
            ModuleInfo.$$$reportNull$$$0(1);
        }
    }

    boolean fileAlreadyExists() {
        return (Boolean)ReadAction.compute(() -> StreamEx.of((Object[])this.rootDir().getChildren()).select(PsiFile.class).map(PsiFileSystemItem::getName).anyMatch("module-info.java"::equals));
    }

    @NotNull
    CharSequence createModuleText() {
        CharSequence requires = this.requiresText();
        CharSequence exports = this.exportsText();
        StringBuilder stringBuilder = new StringBuilder().append("module").append(" ").append(this.node().getName()).append(" {\n").append(requires).append(!requires.isEmpty() && !exports.isEmpty() ? "\n" : "").append(exports).append("}");
        if (stringBuilder == null) {
            ModuleInfo.$$$reportNull$$$0(2);
        }
        return stringBuilder;
    }

    @NotNull
    private CharSequence requiresText() {
        StringBuilder text = new StringBuilder();
        for (Map.Entry<ModuleNode, Set<ModuleNode.DependencyType>> dependency : this.node().getDependencies().entrySet()) {
            String dependencyName;
            if (dependency.getValue() == null || "java.base".equals(dependencyName = dependency.getKey().getName())) continue;
            boolean isBadSyntax = ContainerUtil.or((Object[])dependencyName.split("\\."), part -> PsiUtil.isKeyword((String)part, (LanguageLevel)LanguageLevel.JDK_1_9));
            text.append(isBadSyntax ? "// " : " ").append("requires").append(' ');
            if (dependency.getValue().contains((Object)ModuleNode.DependencyType.STATIC)) {
                text.append("static").append(' ');
            }
            if (dependency.getValue().contains((Object)ModuleNode.DependencyType.TRANSITIVE)) {
                text.append("transitive").append(' ');
            }
            text.append(dependencyName).append(";\n");
        }
        StringBuilder stringBuilder = text;
        if (stringBuilder == null) {
            ModuleInfo.$$$reportNull$$$0(3);
        }
        return stringBuilder;
    }

    @NotNull
    private CharSequence exportsText() {
        StringBuilder text = new StringBuilder();
        for (String packageName : this.node().getExports()) {
            text.append("exports").append(' ').append(packageName).append(";\n");
        }
        StringBuilder stringBuilder = text;
        if (stringBuilder == null) {
            ModuleInfo.$$$reportNull$$$0(4);
        }
        return stringBuilder;
    }

    @NotNull
    public PsiDirectory rootDir() {
        PsiDirectory psiDirectory = this.rootDir;
        if (psiDirectory == null) {
            ModuleInfo.$$$reportNull$$$0(5);
        }
        return psiDirectory;
    }

    @NotNull
    public ModuleNode node() {
        ModuleNode moduleNode = this.node;
        if (moduleNode == null) {
            ModuleInfo.$$$reportNull$$$0(6);
        }
        return moduleNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19api/ModuleInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19api/ModuleInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "requiresText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "exportsText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "rootDir";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

