/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.java.analysis.bytecode.JvmBytecodeDeclarationProcessor;
import com.intellij.java.analysis.bytecode.JvmBytecodeReferenceProcessor;
import com.intellij.java.analysis.bytecode.JvmClassBytecodeDeclaration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

class ModuleVisitor
implements JvmBytecodeDeclarationProcessor,
JvmBytecodeReferenceProcessor {
    private final Set<String> myRequiredPackages;
    private final Set<String> myDeclaredPackages;
    private final Function<String, String> myCheckPackage;

    ModuleVisitor(@NotNull Function<String, String> checkPackage) {
        if (checkPackage == null) {
            ModuleVisitor.$$$reportNull$$$0(0);
        }
        this.myRequiredPackages = new HashSet<String>();
        this.myDeclaredPackages = new HashSet<String>();
        this.myCheckPackage = checkPackage;
    }

    public void processClassReference(@NotNull JvmClassBytecodeDeclaration targetClass, @NotNull JvmClassBytecodeDeclaration sourceClass) {
        String className;
        String packageName;
        if (targetClass == null) {
            ModuleVisitor.$$$reportNull$$$0(1);
        }
        if (sourceClass == null) {
            ModuleVisitor.$$$reportNull$$$0(2);
        }
        if ((packageName = this.myCheckPackage.apply(className = targetClass.getTopLevelSourceClassName())) != null) {
            this.myRequiredPackages.add(packageName);
        }
    }

    public void processClass(@NotNull JvmClassBytecodeDeclaration jvmClass) {
        String packageName;
        if (jvmClass == null) {
            ModuleVisitor.$$$reportNull$$$0(3);
        }
        if ((packageName = this.myCheckPackage.apply(jvmClass.getTopLevelSourceClassName())) != null) {
            this.myDeclaredPackages.add(packageName);
        }
    }

    Set<String> getRequiredPackages() {
        return this.myRequiredPackages;
    }

    Set<String> getDeclaredPackages() {
        return this.myDeclaredPackages;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/java19api/ModuleVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processClassReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

