/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsContexts;

class ProgressTracker {
    private ProgressIndicator myIndicator;
    private int myCount;
    private int mySize;
    private int myPhase;
    private double myUpToNow;
    private final double[] myPhases;

    public ProgressTracker(double ... phases) {
        this.myPhases = phases;
    }

    public void startPhase(@NlsContexts.ProgressText String text, int size) {
        this.myIndicator.setText(text);
        this.myCount = 0;
        this.mySize = Math.min(size, 1);
    }

    public void nextPhase() {
        this.myUpToNow += this.myPhases[this.myPhase++];
    }

    public void increment() {
        this.myIndicator.setFraction(this.myUpToNow + this.myPhases[this.myPhase] * (double)(++this.myCount) / (double)this.mySize);
    }

    public void init(ProgressIndicator indicator) {
        this.myIndicator = indicator;
        this.myIndicator.setFraction(0.0);
        this.myIndicator.setIndeterminate(false);
    }

    public void dispose() {
        this.myIndicator = null;
    }
}

