/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.lambdaToExplicit;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.lambdaToExplicit.LambdaAndExplicitMethodPair;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ExplicitArgumentCanBeLambdaInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.LAMBDA_EXPRESSIONS);
        if (set == null) {
            ExplicitArgumentCanBeLambdaInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ExplicitArgumentCanBeLambdaInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (LambdaAndExplicitMethodPair info : LambdaAndExplicitMethodPair.INFOS) {
                    PsiExpression arg = info.getLambdaCandidateFromExplicitCall(call);
                    if (arg == null || arg instanceof PsiEmptyExpressionImpl || ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)arg)) continue;
                    holder.registerProblem((PsiElement)arg, JavaBundle.message((String)"inspection.explicit.argument.can.be.lambda.message", (Object[])new Object[0]), new LocalQuickFix[]{new ConvertExplicitCallToLambdaFix(info, info.getLambdaMethodName(call))});
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/lambdaToExplicit/ExplicitArgumentCanBeLambdaInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/lambdaToExplicit/ExplicitArgumentCanBeLambdaInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/lambdaToExplicit/ExplicitArgumentCanBeLambdaInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ConvertExplicitCallToLambdaFix
    extends PsiUpdateModCommandQuickFix {
        private final LambdaAndExplicitMethodPair myInfo;
        private final String myName;

        ConvertExplicitCallToLambdaFix(LambdaAndExplicitMethodPair info, String name) {
            this.myInfo = info;
            this.myName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.explicit.argument.can.be.lambda.fix.name", (Object[])new Object[]{this.myName});
            if (string == null) {
                ConvertExplicitCallToLambdaFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.explicit.argument.can.be.lambda.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ConvertExplicitCallToLambdaFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiExpression arg;
            if (project == null) {
                ConvertExplicitCallToLambdaFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ConvertExplicitCallToLambdaFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ConvertExplicitCallToLambdaFix.$$$reportNull$$$0(4);
            }
            if ((arg = (PsiExpression)ObjectUtils.tryCast((Object)element, PsiExpression.class)) == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)arg, PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            Object[] args = call.getArgumentList().getExpressions();
            int idx = ArrayUtil.indexOf((Object[])args, (Object)arg);
            if (idx < 0) {
                return;
            }
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)call, (String)this.myName);
            String lambdaText = this.myInfo.makeLambda(arg);
            PsiLambdaExpression lambda = (PsiLambdaExpression)arg.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(lambdaText, (PsiElement)arg));
            LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference((PsiLambdaExpression)lambda);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/lambdaToExplicit/ExplicitArgumentCanBeLambdaInspection$ConvertExplicitCallToLambdaFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/lambdaToExplicit/ExplicitArgumentCanBeLambdaInspection$ConvertExplicitCallToLambdaFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

