/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.performance;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PatternUtil;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public final class ReplaceAllNonRegexInspection
extends BaseInspection {
    private static final CallMatcher.Simple REPLACE_ALL = CallMatcher.instanceCall((String)"java.lang.String", (String[])new String[]{"replaceAll"}).parameterTypes(new String[]{"java.lang.String", "java.lang.String"});

    @NotNull
    public String buildErrorString(Object ... infos) {
        if (infos == null) {
            ReplaceAllNonRegexInspection.$$$reportNull$$$0(0);
        }
        String string = JavaBundle.message((String)"inspection.replace.all.non.regex.problem.descriptor", (Object[])new Object[0]);
        if (string == null) {
            ReplaceAllNonRegexInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(expression);
                if (PsiUtil.getLanguageLevel((PsiElement)expression).isLessThan(LanguageLevel.JDK_1_5)) {
                    return;
                }
                if (!REPLACE_ALL.test(expression)) {
                    return;
                }
                if (!ReplaceAllNonRegexInspection.isMigratableArgument(expression, 0, (Condition<String>)((Condition)PatternUtil::containsMetaChar))) {
                    return;
                }
                if (!ReplaceAllNonRegexInspection.isMigratableArgument(expression, 1, (Condition<String>)((Condition)replacement -> StringUtil.containsAnyChar((String)replacement, (String)"\\$")))) {
                    return;
                }
                this.registerMethodCallError(expression, new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/performance/ReplaceAllNonRegexInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static boolean isMigratableArgument(PsiMethodCallExpression call, int index, Condition<String> failCondition) {
        PsiExpression argument = call.getArgumentList().getExpressions()[index];
        Object constant = ExpressionUtils.computeConstantExpression((PsiExpression)argument);
        if (!(constant instanceof String)) {
            return false;
        }
        String text = (String)constant;
        return !failCondition.value((Object)text);
    }

    protected LocalQuickFix buildFix(Object ... infos) {
        if (infos == null) {
            ReplaceAllNonRegexInspection.$$$reportNull$$$0(2);
        }
        return new PsiUpdateModCommandQuickFix(this){

            @NotNull
            public String getFamilyName() {
                String string = JavaBundle.message((String)"inspection.replace.all.non.regex.quickfix", (Object[])new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
                PsiMethodCallExpression call;
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (updater == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (!REPLACE_ALL.test(call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class))) {
                    return;
                }
                PsiElement namedElement = call.getMethodExpression().getReferenceNameElement();
                if (namedElement == null) {
                    return;
                }
                namedElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createIdentifier("replace"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/performance/ReplaceAllNonRegexInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/performance/ReplaceAllNonRegexInspection$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/performance/ReplaceAllNonRegexInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/performance/ReplaceAllNonRegexInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildErrorString";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

