/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInsight.daemon.impl.quickfix.AddExportsDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddOpensDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddRequiresDirectiveFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class Java9ReflectionClassVisibilityInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.MODULES);
        if (set == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiJavaModule javaModule;
        if (holder == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(1);
        }
        if ((javaModule = JavaPsiModuleUtil.findDescriptorByElement((PsiElement)holder.getFile())) != null) {
            return new JavaElementVisitor(this){

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitMethodCallExpression(expression);
                    if (JavaReflectionReferenceUtil.isCallToMethod((PsiMethodCallExpression)expression, (String)"java.lang.Class", (String)"forName") || JavaReflectionReferenceUtil.isCallToMethod((PsiMethodCallExpression)expression, (String)"java.lang.ClassLoader", (String)"loadClass")) {
                        Java9ReflectionClassVisibilityInspection.checkClassVisibility(expression, holder, javaModule);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection$1", "visitMethodCallExpression"));
                }
            };
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    private static void checkClassVisibility(@NotNull PsiMethodCallExpression callExpression, @NotNull ProblemsHolder holder, @NotNull PsiJavaModule javaModule) {
        PsiJavaModule otherModule;
        Project project;
        JavaPsiFacade facade;
        PsiClass psiClass;
        PsiExpression classNameArgument;
        String className;
        PsiExpression[] arguments;
        if (callExpression == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(4);
        }
        if (javaModule == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(5);
        }
        if ((arguments = callExpression.getArgumentList().getExpressions()).length != 0 && (className = (String)JavaReflectionReferenceUtil.computeConstantExpression((PsiExpression)(classNameArgument = arguments[0]), String.class)) != null && (psiClass = (facade = JavaPsiFacade.getInstance((Project)(project = holder.getProject()))).findClass(className, callExpression.getResolveScope())) != null && (otherModule = JavaPsiModuleUtil.findDescriptorByElement((PsiElement)psiClass)) != null && otherModule != javaModule) {
            if (!JavaPsiModuleUtil.reads((PsiJavaModule)javaModule, (PsiJavaModule)otherModule)) {
                String message = JavaBundle.message((String)"module.not.in.requirements", (Object[])new Object[]{javaModule.getName(), otherModule.getName()});
                holder.problem((PsiElement)classNameArgument, message).fix((ModCommandAction)new AddRequiresDirectiveFix(javaModule, otherModule.getName())).register();
                return;
            }
            if (otherModule.hasModifierProperty("open")) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiJavaFile.class);
            if (file != null) {
                String packageName = file.getPackageName();
                if (Java9ReflectionClassVisibilityInspection.isPackageAccessible(otherModule.getOpens(), packageName, javaModule)) {
                    return;
                }
                boolean publicApi = Java9ReflectionClassVisibilityInspection.isPublicApi(psiClass);
                if (publicApi && Java9ReflectionClassVisibilityInspection.isPackageAccessible(otherModule.getExports(), packageName, javaModule)) {
                    return;
                }
                if (publicApi) {
                    String message = JavaBundle.message((String)"module.package.not.exported", (Object[])new Object[]{otherModule.getName(), packageName, javaModule.getName()});
                    holder.problem((PsiElement)classNameArgument, message).fix((ModCommandAction)new AddExportsDirectiveFix(otherModule, packageName, javaModule.getName())).register();
                } else {
                    String message = JavaBundle.message((String)"module.package.not.open", (Object[])new Object[]{otherModule.getName(), packageName, javaModule.getName()});
                    holder.problem((PsiElement)classNameArgument, message).fix((ModCommandAction)new AddOpensDirectiveFix(otherModule, packageName, javaModule.getName())).register();
                }
            }
        }
    }

    private static boolean isPackageAccessible(@NotNull Iterable<? extends PsiPackageAccessibilityStatement> statements, @NotNull String packageName, @NotNull PsiJavaModule javaModule) {
        if (statements == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(6);
        }
        if (packageName == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(7);
        }
        if (javaModule == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(8);
        }
        for (PsiPackageAccessibilityStatement psiPackageAccessibilityStatement : statements) {
            List moduleNames;
            if (!packageName.equals(psiPackageAccessibilityStatement.getPackageName()) || !(moduleNames = psiPackageAccessibilityStatement.getModuleNames()).isEmpty() && !moduleNames.contains(javaModule.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isPublicApi(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            Java9ReflectionClassVisibilityInspection.$$$reportNull$$$0(9);
        }
        if (psiClass.hasModifierProperty("public") || psiClass.hasModifierProperty("protected")) {
            PsiElement parent = psiClass.getParent();
            return parent instanceof PsiJavaFile || parent instanceof PsiClass && Java9ReflectionClassVisibilityInspection.isPublicApi((PsiClass)parent);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkClassVisibility";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPackageAccessible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPublicApi";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

