/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaReflectionInvocationInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String JAVA_LANG_REFLECT_METHOD = "java.lang.reflect.Method";
    private static final String JAVA_LANG_REFLECT_CONSTRUCTOR = "java.lang.reflect.Constructor";
    private static final String INVOKE = "invoke";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JavaReflectionInvocationInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression methodCall) {
                if (methodCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(methodCall);
                if (JavaReflectionReferenceUtil.isCallToMethod((PsiMethodCallExpression)methodCall, (String)JavaReflectionInvocationInspection.JAVA_LANG_REFLECT_METHOD, (String)JavaReflectionInvocationInspection.INVOKE)) {
                    JavaReflectionInvocationInspection.checkReflectionCall(methodCall, 1, holder, JavaReflectionInvocationInspection::isReflectionMethod);
                } else if (JavaReflectionReferenceUtil.isCallToMethod((PsiMethodCallExpression)methodCall, (String)JavaReflectionInvocationInspection.JAVA_LANG_REFLECT_CONSTRUCTOR, (String)"newInstance")) {
                    JavaReflectionInvocationInspection.checkReflectionCall(methodCall, 0, holder, JavaReflectionInvocationInspection::isReflectionConstructor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionInvocationInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static boolean isReflectionMethod(PsiMethodCallExpression callExpression) {
        return JavaReflectionReferenceUtil.isCallToMethod((PsiMethodCallExpression)callExpression, (String)"java.lang.Class", (String)"getMethod") || JavaReflectionReferenceUtil.isCallToMethod((PsiMethodCallExpression)callExpression, (String)"java.lang.Class", (String)"getDeclaredMethod");
    }

    private static boolean isReflectionConstructor(PsiMethodCallExpression callExpression) {
        return JavaReflectionReferenceUtil.isCallToMethod((PsiMethodCallExpression)callExpression, (String)"java.lang.Class", (String)"getConstructor") || JavaReflectionReferenceUtil.isCallToMethod((PsiMethodCallExpression)callExpression, (String)"java.lang.Class", (String)"getDeclaredConstructor");
    }

    private static void checkReflectionCall(@NotNull PsiMethodCallExpression methodCall, int argumentOffset, @NotNull ProblemsHolder holder, @NotNull Predicate<? super PsiMethodCallExpression> methodPredicate) {
        PsiExpressionList argumentList;
        Arguments actualArguments;
        List<PsiExpression> requiredTypes;
        if (methodCall == null) {
            JavaReflectionInvocationInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            JavaReflectionInvocationInspection.$$$reportNull$$$0(2);
        }
        if (methodPredicate == null) {
            JavaReflectionInvocationInspection.$$$reportNull$$$0(3);
        }
        if ((requiredTypes = JavaReflectionInvocationInspection.getRequiredMethodArguments(methodCall.getMethodExpression().getQualifierExpression(), argumentOffset, methodPredicate)) != null && (actualArguments = JavaReflectionInvocationInspection.getActualMethodArguments((argumentList = methodCall.getArgumentList()).getExpressions(), argumentOffset, MethodCallUtils.isVarArgCall((PsiCall)methodCall))) != null) {
            PsiExpression[] actualExpressions = actualArguments.expressions;
            if (requiredTypes.size() != actualExpressions.length) {
                if (actualArguments.varargAsArray) {
                    PsiExpression[] expressions = argumentList.getExpressions();
                    PsiExpressionList element = expressions.length == argumentOffset + 1 ? expressions[argumentOffset] : argumentList;
                    holder.registerProblem((PsiElement)element, JavaBundle.message((String)"inspection.reflection.invocation.item.count", (Object[])new Object[]{requiredTypes.size()}), new LocalQuickFix[0]);
                } else if (actualExpressions.length > 0) {
                    TextRange range = actualExpressions[0].getTextRangeInParent().union(actualExpressions[actualExpressions.length - 1].getTextRangeInParent());
                    holder.registerProblem((PsiElement)argumentList, range, JavaBundle.message((String)"inspection.reflection.invocation.reflective.argument.count", (Object[])new Object[]{requiredTypes.size()}), new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)argumentList, JavaBundle.message((String)"inspection.reflection.invocation.reflective.argument.count", (Object[])new Object[]{requiredTypes.size()}), new LocalQuickFix[0]);
                }
                return;
            }
            for (int i = 0; i < requiredTypes.size(); ++i) {
                PsiExpression argument;
                JavaReflectionReferenceUtil.ReflectiveType requiredType = JavaReflectionReferenceUtil.getReflectiveType((PsiExpression)requiredTypes.get(i));
                if (requiredType == null || (argument = actualExpressions[i]) == null) continue;
                PsiType actualType = argument.getType();
                if (TypeUtils.isJavaLangObject((PsiType)actualType) && !requiredType.isAssignableFrom(actualType) && PsiPolyExpressionUtil.isPolyExpression((PsiExpression)argument)) {
                    actualType = ((PsiExpression)argument.copy()).getType();
                }
                if (actualType == null || requiredType.isAssignableFrom(actualType)) continue;
                if (PsiTreeUtil.isAncestor((PsiElement)argumentList, (PsiElement)argument, (boolean)false)) {
                    holder.registerProblem((PsiElement)argument, JavaBundle.message((String)(actualArguments.varargAsArray ? "inspection.reflection.invocation.item.not.assignable" : "inspection.reflection.invocation.argument.not.assignable"), (Object[])new Object[]{requiredType.getQualifiedName()}), new LocalQuickFix[0]);
                    continue;
                }
                PsiExpression[] expressions = argumentList.getExpressions();
                PsiExpressionList element = expressions.length == argumentOffset + 1 ? expressions[argumentOffset] : argumentList;
                holder.registerProblem((PsiElement)element, JavaBundle.message((String)"inspection.reflection.invocation.array.not.assignable", (Object[])new Object[]{actualExpressions.length}), new LocalQuickFix[0]);
                break;
            }
        }
    }

    @Nullable
    private static List<PsiExpression> getRequiredMethodArguments(@Nullable PsiExpression qualifier, int argumentOffset, @NotNull Predicate<? super PsiMethodCallExpression> methodPredicate) {
        PsiMethodCallExpression definitionCall;
        PsiExpression definition;
        if (methodPredicate == null) {
            JavaReflectionInvocationInspection.$$$reportNull$$$0(4);
        }
        if ((definition = JavaReflectionReferenceUtil.findDefinition((PsiExpression)PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier))) instanceof PsiMethodCallExpression && methodPredicate.test((PsiMethodCallExpression)(definitionCall = (PsiMethodCallExpression)definition))) {
            return JavaLangClassMemberReference.getReflectionMethodArguments((PsiMethodCallExpression)definitionCall, (int)argumentOffset);
        }
        return null;
    }

    @Nullable
    static Arguments getActualMethodArguments(PsiExpression[] arguments, int argumentOffset, boolean isVarArgCall) {
        if (!isVarArgCall) {
            List expressions;
            if (arguments.length == argumentOffset + 1 && (expressions = JavaReflectionReferenceUtil.getVarargs((PsiExpression)arguments[argumentOffset])) != null) {
                return new Arguments(expressions.toArray(PsiExpression.EMPTY_ARRAY), true);
            }
        } else if (arguments.length >= argumentOffset) {
            PsiExpression[] expressions = argumentOffset != 0 ? Arrays.copyOfRange(arguments, argumentOffset, arguments.length) : arguments;
            for (int i = 0; i < expressions.length; ++i) {
                PsiExpression castOperand = JavaReflectionInvocationInspection.unwrapDisambiguatingCastToObject(expressions[i]);
                if (castOperand == null) continue;
                expressions[i] = castOperand;
            }
            return new Arguments(expressions, false);
        }
        return null;
    }

    @Nullable
    private static PsiExpression unwrapDisambiguatingCastToObject(@Nullable PsiExpression expression) {
        PsiTypeCastExpression typeCast;
        PsiTypeElement castElement;
        if (expression instanceof PsiTypeCastExpression && (castElement = (typeCast = (PsiTypeCastExpression)expression).getCastType()) != null && castElement.getType().equalsToText("java.lang.Object")) {
            return typeCast.getOperand();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodPredicate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/reflectiveAccess/JavaReflectionInvocationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReflectionCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRequiredMethodArguments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    record Arguments(PsiExpression[] expressions, boolean varargAsArray) {
    }
}

