/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sillyAssignment;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SillyAssignmentInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static LocalQuickFix createRemoveAssignmentFix(PsiExpression expression) {
        PsiVariable variable;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (parent instanceof PsiVariable && (variable = (PsiVariable)parent).hasModifierProperty("final")) {
            return null;
        }
        return new RemoveSillyAssignmentFix();
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "SillyAssignment";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SillyAssignmentInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                SillyAssignmentInspection.checkSillyAssignment(expression, holder);
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.visitElement((PsiElement)expression);
            }

            public void visitVariable(@NotNull PsiVariable variable) {
                PsiExpression initializer;
                if (variable == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((initializer = PsiUtil.deparenthesizeExpression((PsiExpression)variable.getInitializer())) instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)initializer;
                    if (assignment.getOperationTokenType() != JavaTokenType.EQ) {
                        return;
                    }
                    this.checkExpression(variable, PsiUtil.deparenthesizeExpression((PsiExpression)assignment.getLExpression()));
                } else {
                    this.checkExpression(variable, initializer);
                }
            }

            private void checkExpression(PsiVariable variable, PsiExpression expression) {
                if (!(expression instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression refExpr = (PsiReferenceExpression)expression;
                PsiExpression qualifier = refExpr.getQualifierExpression();
                if ((qualifier == null || qualifier instanceof PsiQualifiedExpression || variable.hasModifierProperty("static")) && refExpr.isReferenceTo((PsiElement)variable)) {
                    holder.registerProblem((PsiElement)refExpr, JavaBundle.message((String)"assignment.to.declared.variable.problem.descriptor", (Object[])new Object[]{variable.getName()}), LocalQuickFix.notNullElements((LocalQuickFix)SillyAssignmentInspection.createRemoveAssignmentFix((PsiExpression)refExpr)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVariable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void checkSillyAssignment(@NotNull PsiAssignmentExpression assignment, @NotNull ProblemsHolder holder) {
        if (assignment == null) {
            SillyAssignmentInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            SillyAssignmentInspection.$$$reportNull$$$0(2);
        }
        if (assignment.getOperationTokenType() != JavaTokenType.EQ) {
            return;
        }
        PsiExpression leftExpression = assignment.getLExpression();
        PsiExpression rightExpression = assignment.getRExpression();
        if (rightExpression == null) {
            return;
        }
        PsiExpression leftArrayExpressionOrItself = SillyAssignmentInspection.getArrayExpressionOrItself(leftExpression = PsiUtil.deparenthesizeExpression((PsiExpression)leftExpression));
        if (!(leftArrayExpressionOrItself instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression lRef = (PsiReferenceExpression)leftArrayExpressionOrItself;
        PsiElement resolved = lRef.resolve();
        if (!(resolved instanceof PsiVariable)) {
            return;
        }
        PsiVariable variable = (PsiVariable)resolved;
        rightExpression = SillyAssignmentInspection.deparenthesizeRExpr(rightExpression, variable);
        PsiExpression rightArrayExpressionOrItself = SillyAssignmentInspection.getArrayExpressionOrItself(rightExpression);
        if (!(rightArrayExpressionOrItself instanceof PsiReferenceExpression)) {
            if (!(rightArrayExpressionOrItself instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression rAssignmentExpression = (PsiAssignmentExpression)rightArrayExpressionOrItself;
            rightExpression = SillyAssignmentInspection.deparenthesizeRExpr(rAssignmentExpression.getLExpression(), variable);
        }
        if (rightExpression == null) {
            return;
        }
        EquivalenceChecker checker = EquivalenceChecker.getCanonicalPsiEquivalence();
        if (!checker.expressionsAreEquivalent(leftExpression, rightExpression) || SideEffectChecker.mayHaveSideEffects((PsiExpression)leftExpression)) {
            return;
        }
        String message = leftExpression instanceof PsiArrayAccessExpression ? JavaBundle.message((String)"assignment.array.element.to.itself.problem.descriptor", (Object[])new Object[0]) : JavaBundle.message((String)"assignment.to.itself.problem.descriptor", (Object[])new Object[]{variable.getName()});
        holder.registerProblem((PsiElement)rightExpression, message, new LocalQuickFix[]{SillyAssignmentInspection.createRemoveAssignmentFix(rightExpression)});
    }

    private static PsiExpression getArrayExpressionOrItself(PsiExpression expression) {
        return expression instanceof PsiArrayAccessExpression ? ((PsiArrayAccessExpression)expression).getArrayExpression() : expression;
    }

    private static PsiExpression deparenthesizeRExpr(PsiExpression rExpression, PsiVariable variable) {
        if ((rExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)rExpression)) instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)rExpression;
            PsiExpression operand = typeCastExpression.getOperand();
            PsiTypeElement castTypeElement = typeCastExpression.getCastType();
            if (castTypeElement == null || operand == null) {
                return null;
            }
            PsiType castType = castTypeElement.getType();
            if (castType instanceof PsiPrimitiveType) {
                if (variable.getType().equalsToText("java.lang.Object")) {
                    return rExpression;
                }
                if (TypeUtils.isNarrowingConversion((PsiType)operand.getType(), (PsiType)castType)) {
                    return null;
                }
            }
            return SillyAssignmentInspection.deparenthesizeRExpr(operand, variable);
        }
        return rExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSillyAssignment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RemoveSillyAssignmentFix
    extends PsiUpdateModCommandQuickFix {
        private RemoveSillyAssignmentFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"assignment.to.itself.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveSillyAssignmentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiExpression expression;
            if (project == null) {
                RemoveSillyAssignmentFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                RemoveSillyAssignmentFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveSillyAssignmentFix.$$$reportNull$$$0(3);
            }
            if (!(SillyAssignmentInspection.getArrayExpressionOrItself(expression = (PsiExpression)ObjectUtils.tryCast((Object)element, PsiExpression.class)) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
            if (parent instanceof PsiVariable) {
                expression.delete();
            } else if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiElement grandParent = PsiUtil.skipParenthesizedExprUp((PsiElement)assignmentExpression.getParent());
                if (grandParent instanceof PsiAssignmentExpression) {
                    grandParent.replace((PsiElement)assignmentExpression);
                } else if (grandParent instanceof PsiExpressionStatement) {
                    grandParent.delete();
                } else if (grandParent instanceof PsiVariable) {
                    PsiVariable variable = (PsiVariable)grandParent;
                    PsiExpression rhs = assignmentExpression.getRExpression();
                    variable.setInitializer(rhs == null ? null : (PsiExpression)rhs.copy());
                } else {
                    assignmentExpression.replace((PsiElement)expression);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection$RemoveSillyAssignmentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection$RemoveSillyAssignmentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

