/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.makefinal.EffectivelyFinalFixer;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.java.JavaBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ConvertToStreamFixer
implements EffectivelyFinalFixer {
    public boolean isAvailable(@NotNull PsiLocalVariable var) {
        if (var == null) {
            ConvertToStreamFixer.$$$reportNull$$$0(0);
        }
        return ConvertToStreamFixer.createModel(var) != null;
    }

    public void fix(@NotNull PsiLocalVariable var) {
        StreamModel model;
        if (var == null) {
            ConvertToStreamFixer.$$$reportNull$$$0(1);
        }
        if ((model = ConvertToStreamFixer.createModel(var)) == null) {
            return;
        }
        PsiElement element = model.migration().migrate(var.getProject(), (PsiElement)model.body(), model.tb());
        MigrateToStreamFix.simplify(var.getProject(), element);
    }

    public String getText(@NotNull PsiLocalVariable var) {
        if (var == null) {
            ConvertToStreamFixer.$$$reportNull$$$0(2);
        }
        return JavaBundle.message((String)"intention.make.final.fixer.stream", (Object[])new Object[]{var.getName()});
    }

    private static StreamModel createModel(PsiLocalVariable var) {
        PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)var, null);
        if (block == null) {
            return null;
        }
        List references = VariableAccessUtils.getVariableReferences((PsiVariable)var);
        List writes = ContainerUtil.filter((Collection)references, PsiUtil::isAccessedForWriting);
        if (writes.isEmpty()) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((List)writes);
        if (commonParent == null) {
            return null;
        }
        while (commonParent.getParent() != block) {
            if ((commonParent = commonParent.getParent()) != null) continue;
            return null;
        }
        if (!(commonParent instanceof PsiLoopStatement)) {
            return null;
        }
        PsiLoopStatement statement = (PsiLoopStatement)commonParent;
        PsiStatement body = statement.getBody();
        if (body == null) {
            return null;
        }
        StreamApiMigrationInspection.StreamSource source = StreamApiMigrationInspection.StreamSource.tryCreate(statement);
        if (source == null) {
            return null;
        }
        if (!ExceptionUtil.getThrownCheckedExceptions((PsiElement[])new PsiElement[]{body}).isEmpty()) {
            return null;
        }
        TerminalBlock tb = TerminalBlock.from(source, body);
        BaseStreamApiMigration migration = StreamApiMigrationInspection.findMigration((PsiStatement)statement, (PsiElement)body, tb, false, false);
        if (migration == null) {
            return null;
        }
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)var, (PsiStatement)statement);
        if (status != ControlFlowUtils.InitializerUsageStatus.DECLARED_JUST_BEFORE && status != ControlFlowUtils.InitializerUsageStatus.AT_WANTED_PLACE_ONLY) {
            return null;
        }
        return new StreamModel(migration, body, tb);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "var";
        objectArray2[1] = "com/intellij/codeInspection/streamMigration/ConvertToStreamFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record StreamModel(BaseStreamApiMigration migration, PsiStatement body, TerminalBlock tb) {
    }
}

