/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.ForEachMigration;
import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimplifyForEachInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher.Simple ITERABLE_FOREACH = CallMatcher.instanceCall((String)"java.lang.Iterable", (String[])new String[]{"forEach"}).parameterCount(1);
    private static final CallMatcher.Simple STREAM_FOREACH_ORDERED = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"forEachOrdered"}).parameterCount(1);
    private static final CallMatcher STREAM_FOREACH = CallMatcher.instanceCall((String)"java.util.stream.BaseStream", (String[])new String[]{"forEach", "forEachOrdered"}).parameterCount(1);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
        if (string == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ADVANCED_COLLECTIONS_API);
        if (set == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                boolean lastOpChanged;
                SimplifyForEachContext context;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((context = SimplifyForEachContext.from(call)) == null) {
                    return;
                }
                boolean opCountChanged = context.myTerminalBlock.getOperationCount() > 1;
                boolean bl = lastOpChanged = !(context.myMigration instanceof ForEachMigration);
                if (opCountChanged || lastOpChanged) {
                    String customMessage = lastOpChanged ? CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{context.myMigration.getReplacement() + "()"}) : JavaBundle.message((String)"inspection.simplify.for.each.extract.intermediate.operations", (Object[])new Object[0]);
                    ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    holder.registerProblem((PsiElement)context.myMainStatement, customMessage, highlightType, SimplifyForEachInspection.getRange(call).shiftRight(-call.getTextOffset()), new LocalQuickFix[]{new SimplifyForEachFix(customMessage)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    @NotNull
    private static TextRange getRange(PsiMethodCallExpression call) {
        if (!InspectionProjectProfileManager.isInformationLevel((String)"SimplifyForEach", (PsiElement)call)) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            return new TextRange(methodExpression.getTextOffset(), call.getArgumentList().getTextOffset());
        }
        TextRange textRange = call.getTextRange();
        if (textRange == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Nullable
    static TerminalBlock extractTerminalBlock(@Nullable PsiElement lambdaBody, @NotNull ExistingStreamSource source) {
        if (source == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(4);
        }
        if (lambdaBody instanceof PsiCodeBlock) {
            return TerminalBlock.from((StreamApiMigrationInspection.StreamSource)source, (PsiCodeBlock)lambdaBody);
        }
        if (lambdaBody instanceof PsiExpression) {
            return TerminalBlock.fromStatements(source, new PsiStatement[]{new LightExpressionStatement((PsiExpression)lambdaBody)});
        }
        return null;
    }

    @Nullable
    static PsiLambdaExpression extractLambdaFromForEach(@NotNull PsiMethodCallExpression call) {
        PsiExpression qualifier;
        if (call == null) {
            SimplifyForEachInspection.$$$reportNull$$$0(5);
        }
        if ((qualifier = call.getMethodExpression().getQualifierExpression()) == null || !STREAM_FOREACH.test(call) && !SimplifyForEachInspection.isCollectionForEach(call, qualifier)) {
            return null;
        }
        PsiExpression arg = call.getArgumentList().getExpressions()[0];
        return (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiLambdaExpression.class);
    }

    private static boolean isCollectionForEach(PsiMethodCallExpression call, PsiExpression qualifier) {
        return ITERABLE_FOREACH.test(call) && InheritanceUtil.isInheritor((PsiType)qualifier.getType(), (String)"java.util.Collection");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractTerminalBlock";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractLambdaFromForEach";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    static class LightExpressionStatement
    extends LightElement
    implements PsiExpressionStatement {
        @NotNull
        private final PsiExpression myExpression;

        protected LightExpressionStatement(@NotNull PsiExpression expression) {
            if (expression == null) {
                LightExpressionStatement.$$$reportNull$$$0(0);
            }
            super(expression.getManager(), (Language)JavaLanguage.INSTANCE);
            this.myExpression = expression;
        }

        @NotNull
        public PsiExpression getExpression() {
            PsiExpression psiExpression = this.myExpression;
            if (psiExpression == null) {
                LightExpressionStatement.$$$reportNull$$$0(1);
            }
            return psiExpression;
        }

        public String toString() {
            return this.myExpression.getText() + ";";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$LightExpressionStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$LightExpressionStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ForEachNonFinalFix
    extends PsiUpdateModCommandAction<PsiElement> {
        @Nullable
        private final PsiElement myContext;
        @Nls
        private final String myMessage;

        public ForEachNonFinalFix(@Nullable PsiElement context) {
            super(PsiElement.class);
            SimplifyForEachContext simplifyContext = ForEachNonFinalFix.findMigration(context);
            if (simplifyContext == null) {
                this.myContext = null;
                this.myMessage = null;
            } else {
                this.myContext = context;
                this.myMessage = JavaBundle.message((String)"quickfix.text.avoid.mutation.using.stream.api.0.operation", (Object[])new Object[]{simplifyContext.myMigration.getReplacement()});
            }
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
            if (context == null) {
                ForEachNonFinalFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ForEachNonFinalFix.$$$reportNull$$$0(1);
            }
            return this.myContext == null || !this.myContext.isValid() ? null : Presentation.of((String)this.myMessage).withPriority(PriorityAction.Priority.HIGH);
        }

        private static SimplifyForEachContext findMigration(@Nullable PsiElement context) {
            if (!(context instanceof PsiReferenceExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)context))) {
                return null;
            }
            PsiLambdaExpression lambda = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiLambdaExpression.class);
            if (lambda == null) {
                return null;
            }
            PsiElement lambdaBody = lambda.getBody();
            if (lambdaBody == null) {
                return null;
            }
            PsiExpressionList parameters = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)lambda.getParent()), PsiExpressionList.class);
            if (parameters == null || parameters.getExpressionCount() != 1) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parameters.getParent(), PsiMethodCallExpression.class);
            SimplifyForEachContext simplifyForEachContext = SimplifyForEachContext.from(call);
            if (simplifyForEachContext == null || simplifyForEachContext.myMigration instanceof ForEachMigration) {
                return null;
            }
            return simplifyForEachContext;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement result;
            PsiMethodCallExpression call;
            SimplifyForEachContext simplifyForEachContext;
            if (context == null) {
                ForEachNonFinalFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ForEachNonFinalFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ForEachNonFinalFix.$$$reportNull$$$0(4);
            }
            if ((simplifyForEachContext = SimplifyForEachContext.from(call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class), PsiMethodCallExpression.class))) != null && (result = simplifyForEachContext.migrate()) != null) {
                MigrateToStreamFix.simplify(context.project(), result);
            }
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"quickfix.family.avoid.mutation.using.stream.api", (Object[])new Object[0]);
            if (string == null) {
                ForEachNonFinalFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$ForEachNonFinalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$ForEachNonFinalFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class SimplifyForEachFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        @Nls
        private final String myCustomName;

        protected SimplifyForEachFix(@NotNull @Nls String customName) {
            if (customName == null) {
                SimplifyForEachFix.$$$reportNull$$$0(0);
            }
            this.myCustomName = customName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myCustomName;
            if (string == null) {
                SimplifyForEachFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"quickfix.family.simplify.foreach.lambda", (Object[])new Object[0]);
            if (string == null) {
                SimplifyForEachFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiExpressionStatement statement;
            if (project == null) {
                SimplifyForEachFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                SimplifyForEachFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                SimplifyForEachFix.$$$reportNull$$$0(5);
            }
            if ((statement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)element, PsiExpressionStatement.class)) == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)statement.getExpression(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            SimplifyForEachContext simplifyForEachContext = SimplifyForEachContext.from(call);
            if (simplifyForEachContext == null) {
                return;
            }
            PsiElement result = simplifyForEachContext.migrate();
            if (result == null) {
                return;
            }
            MigrateToStreamFix.simplify(project, result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "customName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$SimplifyForEachFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$SimplifyForEachFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    static final class SimplifyForEachContext {
        @NotNull
        private final TerminalBlock myTerminalBlock;
        @NotNull
        private final PsiStatement myMainStatement;
        @NotNull
        private final BaseStreamApiMigration myMigration;
        @NotNull
        private final PsiElement myLambdaBody;

        private SimplifyForEachContext(@NotNull TerminalBlock terminalBlock, @NotNull PsiStatement mainStatement, @NotNull PsiElement body, @NotNull BaseStreamApiMigration migration) {
            if (terminalBlock == null) {
                SimplifyForEachContext.$$$reportNull$$$0(0);
            }
            if (mainStatement == null) {
                SimplifyForEachContext.$$$reportNull$$$0(1);
            }
            if (body == null) {
                SimplifyForEachContext.$$$reportNull$$$0(2);
            }
            if (migration == null) {
                SimplifyForEachContext.$$$reportNull$$$0(3);
            }
            this.myTerminalBlock = terminalBlock;
            this.myMainStatement = mainStatement;
            this.myLambdaBody = body;
            this.myMigration = migration;
        }

        public PsiElement migrate() {
            PsiElement result = this.myMigration.migrate(this.myMainStatement.getProject(), this.myLambdaBody, this.myTerminalBlock);
            if (result != null) {
                this.myTerminalBlock.operations().forEach(StreamApiMigrationInspection.Operation::cleanUp);
            }
            return result;
        }

        static SimplifyForEachContext from(@Nullable PsiMethodCallExpression call) {
            if (call == null) {
                return null;
            }
            PsiLambdaExpression lambda = SimplifyForEachInspection.extractLambdaFromForEach(call);
            if (lambda == null) {
                return null;
            }
            PsiElement lambdaBody = lambda.getBody();
            ExistingStreamSource source = ExistingStreamSource.extractSource(call, lambda);
            if (source == null) {
                return null;
            }
            TerminalBlock terminalBlock = SimplifyForEachInspection.extractTerminalBlock(lambdaBody, source);
            if (terminalBlock == null) {
                return null;
            }
            PsiStatement mainStatement = source.getMainStatement();
            BaseStreamApiMigration migration = StreamApiMigrationInspection.findMigration(mainStatement, lambdaBody, terminalBlock, true, true);
            if (migration instanceof ForEachMigration && STREAM_FOREACH_ORDERED.test(call)) {
                migration = new ForEachMigration(migration.isShouldWarn(), "forEachOrdered");
            }
            return migration == null ? null : new SimplifyForEachContext(terminalBlock, mainStatement, lambdaBody, migration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "terminalBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mainStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "body";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "migration";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/streamMigration/SimplifyForEachInspection$SimplifyForEachContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ExistingStreamSource
    extends StreamApiMigrationInspection.StreamSource {
        private final boolean myIsCollectionForEach;

        protected ExistingStreamSource(PsiStatement mainStatement, PsiVariable variable, PsiExpression expression, boolean isCollectionForEach) {
            super(mainStatement, variable, expression);
            this.myIsCollectionForEach = isCollectionForEach;
        }

        @Override
        String createReplacement(CommentTracker ct) {
            return this.myExpression.getText() + (this.myIsCollectionForEach ? ".stream()" : "");
        }

        @Nullable
        static ExistingStreamSource extractSource(PsiMethodCallExpression call, PsiLambdaExpression lambda) {
            PsiParameter[] parameters = lambda.getParameterList().getParameters();
            if (parameters.length != 1) {
                return null;
            }
            PsiParameter parameter = parameters[0];
            boolean isCollectionForEach = ITERABLE_FOREACH.test(call);
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return null;
            }
            PsiStatement parent = (PsiStatement)ObjectUtils.tryCast((Object)call.getParent(), PsiExpressionStatement.class);
            if (parent == null) {
                return null;
            }
            return new ExistingStreamSource(parent, (PsiVariable)parameter, qualifier, isCollectionForEach);
        }
    }
}

