/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.ChainContext;
import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FunctionalExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FunctionHelper {
    private static final Logger LOG = Logger.getInstance(FunctionHelper.class);
    private static final CallMatcher PREDICATE_NOT = CallMatcher.staticCall((String)"java.util.function.Predicate", (String[])new String[]{"not"}).parameterCount(1);
    private final PsiType myResultType;

    public FunctionHelper(PsiType resultType) {
        this.myResultType = resultType;
    }

    public final PsiType getResultType() {
        return this.myResultType;
    }

    public final String getText() {
        return this.getExpression().getText();
    }

    public String getStatementText() {
        return this.getText() + ";\n";
    }

    public abstract PsiExpression getExpression();

    public String tryLightTransform() {
        return null;
    }

    public abstract void transform(ChainContext var1, String ... var2);

    public void rename(String oldName, String newName, ChainContext context) {
    }

    public void registerReusedElements(Consumer<? super PsiElement> consumer) {
    }

    @Nullable
    public String getParameterName(int index) {
        return null;
    }

    public void preprocessVariable(ChainContext context, ChainVariable var, int index) {
        String name = this.getParameterName(index);
        if (name != null) {
            var.addBestNameCandidate(name);
        }
    }

    public void suggestOutputNames(ChainContext context, ChainVariable var) {
    }

    List<String> suggestFinalOutputNames(ChainContext context, String desiredName, String worstCaseName) {
        List<String> candidates = Arrays.asList(JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, (String)desiredName, (PsiExpression)this.getExpression(), (PsiType)this.getResultType()).names);
        if (candidates.isEmpty() && worstCaseName != null) {
            candidates = Collections.singletonList(worstCaseName);
        }
        return candidates;
    }

    public static void suggestFromExpression(ChainVariable var, Project project, PsiExpression expression) {
        SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName(VariableKind.LOCAL_VARIABLE, null, expression, null, true);
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(info.names));
        if (expression.getType() != null && !EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(var.getType(), expression.getType())) {
            SuggestedNameInfo byType = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, expression.getType(), true);
            names.removeAll(Arrays.asList(byType.names));
        }
        names.forEach(var::addOtherNameCandidate);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static FunctionHelper create(PsiExpression expression, int paramCount) {
        return FunctionHelper.create(expression, paramCount, false);
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static FunctionHelper create(PsiExpression expression, int paramCount, boolean allowReturns) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
            return null;
        }
        PsiType type = FunctionalExpressionUtils.getFunctionalExpressionType((PsiExpression)expression);
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type);
        if (interfaceMethod == null || interfaceMethod.getParameterList().getParametersCount() != paramCount) {
            return null;
        }
        PsiType returnType = interfaceMethod.getReturnType();
        if (returnType == null) {
            return null;
        }
        returnType = ((PsiClassType)type).resolveGenerics().getSubstitutor().substitute(returnType);
        if (expression instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)expression;
            PsiParameterList list = lambda.getParameterList();
            if (list.getParametersCount() != paramCount) {
                return null;
            }
            CharSequence[] parameters = (String[])StreamEx.of((Object[])list.getParameters()).map(PsiNamedElement::getName).toArray(String[]::new);
            PsiElement body = lambda.getBody();
            PsiExpression lambdaExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body);
            if (lambdaExpression == null) {
                if (body instanceof PsiCodeBlock) {
                    PsiCodeBlock block = (PsiCodeBlock)body;
                    List<PsiReturnStatement> returns = FunctionHelper.getReturns(body);
                    if (PsiTypes.voidType().equals((Object)returnType)) {
                        if (!(allowReturns || returns.isEmpty() && ControlFlowUtils.codeBlockMayCompleteNormally((PsiCodeBlock)block))) {
                            return null;
                        }
                        for (PsiReturnStatement ret : returns) {
                            if (PsiTreeUtil.getParentOfType((PsiElement)ret, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class}) == null) continue;
                            return null;
                        }
                        return new VoidBlockLambdaFunctionHelper(block, (String[])parameters);
                    }
                    if (returns.size() == 1 && ArrayUtil.getLastElement((Object[])block.getStatements()) == returns.getFirst()) {
                        PsiExpression trivialCall = JavaPsiFacade.getElementFactory((Project)lambda.getProject()).createExpressionFromText("((" + type.getCanonicalText() + ")" + lambda.getText() + ")." + interfaceMethod.getName() + "(" + String.join((CharSequence)",", parameters) + ")", (PsiElement)lambda);
                        return new LambdaFunctionHelper(returnType, (PsiElement)trivialCall, (String[])parameters);
                    }
                }
                return null;
            }
            return new LambdaFunctionHelper(returnType, (PsiElement)lambdaExpression, (String[])parameters);
        }
        if (expression instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression;
            if (methodRef.resolve() == null) {
                return null;
            }
            String template = FunctionHelper.tryInlineMethodReference(paramCount, methodRef);
            if (template != null) {
                return new InlinedFunctionHelper(returnType, paramCount, template);
            }
            return new MethodReferenceFunctionHelper(returnType, type, methodRef);
        }
        if (expression instanceof PsiReferenceExpression && ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)expression)) {
            return new SimpleReferenceFunctionHelper(returnType, expression, interfaceMethod.getName());
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiExpression arg;
            FunctionHelper delegate;
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (MethodCallUtils.isCallToStaticMethod((PsiMethodCallExpression)call, (String)"java.util.function.Function", (String)"identity", (int)0)) {
                return paramCount == 1 ? new InlinedFunctionHelper(returnType, 1, "{0}") : null;
            }
            if (MethodCallUtils.isCallToStaticMethod((PsiMethodCallExpression)call, (String)"java.util.Comparator", (String)"naturalOrder", (int)0)) {
                return paramCount == 2 ? new InlinedFunctionHelper(returnType, 2, "{0}.compareTo({1})") : null;
            }
            if (MethodCallUtils.isCallToStaticMethod((PsiMethodCallExpression)call, (String)"java.util.Comparator", (String)"reverseOrder", (int)0) || MethodCallUtils.isCallToStaticMethod((PsiMethodCallExpression)call, (String)"java.util.Collections", (String)"reverseOrder", (int)0)) {
                return paramCount == 2 ? new InlinedFunctionHelper(returnType, 2, "{1}.compareTo({0})") : null;
            }
            if (PREDICATE_NOT.test(call) && (delegate = FunctionHelper.create(arg = call.getArgumentList().getExpressions()[0], paramCount, false)) != null) {
                return new PredicateNotFunctionHelper(delegate);
            }
        }
        return new ComplexExpressionFunctionHelper(returnType, type, interfaceMethod.getName(), expression);
    }

    @Nullable
    private static String tryInlineMethodReference(int paramCount, PsiMethodReferenceExpression methodRef) {
        PsiElement element = methodRef.resolve();
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String name = method.getName();
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                PsiExpression qualifier;
                String className = aClass.getQualifiedName();
                if ("java.util.Objects".equals(className) && paramCount == 1) {
                    if (name.equals("nonNull")) {
                        return "{0}!=null";
                    }
                    if (name.equals("isNull")) {
                        return "{0}==null";
                    }
                }
                if (paramCount == 2 && name.equals("sum") && ("java.lang.Integer".equals(className) || "java.lang.Long".equals(className) || "java.lang.Double".equals(className))) {
                    return "{0}+{1}";
                }
                if ("java.lang.Class".equals(className) && paramCount == 1 && (qualifier = methodRef.getQualifierExpression()) instanceof PsiClassObjectAccessExpression) {
                    PsiTypeElement type = ((PsiClassObjectAccessExpression)qualifier).getOperand();
                    if (name.equals("isInstance")) {
                        return "{0} instanceof " + type.getText();
                    }
                    if (name.equals("cast")) {
                        return "(" + type.getText() + "){0}";
                    }
                }
            }
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    static FunctionHelper newObjectSupplier(PsiType type, final String instanceClassName) {
        return new FunctionHelper(type){
            PsiExpression myExpression;

            @Override
            public PsiExpression getExpression() {
                return this.myExpression;
            }

            @Override
            public void transform(ChainContext context, String ... argumentValues) {
                LOG.assertTrue(argumentValues.length == 0);
                this.myExpression = context.createExpression("new " + instanceClassName + "<>()");
            }
        };
    }

    static boolean hasVarReference(PsiElement expressionOrCodeBlock, String name, ChainContext context) {
        PsiLambdaExpression lambda = (PsiLambdaExpression)context.createExpression(name + "->" + expressionOrCodeBlock.getText());
        PsiParameter var = lambda.getParameterList().getParameters()[0];
        PsiElement body = lambda.getBody();
        LOG.assertTrue(body != null);
        return ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope(body)).findFirst() != null;
    }

    @NotNull
    public static <T extends PsiElement> T replaceVarReference(@NotNull T expressionOrCodeBlock, @NotNull String name, String replacement, ChainContext context) {
        if (expressionOrCodeBlock == null) {
            FunctionHelper.$$$reportNull$$$0(0);
        }
        if (name == null) {
            FunctionHelper.$$$reportNull$$$0(1);
        }
        if (name.equals(replacement)) {
            T t = expressionOrCodeBlock;
            if (t == null) {
                FunctionHelper.$$$reportNull$$$0(2);
            }
            return t;
        }
        PsiLambdaExpression lambda = (PsiLambdaExpression)context.createExpression(name + "->" + expressionOrCodeBlock.getText());
        PsiParameter var = lambda.getParameterList().getParameters()[0];
        PsiElement body = lambda.getBody();
        LOG.assertTrue(body != null);
        PsiExpression replacementExpression = context.createExpression(replacement);
        for (PsiReference ref : ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope(body)).findAll()) {
            ref.getElement().replace((PsiElement)replacementExpression);
        }
        PsiElement psiElement = lambda.getBody();
        if (psiElement == null) {
            FunctionHelper.$$$reportNull$$$0(3);
        }
        return (T)psiElement;
    }

    @NotNull
    private static List<PsiReturnStatement> getReturns(PsiElement body) {
        final ArrayList<PsiReturnStatement> returns = new ArrayList<PsiReturnStatement>();
        body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(@NotNull PsiClass psiClass) {
                if (psiClass == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
                if (returnStatement == null) {
                    2.$$$reportNull$$$0(2);
                }
                super.visitReturnStatement(returnStatement);
                returns.add(returnStatement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiClass";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "returnStatement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/streamToLoop/FunctionHelper$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReturnStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<PsiReturnStatement> arrayList = returns;
        if (arrayList == null) {
            FunctionHelper.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionOrCodeBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamToLoop/FunctionHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamToLoop/FunctionHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceVarReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceVarReference";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class VoidBlockLambdaFunctionHelper
    extends LambdaFunctionHelper {
        VoidBlockLambdaFunctionHelper(PsiCodeBlock body, String[] parameters) {
            super((PsiType)PsiTypes.voidType(), (PsiElement)body, parameters);
        }

        @Override
        public String getStatementText() {
            Object[] children = this.myBody.getChildren();
            return ((StreamEx)StreamEx.of((Object[])children, (int)1, (int)(children.length - 1)).dropWhile(e -> e instanceof PsiWhiteSpace)).map(PsiElement::getText).joining();
        }

        @Override
        public void transform(ChainContext context, String ... argumentValues) {
            super.transform(context, argumentValues);
            List<PsiReturnStatement> returns = FunctionHelper.getReturns(this.myBody);
            String continueStatement = "continue;";
            returns.forEach(ret -> ret.replace((PsiElement)context.createStatement(continueStatement)));
        }
    }

    private static class LambdaFunctionHelper
    extends FunctionHelper {
        @NotNull
        @NotNull String @NotNull [] myParameters;
        @NotNull
        PsiElement myBody;

        LambdaFunctionHelper(PsiType returnType, @NotNull PsiElement body, @NotNull @NotNull String @NotNull [] parameters) {
            if (body == null) {
                LambdaFunctionHelper.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                LambdaFunctionHelper.$$$reportNull$$$0(1);
            }
            super(returnType);
            this.myParameters = parameters;
            this.myBody = body;
        }

        @Override
        public String tryLightTransform() {
            LOG.assertTrue(this.myParameters.length == 1);
            return this.myParameters[0];
        }

        @Override
        public PsiExpression getExpression() {
            return (PsiExpression)this.myBody;
        }

        @Override
        public void transform(ChainContext context, String ... argumentValues) {
            LOG.assertTrue(argumentValues.length == this.myParameters.length);
            EntryStream.zip((Object[])this.myParameters, (Object[])argumentValues).forKeyValue((oldName, newName) -> {
                this.myBody = LambdaFunctionHelper.replaceVarReference(this.myBody, oldName, newName, context);
            });
        }

        @Override
        public void rename(String oldName, String newName, ChainContext context) {
            int idx = ArrayUtil.indexOf((Object[])this.myParameters, (Object)newName);
            if (idx >= 0) {
                int i = 1;
                while (true) {
                    String paramName;
                    if (!((paramName = newName + "$" + i).equals(oldName) || StreamEx.of((Object[])this.myParameters).has((Object)paramName) || LambdaFunctionHelper.hasVarReference(this.myBody, paramName, context))) {
                        this.myBody = LambdaFunctionHelper.replaceVarReference(this.myBody, newName, paramName, context);
                        this.myParameters[idx] = paramName;
                        break;
                    }
                    ++i;
                }
            }
            this.myBody = LambdaFunctionHelper.replaceVarReference(this.myBody, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myBody);
        }

        @Override
        public String getParameterName(int index) {
            return this.myParameters[index];
        }

        @Override
        public void preprocessVariable(ChainContext context, ChainVariable var, int index) {
            super.preprocessVariable(context, var, index);
            boolean hasClassOrLambda = StreamEx.ofTree((Object)this.myBody, e -> StreamEx.of((Object[])e.getChildren())).anyMatch(e -> e instanceof PsiLambdaExpression || e instanceof PsiClass);
            if (hasClassOrLambda) {
                PsiLambdaExpression lambda = (PsiLambdaExpression)context.createExpression(this.getParameterName(index) + "->" + this.myBody.getText());
                PsiParameter parameter = lambda.getParameterList().getParameters()[0];
                PsiElement body = lambda.getBody();
                LOG.assertTrue(body != null);
                boolean mayBeNotFinal = VariableAccessUtils.getVariableReferences((PsiVariable)parameter).stream().allMatch(e -> PsiTreeUtil.getParentOfType((PsiElement)e, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class}) == lambda);
                if (!mayBeNotFinal) {
                    var.markFinal();
                }
            }
        }

        @Override
        public void suggestOutputNames(ChainContext context, ChainVariable var) {
            if (this.myBody instanceof PsiExpression) {
                LambdaFunctionHelper.suggestFromExpression(var, context.getProject(), (PsiExpression)this.myBody);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "body";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/streamToLoop/FunctionHelper$LambdaFunctionHelper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class InlinedFunctionHelper
    extends FunctionHelper {
        private final int myArgCount;
        private final String myTemplate;
        private PsiExpression myExpression;

        InlinedFunctionHelper(PsiType type, int argCount, String template) {
            super(type);
            this.myArgCount = argCount;
            this.myTemplate = template;
        }

        @Override
        public PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        public void transform(ChainContext context, String ... argumentValues) {
            LOG.assertTrue(argumentValues.length == this.myArgCount);
            this.myExpression = context.createExpression(MessageFormat.format(this.myTemplate, argumentValues));
        }
    }

    private static class MethodReferenceFunctionHelper
    extends FunctionHelper {
        private final PsiType myType;
        private final PsiType myQualifierType;
        private PsiMethodReferenceExpression myMethodRef;
        private PsiExpression myExpression;

        MethodReferenceFunctionHelper(PsiType returnType, PsiType functionalInterfaceType, PsiMethodReferenceExpression methodRef) {
            super(returnType);
            this.myMethodRef = methodRef;
            this.myType = functionalInterfaceType;
            PsiExpression qualifier = methodRef.getQualifierExpression();
            this.myQualifierType = qualifier == null ? null : qualifier.getType();
        }

        @Override
        public String tryLightTransform() {
            PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.createLambda((PsiMethodReferenceExpression)this.myMethodRef, (boolean)true);
            if (lambdaExpression == null) {
                return null;
            }
            String typedParamList = LambdaUtil.createLambdaParameterListWithFormalTypes((PsiType)this.myType, (PsiLambdaExpression)lambdaExpression, (boolean)false);
            if (typedParamList != null && lambdaExpression.getBody() != null) {
                lambdaExpression = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)this.myMethodRef.getProject()).createExpressionFromText(typedParamList + "->" + lambdaExpression.getBody().getText(), (PsiElement)this.myMethodRef);
            }
            this.myExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambdaExpression.getBody());
            if (this.myExpression == null) {
                return null;
            }
            PsiParameterList list = lambdaExpression.getParameterList();
            if (list.getParametersCount() != 1) {
                return null;
            }
            return list.getParameters()[0].getName();
        }

        @Override
        public PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myMethodRef.getQualifier());
        }

        @Override
        public void transform(ChainContext context, String ... argumentValues) {
            PsiLambdaExpression lambda;
            PsiMethodReferenceExpression methodRef = this.myMethodRef;
            PsiExpression qualifier = methodRef.getQualifierExpression();
            if (qualifier != null) {
                String qualifierText = qualifier.getText();
                if (!ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)qualifier) && this.myQualifierType != null) {
                    String nameCandidate = "expr";
                    SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, this.myQualifierType, true);
                    if (info.names.length > 0) {
                        nameCandidate = info.names[0];
                    }
                    String expr = context.declare(nameCandidate, this.myQualifierType.getCanonicalText(), qualifierText);
                    PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)context.createExpression("(" + this.myQualifierType.getCanonicalText() + " " + expr + ")->(" + this.myType.getCanonicalText() + ")" + expr + "::" + this.myMethodRef.getReferenceName());
                    PsiTypeCastExpression castExpr = (PsiTypeCastExpression)lambdaExpression.getBody();
                    LOG.assertTrue(castExpr != null);
                    methodRef = (PsiMethodReferenceExpression)castExpr.getOperand();
                    LOG.assertTrue(methodRef != null);
                }
            }
            if ((lambda = LambdaRefactoringUtil.createLambda((PsiMethodReferenceExpression)methodRef, (boolean)true)) == null) {
                throw new IllegalStateException("Unable to convert method reference to lambda: " + methodRef.getText());
            }
            this.myExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody());
            LOG.assertTrue(this.myExpression != null);
            EntryStream.zip((Object[])lambda.getParameterList().getParameters(), (Object[])argumentValues).forKeyValue((param, newName) -> {
                String oldName = param.getName();
                this.myExpression = MethodReferenceFunctionHelper.replaceVarReference(this.myExpression, oldName, newName, context);
            });
        }

        @Override
        public void suggestOutputNames(ChainContext context, ChainVariable var) {
            PsiExpression body;
            PsiLambdaExpression lambda = LambdaRefactoringUtil.createLambda((PsiMethodReferenceExpression)this.myMethodRef, (boolean)true);
            if (lambda != null && (body = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody())) != null) {
                MethodReferenceFunctionHelper.suggestFromExpression(var, context.getProject(), body);
            }
        }

        @NotNull
        private PsiMethodReferenceExpression fromText(ChainContext context, String text) {
            PsiTypeCastExpression castExpr = (PsiTypeCastExpression)context.createExpression("(" + this.myType.getCanonicalText() + ")" + text);
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)castExpr.getOperand();
            LOG.assertTrue(methodRef != null);
            PsiMethodReferenceExpression psiMethodReferenceExpression = methodRef;
            if (psiMethodReferenceExpression == null) {
                MethodReferenceFunctionHelper.$$$reportNull$$$0(0);
            }
            return psiMethodReferenceExpression;
        }

        @Override
        public void rename(String oldName, String newName, ChainContext context) {
            if (oldName.equals(newName)) {
                return;
            }
            PsiExpression qualifier = this.myMethodRef.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            qualifier = MethodReferenceFunctionHelper.replaceVarReference(qualifier, oldName, newName, context);
            this.myMethodRef = this.fromText(context, qualifier.getText() + "::" + this.myMethodRef.getReferenceName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/FunctionHelper$MethodReferenceFunctionHelper", "fromText"));
        }
    }

    private static class SimpleReferenceFunctionHelper
    extends FunctionHelper {
        private PsiExpression myReference;
        private final String myName;
        private PsiExpression myExpression;

        SimpleReferenceFunctionHelper(PsiType returnType, PsiExpression reference, String methodName) {
            super(returnType);
            this.myReference = reference;
            this.myName = methodName;
        }

        @Override
        public PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        public void transform(ChainContext context, String ... argumentValues) {
            this.myExpression = context.createExpression(this.myReference.getText() + "." + this.myName + "(" + String.join((CharSequence)",", argumentValues) + ")");
        }

        @Override
        public void rename(String oldName, String newName, ChainContext context) {
            this.myReference = SimpleReferenceFunctionHelper.replaceVarReference(this.myReference, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myReference);
        }
    }

    private static class PredicateNotFunctionHelper
    extends FunctionHelper {
        @NotNull
        private final FunctionHelper myDelegate;
        private PsiExpression myExpression;

        private PredicateNotFunctionHelper(@NotNull FunctionHelper delegate) {
            if (delegate == null) {
                PredicateNotFunctionHelper.$$$reportNull$$$0(0);
            }
            super(delegate.getResultType());
            this.myDelegate = delegate;
        }

        @Override
        public PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        public void rename(String oldName, String newName, ChainContext context) {
            this.myDelegate.rename(oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.myDelegate.registerReusedElements(consumer);
        }

        @Override
        public void suggestOutputNames(ChainContext context, ChainVariable var) {
            this.myDelegate.suggestOutputNames(context, var);
        }

        @Override
        public void preprocessVariable(ChainContext context, ChainVariable var, int index) {
            this.myDelegate.preprocessVariable(context, var, index);
        }

        @Override
        public void transform(ChainContext context, String ... argumentValues) {
            this.myDelegate.transform(context, argumentValues);
            this.myExpression = context.createExpression(BoolUtils.getNegatedExpressionText((PsiExpression)this.myDelegate.getExpression()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/codeInspection/streamToLoop/FunctionHelper$PredicateNotFunctionHelper", "<init>"));
        }
    }

    private static final class ComplexExpressionFunctionHelper
    extends FunctionHelper {
        private final String myMethodName;
        private final String myNameCandidate;
        private final String myFnType;
        private PsiExpression myExpression;
        private PsiExpression myFinalExpression;

        private ComplexExpressionFunctionHelper(PsiType type, PsiType functionalInterface, String name, PsiExpression expression) {
            super(type);
            this.myMethodName = name;
            this.myExpression = expression;
            this.myNameCandidate = this.getNameCandidate(functionalInterface);
            this.myFnType = functionalInterface.getCanonicalText();
        }

        @NotNull
        private String getNameCandidate(PsiType functionalInterface) {
            PsiClass psiClass;
            PsiElement parent = this.myExpression.getParent();
            if (parent instanceof PsiExpressionList) {
                PsiParameter[] parameters;
                PsiMethod method;
                int idx = ArrayUtil.indexOf((Object[])((PsiExpressionList)parent).getExpressions(), (Object)this.myExpression);
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiMethodCallExpression && idx >= 0 && (method = ((PsiMethodCallExpression)gParent).resolveMethod()) != null && idx < (parameters = method.getParameterList().getParameters()).length) {
                    String string = parameters[idx].getName();
                    if (string == null) {
                        ComplexExpressionFunctionHelper.$$$reportNull$$$0(0);
                    }
                    return string;
                }
            }
            if ((psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)functionalInterface)) != null && psiClass.getName() != null) {
                String string = StringUtil.toLowerCase((String)psiClass.getName());
                if (string == null) {
                    ComplexExpressionFunctionHelper.$$$reportNull$$$0(1);
                }
                return string;
            }
            return "fn";
        }

        @Override
        public PsiExpression getExpression() {
            LOG.assertTrue(this.myFinalExpression != null);
            return this.myFinalExpression;
        }

        @Override
        public void rename(String oldName, String newName, ChainContext context) {
            this.myExpression = ComplexExpressionFunctionHelper.replaceVarReference(this.myExpression, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myExpression);
        }

        @Override
        public void transform(ChainContext context, String ... argumentValues) {
            String varName = context.declare(this.myNameCandidate, this.myFnType, this.myExpression.getText());
            this.myFinalExpression = context.createExpression(varName + "." + this.myMethodName + "(" + String.join((CharSequence)",", argumentValues) + ")");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/FunctionHelper$ComplexExpressionFunctionHelper", "getNameCandidate"));
        }
    }
}

