/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.codeInspection.streamToLoop.SourceOperation;
import com.intellij.codeInspection.streamToLoop.StreamToLoopInspection;
import com.intellij.codeInspection.streamToLoop.StreamToLoopReplacementContext;
import com.intellij.codeInspection.streamToLoop.TerminalOperation;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class Operation {
    Operation() {
    }

    boolean changesVariable() {
        return false;
    }

    StreamEx<StreamToLoopInspection.OperationRecord> nestedOperations() {
        return StreamEx.empty();
    }

    void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
    }

    abstract String wrap(ChainVariable var1, ChainVariable var2, String var3, StreamToLoopReplacementContext var4);

    Operation combineWithNext(Operation next) {
        return null;
    }

    public void registerReusedElements(Consumer<? super PsiElement> consumer) {
    }

    public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
    }

    @Nullable
    static Operation createIntermediate(@NotNull String name, PsiExpression @NotNull [] args, @NotNull ChainVariable outVar, @NotNull PsiType inType, boolean supportUnknownSources) {
        if (name == null) {
            Operation.$$$reportNull$$$0(0);
        }
        if (outVar == null) {
            Operation.$$$reportNull$$$0(1);
        }
        if (inType == null) {
            Operation.$$$reportNull$$$0(2);
        }
        if (args == null) {
            Operation.$$$reportNull$$$0(3);
        }
        if (name.equals("distinct") && args.length == 0) {
            return new DistinctOperation();
        }
        if (name.equals("skip") && args.length == 1) {
            return new SkipOperation(args[0]);
        }
        if (name.equals("limit") && args.length == 1) {
            return new LimitOperation(args[0]);
        }
        if (name.equals("filter") && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new FilterOperation(fn);
        }
        if (name.equals("takeWhile") && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new TakeWhileOperation(fn);
        }
        if (name.equals("dropWhile") && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new DropWhileOperation(fn);
        }
        if (name.equals("nonNull") && args.length == 0) {
            return new FilterOperation(new FunctionHelper.InlinedFunctionHelper((PsiType)PsiTypes.booleanType(), 1, "{0} != null"));
        }
        if (name.equals("sorted") && !(inType instanceof PsiPrimitiveType)) {
            return new SortedOperation(args.length == 1 ? args[0] : null);
        }
        if (name.equals("peek") && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new PeekOperation(fn);
        }
        if ((name.equals("boxed") || name.equals("asLongStream") || name.equals("asDoubleStream")) && args.length == 0) {
            return new WideningOperation();
        }
        if ((name.equals("flatMap") || name.equals("flatMapToInt") || name.equals("flatMapToLong") || name.equals("flatMapToDouble")) && args.length == 1) {
            return FlatMapOperation.from(outVar, args[0], supportUnknownSources);
        }
        if ((name.equals("map") || name.equals("mapToInt") || name.equals("mapToLong") || name.equals("mapToDouble") || name.equals("mapToObj")) && args.length == 1) {
            FunctionHelper fn = FunctionHelper.create(args[0], 1);
            return fn == null ? null : new MapOperation(fn);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "outVar";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "inType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "args";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/streamToLoop/Operation";
        objectArray[2] = "createIntermediate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class DistinctOperation
    extends Operation {
        DistinctOperation() {
        }

        @Override
        String wrap(ChainVariable inVar, ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            String set = context.declare("uniqueValues", "java.util.Set<" + PsiTypesUtil.boxIfPossible((String)inVar.getType().getCanonicalText()) + ">", "new java.util.HashSet<>()");
            return "if(" + set + ".add(" + String.valueOf(inVar) + ")) {\n" + code + "}\n";
        }
    }

    static class SkipOperation
    extends Operation {
        PsiExpression myExpression;

        SkipOperation(PsiExpression expression) {
            this.myExpression = expression;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
            this.myExpression = FunctionHelper.replaceVarReference(this.myExpression, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myExpression);
        }

        @Override
        String wrap(ChainVariable inVar, ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            if (ExpressionUtils.isLiteral((PsiElement)this.myExpression, (Object)1)) {
                String first = context.declare("first", "boolean", "true");
                return "if(" + first + ") {\n" + first + "=false;\ncontinue;\n}\n" + code;
            }
            String toSkip = context.declare("toSkip", "long", this.myExpression.getText());
            return "if(" + toSkip + ">0) {\n" + toSkip + "--;\ncontinue;\n}\n" + code;
        }
    }

    static class LimitOperation
    extends Operation {
        PsiExpression myLimit;

        LimitOperation(PsiExpression expression) {
            this.myLimit = expression;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
            this.myLimit = FunctionHelper.replaceVarReference(this.myLimit, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myLimit);
        }

        @Override
        String wrap(ChainVariable inVar, ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            String limit = context.declare("limit", "long", this.myLimit.getText());
            return "if(" + limit + "--==0) " + context.getBreakStatement() + code;
        }
    }

    static class FilterOperation
    extends LambdaIntermediateOperation {
        FilterOperation(FunctionHelper fn) {
            super(fn);
        }

        @Override
        String wrap(ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            return "if(" + this.myFn.getText() + ") {\n" + code + "}\n";
        }
    }

    static class TakeWhileOperation
    extends LambdaIntermediateOperation {
        TakeWhileOperation(FunctionHelper fn) {
            super(fn);
        }

        @Override
        String wrap(ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            return "if(" + BoolUtils.getNegatedExpressionText((PsiExpression)this.myFn.getExpression()) + ") {\n" + context.getBreakStatement() + "}\n" + code;
        }
    }

    static class DropWhileOperation
    extends LambdaIntermediateOperation {
        DropWhileOperation(FunctionHelper fn) {
            super(fn);
        }

        @Override
        String wrap(ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            String dropping = context.declare("dropping", "boolean", "true");
            return "if(" + dropping + ") {\nif(" + this.myFn.getText() + ") {\ncontinue;\n}\n" + dropping + "=false;\n}\n" + code;
        }
    }

    static class SortedOperation
    extends Operation {
        @Nullable
        private final PsiExpression myComparator;

        SortedOperation(@Nullable PsiExpression comparator) {
            this.myComparator = comparator;
        }

        @Override
        Operation combineWithNext(Operation next) {
            if (next instanceof TerminalOperation.ToArrayTerminalOperation || next instanceof TerminalOperation.ToCollectionTerminalOperation && ((TerminalOperation.ToCollectionTerminalOperation)next).isList()) {
                return new TerminalOperation.SortedTerminalOperation((TerminalOperation.AccumulatedOperation)next, this.myComparator);
            }
            return null;
        }

        @Override
        String wrap(ChainVariable inVar, ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            String list = context.registerVarName(Arrays.asList("toSort", "listToSort"));
            context.addAfterStep(new SourceOperation.ForEachSource(context.createExpression(list)).wrap(null, outVar, code, context));
            context.addAfterStep(list + ".sort(" + (this.myComparator == null ? "null" : this.myComparator.getText()) + ");\n");
            String listType = "java.util.List<" + inVar.getType().getCanonicalText() + ">";
            String initializer = "new java.util.ArrayList<>()";
            context.addBeforeStep(listType + " " + list + "=" + initializer + ";");
            return list + ".add(" + String.valueOf(inVar) + ");\n";
        }
    }

    static class PeekOperation
    extends LambdaIntermediateOperation {
        PeekOperation(FunctionHelper fn) {
            super(fn);
        }

        @Override
        String wrap(ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            return this.myFn.getStatementText() + code;
        }
    }

    static class WideningOperation
    extends Operation {
        WideningOperation() {
        }

        @Override
        String wrap(ChainVariable inVar, ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            return outVar.getDeclaration(inVar.getName()) + code;
        }

        @Override
        boolean changesVariable() {
            return true;
        }
    }

    static final class FlatMapOperation
    extends Operation {
        private final String myVarName;
        private final FunctionHelper myFn;
        private final List<StreamToLoopInspection.OperationRecord> myRecords;
        private PsiExpression myCondition;
        private final boolean myInverted;

        private FlatMapOperation(String varName, FunctionHelper fn, List<StreamToLoopInspection.OperationRecord> records, PsiExpression condition, boolean inverted) {
            this.myVarName = varName;
            this.myFn = fn;
            this.myRecords = records;
            this.myCondition = condition;
            this.myInverted = inverted;
        }

        @Override
        StreamEx<StreamToLoopInspection.OperationRecord> nestedOperations() {
            return StreamEx.of(this.myRecords).flatMap(or -> StreamEx.of((Object)or).append(or.myOperation.nestedOperations()));
        }

        @Override
        boolean changesVariable() {
            return true;
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            String name = this.myFn.getParameterName(0);
            if (name != null) {
                inVar.addBestNameCandidate(name);
            }
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.myRecords.forEach(or -> or.myOperation.registerReusedElements(consumer));
            if (this.myCondition != null) {
                consumer.accept((PsiElement)this.myCondition);
            }
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
            this.myRecords.forEach(or -> or.myOperation.rename(oldName, newName, context));
            if (this.myCondition != null) {
                this.myCondition = FunctionHelper.replaceVarReference(this.myCondition, oldName, newName, context);
            }
        }

        @Override
        String wrap(ChainVariable inVar, ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            if (!this.myVarName.equals(inVar.getName())) {
                this.rename(this.myVarName, inVar.getName(), context);
            }
            StreamToLoopReplacementContext innerContext = new StreamToLoopReplacementContext(context, this.myRecords);
            String replacement = code;
            for (StreamToLoopInspection.OperationRecord or : StreamEx.ofReversed(this.myRecords)) {
                replacement = or.myOperation.wrap(or.myInVar, or.myOutVar, replacement, innerContext);
            }
            if (this.myCondition != null) {
                String conditionText = this.myCondition.getText();
                if (this.myInverted) {
                    conditionText = BoolUtils.getNegatedExpressionText((PsiExpression)this.myCondition);
                }
                return "if(" + conditionText + "){\n" + replacement + "}\n";
            }
            return replacement;
        }

        @Nullable
        public static FlatMapOperation from(ChainVariable outVar, PsiExpression arg, boolean supportUnknownSources) {
            FunctionHelper fn = FunctionHelper.create(arg, 1);
            if (fn == null) {
                return null;
            }
            String varName = fn.tryLightTransform();
            if (varName == null) {
                return null;
            }
            PsiExpression body = PsiUtil.skipParenthesizedExprDown((PsiExpression)fn.getExpression());
            PsiExpression condition = null;
            boolean inverted = false;
            if (body instanceof PsiConditionalExpression) {
                PsiConditionalExpression ternary = (PsiConditionalExpression)body;
                condition = ternary.getCondition();
                PsiExpression thenExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)ternary.getThenExpression());
                PsiExpression elseExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)ternary.getElseExpression());
                if (StreamApiUtil.isNullOrEmptyStream((PsiExpression)thenExpression)) {
                    body = elseExpression;
                    inverted = true;
                } else if (StreamApiUtil.isNullOrEmptyStream((PsiExpression)elseExpression)) {
                    body = thenExpression;
                } else {
                    return null;
                }
            }
            if (!(body instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression terminalCall = (PsiMethodCallExpression)body;
            List<StreamToLoopInspection.OperationRecord> records = StreamToLoopInspection.extractOperations(outVar, terminalCall, supportUnknownSources);
            if (records == null || StreamToLoopInspection.getTerminal(records) != null) {
                return null;
            }
            return new FlatMapOperation(varName, fn, records, condition, inverted);
        }
    }

    static class MapOperation
    extends LambdaIntermediateOperation {
        MapOperation(FunctionHelper fn) {
            super(fn);
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            super.preprocessVariables(context, inVar, outVar);
            this.myFn.suggestOutputNames(context, outVar);
        }

        @Override
        String wrap(ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            return outVar.getDeclaration(this.myFn.getText()) + code;
        }

        @Override
        boolean changesVariable() {
            return true;
        }
    }

    static abstract class LambdaIntermediateOperation
    extends Operation {
        final FunctionHelper myFn;

        LambdaIntermediateOperation(FunctionHelper fn) {
            this.myFn = fn;
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.myFn.registerReusedElements(consumer);
        }

        @Override
        final String wrap(ChainVariable inVar, ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            this.myFn.transform(context, inVar.getName());
            return this.wrap(outVar, code, context);
        }

        abstract String wrap(ChainVariable var1, String var2, StreamToLoopReplacementContext var3);

        @Override
        void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
            this.myFn.rename(oldName, newName, context);
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            this.myFn.preprocessVariable(context, inVar, 0);
        }
    }
}

