/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.codeInspection.streamToLoop.Operation;
import com.intellij.codeInspection.streamToLoop.StreamToLoopReplacementContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SourceOperation
extends Operation {
    private static final CallMatcher ITERABLE_SPLITERATOR = CallMatcher.instanceCall((String)"java.lang.Iterable", (String[])new String[]{"spliterator"}).parameterCount(0);

    SourceOperation() {
    }

    @Override
    @Contract(value=" -> true", pure=true)
    final boolean changesVariable() {
        return true;
    }

    @Override
    @NotNull
    final String wrap(ChainVariable inVar, ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
        String result = this.wrap(outVar, code, context);
        String string = context.drainBeforeSteps() + result + context.drainAfterSteps();
        if (string == null) {
            SourceOperation.$$$reportNull$$$0(0);
        }
        return string;
    }

    abstract String wrap(ChainVariable var1, String var2, StreamToLoopReplacementContext var3);

    @Nullable
    static SourceOperation createSource(PsiMethodCallExpression call, boolean supportUnknownSources) {
        PsiType type;
        PsiExpression qualifier;
        PsiMethodCallExpression spliteratorExpr;
        PsiExpression qualifier2;
        PsiExpression[] args = call.getArgumentList().getExpressions();
        PsiType callType = call.getType();
        if (callType == null || PsiTypes.voidType().equals((Object)callType)) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        String name = method.getName();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        String className = aClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        if ((name.equals("range") || name.equals("rangeClosed")) && args.length == 2 && method.getModifierList().hasExplicitModifier("static") && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream")) {
            return new RangeSource(args[0], args[1], name.equals("rangeClosed"));
        }
        if (name.equals("of") && method.getModifierList().hasExplicitModifier("static") && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream")) {
            if (method.getParameterList().getParametersCount() != 1) {
                return null;
            }
            if (args.length == 1) {
                PsiType type2 = args[0].getType();
                PsiType componentType = null;
                if (type2 instanceof PsiArrayType) {
                    componentType = ((PsiArrayType)type2).getComponentType();
                } else if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Iterable")) {
                    componentType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.lang.Iterable", (int)0, (boolean)false);
                }
                PsiType elementType = StreamApiUtil.getStreamElementType((PsiType)callType);
                if (componentType != null && elementType.isAssignableFrom(componentType)) {
                    return new ForEachSource(args[0]);
                }
                if (type2 == null || !elementType.isAssignableFrom(type2)) {
                    return null;
                }
            }
            return new ExplicitSource(call);
        }
        if (name.equals("generate") && args.length == 1 && method.getModifierList().hasExplicitModifier("static") && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream")) {
            FunctionHelper fn = FunctionHelper.create(args[0], 0);
            return fn == null ? null : new GenerateSource(fn, null);
        }
        if (name.equals("iterate") && args.length == 2 && method.getModifierList().hasExplicitModifier("static") && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream")) {
            FunctionHelper fn = FunctionHelper.create(args[1], 1);
            return fn == null ? null : new IterateSource(args[0], fn);
        }
        if (name.equals("stream") && args.length == 0 && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection") && (qualifier2 = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)call.getMethodExpression())) != null) {
            return new ForEachSource(qualifier2);
        }
        if (name.equals("stream") && args.length == 2 && method.getModifierList().hasExplicitModifier("static") && "java.util.stream.StreamSupport".equals(className) && ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[1]), (Object)false) && ITERABLE_SPLITERATOR.test(spliteratorExpr = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiMethodCallExpression.class)) && (qualifier = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)spliteratorExpr.getMethodExpression())) != null) {
            return new ForEachSource(qualifier);
        }
        if (name.equals("stream") && args.length == 1 && "java.util.Arrays".equals(className)) {
            return new ForEachSource(args[0]);
        }
        if (name.equals("stream") && args.length == 3 && "java.util.Arrays".equals(className) && args[0].getType() != null && PsiTypes.intType().equals((Object)args[1].getType()) && PsiTypes.intType().equals((Object)args[2].getType())) {
            return new ArraySliceSource(args[0], args[1], args[2]);
        }
        if (supportUnknownSources && (type = StreamApiUtil.getStreamElementType((PsiType)call.getType(), (boolean)false)) != null) {
            return new StreamIteratorSource(call, type);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/SourceOperation", "wrap"));
    }

    static class RangeSource
    extends SourceOperation {
        private PsiExpression myOrigin;
        private PsiExpression myBound;
        private final boolean myInclusive;

        RangeSource(PsiExpression origin, PsiExpression bound, boolean inclusive) {
            this.myOrigin = origin;
            this.myBound = bound;
            this.myInclusive = inclusive;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
            this.myOrigin = FunctionHelper.replaceVarReference(this.myOrigin, oldName, newName, context);
            this.myBound = FunctionHelper.replaceVarReference(this.myBound, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myOrigin);
            consumer.accept((PsiElement)this.myBound);
        }

        @Override
        String wrap(ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            String bound = this.myBound.getText();
            if (RangeSource.needBound(context, bound)) {
                bound = context.declare("bound", outVar.getType().getCanonicalText(), bound);
            }
            String loopVar = outVar.getName();
            String reassign = "";
            if (outVar.isFinal()) {
                loopVar = context.registerVarName(Arrays.asList("i", "j", "idx"));
                reassign = outVar.getDeclaration(loopVar);
            }
            return context.getLoopLabel() + "for(" + outVar.getType().getCanonicalText() + " " + loopVar + " = " + this.myOrigin.getText() + ";" + loopVar + (this.myInclusive ? "<=" : "<") + bound + ";" + loopVar + "++) {\n" + reassign + code + "}\n";
        }

        private static boolean needBound(StreamToLoopReplacementContext context, String bound) {
            PsiElement ref;
            PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)context.createExpression(bound));
            while (expression instanceof PsiReferenceExpression && (ref = ((PsiReferenceExpression)expression).resolve()) instanceof PsiVariable && ((PsiVariable)ref).hasModifierProperty("final")) {
                expression = ((PsiReferenceExpression)expression).getQualifierExpression();
            }
            return !ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)expression);
        }
    }

    static class ForEachSource
    extends SourceOperation {
        private final boolean myEntrySet;
        @NotNull
        private PsiExpression myQualifier;

        ForEachSource(@NotNull PsiExpression qualifier) {
            if (qualifier == null) {
                ForEachSource.$$$reportNull$$$0(0);
            }
            this(qualifier, false);
        }

        ForEachSource(@NotNull PsiExpression qualifier, boolean entrySet) {
            if (qualifier == null) {
                ForEachSource.$$$reportNull$$$0(1);
            }
            this.myQualifier = qualifier;
            this.myEntrySet = entrySet;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
            this.myQualifier = FunctionHelper.replaceVarReference(this.myQualifier, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myQualifier);
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            String singularName;
            String name;
            if (this.myQualifier instanceof PsiReferenceExpression && (name = ((PsiReferenceExpression)this.myQualifier).getReferenceName()) != null && (singularName = StringUtil.unpluralize((String)name)) != null && !name.equals(singularName)) {
                outVar.addOtherNameCandidate(singularName);
            }
        }

        @Override
        public String wrap(ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            String iterationParameterText = this.myQualifier.getText() + (this.myEntrySet ? ".entrySet()" : "");
            return context.getLoopLabel() + "for(" + outVar.getDeclaration() + ": " + iterationParameterText + ") {" + code + "}\n";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/codeInspection/streamToLoop/SourceOperation$ForEachSource", "<init>"));
        }
    }

    static class ExplicitSource
    extends SourceOperation {
        private PsiMethodCallExpression myCall;

        ExplicitSource(PsiMethodCallExpression call) {
            this.myCall = call;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
            this.myCall = FunctionHelper.replaceVarReference(this.myCall, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myCall.getArgumentList());
        }

        @Override
        public String wrap(ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            Object iterationParameter;
            PsiType type = outVar.getType();
            PsiExpressionList argList = this.myCall.getArgumentList();
            if (type instanceof PsiPrimitiveType) {
                Object[] children = argList.getChildren();
                iterationParameter = StreamEx.of((Object[])children, (int)1, (int)(children.length - 1)).map(PsiElement::getText).joining((CharSequence)"", (CharSequence)("new " + type.getCanonicalText() + "[] {"), (CharSequence)"}");
            } else {
                iterationParameter = "java.util.Arrays.<" + type.getCanonicalText() + ">asList" + argList.getText();
            }
            return context.getLoopLabel() + "for(" + outVar.getDeclaration() + ": " + (String)iterationParameter + ") {" + code + "}\n";
        }
    }

    static class GenerateSource
    extends SourceOperation {
        private final FunctionHelper myFn;
        private PsiExpression myLimit;

        GenerateSource(FunctionHelper fn, PsiExpression limit) {
            this.myFn = fn;
            this.myLimit = limit;
        }

        @Override
        Operation combineWithNext(Operation next) {
            if (this.myLimit == null && next instanceof Operation.LimitOperation) {
                return new GenerateSource(this.myFn, ((Operation.LimitOperation)next).myLimit);
            }
            return null;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
            this.myFn.rename(oldName, newName, context);
            if (this.myLimit != null) {
                this.myLimit = FunctionHelper.replaceVarReference(this.myLimit, oldName, newName, context);
            }
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            this.myFn.registerReusedElements(consumer);
            if (this.myLimit != null) {
                consumer.accept((PsiElement)this.myLimit);
            }
        }

        @Override
        String wrap(ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            this.myFn.transform(context, new String[0]);
            Object loop = "while(true)";
            if (this.myLimit != null) {
                String loopIdx = context.registerVarName(Arrays.asList("count", "limit"));
                loop = "for(long " + loopIdx + "=" + this.myLimit.getText() + ";" + loopIdx + ">0;" + loopIdx + "--)";
            }
            return context.getLoopLabel() + (String)loop + "{\n" + outVar.getDeclaration(this.myFn.getText()) + code + "}\n";
        }
    }

    static class IterateSource
    extends SourceOperation {
        private PsiExpression myInitializer;
        private final FunctionHelper myFn;

        IterateSource(PsiExpression initializer, FunctionHelper fn) {
            this.myInitializer = initializer;
            this.myFn = fn;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
            this.myInitializer = FunctionHelper.replaceVarReference(this.myInitializer, oldName, newName, context);
            this.myFn.rename(oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myInitializer);
            this.myFn.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            this.myFn.preprocessVariable(context, outVar, 0);
        }

        @Override
        String wrap(ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            this.myFn.transform(context, outVar.getName());
            return context.getLoopLabel() + "for(" + outVar.getDeclaration() + "=" + this.myInitializer.getText() + ";;" + String.valueOf(outVar) + "=" + this.myFn.getText() + ") {\n" + code + "}\n";
        }
    }

    static class ArraySliceSource
    extends SourceOperation {
        @NotNull
        private PsiExpression myArray;
        @NotNull
        private PsiExpression myOrigin;
        @NotNull
        private PsiExpression myBound;
        @NotNull
        private final PsiType myArrayType;

        ArraySliceSource(@NotNull PsiExpression array, @NotNull PsiExpression origin, @NotNull PsiExpression bound) {
            if (array == null) {
                ArraySliceSource.$$$reportNull$$$0(0);
            }
            if (origin == null) {
                ArraySliceSource.$$$reportNull$$$0(1);
            }
            if (bound == null) {
                ArraySliceSource.$$$reportNull$$$0(2);
            }
            this.myOrigin = origin;
            this.myBound = bound;
            this.myArray = array;
            this.myArrayType = Objects.requireNonNull(this.myArray.getType());
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
            this.myOrigin = FunctionHelper.replaceVarReference(this.myOrigin, oldName, newName, context);
            this.myBound = FunctionHelper.replaceVarReference(this.myBound, oldName, newName, context);
            this.myArray = FunctionHelper.replaceVarReference(this.myArray, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myOrigin);
            consumer.accept((PsiElement)this.myBound);
            consumer.accept((PsiElement)this.myArray);
        }

        @Override
        String wrap(ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            String bound = this.myBound.getText();
            String array = this.myArray.getText();
            if (!ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)context.createExpression(array))) {
                array = context.declare("array", this.myArrayType.getCanonicalText(), array);
            }
            if (!ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)context.createExpression(bound))) {
                bound = context.declare("bound", "int", bound);
            }
            String loopVar = context.registerVarName(Arrays.asList("i", "j", "idx"));
            String element = outVar.getDeclaration(array + "[" + loopVar + "]");
            return context.getLoopLabel() + "for(int " + loopVar + " = " + this.myOrigin.getText() + ";" + loopVar + "<" + bound + ";" + loopVar + "++) {\n" + element + code + "}\n";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "array";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "origin";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bound";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/streamToLoop/SourceOperation$ArraySliceSource";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StreamIteratorSource
    extends SourceOperation {
        private final String myElementType;
        private PsiMethodCallExpression myCall;

        StreamIteratorSource(PsiMethodCallExpression call, PsiType type) {
            this.myCall = call;
            this.myElementType = type.getCanonicalText();
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopReplacementContext context) {
            this.myCall = FunctionHelper.replaceVarReference(this.myCall, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myCall);
        }

        @Override
        public void preprocessVariables(StreamToLoopReplacementContext context, ChainVariable inVar, ChainVariable outVar) {
            String unpluralized;
            String name = this.myCall.getMethodExpression().getReferenceName();
            if (name != null && (unpluralized = StringUtil.unpluralize((String)name)) != null && !unpluralized.equals(name)) {
                outVar.addOtherNameCandidate(unpluralized);
            }
        }

        static String getIteratorType(String type) {
            return switch (type) {
                case "int" -> "java.util.PrimitiveIterator.OfInt";
                case "long" -> "java.util.PrimitiveIterator.OfLong";
                case "double" -> "java.util.PrimitiveIterator.OfDouble";
                default -> "java.util.Iterator<" + type + ">";
            };
        }

        @Override
        String wrap(ChainVariable outVar, String code, StreamToLoopReplacementContext context) {
            String iterator = context.registerVarName(Arrays.asList("it", "iter", "iterator"));
            String declaration = StreamIteratorSource.getIteratorType(this.myElementType) + " " + iterator + "=" + this.myCall.getText() + ".iterator()";
            String condition = iterator + ".hasNext()";
            return "for(" + declaration + ";" + condition + ";) {\n" + outVar.getDeclaration(iterator + ".next()") + code + "}\n";
        }
    }
}

