/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.TrivialFunctionalExpressionUsageInspection;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.codeInspection.streamToLoop.Operation;
import com.intellij.codeInspection.streamToLoop.SourceOperation;
import com.intellij.codeInspection.streamToLoop.StreamToLoopReplacementContext;
import com.intellij.codeInspection.streamToLoop.TerminalOperation;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StreamToLoopInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(StreamToLoopInspection.class);
    private static final Set<String> SUPPORTED_TERMINALS = Set.of("count", "sum", "summaryStatistics", "reduce", "collect", "findFirst", "findAny", "anyMatch", "allMatch", "noneMatch", "toArray", "average", "forEach", "forEachOrdered", "min", "max", "toList", "toSet", "toImmutableList", "toImmutableSet");
    private static final CallMatcher ITERABLE_FOREACH = CallMatcher.instanceCall((String)"java.lang.Iterable", (String[])new String[]{"forEach"}).parameterTypes(new String[]{"java.util.function.Consumer"});
    private static final CallMatcher MAP_FOREACH = CallMatcher.instanceCall((String)"java.util.Map", (String[])new String[]{"forEach"}).parameterTypes(new String[]{"java.util.function.BiConsumer"});
    public boolean SUPPORT_UNKNOWN_SOURCES = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"SUPPORT_UNKNOWN_SOURCES", (String)JavaBundle.message((String)"checkbox.iterate.unknown.stream.sources.via.stream.iterator", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            StreamToLoopInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            StreamToLoopInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            StreamToLoopInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(call);
                PsiReferenceExpression expression = call.getMethodExpression();
                PsiElement nameElement = expression.getReferenceNameElement();
                if (nameElement == null || !SUPPORTED_TERMINALS.contains(nameElement.getText())) {
                    return;
                }
                if (!CodeBlockSurrounder.canSurround((PsiExpression)call)) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream")) {
                    if (StreamToLoopInspection.extractOperations(ChainVariable.STUB, call, StreamToLoopInspection.this.SUPPORT_UNKNOWN_SOURCES) != null) {
                        this.register(call, nameElement, JavaBundle.message((String)"stream.to.loop.inspection.message.replace.stream.api.chain.with.loop", (Object[])new Object[0]));
                    }
                } else if (StreamToLoopInspection.extractIterableForEach(call) != null || StreamToLoopInspection.extractMapForEach(call) != null) {
                    this.register(call, nameElement, JavaBundle.message((String)"stream.to.loop.inspection.message.replace.foreach.call.with.loop", (Object[])new Object[0]));
                }
            }

            private void register(PsiMethodCallExpression call, PsiElement nameElement, @InspectionMessage String message) {
                TextRange range = isOnTheFly && InspectionProjectProfileManager.isInformationLevel((String)StreamToLoopInspection.this.getShortName(), (PsiElement)call) ? new TextRange(0, call.getTextLength()) : nameElement.getTextRange().shiftRight(-call.getTextOffset());
                holder.registerProblem((PsiElement)call, range, message, new LocalQuickFix[]{new ReplaceStreamWithLoopFix(message)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/streamToLoop/StreamToLoopInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    @Nullable
    static Operation createOperationFromCall(ChainVariable outVar, PsiMethodCallExpression call, boolean supportUnknownSources) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        String name = method.getName();
        String className = aClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        PsiType callType = call.getType();
        if (callType == null) {
            return null;
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream") && !method.getModifierList().hasExplicitModifier("static")) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier != null) {
                PsiType elementType = StreamApiUtil.getStreamElementType((PsiType)qualifier.getType());
                if (!StreamToLoopInspection.isValidElementType(elementType, (PsiElement)call, false)) {
                    return null;
                }
                Operation op = Operation.createIntermediate(name, args, outVar, elementType, supportUnknownSources);
                if (op != null) {
                    return op;
                }
                op = TerminalOperation.createTerminal(name, args, elementType, callType, ExpressionUtils.isVoidContext((PsiExpression)call));
                if (op != null) {
                    return op;
                }
            }
            return null;
        }
        return SourceOperation.createSource(call, supportUnknownSources);
    }

    private static boolean isValidElementType(PsiType elementType, PsiElement context, boolean allowRaw) {
        PsiResolveHelper helper;
        if (elementType == null || !allowRaw && elementType instanceof PsiClassType && ((PsiClassType)elementType).isRaw()) {
            return false;
        }
        return !(elementType instanceof PsiImmediateClassType) || (helper = PsiResolveHelper.getInstance((Project)context.getProject())).resolveReferencedClass(elementType.getCanonicalText(), context) != null;
    }

    @Nullable
    static List<OperationRecord> extractIterableForEach(PsiMethodCallExpression terminalCall) {
        if (!ITERABLE_FOREACH.test(terminalCall) || !ExpressionUtils.isVoidContext((PsiExpression)terminalCall)) {
            return null;
        }
        PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)terminalCall.getMethodExpression());
        if (qualifier == null) {
            return null;
        }
        PsiType type = qualifier.getType();
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.stream.BaseStream")) {
            return null;
        }
        PsiExpression arg = terminalCall.getArgumentList().getExpressions()[0];
        FunctionHelper fn = FunctionHelper.create(arg, 1, true);
        if (fn == null) {
            return null;
        }
        PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.lang.Iterable", (int)0, (boolean)false);
        if (!StreamToLoopInspection.isValidElementType(elementType, (PsiElement)terminalCall, true)) {
            return null;
        }
        elementType = GenericsUtil.getVariableTypeByExpressionType((PsiType)elementType);
        TerminalOperation.ForEachTerminalOperation terminal = new TerminalOperation.ForEachTerminalOperation(fn);
        SourceOperation.ForEachSource source = new SourceOperation.ForEachSource(qualifier);
        OperationRecord terminalRecord = new OperationRecord();
        OperationRecord sourceRecord = new OperationRecord();
        terminalRecord.myOperation = terminal;
        sourceRecord.myOperation = source;
        sourceRecord.myOutVar = terminalRecord.myInVar = new ChainVariable(elementType);
        sourceRecord.myInVar = terminalRecord.myOutVar = ChainVariable.STUB;
        return Arrays.asList(sourceRecord, terminalRecord);
    }

    @Nullable
    static List<OperationRecord> extractMapForEach(PsiMethodCallExpression terminalCall) {
        if (!MAP_FOREACH.test(terminalCall) || !ExpressionUtils.isVoidContext((PsiExpression)terminalCall)) {
            return null;
        }
        PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)terminalCall.getMethodExpression());
        if (qualifier == null) {
            return null;
        }
        PsiType type = qualifier.getType();
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.stream.BaseStream")) {
            return null;
        }
        PsiExpression arg = terminalCall.getArgumentList().getExpressions()[0];
        FunctionHelper fn = FunctionHelper.create(arg, 2, true);
        if (fn == null) {
            return null;
        }
        PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)0, (boolean)false);
        PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)1, (boolean)false);
        if (!StreamToLoopInspection.isValidElementType(keyType, (PsiElement)terminalCall, true) || !StreamToLoopInspection.isValidElementType(valueType, (PsiElement)terminalCall, true)) {
            return null;
        }
        Project project = terminalCall.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass entryClass = facade.findClass("java.util.Map.Entry", terminalCall.getResolveScope());
        if (entryClass == null || entryClass.getTypeParameters().length != 2) {
            return null;
        }
        PsiClassType entryType = JavaPsiFacade.getElementFactory((Project)project).createType(entryClass, new PsiType[]{keyType, valueType});
        keyType = GenericsUtil.getVariableTypeByExpressionType((PsiType)keyType);
        valueType = GenericsUtil.getVariableTypeByExpressionType((PsiType)valueType);
        TerminalOperation.MapForEachTerminalOperation terminal = new TerminalOperation.MapForEachTerminalOperation(fn, keyType, valueType);
        SourceOperation.ForEachSource source = new SourceOperation.ForEachSource(qualifier, true);
        OperationRecord terminalRecord = new OperationRecord();
        OperationRecord sourceRecord = new OperationRecord();
        terminalRecord.myOperation = terminal;
        sourceRecord.myOperation = source;
        sourceRecord.myOutVar = terminalRecord.myInVar = new ChainVariable((PsiType)entryType);
        sourceRecord.myInVar = terminalRecord.myOutVar = ChainVariable.STUB;
        return Arrays.asList(sourceRecord, terminalRecord);
    }

    @Nullable
    static List<OperationRecord> extractOperations(ChainVariable outVar, PsiMethodCallExpression terminalCall, boolean supportUnknownSources) {
        ArrayList<OperationRecord> operations = new ArrayList<OperationRecord>();
        PsiMethodCallExpression currentCall = terminalCall;
        ChainVariable lastVar = outVar;
        Operation next = null;
        Operation op;
        while ((op = StreamToLoopInspection.createOperationFromCall(lastVar, currentCall, supportUnknownSources)) != null) {
            Operation combined;
            if (next != null && (combined = op.combineWithNext(next)) != null) {
                op = combined;
                operations.removeLast();
            }
            OperationRecord or = new OperationRecord();
            or.myOperation = op;
            or.myOutVar = lastVar;
            operations.add(or);
            if (op instanceof SourceOperation) {
                or.myInVar = ChainVariable.STUB;
                Collections.reverse(operations);
                return operations;
            }
            if ((currentCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)currentCall)) == null) {
                return null;
            }
            if (op.changesVariable()) {
                PsiType type = StreamApiUtil.getStreamElementType((PsiType)currentCall.getType());
                if (type == null) {
                    return null;
                }
                lastVar = new ChainVariable(type);
            }
            or.myInVar = lastVar;
            next = op;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    static TerminalOperation getTerminal(List<? extends OperationRecord> operations) {
        if (operations == null || operations.isEmpty()) {
            return null;
        }
        OperationRecord record = operations.getLast();
        if (record.myOperation instanceof TerminalOperation) {
            return (TerminalOperation)record.myOperation;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamToLoop/StreamToLoopInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamToLoop/StreamToLoopInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    static class OperationRecord {
        Operation myOperation;
        ChainVariable myInVar;
        ChainVariable myOutVar;

        OperationRecord() {
        }
    }

    static enum ResultKind {
        FINAL,
        NON_FINAL,
        UNKNOWN;

    }

    static class ReplaceStreamWithLoopFix
    extends PsiUpdateModCommandQuickFix {
        @IntentionName
        private final String myMessage;

        ReplaceStreamWithLoopFix(@IntentionName String message) {
            this.myMessage = message;
        }

        @NotNull
        public String getName() {
            String string = this.myMessage;
            if (string == null) {
                ReplaceStreamWithLoopFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"quickfix.family.replace.stream.api.chain.with.loop", (Object[])new Object[0]);
            if (string == null) {
                ReplaceStreamWithLoopFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            TerminalOperation terminal;
            if (project == null) {
                ReplaceStreamWithLoopFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceStreamWithLoopFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceStreamWithLoopFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression terminalCall = (PsiMethodCallExpression)element;
            CodeBlockSurrounder surrounder = CodeBlockSurrounder.forExpression((PsiExpression)terminalCall);
            if (surrounder == null) {
                return;
            }
            CodeBlockSurrounder.SurroundResult surroundResult = surrounder.surround();
            terminalCall = (PsiMethodCallExpression)surroundResult.getExpression();
            PsiType resultType = terminalCall.getType();
            if (resultType == null) {
                return;
            }
            List<OperationRecord> operations = StreamToLoopInspection.extractOperations(ChainVariable.STUB, terminalCall, true);
            if (operations == null) {
                operations = StreamToLoopInspection.extractIterableForEach(terminalCall);
            }
            if (operations == null) {
                operations = StreamToLoopInspection.extractMapForEach(terminalCall);
            }
            if ((terminal = StreamToLoopInspection.getTerminal(operations)) == null) {
                return;
            }
            PsiStatement statement = surroundResult.getAnchor();
            CommentTracker ct = new CommentTracker();
            try {
                PsiElement firstAdded;
                StreamToLoopReplacementContext context = new StreamToLoopReplacementContext(statement, operations, (PsiExpression)terminalCall, ct);
                ReplaceStreamWithLoopFix.registerVariables(operations, context);
                String replacement = "";
                for (OperationRecord or : StreamEx.ofReversed(operations)) {
                    replacement = or.myOperation.wrap(or.myInVar, or.myOutVar, replacement, context);
                }
                PsiElement previous = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)statement);
                PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement);
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                for (PsiStatement addedStatement : ((PsiBlockStatement)factory.createStatementFromText("{" + replacement + "}", (PsiElement)statement)).getCodeBlock().getStatements()) {
                    ReplaceStreamWithLoopFix.addStatement(statement, addedStatement);
                }
                PsiElement result = context.makeFinalReplacement();
                if (result != null) {
                    ReplaceStreamWithLoopFix.normalize(result);
                }
                if (previous != null && (firstAdded = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)previous)) != null) {
                    ct.insertCommentsBefore(firstAdded);
                    JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                    for (PsiElement e = firstAdded; e != null && e != next; e = e.getNextSibling()) {
                        codeStyleManager.shortenClassReferences(e);
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Error converting Stream to loop", (Throwable)ex, new Attachment[]{new Attachment("Stream_code.txt", terminalCall.getText())});
            }
        }

        private static void addStatement(PsiStatement statement, PsiStatement context) {
            PsiElement element = statement.getParent().addBefore((PsiElement)context, (PsiElement)statement);
            ReplaceStreamWithLoopFix.normalize(element);
        }

        private static void normalize(@NotNull PsiElement element) {
            if (element == null) {
                ReplaceStreamWithLoopFix.$$$reportNull$$$0(5);
            }
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments((PsiElement)element);
            RedundantCastUtil.getRedundantCastsInside((PsiElement)element).forEach(RemoveRedundantCastUtil::removeCast);
            TrivialFunctionalExpressionUsageInspection.simplifyAllLambdas((PsiElement)element);
        }

        private static StreamEx<OperationRecord> allOperations(List<OperationRecord> operations) {
            return StreamEx.of(operations).flatMap(or -> or.myOperation.nestedOperations().append(or));
        }

        private static void registerVariables(List<OperationRecord> operations, StreamToLoopReplacementContext context) {
            ReplaceStreamWithLoopFix.allOperations(operations).forEach(or -> or.myOperation.preprocessVariables(context, or.myInVar, or.myOutVar));
            ReplaceStreamWithLoopFix.allOperations(operations).map(or -> or.myOperation).forEach(op -> op.registerReusedElements(context::registerReusedElement));
            ((StreamEx)ReplaceStreamWithLoopFix.allOperations(operations).map(or -> or.myInVar).distinct()).forEach(var -> var.register(context));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamToLoop/StreamToLoopInspection$ReplaceStreamWithLoopFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamToLoop/StreamToLoopInspection$ReplaceStreamWithLoopFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "normalize";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

