/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.CommonJavaInlineUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConvertToLocalUtils {
    ConvertToLocalUtils() {
    }

    @Nullable
    public static PsiElement copyVariableToMethodBody(PsiVariable variable, List<? extends PsiReferenceExpression> references, Function<? super PsiCodeBlock, String> newName) {
        PsiElement newDeclaration;
        PsiCodeBlock anchorBlock = ConvertToLocalUtils.findAnchorBlock(references);
        if (anchorBlock == null) {
            return null;
        }
        PsiElement firstElement = ConvertToLocalUtils.getLowestOffsetElement(references);
        String localName = newName.apply((PsiCodeBlock)anchorBlock);
        PsiElement anchor = ConvertToLocalUtils.getAnchorElement(anchorBlock, firstElement);
        if (anchor == null) {
            return null;
        }
        PsiAssignmentExpression anchorAssignmentExpression = ConvertToLocalUtils.searchAssignmentExpression(anchor);
        PsiExpression initializer = anchorAssignmentExpression != null && ConvertToLocalUtils.isVariableAssignment(anchorAssignmentExpression, variable) ? anchorAssignmentExpression.getRExpression() : variable.getInitializer();
        PsiElementFactory psiFactory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
        PsiDeclarationStatement declaration = psiFactory.createVariableDeclarationStatement(localName, variable.getType(), initializer, (PsiElement)variable);
        for (int i = 1; i < references.size(); ++i) {
            if (!PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)references.get(i)))) continue;
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiLocalVariable)declaration.getDeclaredElements()[0]), (String)"final", (boolean)false);
            break;
        }
        if (anchorAssignmentExpression != null && ConvertToLocalUtils.isVariableAssignment(anchorAssignmentExpression, variable)) {
            newDeclaration = new CommentTracker().replaceAndRestoreComments(anchor, (PsiElement)declaration);
        } else if (anchorBlock.getParent() instanceof PsiSwitchStatement) {
            PsiElement parent = anchorBlock.getParent();
            PsiElement switchContainer = parent.getParent();
            newDeclaration = switchContainer.addBefore((PsiElement)declaration, parent);
        } else {
            newDeclaration = anchorBlock.addBefore((PsiElement)declaration, anchor);
        }
        ConvertToLocalUtils.retargetReferences(psiFactory, localName, references);
        return newDeclaration;
    }

    public static void inlineRedundant(@Nullable PsiElement declaration) {
        PsiExpression initializer;
        PsiLocalVariable newVariable = ConvertToLocalUtils.extractDeclared(declaration);
        if (newVariable != null && VariableAccessUtils.isLocalVariableCopy((PsiLocalVariable)newVariable, (PsiExpression)(initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)newVariable.getInitializer())))) {
            List references = VariableAccessUtils.getVariableReferences((PsiVariable)newVariable);
            for (PsiJavaCodeReferenceElement reference : references) {
                CommonJavaInlineUtil.getInstance().inlineVariable((PsiVariable)newVariable, initializer, reference, null);
            }
            declaration.delete();
        }
    }

    @Nullable
    private static PsiLocalVariable extractDeclared(@Nullable PsiElement declaration) {
        PsiLocalVariable var;
        PsiElement psiElement;
        if (!(declaration instanceof PsiDeclarationStatement)) {
            return null;
        }
        PsiDeclarationStatement statement = (PsiDeclarationStatement)declaration;
        PsiElement[] declaredElements = statement.getDeclaredElements();
        return declaredElements.length == 1 && (psiElement = declaredElements[0]) instanceof PsiLocalVariable ? (var = (PsiLocalVariable)psiElement) : null;
    }

    @Nullable
    private static PsiAssignmentExpression searchAssignmentExpression(@Nullable PsiElement anchor) {
        PsiAssignmentExpression assignment;
        if (!(anchor instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpressionStatement statement = (PsiExpressionStatement)anchor;
        PsiExpression psiExpression = statement.getExpression();
        return psiExpression instanceof PsiAssignmentExpression ? (assignment = (PsiAssignmentExpression)psiExpression) : null;
    }

    private static boolean isVariableAssignment(@NotNull PsiAssignmentExpression expression, @NotNull PsiVariable variable) {
        PsiReferenceExpression leftExpression;
        PsiExpression psiExpression;
        if (expression == null) {
            ConvertToLocalUtils.$$$reportNull$$$0(0);
        }
        if (variable == null) {
            ConvertToLocalUtils.$$$reportNull$$$0(1);
        }
        return expression.getOperationTokenType() == JavaTokenType.EQ && (psiExpression = expression.getLExpression()) instanceof PsiReferenceExpression && (leftExpression = (PsiReferenceExpression)psiExpression).isReferenceTo((PsiElement)variable);
    }

    private static void retargetReferences(PsiElementFactory elementFactory, String newName, Collection<? extends PsiReferenceExpression> refs) {
        PsiReferenceExpression newRef = (PsiReferenceExpression)elementFactory.createExpressionFromText(newName, null);
        for (PsiReferenceExpression psiReferenceExpression : refs) {
            psiReferenceExpression.replace((PsiElement)newRef);
        }
    }

    @Nullable
    private static PsiElement getAnchorElement(PsiCodeBlock anchorBlock, @Nullable PsiElement firstElement) {
        PsiElement element;
        for (element = firstElement; element != null && element.getParent() != anchorBlock; element = element.getParent()) {
        }
        return element;
    }

    @Nullable
    private static PsiElement getLowestOffsetElement(@NotNull Collection<? extends PsiReferenceExpression> refs) {
        if (refs == null) {
            ConvertToLocalUtils.$$$reportNull$$$0(2);
        }
        PsiReferenceExpression firstElement = null;
        for (PsiReferenceExpression psiReferenceExpression : refs) {
            if (firstElement != null && firstElement.getTextRange().getStartOffset() <= psiReferenceExpression.getTextRange().getStartOffset()) continue;
            firstElement = psiReferenceExpression;
        }
        return firstElement;
    }

    private static PsiCodeBlock findAnchorBlock(Collection<? extends PsiReferenceExpression> refs) {
        PsiCodeBlock result = null;
        for (PsiReferenceExpression psiReferenceExpression : refs) {
            if (PsiUtil.isInsideJavadocComment((PsiElement)psiReferenceExpression)) continue;
            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)psiReferenceExpression, PsiCodeBlock.class);
            if (result == null || block == null) {
                result = block;
                continue;
            }
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)result, (PsiElement)block);
            if ((result = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class, (boolean)false)) != null) continue;
            return null;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/ConvertToLocalUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isVariableAssignment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLowestOffsetElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

