/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.wrongPackageStatement;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.MoveToPackageFix;
import com.intellij.codeInspection.MoveToPackageModCommandFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.wrongPackageStatement.AdjustPackageNameFix;
import com.intellij.java.codeserver.core.JavaPsiSingleFileSourceUtil;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SingleFileSourcesTracker;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WrongPackageStatementInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static void addMoveToPackageFix(@NotNull PsiFile file, String packName, @NotNull List<? super LocalQuickFix> availableFixes) {
        ModCommandAction moveToPackageFix;
        if (file == null) {
            WrongPackageStatementInspection.$$$reportNull$$$0(0);
        }
        if (availableFixes == null) {
            WrongPackageStatementInspection.$$$reportNull$$$0(1);
        }
        if ((moveToPackageFix = MoveToPackageModCommandFix.createIfAvailable((PsiFile)file, (String)packName)) != null) {
            availableFixes.add((LocalQuickFix)LocalQuickFix.from((ModCommandAction)moveToPackageFix));
        } else {
            MoveToPackageFix oldFix = MoveToPackageFix.createIfAvailable((PsiFile)file, (String)packName);
            if (oldFix != null) {
                availableFixes.add((LocalQuickFix)oldFix);
            }
        }
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            WrongPackageStatementInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            WrongPackageStatementInspection.$$$reportNull$$$0(3);
        }
        if (!(file instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
            return null;
        }
        if (JavaPsiSingleFileSourceUtil.isJavaHashBangScript((PsiFile)javaFile)) {
            return null;
        }
        PsiDirectory directory = javaFile.getOriginalFile().getContainingDirectory();
        if (directory == null) {
            return null;
        }
        PsiPackage dirPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (dirPackage == null) {
            return null;
        }
        PsiPackageStatement packageStatement = javaFile.getPackageStatement();
        String packageName = dirPackage.getQualifiedName();
        SingleFileSourcesTracker singleFileSourcesTracker = SingleFileSourcesTracker.getInstance((Project)file.getProject());
        String singleFileSourcePackageName = singleFileSourcesTracker.getPackageNameForSingleFileSource(file.getVirtualFile());
        if (singleFileSourcePackageName != null) {
            packageName = singleFileSourcePackageName;
        }
        if (packageStatement == null) {
            if (!Comparing.strEqual((String)packageName, (String)"", (boolean)true)) {
                String description;
                AdjustPackageNameFix fix;
                PsiClass[] classes = javaFile.getClasses();
                if (classes.length == 0) {
                    return null;
                }
                PsiIdentifier nameIdentifier = classes[0].getNameIdentifier();
                if (nameIdentifier == null) {
                    return null;
                }
                if (PsiDirectoryFactory.getInstance((Project)file.getProject()).isValidPackageName(packageName)) {
                    fix = new AdjustPackageNameFix(packageName);
                    description = JavaErrorBundle.message((String)"missing.package.statement", (Object[])new Object[]{packageName});
                } else {
                    fix = null;
                    description = JavaErrorBundle.message((String)"missing.package.statement.package.name.invalid", (Object[])new Object[]{packageName});
                }
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)nameIdentifier, description, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
            }
        } else {
            if (ContainerUtil.or((Object[])javaFile.getClasses(), c -> c instanceof PsiImplicitClass)) {
                return null;
            }
            PsiJavaCodeReferenceElement packageReference = packageStatement.getPackageReference();
            PsiPackage classPackage = (PsiPackage)packageReference.resolve();
            ArrayList<AdjustPackageNameFix> availableFixes = new ArrayList<AdjustPackageNameFix>();
            if (classPackage == null || !Comparing.equal((String)packageName, (String)packageReference.getQualifiedName(), (boolean)true)) {
                if (PsiDirectoryFactory.getInstance((Project)file.getProject()).isValidPackageName(packageName)) {
                    availableFixes.add(new AdjustPackageNameFix(packageName));
                }
                String packName = classPackage != null ? classPackage.getQualifiedName() : packageReference.getQualifiedName();
                WrongPackageStatementInspection.addMoveToPackageFix(file, packName, availableFixes);
            }
            if (!availableFixes.isEmpty()) {
                String description = JavaErrorBundle.message((String)"package.name.file.path.mismatch", (Object[])new Object[]{packageReference.getQualifiedName(), packageName});
                LocalQuickFix[] fixes = availableFixes.toArray(LocalQuickFix.EMPTY_ARRAY);
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)packageStatement.getPackageReference(), description, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                return new ProblemDescriptor[]{descriptor};
            }
        }
        return null;
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            WrongPackageStatementInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "WrongPackageStatement";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableFixes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/wrongPackageStatement/WrongPackageStatementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/wrongPackageStatement/WrongPackageStatementInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addMoveToPackageFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

