/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CantRunException
extends ExecutionException {
    public CantRunException(@NlsContexts.DialogMessage String message) {
        super(message);
    }

    public CantRunException(@NlsContexts.DialogMessage String message, Throwable cause) {
        super(message, cause);
    }

    public static CantRunException noModuleConfigured(@Nullable String moduleName) {
        return StringUtil.isEmptyOrSpaces((String)moduleName) ? new CantRunException(ExecutionBundle.message("no.module.defined.error.message", new Object[0])) : new CantRunException(ExecutionBundle.message("module.does.not.exist.error.message", moduleName));
    }

    public static CantRunException noJdkForModule(@NotNull Module module) {
        if (module == null) {
            CantRunException.$$$reportNull$$$0(0);
        }
        return new CantRunException(ExecutionBundle.message("no.jdk.for.module.error.message", module.getName()));
    }

    public static CantRunException jdkMisconfigured(@NotNull Sdk jdk) {
        if (jdk == null) {
            CantRunException.$$$reportNull$$$0(1);
        }
        return new CantRunException(ExecutionBundle.message("jdk.is.bad.configured.error.message", jdk.getName()));
    }

    public static CantRunException classNotFound(@NotNull String className, @NotNull Module module) {
        if (className == null) {
            CantRunException.$$$reportNull$$$0(2);
        }
        if (module == null) {
            CantRunException.$$$reportNull$$$0(3);
        }
        return new CantRunException(ExecutionBundle.message("class.not.found.in.module.error.message", className, module.getName()));
    }

    public static CantRunException packageNotFound(@NotNull String packageName) {
        if (packageName == null) {
            CantRunException.$$$reportNull$$$0(4);
        }
        return new CantRunException(ExecutionBundle.message("package.not.found.error.message", packageName));
    }

    public static CantRunException badModuleDependencies() {
        return new CantRunException(ExecutionBundle.message("some.modules.has.circular.dependency.error.message", new Object[0]));
    }

    public static CantRunException noJdkConfigured() {
        return new CantRunException(ExecutionBundle.message("project.has.no.jdk.configured.error.message", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/CantRunException";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "noJdkForModule";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "jdkMisconfigured";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "classNotFound";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "packageNotFound";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CustomProcessedCantRunException
    extends CantRunException {
        public CustomProcessedCantRunException() {
            super("");
        }
    }
}

