/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HtmlToSimpleColoredComponentConverter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.lang.runtime.SwitchBootstraps;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;
import javax.swing.text.html.HTML;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TestStatusLine
extends NonOpaquePanel {
    private static final SimpleTextAttributes IGNORED_ATTRIBUTES = new SimpleTextAttributes(0, JBUI.CurrentTheme.Label.warningForeground());
    private static final SimpleTextAttributes FAILED_ATTRIBUTES = new SimpleTextAttributes(0, JBUI.CurrentTheme.Label.errorForeground());
    private final HtmlToSimpleColoredComponentConverter myConverter;
    protected final JProgressBar myProgressBar = new JProgressBar();
    protected final SimpleColoredComponent myState = new SimpleColoredComponent();
    private final SimpleColoredComponent myStateDescription = new SimpleColoredComponent();
    private final JPanel myProgressPanel;
    private final JLabel myWarning = new JLabel();

    @TestOnly
    @ApiStatus.Internal
    public SimpleColoredComponent getStateDescription() {
        return this.myStateDescription;
    }

    public TestStatusLine() {
        super((LayoutManager)new BorderLayout());
        this.myProgressPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.add(this.myProgressPanel, "South");
        this.myProgressBar.setMaximum(100);
        this.myProgressBar.putClientProperty("ProgressBar.stripeWidth", 3);
        this.myProgressBar.putClientProperty("ProgressBar.status", "passed");
        NonOpaquePanel stateWrapper = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        stateWrapper.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        GridBag constraint = new GridBag();
        this.myState.setOpaque(false);
        stateWrapper.add((Component)this.myState, constraint.next());
        this.myStateDescription.setOpaque(false);
        stateWrapper.add((Component)this.myStateDescription, constraint.next().insetLeft(6));
        this.myWarning.setOpaque(false);
        this.myWarning.setVisible(false);
        this.myWarning.setIcon(AllIcons.General.Warning);
        stateWrapper.add((Component)this.myWarning, constraint.next().insetLeft(12));
        this.add((Component)stateWrapper, "West");
        this.myState.append(ExecutionBundle.message("junit.running.info.starting.label", new Object[0]));
        this.myConverter = new HtmlToSimpleColoredComponentConverter((tag, attr) -> {
            String className;
            String selector0$temp = className = (String)attr.getAttribute(HTML.Attribute.CLASS);
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"failed", "ignored"}, (Object)selector0$temp, index$1)) {
                case 0 -> FAILED_ATTRIBUTES;
                case 1 -> IGNORED_ATTRIBUTES;
                default -> SimpleTextAttributes.REGULAR_ATTRIBUTES;
            };
        });
    }

    public void formatTestMessage(int testsTotal, int finishedTestsCount, int failuresCount, int ignoredTestsCount, Long duration, long endTime) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.doFormatTestMessage(testsTotal, finishedTestsCount, failuresCount, ignoredTestsCount, duration, endTime);
            this.updateWarningVisibility();
        });
    }

    private void updateWarningVisibility() {
        this.myWarning.setVisible(!this.myState.getCharSequence(false).isEmpty() && StringUtil.isNotEmpty((String)this.myWarning.getText()));
    }

    private void doFormatTestMessage(int testsTotal, int finishedTestsCount, int failuresCount, int ignoredTestsCount, Long duration, long endTime) {
        boolean indefinite;
        this.myState.clear();
        this.myStateDescription.clear();
        if (testsTotal == 0 && (testsTotal = finishedTestsCount) == 0) {
            return;
        }
        int passedCount = Math.max(finishedTestsCount - failuresCount - ignoredTestsCount, 0);
        boolean ongoing = finishedTestsCount != testsTotal;
        boolean finished = endTime != 0L;
        boolean bl = indefinite = testsTotal < 0;
        if (ongoing && finished) {
            this.myState.append(TestRunnerBundle.message("test.result.stopped", new Object[0]));
            this.myState.append(" ");
        }
        if (failuresCount == 0 && ignoredTestsCount == 0) {
            this.myState.append(TestRunnerBundle.message("test.result.all.passed", finishedTestsCount));
        } else if (passedCount == 0 && ignoredTestsCount == 0) {
            this.appendColored(TestRunnerBundle.message("test.result.all.failed", failuresCount));
        } else if (failuresCount == 0 && passedCount == 0) {
            this.appendColored(TestRunnerBundle.message("test.result.all.ignored", ignoredTestsCount));
        } else if (ignoredTestsCount == 0) {
            this.appendColored(TestRunnerBundle.message("test.result.failed.passed", failuresCount, passedCount));
        } else if (passedCount == 0) {
            this.appendColored(TestRunnerBundle.message("test.result.failed.ignored", failuresCount, ignoredTestsCount));
        } else if (failuresCount == 0) {
            this.appendColored(TestRunnerBundle.message("test.result.passed.ignored", passedCount, ignoredTestsCount));
        } else {
            this.appendColored(TestRunnerBundle.message("test.result.failed.passed.ignored", failuresCount, passedCount, ignoredTestsCount));
        }
        int count = failuresCount + passedCount + ignoredTestsCount;
        if (ongoing && finished && !indefinite && duration != null) {
            this.myStateDescription.append(TestRunnerBundle.message("test.result.in.progress.description.and.duration", count, testsTotal, NlsMessages.formatDurationApproximateNarrow((long)duration)), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (finished && indefinite && duration != null) {
            this.myStateDescription.append(TestRunnerBundle.message("test.result.finished.description", count, NlsMessages.formatDurationApproximateNarrow((long)duration)), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (ongoing && !indefinite) {
            this.myStateDescription.append(TestRunnerBundle.message("test.result.in.progress.description", count, testsTotal), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (!indefinite && duration != null) {
            this.myStateDescription.append(TestRunnerBundle.message("test.result.finished.description", testsTotal, NlsMessages.formatDurationApproximateNarrow((long)duration)), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    private void appendColored(@Nls String text2) {
        this.myConverter.convert(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES).forEach(frag -> this.myState.append(frag.getText(), frag.getAttributes()));
    }

    public void setIndeterminate(boolean flag) {
        this.myProgressPanel.add((Component)this.myProgressBar, "North");
        this.myProgressBar.setIndeterminate(flag);
    }

    public void onTestsDone(@Nullable Supplier<? extends Icon> toolbarIconSupplier) {
        EdtInvocationManager.getInstance().invokeLater(() -> {
            if (toolbarIconSupplier != null) {
                this.myState.setIcon((Icon)toolbarIconSupplier.get());
            }
        });
    }

    @ApiStatus.Internal
    public String getStatus() {
        Object property = this.myProgressBar.getClientProperty("ProgressBar.status");
        if (property == null) {
            return null;
        }
        return (String)property;
    }

    public void setStatus(@NotNull String status) {
        if (status == null) {
            TestStatusLine.$$$reportNull$$$0(0);
        }
        this.myProgressBar.putClientProperty("ProgressBar.status", status);
    }

    public void setFraction(double v) {
        int fraction2 = (int)(v * 100.0);
        this.myProgressBar.setValue(fraction2);
    }

    @ApiStatus.Internal
    public void showProgressBar() {
        this.myProgressBar.setVisible(true);
    }

    @ApiStatus.Internal
    public void hideProgressBar() {
        this.myProgressBar.setVisible(false);
    }

    public void setText(@Nls String progressStatus_text) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myState.clear();
            this.myState.append(progressStatus_text);
        });
    }

    @NlsSafe
    @NotNull
    public String getStateText() {
        String string = this.myState.toString();
        if (string == null) {
            TestStatusLine.$$$reportNull$$$0(1);
        }
        return string;
    }

    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public SimpleColoredComponent.ColoredIterator getStateIterator() {
        SimpleColoredComponent.ColoredIterator coloredIterator = this.myState.iterator();
        if (coloredIterator == null) {
            TestStatusLine.$$$reportNull$$$0(2);
        }
        return coloredIterator;
    }

    @ApiStatus.Internal
    public void setWarning(@Nls @NotNull String suffix) {
        if (suffix == null) {
            TestStatusLine.$$$reportNull$$$0(3);
        }
        this.myWarning.setText(suffix);
        this.updateWarningVisibility();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/ui/TestStatusLine";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/ui/TestStatusLine";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setStatus";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setWarning";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

