/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.themePicker;

import com.intellij.internal.inspector.themePicker.ThemeColorInfo;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/inspector/themePicker/EditorColorPicker;", "", "<init>", "()V", "getEditorColorsAt", "", "Lcom/intellij/internal/inspector/themePicker/ThemeColorInfo;", "point", "Lcom/intellij/ui/awt/RelativePoint;", "processMarkupModel", "", "result", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "offset", "", "processSyntaxModel", "intellij.platform.ide.ui.inspector"})
@SourceDebugExtension(value={"SMAP\nEditorColorPicker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorColorPicker.kt\ncom/intellij/internal/inspector/themePicker/EditorColorPicker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n812#2,12:63\n1080#2:75\n*S KotlinDebug\n*F\n+ 1 EditorColorPicker.kt\ncom/intellij/internal/inspector/themePicker/EditorColorPicker\n*L\n35#1:63,12\n35#1:75\n*E\n"})
public final class EditorColorPicker {
    @NotNull
    public static final EditorColorPicker INSTANCE = new EditorColorPicker();

    private EditorColorPicker() {
    }

    @Nullable
    public final List<ThemeColorInfo> getEditorColorsAt(@NotNull RelativePoint point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Component component = UIUtil.getDeepestComponentAt((Component)point.getComponent(), (int)point.getPoint().x, (int)point.getPoint().y);
        if (component == null) {
            return null;
        }
        Component component2 = component;
        EditorComponentImpl editorComponentImpl = component2 instanceof EditorComponentImpl ? (EditorComponentImpl)component2 : null;
        if (editorComponentImpl == null) {
            return null;
        }
        EditorComponentImpl editorComponent = editorComponentImpl;
        EditorImpl editorImpl = editorComponent.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorImpl, (String)"getEditor(...)");
        EditorImpl editor = editorImpl;
        LogicalPosition logicalPosition = editor.xyToLogicalPosition(point.getPoint((Component)editorComponent));
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
        LogicalPosition position = logicalPosition;
        int offset = editor.logicalPositionToOffset(position);
        List result2 = new ArrayList();
        this.processMarkupModel(result2, editor, offset);
        this.processSyntaxModel(result2, editor, offset);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void processMarkupModel(List<ThemeColorInfo> result2, EditorImpl editor, int offset) {
        void $this$sortedByDescending$iv;
        void $this$filterIsInstanceTo$iv$iv;
        MarkupModelEx markupModelEx = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx editorModel = markupModelEx;
        MarkupModelEx markupModelEx2 = editor.getFilteredDocumentMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx2, (String)"getFilteredDocumentMarkupModel(...)");
        MarkupModelEx documentModel = markupModelEx2;
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        editorModel.processRangeHighlightersOverlappingWith(offset - 1, offset + 1, (Processor<? super RangeHighlighterEx>)((Processor)processor));
        documentModel.processRangeHighlightersOverlappingWith(offset - 1, offset + 1, (Processor<? super RangeHighlighterEx>)((Processor)processor));
        Collection collection = processor.getResults();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResults(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof RangeHighlighterEx)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List highlighters = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RangeHighlighterEx it = (RangeHighlighterEx)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getLayer());
                it = (RangeHighlighterEx)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getLayer()));
            }
        });
        for (RangeHighlighterEx highlighterEx : highlighters) {
            int n;
            Intrinsics.checkNotNullExpressionValue((Object)editor.getDocument().getImmutableCharSequence(), (String)"getImmutableCharSequence(...)");
            int n2 = highlighterEx.getStartOffset();
            String text2 = ((Object)destination$iv$iv.subSequence(n2, n = highlighterEx.getEndOffset())).toString();
            ThemeColorInfo.HighlighterInfo highlighterInfo = new ThemeColorInfo.HighlighterInfo(text2.toString(), highlighterEx.getForcedTextAttributes(), highlighterEx.getTextAttributesKey(), highlighterEx.getTextAttributes());
            if (highlighterInfo.isEmpty()) continue;
            ((Collection)result2).add(highlighterInfo);
        }
    }

    private final void processSyntaxModel(List<ThemeColorInfo> result2, EditorImpl editor, int offset) {
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(offset - 1);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        while (!iterator.atEnd() && iterator.getStart() <= offset + 1) {
            CharSequence charSequence;
            Intrinsics.checkNotNullExpressionValue((Object)editor.getDocument().getImmutableCharSequence(), (String)"getImmutableCharSequence(...)");
            int n = iterator.getStart();
            int n2 = iterator.getEnd();
            String text2 = ((Object)charSequence.subSequence(n, n2)).toString();
            TextAttributesKey[] textAttributesKeyArray = iterator.getTextAttributesKeys();
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray, (String)"getTextAttributesKeys(...)");
            ThemeColorInfo.SyntaxInfo syntaxInfo = new ThemeColorInfo.SyntaxInfo(text2, textAttributesKeyArray, iterator.getTextAttributes());
            if (!syntaxInfo.isEmpty()) {
                ((Collection)result2).add(syntaxInfo);
            }
            iterator.advance();
        }
    }
}

