/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.list;

import com.intellij.collaboration.ui.codereview.avatar.CodeReviewAvatarUtils;
import com.intellij.collaboration.ui.codereview.list.NamedCollection;
import com.intellij.collaboration.ui.codereview.list.ReviewListComponentFactory;
import com.intellij.collaboration.ui.codereview.list.ReviewListItemPresentation;
import com.intellij.collaboration.ui.codereview.list.TagPresentation;
import com.intellij.collaboration.ui.codereview.list.UserPresentation;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import icons.CollaborationToolsIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestDetails;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestState;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeStatus;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001f\u0010\u0017\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/list/GitLabMergeRequestsListComponentFactory;", "", "<init>", "()V", "create", "Lcom/intellij/ui/components/JBList;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestDetails;", "listModel", "Lcom/intellij/ui/CollectionListModel;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "getLabelPresentation", "Lcom/intellij/collaboration/ui/codereview/list/TagPresentation;", "label", "", "userPresentation", "Lcom/intellij/collaboration/ui/codereview/list/UserPresentation;", "user", "getMergeableStatus", "Lcom/intellij/collaboration/ui/codereview/list/ReviewListItemPresentation$Status;", "mergeStatus", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeStatus;", "getMergeStateText", "Lcom/intellij/openapi/util/NlsSafe;", "mergeRequestState", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestState;", "isDraft", "", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMergeRequestsListComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestsListComponentFactory.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/list/GitLabMergeRequestsListComponentFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1586#2:93\n1661#2,3:94\n1586#2:97\n1661#2,3:98\n1586#2:101\n1661#2,3:102\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestsListComponentFactory.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/list/GitLabMergeRequestsListComponentFactory\n*L\n36#1:93\n36#1:94,3\n43#1:97\n43#1:98,3\n47#1:101\n47#1:102,3\n*E\n"})
public final class GitLabMergeRequestsListComponentFactory {
    @NotNull
    public static final GitLabMergeRequestsListComponentFactory INSTANCE = new GitLabMergeRequestsListComponentFactory();

    private GitLabMergeRequestsListComponentFactory() {
    }

    @NotNull
    public final JBList<GitLabMergeRequestDetails> create(@NotNull CollectionListModel<GitLabMergeRequestDetails> listModel, @NotNull IconsProvider<GitLabUserDTO> avatarIconsProvider) {
        Intrinsics.checkNotNullParameter(listModel, (String)"listModel");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        return new ReviewListComponentFactory((ListModel)listModel).create(arg_0 -> GitLabMergeRequestsListComponentFactory.create$lambda$0(avatarIconsProvider, arg_0));
    }

    private final TagPresentation getLabelPresentation(String label) {
        return (TagPresentation)new TagPresentation.Simple(label, null);
    }

    private final UserPresentation userPresentation(GitLabUserDTO user2, IconsProvider<GitLabUserDTO> avatarIconsProvider) {
        return (UserPresentation)new UserPresentation.Simple(user2.getUsername(), user2.getName(), avatarIconsProvider.getIcon((Object)user2, CodeReviewAvatarUtils.INSTANCE.expectedIconHeight(18)));
    }

    private final ReviewListItemPresentation.Status getMergeableStatus(GitLabMergeStatus mergeStatus) {
        if (mergeStatus == GitLabMergeStatus.CANNOT_BE_MERGED) {
            Icon icon = CollaborationToolsIcons.Review.NonMergeable;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"NonMergeable");
            return new ReviewListItemPresentation.Status(icon, GitLabBundle.message("merge.request.list.renderer.merge.conflict.tooltip", new Object[0]));
        }
        return null;
    }

    private final String getMergeStateText(GitLabMergeRequestState mergeRequestState, boolean isDraft) {
        if (mergeRequestState == GitLabMergeRequestState.OPENED && !isDraft) {
            return null;
        }
        if (isDraft) {
            return GitLabBundle.message("merge.request.list.renderer.state.draft", new Object[0]);
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[mergeRequestState.ordinal()]) {
            case 1 -> GitLabBundle.message("merge.request.list.renderer.state.closed", new Object[0]);
            case 2 -> GitLabBundle.message("merge.request.list.renderer.state.merged", new Object[0]);
            default -> null;
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final ReviewListItemPresentation create$lambda$0(IconsProvider $avatarIconsProvider, GitLabMergeRequestDetails mergeRequest) {
        Object object;
        Collection<UserPresentation> collection;
        GitLabUserDTO assignee;
        Object object2;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Collection<TagPresentation> collection2;
        void $this$mapTo$iv$iv2;
        Object $this$map$iv;
        Object object3 = new Object[]{mergeRequest.getLabels().size()};
        String string = GitLabBundle.message("merge.request.list.renderer.labels.popup", object3);
        object3 = mergeRequest.getLabels();
        GitLabMergeRequestsListComponentFactory gitLabMergeRequestsListComponentFactory = INSTANCE;
        String string2 = string;
        NamedCollection.Companion companion = NamedCollection.Companion;
        UserPresentation userPresentation = INSTANCE.userPresentation(mergeRequest.getAuthor(), (IconsProvider<GitLabUserDTO>)$avatarIconsProvider);
        Date date = mergeRequest.getCreatedAt();
        String string3 = "!" + mergeRequest.getIid();
        String string4 = mergeRequest.getTitle();
        boolean $i$f$map22 = false;
        void var5_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            String string5 = (String)item$iv$iv2;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(gitLabMergeRequestsListComponentFactory.getLabelPresentation((String)p0));
        }
        collection2 = (List)destination$iv$iv;
        NamedCollection namedCollection = companion.create(string2, (List)collection2);
        $this$map$iv = new Object[]{mergeRequest.getAssignees().size()};
        String string6 = GitLabBundle.message("merge.request.list.renderer.user.assignees", (Object[])$this$map$iv);
        $this$map$iv = mergeRequest.getAssignees();
        String string7 = string6;
        NamedCollection.Companion companion2 = NamedCollection.Companion;
        String string8 = INSTANCE.getMergeStateText(mergeRequest.getState(), mergeRequest.getDraft());
        collection2 = null;
        string2 = INSTANCE.getMergeableStatus(mergeRequest.getMergeStatus());
        companion = namedCollection;
        boolean $i$f$map = false;
        Object[] $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv2;
            item$iv$iv = iterator.next();
            item$iv$iv2 = (GitLabUserDTO)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object2.add(INSTANCE.userPresentation(assignee, (IconsProvider<GitLabUserDTO>)$avatarIconsProvider));
        }
        object2 = (List)destination$iv$iv2;
        NamedCollection namedCollection2 = companion2.create(string7, (List)object2);
        $this$map$iv = new Object[]{mergeRequest.getReviewers().size()};
        String string9 = GitLabBundle.message("merge.request.list.renderer.user.reviewers", (Object[])$this$map$iv);
        $this$map$iv = mergeRequest.getReviewers();
        object2 = string9;
        string7 = NamedCollection.Companion;
        companion2 = namedCollection2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void reviewer;
            item$iv$iv = iterator.next();
            assignee = (GitLabUserDTO)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(INSTANCE.userPresentation((GitLabUserDTO)reviewer, (IconsProvider<GitLabUserDTO>)$avatarIconsProvider));
        }
        collection = (List)destination$iv$iv2;
        String string10 = string4;
        String string11 = string3;
        Date date2 = date;
        UserPresentation userPresentation2 = userPresentation;
        NamedCollection.Companion companion3 = companion;
        String string12 = string2;
        Collection<TagPresentation> collection3 = collection2;
        String string13 = string8;
        NamedCollection.Companion companion4 = companion2;
        Object object4 = string7.create((String)object2, collection);
        Integer n = mergeRequest.getUserNotesCount();
        if (n != null) {
            void it;
            int $this$mapTo$iv$iv3 = ((Number)n).intValue();
            string7 = object4;
            companion2 = companion4;
            string8 = string13;
            collection2 = collection3;
            string2 = string12;
            companion = companion3;
            userPresentation = userPresentation2;
            date = date2;
            string3 = string11;
            string4 = string10;
            boolean bl = false;
            Object[] objectArray = new Object[]{(int)it};
            object2 = new ReviewListItemPresentation.CommentsCounter((int)it, GitLabBundle.message("merge.request.list.renderer.commentCount.tooltip", objectArray));
            string10 = string4;
            string11 = string3;
            date2 = date;
            userPresentation2 = userPresentation;
            companion3 = companion;
            string12 = string2;
            collection3 = collection2;
            string13 = string8;
            companion4 = companion2;
            object4 = string7;
            object = object2;
        } else {
            object = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 2048;
        Boolean bl = null;
        Object object5 = object;
        NamedCollection namedCollection3 = object4;
        NamedCollection.Companion companion5 = companion4;
        String string14 = string13;
        Collection<TagPresentation> collection4 = collection3;
        String string15 = string12;
        NamedCollection.Companion companion6 = companion3;
        UserPresentation userPresentation3 = userPresentation2;
        Date date3 = date2;
        String string16 = string11;
        String string17 = string10;
        return (ReviewListItemPresentation)new ReviewListItemPresentation.Simple(string17, string16, date3, userPresentation3, (NamedCollection)companion6, (ReviewListItemPresentation.Status)string15, collection4, string14, (NamedCollection)companion5, namedCollection3, object5, bl, n2, defaultConstructorMarker);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GitLabMergeRequestState.values().length];
            try {
                nArray[GitLabMergeRequestState.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitLabMergeRequestState.MERGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

