/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.lang.Language;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMethodReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyResolver;
import org.jetbrains.plugins.groovy.lang.resolve.ReceiverKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ConstructorsKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodReferenceProcessor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/GrMethodReferenceResolver;", "Lorg/jetbrains/plugins/groovy/lang/resolve/GroovyResolver;", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/GrMethodReferenceExpressionImpl;", "<init>", "()V", "resolve", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "ref", "incomplete", "", "(Lorg/jetbrains/plugins/groovy/lang/psi/impl/GrMethodReferenceExpressionImpl;Z)[Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "fakeArrayConstructors", "", "type", "Lcom/intellij/psi/PsiArrayType;", "manager", "Lcom/intellij/psi/PsiManager;", "fakeArrayConstructor", "Lcom/intellij/psi/impl/light/LightMethodBuilder;", "dimensions", "", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGrMethodReferenceResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrMethodReferenceResolver.kt\norg/jetbrains/plugins/groovy/lang/resolve/GrMethodReferenceResolver\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n37#2,2:67\n37#2,2:69\n1586#3:71\n1661#3,3:72\n*S KotlinDebug\n*F\n+ 1 GrMethodReferenceResolver.kt\norg/jetbrains/plugins/groovy/lang/resolve/GrMethodReferenceResolver\n*L\n30#1:67,2\n43#1:69,2\n47#1:71\n47#1:72,3\n*E\n"})
public final class GrMethodReferenceResolver
implements GroovyResolver<GrMethodReferenceExpressionImpl> {
    @NotNull
    public static final GrMethodReferenceResolver INSTANCE = new GrMethodReferenceResolver();

    private GrMethodReferenceResolver() {
    }

    @Override
    @NotNull
    public GroovyResolveResult[] resolve(@NotNull GrMethodReferenceExpressionImpl ref2, boolean incomplete) {
        List<GroovyResolveResult> list;
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
        String string = ref2.getReferenceName();
        if (string == null) {
            Intrinsics.checkNotNullExpressionValue((Object)GroovyResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        String name = string;
        GrExpression grExpression = ref2.getQualifier();
        if (grExpression == null || (grExpression = grExpression.getType()) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)GroovyResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GrExpression type = grExpression;
        GrMethodReferenceResolver $this$resolve_u24lambda_u240 = this;
        boolean bl = false;
        MethodReferenceProcessor processor = new MethodReferenceProcessor(name);
        PsiScopeProcessor psiScopeProcessor = processor;
        ResolveState resolveState = ResolveState.initial();
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"initial(...)");
        ReceiverKt.processReceiverType((PsiType)type, psiScopeProcessor, resolveState, ref2);
        List<GroovyResolveResult> methods = processor.getResults();
        PsiType psiType = ResolveUtil.unwrapClassType((PsiType)type);
        if (psiType == null) {
            Collection $this$toTypedArray$iv = methods;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new GroovyResolveResult[0]);
        }
        PsiType unwrapped = psiType;
        if (Intrinsics.areEqual((Object)name, (Object)"new")) {
            PsiType $this$toTypedArray$iv = unwrapped;
            if ($this$toTypedArray$iv instanceof PsiClassType) {
                list = CollectionsKt.toList((Iterable)ConstructorsKt.getAllConstructorResults((PsiClassType)unwrapped, ref2));
            } else if ($this$toTypedArray$iv instanceof PsiArrayType) {
                PsiArrayType psiArrayType = (PsiArrayType)unwrapped;
                PsiManagerEx psiManagerEx = ref2.getManager();
                Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
                list = this.fakeArrayConstructors(psiArrayType, (PsiManager)psiManagerEx);
            } else {
                list = CollectionsKt.emptyList();
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        List<GroovyResolveResult> constructors = list;
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)methods, (Iterable)constructors);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new GroovyResolveResult[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final List<GroovyResolveResult> fakeArrayConstructors(PsiArrayType type, PsiManager manager) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)type.getArrayDimensions());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ElementResolveResult<PsiElement>((PsiElement)INSTANCE.fakeArrayConstructor(type, manager, (int)i2)));
        }
        return (List)destination$iv$iv;
    }

    private final LightMethodBuilder fakeArrayConstructor(PsiArrayType type, PsiManager manager, int dimensions) {
        LightMethodBuilder lightMethodBuilder;
        LightMethodBuilder $this$fakeArrayConstructor_u24lambda_u240 = lightMethodBuilder = new LightMethodBuilder(manager, (Language)GroovyLanguage.INSTANCE, "fake array constructor");
        boolean bl = false;
        $this$fakeArrayConstructor_u24lambda_u240.setMethodReturnType((PsiType)type);
        if (dimensions == 0) {
            $this$fakeArrayConstructor_u24lambda_u240.addParameter("size", (PsiType)PsiTypes.intType());
        } else {
            int i2 = 0;
            if (i2 <= dimensions) {
                while (true) {
                    $this$fakeArrayConstructor_u24lambda_u240.addParameter("size" + i2, (PsiType)PsiTypes.intType());
                    if (i2 == dimensions) break;
                    ++i2;
                }
            }
        }
        return lightMethodBuilder;
    }
}

