/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.delegatesTo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureSamParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.FromStringHintProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToProvider;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\tH\u0002\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\t\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a&\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u001a$\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0004\u001a \u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010$\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010&\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"DELEGATES_TO_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "DELEGATES_TO_TYPE_KEY", "", "DELEGATES_TO_STRATEGY_KEY", "", "getDelegatesToInfo", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "doGetDelegatesToInfo", "expression", "getContainingCall", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrCall;", "getFromValue", "Lcom/intellij/psi/PsiType;", "delegatesTo", "Lcom/intellij/psi/PsiAnnotation;", "getFromTarget", "parameterList", "Lcom/intellij/psi/PsiParameterList;", "mapping", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ArgumentMapping;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/PsiCallParameter;", "inferGenericArgType", "targetType", "genericIndex", "param", "Lcom/intellij/psi/PsiParameter;", "findTargetParameter", "list", "target", "getFromType", "call", "result", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "getStrategyValue", "strategy", "Lcom/intellij/psi/PsiAnnotationMemberValue;", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\ngrDelegatesToUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 grDelegatesToUtil.kt\norg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/GrDelegatesToUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n296#2,2:179\n*S KotlinDebug\n*F\n+ 1 grDelegatesToUtil.kt\norg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/GrDelegatesToUtilKt\n*L\n102#1:179,2\n*E\n"})
public final class GrDelegatesToUtilKt {
    @JvmField
    @NotNull
    public static final Key<DelegatesToInfo> DELEGATES_TO_KEY;
    @JvmField
    @NotNull
    public static final Key<String> DELEGATES_TO_TYPE_KEY;
    @JvmField
    @NotNull
    public static final Key<Integer> DELEGATES_TO_STRATEGY_KEY;

    @Nullable
    public static final DelegatesToInfo getDelegatesToInfo(@NotNull GrFunctionalExpression closure) {
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        return TypeInferenceHelper.getCurrentContext().getCachedValue((GroovyPsiElement)closure, arg_0 -> GrDelegatesToUtilKt.getDelegatesToInfo$lambda$0(getDelegatesToInfo.1.INSTANCE, arg_0));
    }

    private static final DelegatesToInfo doGetDelegatesToInfo(GrFunctionalExpression expression) {
        for (GrDelegatesToProvider ext : (GrDelegatesToProvider[])GrDelegatesToProvider.EP_NAME.getExtensions()) {
            DelegatesToInfo info = ext.getDelegatesToInfo(expression);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Nullable
    public static final GrCall getContainingCall(@NotNull GrFunctionalExpression expression) {
        GrClosableBlock[] grClosableBlockArray;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiElement parent = expression.getParent();
        if (parent instanceof GrCall && ArrayUtil.contains((Object)expression, (Object[])Arrays.copyOf(grClosableBlockArray = ((GrCall)parent).getClosureArguments(), grClosableBlockArray.length))) {
            return (GrCall)parent;
        }
        if (parent instanceof GrArgumentList) {
            PsiElement grandParent = ((GrArgumentList)parent).getParent();
            return grandParent instanceof GrCall ? (GrCall)grandParent : null;
        }
        return null;
    }

    @Nullable
    public static final PsiType getFromValue(@NotNull PsiAnnotation delegatesTo) {
        Intrinsics.checkNotNullParameter((Object)delegatesTo, (String)"delegatesTo");
        PsiAnnotationMemberValue value = delegatesTo.findDeclaredAttributeValue("value");
        if (value instanceof GrReferenceExpression) {
            return ResolveUtil.unwrapClassType(((GrReferenceExpression)value).getType());
        }
        if (value instanceof PsiClassObjectAccessExpression) {
            return ResolveUtil.unwrapClassType(((PsiClassObjectAccessExpression)value).getType());
        }
        if (value == null || value instanceof PsiLiteralExpression && ((PsiLiteralExpression)value).getType() == PsiTypes.nullType() || value instanceof GrLiteral && ((GrLiteral)value).getType() == PsiTypes.nullType()) {
            return null;
        }
        if (value instanceof PsiExpression) {
            return ((PsiExpression)value).getType();
        }
        return null;
    }

    @Nullable
    public static final PsiType getFromTarget(@NotNull PsiParameterList parameterList, @NotNull PsiAnnotation delegatesTo, @NotNull ArgumentMapping<? extends PsiCallParameter> mapping) {
        PsiType psiType;
        Object v3;
        PsiParameter parameter;
        block4: {
            Intrinsics.checkNotNullParameter((Object)parameterList, (String)"parameterList");
            Intrinsics.checkNotNullParameter((Object)delegatesTo, (String)"delegatesTo");
            Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
            String string = GrAnnotationUtil.inferStringAttribute(delegatesTo, "target");
            if (string == null) {
                return null;
            }
            String target = string;
            PsiParameter psiParameter = GrDelegatesToUtilKt.findTargetParameter(parameterList, target);
            if (psiParameter == null) {
                return null;
            }
            parameter = psiParameter;
            Iterable $this$firstOrNull$iv = mapping.getArguments();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Argument it = (Argument)element$iv;
                boolean bl = false;
                PsiCallParameter psiCallParameter = mapping.targetParameter(it);
                if (!Intrinsics.areEqual((Object)(psiCallParameter != null ? psiCallParameter.getPsi() : null), (Object)parameter)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        Argument argument = v3;
        if (argument == null || (psiType = argument.getType()) == null) {
            return null;
        }
        PsiType type = psiType;
        Integer index = GrAnnotationUtil.inferIntegerAttribute(delegatesTo, "genericTypeIndex");
        return index != null ? GrDelegatesToUtilKt.inferGenericArgType(type, index, parameter) : type;
    }

    private static final PsiType inferGenericArgType(PsiType targetType, int genericIndex, PsiParameter param) {
        if (!(targetType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)targetType).resolveGenerics();
        Intrinsics.checkNotNullExpressionValue((Object)classResolveResult, (String)"resolveGenerics(...)");
        PsiClassType.ClassResolveResult result2 = classResolveResult;
        PsiClass psiClass = result2.getElement();
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getSubstitutor(...)");
        PsiSubstitutor substitutor = psiSubstitutor;
        PsiType psiType = param.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
        PsiType baseType = psiType;
        PsiClass baseClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)baseType);
        if (baseClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass2, (PsiClass)baseClass, (boolean)true)) {
            PsiTypeParameter[] psiTypeParameterArray = baseClass.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
            PsiTypeParameter[] typeParameters = psiTypeParameterArray;
            if (genericIndex < typeParameters.length) {
                PsiSubstitutor psiSubstitutor2 = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)psiClass2, (PsiSubstitutor)substitutor);
                Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor2, (String)"getSuperClassSubstitutor(...)");
                PsiSubstitutor superClassSubstitutor = psiSubstitutor2;
                return superClassSubstitutor.substitute(typeParameters[genericIndex]);
            }
        }
        return null;
    }

    @Nullable
    public static final PsiParameter findTargetParameter(@NotNull PsiParameterList list, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        PsiParameter[] psiParameterArray = list.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        for (PsiParameter parameter : psiParameterArray) {
            String value;
            PsiAnnotation targetAnnotation;
            PsiModifierList modifierList;
            if (parameter.getModifierList() == null || modifierList.findAnnotation("groovy.lang.DelegatesTo.Target") == null || GrAnnotationUtil.inferStringAttribute(targetAnnotation, "value") == null || !Intrinsics.areEqual((Object)value, (Object)target)) continue;
            return parameter;
        }
        return null;
    }

    @Nullable
    public static final PsiType getFromType(@NotNull GrCall call, @NotNull GroovyResolveResult result2, @NotNull PsiAnnotation delegatesTo) {
        GroovyMethodCandidate groovyMethodCandidate;
        PsiType type;
        block7: {
            block5: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                    Intrinsics.checkNotNullParameter((Object)delegatesTo, (String)"delegatesTo");
                    PsiElement psiElement = result2.getElement();
                    PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
                    if (psiMethod == null) {
                        return null;
                    }
                    PsiMethod element = psiMethod;
                    String string = GrAnnotationUtil.inferStringAttribute(delegatesTo, "type");
                    if (string == null) {
                        return null;
                    }
                    String typeValue = string;
                    if (StringsKt.isBlank((CharSequence)typeValue)) {
                        return null;
                    }
                    PsiElement psiElement2 = FromStringHintProcessor.createContext(element);
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"createContext(...)");
                    PsiElement context = psiElement2;
                    PsiType psiType = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(typeValue, context);
                    Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"createTypeFromText(...)");
                    type = psiType;
                    if (!(result2 instanceof GroovyMethodResult)) break block5;
                    groovyMethodCandidate = ((GroovyMethodResult)result2).getCandidate();
                    if (groovyMethodCandidate == null) break block6;
                    GroovyMethodCandidate candidate = groovyMethodCandidate;
                    boolean bl = false;
                    PsiSubstitutor psiSubstitutor = ClosureSamParameterEnhancer.Companion.substitutorIgnoringClosures(call, candidate, (GroovyMethodResult)result2);
                    groovyMethodCandidate = psiSubstitutor;
                    if (psiSubstitutor != null) break block7;
                }
                PsiSubstitutor psiSubstitutor = ((GroovyMethodResult)result2).getPartialSubstitutor();
                groovyMethodCandidate = psiSubstitutor;
                Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getPartialSubstitutor(...)");
                break block7;
            }
            PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
            Intrinsics.checkNotNull((Object)psiSubstitutor);
            groovyMethodCandidate = psiSubstitutor;
        }
        GroovyMethodCandidate substitutor = groovyMethodCandidate;
        return substitutor.substitute(type);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final int getStrategyValue(@Nullable PsiAnnotationMemberValue strategy) {
        if (strategy == null) {
            return 0;
        }
        String text = strategy.getText();
        if (text != null) {
            int n = -1;
            switch (text.hashCode()) {
                case 48: {
                    if (!text.equals("0")) break;
                    n = 1;
                    break;
                }
                case 49: {
                    if (!text.equals("1")) break;
                    n = 2;
                    break;
                }
                case 50: {
                    if (!text.equals("2")) break;
                    n = 3;
                    break;
                }
                case 51: {
                    if (!text.equals("3")) break;
                    n = 4;
                    break;
                }
                case 52: {
                    if (!text.equals("4")) break;
                    n = 5;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
            }
        }
        Intrinsics.checkNotNull((Object)text);
        if (StringsKt.endsWith$default((String)text, (String)"OWNER_FIRST", (boolean)false, (int)2, null)) {
            return 0;
        }
        if (StringsKt.endsWith$default((String)text, (String)"DELEGATE_FIRST", (boolean)false, (int)2, null)) {
            return 1;
        }
        if (StringsKt.endsWith$default((String)text, (String)"OWNER_ONLY", (boolean)false, (int)2, null)) {
            return 2;
        }
        if (StringsKt.endsWith$default((String)text, (String)"DELEGATE_ONLY", (boolean)false, (int)2, null)) {
            return 3;
        }
        if (!StringsKt.endsWith$default((String)text, (String)"TO_SELF", (boolean)false, (int)2, null)) return 0;
        return 4;
    }

    private static final DelegatesToInfo getDelegatesToInfo$lambda$0(Function1 $tmp0, Object p0) {
        return (DelegatesToInfo)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ DelegatesToInfo access$doGetDelegatesToInfo(GrFunctionalExpression expression) {
        return GrDelegatesToUtilKt.doGetDelegatesToInfo(expression);
    }

    static {
        Key key = Key.create((String)"groovy.closure.delegatesTo");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DELEGATES_TO_KEY = key;
        Key key2 = Key.create((String)"groovy.closure.delegatesTo.type");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        DELEGATES_TO_TYPE_KEY = key2;
        Key key3 = Key.create((String)"groovy.closure.delegatesTo.strategy");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        DELEGATES_TO_STRATEGY_KEY = key3;
    }
}

