/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.imports.impl;

import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyFileImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.RegularImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StarImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StaticImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StaticStarImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.impl.GroovyFileImportsImpl;
import org.jetbrains.plugins.groovy.lang.resolve.imports.impl.ImportKind;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0000J<\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\u001d0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\u001d`\u000f\"\b\b\u0000\u0010\u001d*\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\fH\u0002J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010 \u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010 \u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010 \u001a\u00020'H\u0002J\u000e\u0010(\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\tJ\u0016\u0010\u001f\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000eJ\u001e\u0010\"\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000eJ\u000e\u0010$\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u000eJ\u000e\u0010&\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u000eJ\u0015\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b/J\u0006\u00100\u001a\u000201R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010\n\u001a^\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t`\u000f0\u000bj.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t`\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/imports/impl/GroovyImportCollector;", "", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;)V", "statementToImport", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/toplevel/imports/GrImportStatement;", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyImport;", "imports", "Ljava/util/HashMap;", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/impl/ImportKind;", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "Lkotlin/collections/HashMap;", "isEmpty", "", "()Z", "clear", "", "setFrom", "collector", "allImports", "", "getAllImports", "()Ljava/util/Collection;", "getMap", "T", "kind", "addRegularImport", "import", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/RegularImport;", "addStaticImport", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/StaticImport;", "addStarImport", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/StarImport;", "addStaticStarImport", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/StaticStarImport;", "addImport", "classFqn", "name", "memberName", "packageFqn", "addImportFromStatement", "statement", "addImportFromStatement$intellij_groovy_psi", "build", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyFileImports;", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGroovyImportCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyImportCollector.kt\norg/jetbrains/plugins/groovy/lang/resolve/imports/impl/GroovyImportCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,83:1\n1786#2,3:84\n1391#2:87\n1480#2,5:88\n1266#2,4:102\n383#3,7:93\n466#3:100\n415#3:101\n*S KotlinDebug\n*F\n+ 1 GroovyImportCollector.kt\norg/jetbrains/plugins/groovy/lang/resolve/imports/impl/GroovyImportCollector\n*L\n19#1:84,3\n30#1:87\n30#1:88,5\n78#1:102,4\n34#1:93,7\n78#1:100\n78#1:101\n*E\n"})
public final class GroovyImportCollector {
    @NotNull
    private final GroovyFileBase file;
    @NotNull
    private final Map<GrImportStatement, GroovyImport> statementToImport;
    @NotNull
    private final HashMap<ImportKind<?>, LinkedHashMap<String, GroovyImport>> imports;

    public GroovyImportCollector(@NotNull GroovyFileBase file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.statementToImport = new LinkedHashMap();
        this.imports = new HashMap();
    }

    public final boolean isEmpty() {
        boolean bl;
        block3: {
            Collection<LinkedHashMap<String, GroovyImport>> collection = this.imports.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LinkedHashMap it = (LinkedHashMap)element$iv;
                    boolean bl2 = false;
                    if (it.isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final void clear() {
        this.imports.clear();
    }

    public final void setFrom(@NotNull GroovyImportCollector collector) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        this.imports.clear();
        this.imports.putAll((Map)collector.imports);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<GroovyImport> getAllImports() {
        void $this$flatMapTo$iv$iv;
        Collection<LinkedHashMap<String, GroovyImport>> collection = this.imports.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LinkedHashMap it = (LinkedHashMap)element$iv$iv;
            boolean bl = false;
            Collection collection2 = it.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
            Iterable list$iv$iv = collection2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends GroovyImport> LinkedHashMap<String, T> getMap(ImportKind<T> kind) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = this.imports;
        ImportKind<T> key$iv = kind;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            LinkedHashMap answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        LinkedHashMap map3 = (LinkedHashMap)object;
        return map3;
    }

    private final void addRegularImport(RegularImport regularImport) {
        ((Map)this.getMap(ImportKind.Regular.INSTANCE)).put(regularImport.getName(), regularImport);
    }

    private final void addStaticImport(StaticImport staticImport) {
        ((Map)this.getMap(ImportKind.Static.INSTANCE)).put(staticImport.getName(), staticImport);
    }

    private final void addStarImport(StarImport starImport) {
        ((Map)this.getMap(ImportKind.Star.INSTANCE)).put(starImport.getPackageFqn(), starImport);
    }

    private final void addStaticStarImport(StaticStarImport staticStarImport) {
        ((Map)this.getMap(ImportKind.StaticStar.INSTANCE)).put(staticStarImport.getClassFqn(), staticStarImport);
    }

    public final void addImport(@NotNull GroovyImport groovyImport) {
        Intrinsics.checkNotNullParameter((Object)groovyImport, (String)"import");
        GroovyImport groovyImport2 = groovyImport;
        if (groovyImport2 instanceof RegularImport) {
            this.addRegularImport((RegularImport)groovyImport);
        } else if (groovyImport2 instanceof StaticImport) {
            this.addStaticImport((StaticImport)groovyImport);
        } else if (groovyImport2 instanceof StarImport) {
            this.addStarImport((StarImport)groovyImport);
        } else if (groovyImport2 instanceof StaticStarImport) {
            this.addStaticStarImport((StaticStarImport)groovyImport);
        } else {
            throw new IllegalStateException(("Unsupported import. Class: " + groovyImport.getClass() + "; toString: " + groovyImport).toString());
        }
    }

    public final void addRegularImport(@NotNull String classFqn, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addRegularImport(new RegularImport(classFqn, name));
    }

    public final void addStaticImport(@NotNull String classFqn, @NotNull String memberName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addStaticImport(new StaticImport(classFqn, memberName, name));
    }

    public final void addStarImport(@NotNull String packageFqn) {
        Intrinsics.checkNotNullParameter((Object)packageFqn, (String)"packageFqn");
        this.addStarImport(new StarImport(packageFqn));
    }

    public final void addStaticStarImport(@NotNull String classFqn) {
        Intrinsics.checkNotNullParameter((Object)classFqn, (String)"classFqn");
        this.addStaticStarImport(new StaticStarImport(classFqn));
    }

    public final void addImportFromStatement$intellij_groovy_psi(@NotNull GrImportStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        GroovyImport groovyImport = statement.getImport();
        if (groovyImport == null) {
            return;
        }
        GroovyImport groovyImport2 = groovyImport;
        this.statementToImport.put(statement, groovyImport2);
        this.addImport(groovyImport2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GroovyFileImports build() {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map map2 = this.imports;
        GroovyFileBase groovyFileBase = this.file;
        boolean $i$f$mapValues = false;
        void var3_4 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            LinkedHashMap map5 = (LinkedHashMap)entry2.getValue();
            Collection collection = map5.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            List list = CollectionsKt.toList((Iterable)collection);
            map4.put(k, list);
        }
        Map map6 = UtilKt.reverse(this.statementToImport);
        Map<GrImportStatement, GroovyImport> map7 = this.statementToImport;
        Map map8 = MapsKt.toMap((Map)destination$iv$iv$iv);
        GroovyFileBase groovyFileBase2 = groovyFileBase;
        return new GroovyFileImportsImpl(groovyFileBase2, map8, map7, map6);
    }
}

