/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.ui;

import com.intellij.ide.ui.AntiFlickeringPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DebuggerUIUtilShared {
    private static boolean shouldUseAntiFlickeringPanel() {
        return !ApplicationManager.getApplication().isUnitTestMode() && Registry.intValue((String)"debugger.anti.flickering.delay", (int)0) > 0;
    }

    @NotNull
    public static JComponent wrapWithAntiFlickeringPanel(@NotNull JComponent component) {
        if (component == null) {
            DebuggerUIUtilShared.$$$reportNull$$$0(0);
        }
        JComponent jComponent = DebuggerUIUtilShared.shouldUseAntiFlickeringPanel() ? new AntiFlickeringPanel(component) : component;
        if (jComponent == null) {
            DebuggerUIUtilShared.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    public static boolean freezePaintingToReduceFlickering(@Nullable Component component) {
        if (component instanceof AntiFlickeringPanel) {
            AntiFlickeringPanel antiFlickeringPanel = (AntiFlickeringPanel)component;
            int delay = Registry.intValue((String)"debugger.anti.flickering.delay", (int)0);
            if (delay > 0) {
                ApplicationManager.getApplication().invokeAndWait(() -> antiFlickeringPanel.freezePainting(delay), ModalityState.any());
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/debugger/impl/ui/DebuggerUIUtilShared";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/debugger/impl/ui/DebuggerUIUtilShared";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithAntiFlickeringPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithAntiFlickeringPanel";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

