/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers;

import com.intellij.ide.startup.importSettings.models.BundledKeymap;
import com.intellij.ide.startup.importSettings.models.KeyBinding;
import com.intellij.ide.startup.importSettings.models.Keymap;
import com.intellij.ide.startup.importSettings.models.PatchedKeymap;
import com.intellij.ide.startup.importSettings.models.PluginKeymap;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.models.SettingsPreferencesKind;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.PartialImportPerformer;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\tH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/KeymapSchemeImportPerformer;", "Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/PartialImportPerformer;", "<init>", "()V", "willPerform", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "collectAllRequiredPlugins", "", "Lcom/intellij/openapi/extensions/PluginId;", "patchSettingsAfterPluginInstallation", "pluginIds", "", "perform", "", "project", "Lcom/intellij/openapi/project/Project;", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "performEdt", "doBundledKeymap", "keymap", "Lcom/intellij/ide/startup/importSettings/models/BundledKeymap;", "doPatchedKeymap", "Lcom/intellij/ide/startup/importSettings/models/PatchedKeymap;", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nPartialImportPerformers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartialImportPerformers.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/KeymapSchemeImportPerformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1#2:243\n1915#3:244\n1915#3,2:245\n1916#3:247\n1915#3:248\n777#3:249\n873#3,2:250\n1915#3,2:252\n1916#3:254\n*S KotlinDebug\n*F\n+ 1 PartialImportPerformers.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/KeymapSchemeImportPerformer\n*L\n204#1:244\n205#1:245,2\n204#1:247\n210#1:248\n212#1:249\n212#1:250,2\n213#1:252,2\n210#1:254\n*E\n"})
public final class KeymapSchemeImportPerformer
implements PartialImportPerformer {
    @Override
    public boolean willPerform(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings.getPreferences().get(SettingsPreferencesKind.Keymap) && settings.getKeymap() != null;
    }

    @Override
    @NotNull
    public Set<PluginId> collectAllRequiredPlugins(@NotNull Settings settings) {
        PluginKeymap pluginKeymap;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Keymap keymap = settings.getKeymap();
        PluginKeymap pluginKeymap2 = pluginKeymap = keymap instanceof PluginKeymap ? (PluginKeymap)keymap : null;
        if (pluginKeymap != null) {
            PluginKeymap it = pluginKeymap;
            boolean bl = false;
            return SetsKt.setOf((Object)PluginId.Companion.getId(it.getPluginId()));
        }
        Keymap bl = settings.getKeymap();
        PatchedKeymap patchedKeymap = bl instanceof PatchedKeymap ? (PatchedKeymap)bl : null;
        keymap = patchedKeymap != null ? patchedKeymap.getParent() : null;
        PluginKeymap pluginKeymap3 = pluginKeymap = keymap instanceof PluginKeymap ? (PluginKeymap)keymap : null;
        if (pluginKeymap != null) {
            PluginKeymap it = pluginKeymap;
            boolean bl2 = false;
            return SetsKt.setOf((Object)PluginId.Companion.getId(it.getPluginId()));
        }
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Settings patchSettingsAfterPluginInstallation(@NotNull Settings settings, @NotNull Set<String> pluginIds) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        Keymap km = settings.getKeymap();
        if (km instanceof PatchedKeymap) {
            PluginKeymap parent;
            Keymap keymap = ((PatchedKeymap)km).getParent();
            PluginKeymap pluginKeymap = parent = keymap instanceof PluginKeymap ? (PluginKeymap)keymap : null;
            if (parent != null) {
                if (pluginIds.contains(parent.getPluginId())) {
                    ((PatchedKeymap)km).setParent(BundledKeymap.Companion.fromManager(((PatchedKeymap)km).getTransferableId(), parent.getInstalledName(), CollectionsKt.emptyList()));
                } else {
                    ((PatchedKeymap)km).setParent(parent.getFallback());
                }
            }
        }
        if (km instanceof PluginKeymap) {
            if (pluginIds.contains(((PluginKeymap)km).getPluginId())) {
                settings.setKeymap(BundledKeymap.Companion.fromManager(((PluginKeymap)km).getTransferableId(), ((PluginKeymap)km).getInstalledName(), CollectionsKt.emptyList()));
            } else {
                settings.setKeymap(((PluginKeymap)km).getFallback());
            }
        }
        return settings;
    }

    @Override
    public void perform(@Nullable Project project, @NotNull Settings settings, @NotNull ProgressIndicator pi) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
    }

    @Override
    public void performEdt(@Nullable Project project, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Keymap keymap = settings.getKeymap();
        if (keymap == null) {
            return;
        }
        Keymap keymap2 = keymap;
        Keymap keymap3 = keymap2;
        if (keymap3 instanceof BundledKeymap) {
            this.doBundledKeymap((BundledKeymap)keymap2);
        } else if (keymap3 instanceof PatchedKeymap) {
            this.doPatchedKeymap((PatchedKeymap)keymap2);
        }
    }

    private final void doBundledKeymap(BundledKeymap keymap) {
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        keymapManager.setActiveKeymap(keymap.getKeymap());
    }

    /*
     * WARNING - void declaration
     */
    private final void doPatchedKeymap(PatchedKeymap keymap) {
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        Keymap keymap2 = keymap.getParent();
        BundledKeymap bundledKeymap = keymap2 instanceof BundledKeymap ? (BundledKeymap)keymap2 : null;
        Object parent = bundledKeymap != null ? bundledKeymap.getKeymap() : null;
        if (parent == null) {
            boolean $i$a$-requireNotNull-KeymapSchemeImportPerformer$doPatchedKeymap$22 = false;
            String $i$a$-requireNotNull-KeymapSchemeImportPerformer$doPatchedKeymap$22 = "parent must be BundledKeymap at this point";
            throw new IllegalArgumentException($i$a$-requireNotNull-KeymapSchemeImportPerformer$doPatchedKeymap$22.toString());
        }
        if (keymap.getOverrides().isEmpty() && keymap.getRemoval().isEmpty()) {
            keymapManager.setActiveKeymap(parent);
            return;
        }
        com.intellij.openapi.keymap.Keymap keymap3 = parent.deriveKeymap(parent.getName() + " (Migrated)");
        Intrinsics.checkNotNullExpressionValue((Object)keymap3, (String)"deriveKeymap(...)");
        com.intellij.openapi.keymap.Keymap derived = keymap3;
        Iterable $this$forEach$iv = keymap.getOverrides();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyBinding it = (KeyBinding)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = it.getShortcuts();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KeyboardShortcut ks = (KeyboardShortcut)element$iv2;
                boolean bl2 = false;
                derived.addShortcut(it.getActionId(), (Shortcut)ks);
            }
        }
        $this$forEach$iv = keymap.getRemoval();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv;
            Object element$iv2;
            KeyBinding removedBinding = (KeyBinding)element$iv;
            boolean bl = false;
            Shortcut[] shortcutArray = derived.getShortcuts(removedBinding.getActionId());
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Set og = ArraysKt.toSet((Object[])shortcutArray);
            Iterable $this$filter$iv = removedBinding.getShortcuts();
            boolean $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KeyboardShortcut it = (KeyboardShortcut)element$iv$iv;
                boolean bl3 = false;
                if (!og.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List toRemove = (List)destination$iv$iv;
            Iterable $this$forEach$iv3 = toRemove;
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                KeyboardShortcut tr = (KeyboardShortcut)element$iv3;
                boolean bl4 = false;
                derived.removeShortcut(removedBinding.getActionId(), (Shortcut)tr);
            }
        }
        keymapManager.getSchemeManager().addScheme((Object)derived);
        keymapManager.setActiveKeymap(derived);
        System.out.println();
    }
}

