/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.parsers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.RecentProjectMetaInfo;
import com.intellij.ide.startup.importSettings.db.WindowsEnvVariables;
import com.intellij.ide.startup.importSettings.models.FeatureInfo;
import com.intellij.ide.startup.importSettings.models.ILookAndFeel;
import com.intellij.ide.startup.importSettings.models.RecentPathInfo;
import com.intellij.ide.startup.importSettings.providers.vswin.mappings.FontsAndColorsMappings;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSProfileDetectorUtils;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSProfileSettingsFileNotFound;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.registryUtils.IRegistryKey;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.registryUtils.impl.RegistryRoot;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.mappings.VisualStudioPluginsMapping;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.utilities.VSHive;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.utilities.VSHiveDetourFileNotFoundException;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.utilities.registryUtils.impl.PrivateRegistryRoot;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.util.io.PathKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 :2\u00020\u0001:\u0001:B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010.\u001a\u00020/H\u0002J\n\u00100\u001a\u0004\u0018\u00010'H\u0002J\u0014\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\"0!H\u0002J\u0018\u00102\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\fH\u0002J\n\u00103\u001a\u0004\u0018\u00010\tH\u0002J\n\u00104\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u00105\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0002J\u0010\u00106\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0002J\b\u00107\u001a\u00020\tH\u0002J\n\u00108\u001a\u0004\u0018\u00010\u0016H\u0002J\n\u00109\u001a\u0004\u0018\u00010\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0011\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0010\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0010\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0010\u001a\u0004\b\u001d\u0010\u001eR'\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\"0!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0010\u001a\u0004\b#\u0010$R\u001d\u0010&\u001a\u0004\u0018\u00010'8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u0010\u001a\u0004\b(\u0010)R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSRegistryParserNew;", "", "hive", "Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/utilities/VSHive;", "<init>", "(Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/utilities/VSHive;)V", "getHive", "()Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/utilities/VSHive;", "appDataHiveFolder", "Ljava/nio/file/Path;", "detourFile", "envPath", "Lkotlin/Pair;", "getEnvPath", "()Lkotlin/Pair;", "envPath$delegate", "Lkotlin/Lazy;", "settingsFile", "getSettingsFile", "()Ljava/nio/file/Path;", "settingsFile$delegate", "vsLocation", "", "getVsLocation", "()Ljava/lang/String;", "vsLocation$delegate", "recentProjects", "", "Lcom/intellij/ide/startup/importSettings/models/RecentPathInfo;", "getRecentProjects", "()Ljava/util/List;", "recentProjects$delegate", "extensions", "", "Lcom/intellij/ide/startup/importSettings/models/FeatureInfo;", "getExtensions", "()Ljava/util/Map;", "extensions$delegate", "theme", "Lcom/intellij/ide/startup/importSettings/models/ILookAndFeel;", "getTheme", "()Lcom/intellij/ide/startup/importSettings/models/ILookAndFeel;", "theme$delegate", "registryRootKey", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/registryUtils/IRegistryKey;", "registryRootKeyConfig", "isRegistryDetourRequired", "", "themeInit", "extensionsListInit", "envPathInit", "settingsFileInit", "vsLocationInit", "recentProjectsNewVSInit", "recentProjectsInit", "detourFileInit", "loadCodeContainersFromConfig", "loadCodeContainersFromRegistry", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nVSRegistryParserNew.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSRegistryParserNew.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSRegistryParserNew\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,356:1\n1642#2,10:357\n1915#2:367\n1916#2:369\n1652#2:370\n1642#2,10:372\n1915#2:382\n1916#2:384\n1652#2:385\n1080#2:386\n1586#2:387\n1661#2,3:388\n1#3:368\n1#3:371\n1#3:383\n1#3:402\n1#3:405\n139#4,10:391\n221#4:401\n222#4:403\n149#4:404\n82#5,3:406\n13#5:409\n*S KotlinDebug\n*F\n+ 1 VSRegistryParserNew.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSRegistryParserNew\n*L\n104#1:357,10\n104#1:367\n104#1:369\n104#1:370\n208#1:372,10\n208#1:382\n208#1:384\n208#1:385\n223#1:386\n225#1:387\n225#1:388,3\n104#1:368\n208#1:383\n271#1:402\n271#1:391,10\n271#1:401\n271#1:403\n271#1:404\n317#1:406,3\n44#1:409\n*E\n"})
public final class VSRegistryParserNew {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VSHive hive;
    @NotNull
    private final Path appDataHiveFolder;
    @Nullable
    private final Path detourFile;
    @NotNull
    private final Lazy envPath$delegate;
    @NotNull
    private final Lazy settingsFile$delegate;
    @NotNull
    private final Lazy vsLocation$delegate;
    @NotNull
    private final Lazy recentProjects$delegate;
    @NotNull
    private final Lazy extensions$delegate;
    @NotNull
    private final Lazy theme$delegate;
    @NotNull
    private final IRegistryKey registryRootKey;
    @NotNull
    private final IRegistryKey registryRootKeyConfig;
    @NotNull
    private static final Lifetime veryBadLifetime = Lifetime.Companion.getEternal();
    @NotNull
    private static final Logger logger;

    private VSRegistryParserNew(VSHive hive) {
        RegistryRoot registryRoot;
        this.hive = hive;
        Path path = Paths.get(WindowsEnvVariables.INSTANCE.getLocalApplicationData() + "\\Microsoft\\VisualStudio\\" + this.hive.getHiveString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.appDataHiveFolder = path;
        this.detourFile = this.isRegistryDetourRequired() ? this.detourFileInit() : null;
        this.envPath$delegate = LazyKt.lazy(() -> VSRegistryParserNew.envPath_delegate$lambda$0(this));
        this.settingsFile$delegate = LazyKt.lazy(() -> VSRegistryParserNew.settingsFile_delegate$lambda$0(this));
        this.vsLocation$delegate = LazyKt.lazy(() -> VSRegistryParserNew.vsLocation_delegate$lambda$0(this));
        this.recentProjects$delegate = LazyKt.lazy(() -> VSRegistryParserNew.recentProjects_delegate$lambda$0(this));
        this.extensions$delegate = LazyKt.lazy(() -> VSRegistryParserNew.extensions_delegate$lambda$0(this));
        this.theme$delegate = LazyKt.lazy(() -> VSRegistryParserNew.theme_delegate$lambda$0(this));
        if (this.isRegistryDetourRequired()) {
            if (this.detourFile == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            registryRoot = PrivateRegistryRoot.Companion.getOrCreate(this.detourFile, veryBadLifetime);
        } else {
            WinReg.HKEY hKEY = WinReg.HKEY_CURRENT_USER;
            Intrinsics.checkNotNullExpressionValue((Object)hKEY, (String)"HKEY_CURRENT_USER");
            registryRoot = new RegistryRoot(hKEY, veryBadLifetime);
        }
        this.registryRootKey = registryRoot.fromKey("SOFTWARE\\Microsoft\\VisualStudio\\" + this.hive.getHiveString());
        this.registryRootKeyConfig = this.registryRootKey.withSuffix("_Config");
    }

    @NotNull
    public final VSHive getHive() {
        return this.hive;
    }

    @NotNull
    public final Pair<Path, Path> getEnvPath() {
        Lazy lazy = this.envPath$delegate;
        return (Pair)lazy.getValue();
    }

    @Nullable
    public final Path getSettingsFile() {
        Lazy lazy = this.settingsFile$delegate;
        return (Path)lazy.getValue();
    }

    @Nullable
    public final String getVsLocation() {
        Lazy lazy = this.vsLocation$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final List<RecentPathInfo> getRecentProjects() {
        Lazy lazy = this.recentProjects$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Map<String, FeatureInfo> getExtensions() {
        Lazy lazy = this.extensions$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final ILookAndFeel getTheme() {
        Lazy lazy = this.theme$delegate;
        return (ILookAndFeel)lazy.getValue();
    }

    private final boolean isRegistryDetourRequired() {
        return this.hive.getInstanceId() != null;
    }

    private final ILookAndFeel themeInit() {
        String string;
        try {
            String string2;
            String string3 = this.registryRootKey.inChild("General").getStringValue("CurrentTheme");
            if (string3 != null) {
                String string4 = string3.toUpperCase(Locale.ROOT);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (Throwable throwable) {
            return null;
        }
        String regValue = string;
        if (regValue == null) {
            return FontsAndColorsMappings.VsTheme.Dark.toRiderTheme();
        }
        return FontsAndColorsMappings.VsTheme.Companion.fromString(regValue).toRiderTheme();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, FeatureInfo> extensionsListInit() {
        Map map;
        Object object;
        IRegistryKey packagesKey = this.registryRootKeyConfig.inChild("Packages");
        try {
            Object object2;
            List<String> list = packagesKey.getKeys();
            if (list != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                object = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    Map<String, Object> a;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    Map<String, Object> map2 = a = packagesKey.inChild(it).getValues();
                    Object compName = map2 != null ? map2.get("CompanyName") : null;
                    Map<String, Object> map3 = a;
                    if (map3 == null || (map3 = map3.get("ProductName")) == null) {
                        string = null;
                    } else {
                        Map<String, Object> productName = map3;
                        string = compName + "|" + productName;
                    }
                    if (string == null) continue;
                    String it$iv$iv = string;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                object2 = (List)destination$iv$iv;
            } else {
                object2 = null;
            }
            map = object2;
        }
        catch (Throwable t) {
            logger.warn("error in new method");
            logger.warn(t);
            return MapsKt.emptyMap();
        }
        Map preParsed = map;
        Map map4 = preParsed;
        logger.info("Installed plugins in " + this.hive.getHiveString() + ": " + (map4 != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)((Object)map4)), null, null, null, (int)0, null, VSRegistryParserNew::extensionsListInit$lambda$1, (int)31, null) : null));
        Map $this$extensionsListInit_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        if (preParsed != null) {
            object = preParsed.iterator();
            while (object.hasNext()) {
                String id = (String)object.next();
                FeatureInfo plugin = VisualStudioPluginsMapping.INSTANCE.get(id);
                if (plugin == null) continue;
                $this$extensionsListInit_u24lambda_u242.put(id, plugin);
            }
        }
        return MapsKt.build((Map)map);
    }

    private final Pair<Path, Path> envPathInit() {
        String string;
        String string2;
        Path envDir = null;
        Path devEnv = null;
        IRegistryKey setupVSKey = this.registryRootKeyConfig.div("Setup").div("VS");
        try {
            string2 = setupVSKey.getStringValue("EnvironmentDirectory");
        }
        catch (Throwable t) {
            logger.warn("Failed to obtain path to EnvDir (probably vs is corrupted)");
            logger.debug(t);
            return new Pair(null, null);
        }
        String fileDirStr = string2;
        if (fileDirStr == null) {
            logger.trace("EnvDir is null");
        }
        try {
            string = setupVSKey.getStringValue("EnvironmentPath");
        }
        catch (Throwable t) {
            logger.warn("Failed to obtain path to EnvPath (probably vs is corrupted)");
            logger.debug(t);
            return new Pair(null, null);
        }
        String filePathStr = string;
        if (filePathStr == null) {
            logger.trace("EnvPath is null");
        }
        if (fileDirStr != null) {
            Path path = Paths.get(fileDirStr, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            envDir = path;
            if (!Files.exists(envDir, new LinkOption[0])) {
                logger.info("envDir was not found in fs");
                envDir = null;
            }
        }
        if (filePathStr != null) {
            Path path = Paths.get(filePathStr, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            devEnv = path;
        }
        return new Pair(envDir, devEnv);
    }

    private final Path settingsFileInit() {
        Path path;
        String path2;
        String string;
        try {
            string = this.registryRootKey.inChild("Profile").getStringValue("AutoSaveFile");
        }
        catch (Win32Exception win32Exception) {
            throw new VSProfileSettingsFileNotFound("A problem occurred while trying to work with registry. Probably key does not exist.", null, 2, null);
        }
        String string2 = string;
        if (string2 == null) {
            throw new Exception("Unknown registry error");
        }
        String unexpandedPath = string2;
        String string3 = path2 = VSProfileDetectorUtils.INSTANCE.expandPath(unexpandedPath, this.hive);
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            Path path3 = Paths.get(it, new String[0]);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        } else {
            path = null;
        }
        return path;
    }

    private final String vsLocationInit() {
        return this.registryRootKey.getStringValue("VisualStudioLocation");
    }

    /*
     * Unable to fully structure code
     */
    private final List<RecentPathInfo> recentProjectsNewVSInit() {
        v0 = this.loadCodeContainersFromConfig();
        if (v0 == null && (v0 = this.loadCodeContainersFromRegistry()) == null) {
            return null;
        }
        dataSource = v0;
        try {
            var3_2 = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS)).readTree(dataSource);
        }
        catch (Throwable t) {
            VSRegistryParserNew.logger.warn(t);
            return null;
        }
        root = var3_2;
        Intrinsics.checkNotNull((Object)root);
        $this$mapNotNull$iv = (Iterable)root;
        $i$f$mapNotNull = false;
        var6_7 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var11_13 = $this$forEach$iv$iv$iv.iterator();
        while (var11_13.hasNext()) {
            block9: {
                block8: {
                    element$iv$iv = element$iv$iv$iv = var11_13.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (JsonNode)element$iv$iv;
                    $i$a$-mapNotNull-VSRegistryParserNew$recentProjectsNewVSInit$preItems$1 = false;
                    if (it.get("Value").get("IsLocal").asBoolean()) break block8;
                    v1 = null;
                    break block9;
                }
                date = it.get("Value").get("LastAccessed").asText();
                path = it.get("Value").get("LocalProperties").get("FullPath").asText();
                Intrinsics.checkNotNull((Object)path);
                pathExpanded = VSProfileDetectorUtils.INSTANCE.expandPath(path, this.hive);
                if (pathExpanded == null) ** GOTO lbl-1000
                v2 = Paths.get(pathExpanded, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
                v3 = new LinkOption[]{};
                if (!Files.exists(v2, Arrays.copyOf(v3, v3.length))) lbl-1000:
                // 2 sources

                {
                    v1 = null;
                } else {
                    $this$recentProjectsNewVSInit_u24lambda_u240_u240 = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(date);
                    $i$a$-run-VSRegistryParserNew$recentProjectsNewVSInit$preItems$1$dateParser$1 = false;
                    dateParser = Instant.from($this$recentProjectsNewVSInit_u24lambda_u240_u240);
                    dateConverted = Date.from(dateParser);
                    v1 = new Pair((Object)pathExpanded, (Object)dateConverted);
                }
            }
            if (v1 == null) continue;
            it$iv$iv = v1;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$sortedByDescending = false;
        preItems = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Date)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Date)it.getSecond()));
            }
        });
        $this$map$iv = preItems;
        $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var11_13 = (Pair)item$iv$iv;
            var26_30 = destination$iv$iv;
            $i$a$-map-VSRegistryParserNew$recentProjectsNewVSInit$1 = false;
            v4 = VSProfileDetectorUtils.INSTANCE.expandPath((String)it.getFirst(), this.hive);
            Intrinsics.checkNotNull((Object)v4);
            Intrinsics.checkNotNullExpressionValue((Object)Paths.get(v4, new String[0]), (String)"get(...)");
            $this$recentProjectsNewVSInit_u24lambda_u242_u240 = var14_18 = new RecentProjectMetaInfo();
            $i$a$-apply-VSRegistryParserNew$recentProjectsNewVSInit$1$info$1 = false;
            $this$recentProjectsNewVSInit_u24lambda_u242_u240.setMetadata(null);
            v5 = new LinkOption[]{};
            if (Files.isDirectory(pathExp, Arrays.copyOf(v5, v5.length))) {
                $this$recentProjectsNewVSInit_u24lambda_u242_u240.setMetadata("folder|");
            }
            $this$recentProjectsNewVSInit_u24lambda_u242_u240.setDisplayName(PathsKt.getName((Path)pathExp));
            $this$recentProjectsNewVSInit_u24lambda_u242_u240.setProjectOpenTimestamp(((Date)it.getSecond()).getTime());
            $this$recentProjectsNewVSInit_u24lambda_u242_u240.setBuildTimestamp(((Date)it.getSecond()).getTime());
            info = var14_18;
            var26_30.add(new RecentPathInfo(PathsKt.getInvariantSeparatorsPathString((Path)pathExp), info));
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<RecentPathInfo> recentProjectsInit() {
        void $this$mapNotNullTo$iv$iv;
        Map<String, Object> map;
        List<RecentPathInfo> newMethod = this.recentProjectsNewVSInit();
        if (newMethod != null) {
            return newMethod;
        }
        logger.info("New proj detection method failed");
        try {
            try {
                map = this.registryRootKey.div("MRUItems").div("{a9c4a31f-f9cb-47a9-abc0-49ce82d0b3ac}").div("Items").getValues();
            }
            catch (Throwable t2) {
                logger.info("Failed to get recent projects using new method, trying old one");
                logger.debug(t2);
                map = this.registryRootKey.div("ProjectMRUList").getValues();
            }
        }
        catch (Throwable t) {
            logger.warn("Sorry, no recent projects for you");
            logger.debug(t);
            return null;
        }
        Map<String, Object> registry = map;
        if (registry == null) {
            logger.info("No recent projects found (no registry keys)");
            return null;
        }
        Map<String, Object> $this$mapNotNull$iv = registry;
        boolean $i$f$mapNotNull = false;
        Map<String, Object> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            RecentPathInfo recentPathInfo;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            Object item = entry.getValue();
            if (!(item instanceof String)) {
                logger.warn("Got not strings for keys for some unknown reason");
                recentPathInfo = null;
            } else {
                char[] cArray = new char[]{'|', ';'};
                List spl = StringsKt.split$default((CharSequence)((CharSequence)item), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                String path = (String)spl.get(0);
                String name = (String)spl.get(3);
                if (((CharSequence)path).length() == 0) {
                    logger.warn("path is empty");
                    recentPathInfo = null;
                } else {
                    Path pathExp;
                    RecentProjectMetaInfo recentProjectMetaInfo;
                    long i = 0L;
                    i = System.currentTimeMillis();
                    String string = VSProfileDetectorUtils.INSTANCE.expandPath(path, this.hive);
                    Intrinsics.checkNotNull((Object)string);
                    Intrinsics.checkNotNullExpressionValue((Object)Paths.get(string, new String[0]), (String)"get(...)");
                    RecentProjectMetaInfo $this$recentProjectsInit_u24lambda_u240_u240 = recentProjectMetaInfo = new RecentProjectMetaInfo();
                    boolean bl3 = false;
                    i -= (long)1000;
                    $this$recentProjectsInit_u24lambda_u240_u240.setMetadata(null);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isDirectory(pathExp, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        $this$recentProjectsInit_u24lambda_u240_u240.setMetadata("folder|");
                    }
                    $this$recentProjectsInit_u24lambda_u240_u240.setProjectOpenTimestamp(i);
                    $this$recentProjectsInit_u24lambda_u240_u240.setBuildTimestamp(i);
                    $this$recentProjectsInit_u24lambda_u240_u240.setDisplayName(name);
                    RecentProjectMetaInfo info = recentProjectMetaInfo;
                    recentPathInfo = new RecentPathInfo(PathKt.getSystemIndependentPath((Path)pathExp), info);
                }
            }
            if (recentPathInfo == null) continue;
            RecentPathInfo it$iv$iv = recentPathInfo;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    private final Path detourFileInit() {
        if (!this.isRegistryDetourRequired()) {
            boolean bl = false;
            String string = "Calling getDetourFile for old VS";
            throw new IllegalStateException(string.toString());
        }
        Path file = this.appDataHiveFolder.resolve("privateregistry.bin");
        Intrinsics.checkNotNull((Object)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger.warn("detour file is not found. did you delete it or its not vs<=17?");
            throw new VSHiveDetourFileNotFoundException();
        }
        return file;
    }

    private final String loadCodeContainersFromConfig() {
        Object object;
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Object factory;
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            Path configFile = this.appDataHiveFolder.resolve("ApplicationPrivateSettings.xml");
            Intrinsics.checkNotNull((Object)configFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(configFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
            try {
                factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
                factory = builder.parse(configFile.toFile());
            }
            catch (Throwable e) {
                VSRegistryParserNew.logger.info("Error reading the XML config file.", e);
                return null;
            }
            Object document = factory;
            XPathExpression query = XPathFactory.newInstance().newXPath().compile("/content/indexed/collection[@name='CodeContainers.Offline']");
            Object object2 = query.evaluate(document, XPathConstants.NODE);
            Node node = object2 instanceof Node ? (Node)object2 : null;
            if (node == null) {
                VSRegistryParserNew $this$loadCodeContainersFromConfig_u24lambda_u240_u240 = this;
                boolean bl3 = false;
                VSRegistryParserNew.logger.info("\"" + configFile + "\" has no CodeContainers defined.");
                return null;
            }
            Node element = node;
            object = Result.constructor-impl((Object)element.getTextContent());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (String)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    private final String loadCodeContainersFromRegistry() {
        String string;
        try {
            string = this.registryRootKey.div("ApplicationPrivateSettings").div("_metadata").div("baselines").div("CodeContainers").getStringValue("Offline");
        }
        catch (Throwable t2) {
            logger.info("Super new method of getting projects failed");
            logger.debug(t2);
            string = null;
        }
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        String regInfo = string2;
        String regInfo2 = !StringsKt.startsWith$default((CharSequence)regInfo, (char)'{', (boolean)false, (int)2, null) ? StringsKt.drop((String)regInfo, (int)1) : regInfo;
        return regInfo2;
    }

    private static final Pair envPath_delegate$lambda$0(VSRegistryParserNew this$0) {
        return this$0.envPathInit();
    }

    private static final Path settingsFile_delegate$lambda$0(VSRegistryParserNew this$0) {
        return this$0.settingsFileInit();
    }

    private static final String vsLocation_delegate$lambda$0(VSRegistryParserNew this$0) {
        return this$0.vsLocationInit();
    }

    private static final List recentProjects_delegate$lambda$0(VSRegistryParserNew this$0) {
        List list = this$0.recentProjectsInit();
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    private static final Map extensions_delegate$lambda$0(VSRegistryParserNew this$0) {
        return this$0.extensionsListInit();
    }

    private static final ILookAndFeel theme_delegate$lambda$0(VSRegistryParserNew this$0) {
        return this$0.themeInit();
    }

    private static final CharSequence extensionsListInit$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + ", ";
    }

    public /* synthetic */ VSRegistryParserNew(VSHive hive, DefaultConstructorMarker $constructor_marker) {
        this(hive);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VSRegistryParserNew.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VSRegistryParserNew.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSRegistryParserNew$Companion;", "", "<init>", "()V", "veryBadLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/parsers/VSRegistryParserNew;", "hive", "Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/utilities/VSHive;", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VSRegistryParserNew create(@NotNull VSHive hive) {
            VSRegistryParserNew vSRegistryParserNew;
            Intrinsics.checkNotNullParameter((Object)hive, (String)"hive");
            try {
                vSRegistryParserNew = new VSRegistryParserNew(hive, null);
            }
            catch (VSHiveDetourFileNotFoundException t) {
                throw t;
            }
            catch (Throwable t) {
                logger.warn("Failed to initialize registry");
                logger.warn(t);
                vSRegistryParserNew = null;
            }
            return vSRegistryParserNew;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

