/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.impl.text.EditorHighlighterUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DiffEditorHighlighterUpdater
extends EditorHighlighterUpdater {
    @NotNull
    private final DocumentContent myContent;

    public DiffEditorHighlighterUpdater(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull EditorEx editor, @NotNull DocumentContent content) {
        if (project == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(2);
        }
        if (content == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(3);
        }
        super(project, parentDisposable, (SimpleMessageBusConnection)project.getMessageBus().connect(parentDisposable), editor, content.getHighlightFile(), null);
        this.myContent = content;
    }

    @NotNull
    protected EditorHighlighter createHighlighter(boolean forceEmpty) {
        CharSequence text;
        EditorHighlighter highlighter;
        if (!forceEmpty && (highlighter = DiffUtil.initEditorHighlighter(this.project, this.myContent, text = this.editor.getDocument().getImmutableCharSequence())) != null) {
            EditorHighlighter editorHighlighter = highlighter;
            if (editorHighlighter == null) {
                DiffEditorHighlighterUpdater.$$$reportNull$$$0(4);
            }
            return editorHighlighter;
        }
        EditorHighlighter editorHighlighter = DiffUtil.createEmptyEditorHighlighter();
        if (editorHighlighter == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(5);
        }
        return editorHighlighter;
    }

    protected void setupHighlighter(@NotNull EditorHighlighter highlighter) {
        if (highlighter == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(6);
        }
        super.setupHighlighter(highlighter);
        DiffEditorHighlighterUpdater.restartHighlighterInWindow(this.project, (Editor)this.editor, this.myContent.getDocument(), (Object)this);
    }

    private static void restartHighlighterInWindow(@Nullable Project project, @NotNull Editor editor, @NotNull Document document, @NotNull @NonNls Object restartReason) {
        if (editor == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(7);
        }
        if (document == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(8);
        }
        if (restartReason == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(9);
        }
        if (project == null) {
            return;
        }
        Window window = UIUtil.getWindow((Component)editor.getComponent());
        if (window == null || !window.isShowing() || UIUtil.isFocusAncestor((Component)window)) {
            return;
        }
        DiffEditorHighlighterUpdater.restartHighlighterFor(project, editor, document, restartReason);
    }

    public static void restartHighlighterFor(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, @NotNull @NonNls Object restartReason) {
        if (project == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(11);
        }
        if (document == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(12);
        }
        if (restartReason == null) {
            DiffEditorHighlighterUpdater.$$$reportNull$$$0(13);
        }
        ReadAction.nonBlocking(() -> PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(document)).coalesceBy(new Object[]{DiffEditorHighlighterUpdater.class, editor}).expireWith((Disposable)project).submit((Executor)NonUrgentExecutor.getInstance()).onSuccess(psiFile -> {
            if (psiFile != null) {
                if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile, restartReason);
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile, restartReason));
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffEditorHighlighterUpdater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restartReason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffEditorHighlighterUpdater";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupHighlighter";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "restartHighlighterInWindow";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "restartHighlighterFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

