/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.KotlinK2ModeCompatibilityCheckerKt;
import com.intellij.ide.plugins.NonBundledPluginsAreExplicitlyDisabled;
import com.intellij.ide.plugins.PluginCompatibilityUtils;
import com.intellij.ide.plugins.PluginInitializationContext;
import com.intellij.ide.plugins.PluginIsCompatibleOnlyWithIntelliJIDEA;
import com.intellij.ide.plugins.PluginIsIncompatibleWithKotlinMode;
import com.intellij.ide.plugins.PluginIsMarkedBroken;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNonLoadReason;
import com.intellij.idea.AppMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"validatePluginIsCompatible", "Lcom/intellij/ide/plugins/PluginNonLoadReason;", "Lcom/intellij/ide/plugins/PluginInitializationContext;", "plugin", "Lcom/intellij/ide/plugins/PluginMainDescriptor;", "intellij.platform.core.impl"})
public final class PluginInitializationContextKt {
    @ApiStatus.Internal
    @Nullable
    public static final PluginNonLoadReason validatePluginIsCompatible(@NotNull PluginInitializationContext $this$validatePluginIsCompatible, @NotNull PluginMainDescriptor plugin) {
        Intrinsics.checkNotNullParameter((Object)$this$validatePluginIsCompatible, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        if (KotlinK2ModeCompatibilityCheckerKt.isPluginWhichDependsOnKotlinPluginAndItsIncompatibleWithIt(plugin)) {
            String mode = KotlinK2ModeCompatibilityCheckerKt.isKotlinPluginK1Mode() ? CoreBundle.message((String)"plugin.loading.error.k1.mode", (Object[])new Object[0]) : CoreBundle.message((String)"plugin.loading.error.k2.mode", (Object[])new Object[0]);
            return new PluginIsIncompatibleWithKotlinMode(plugin, mode);
        }
        if (plugin.isBundled()) {
            return null;
        }
        if (AppMode.isDisableNonBundledPlugins()) {
            return new NonBundledPluginsAreExplicitlyDisabled(plugin);
        }
        PluginNonLoadReason pluginNonLoadReason = PluginManagerCore.checkBuildNumberCompatibility(plugin, $this$validatePluginIsCompatible.getProductBuildNumber());
        if (pluginNonLoadReason != null) {
            PluginNonLoadReason it = pluginNonLoadReason;
            boolean bl = false;
            return it;
        }
        if ($this$validatePluginIsCompatible.isPluginBroken(plugin.getPluginId(), plugin.getVersion())) {
            return new PluginIsMarkedBroken(plugin);
        }
        if ($this$validatePluginIsCompatible.getRequirePlatformAliasDependencyForLegacyPlugins() && PluginCompatibilityUtils.INSTANCE.isLegacyPluginWithoutPlatformAliasDependencies(plugin)) {
            return new PluginIsCompatibleOnlyWithIntelliJIDEA(plugin);
        }
        return null;
    }
}

