/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.EventWatcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ThreadingSupport;
import com.intellij.openapi.application.impl.BulkArrayQueue;
import com.intellij.openapi.application.impl.InvocationUtil;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 72\u00020\u0001:\u0005789:;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0002J,\u0010\u001d\u001a\u00020\u00152\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\n2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\b0\u0007H\u0002J\u0006\u0010 \u001a\u00020\u0015J\b\u0010!\u001a\u00020\u0015H\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\bH\u0002J\"\u0010$\u001a\u00020\u00152\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\bH\u0002J\u0006\u0010*\u001a\u00020\u0015J\u0006\u0010+\u001a\u00020\u0015J*\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00132\n\u00102\u001a\u0006\u0012\u0002\b\u000303J\n\u00104\u001a\u000205H\u0096\u0080\u0004J\u000e\u00106\u001a\u00020\u00132\u0006\u0010/\u001a\u000200R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue;", "", "threadingSupport", "Lcom/intellij/openapi/application/ThreadingSupport;", "<init>", "(Lcom/intellij/openapi/application/ThreadingSupport;)V", "writeIntentQueue", "Lcom/intellij/openapi/application/impl/BulkArrayQueue;", "Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue$RunnableInfo;", "skippedWriteIntentQueue", "Lcom/intellij/openapi/util/Ref;", "Lit/unimi/dsi/fastutil/objects/ObjectArrayList;", "uiQueue", "Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue$FlushQueueCommand;", "skippedUiQueue", "lockObject", "timeCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "FLUSH_SCHEDULED", "", "setFlushScheduledGuard", "", "value", "getFlushScheduledGuard", "FLUSH_NOW", "Lcom/intellij/concurrency/ContextAwareRunnable;", "currentWriteIntentLockMode", "Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue$WriteIntentLockMode;", "pollNextEvent", "reincludeSkippedItems", "list", "mainQueue", "requestFlush", "flushNow", "runNextEvent", "nextRunnable", "reportStatistics", "watcher", "Lcom/intellij/diagnostic/EventWatcher;", "waitingFinishedNs", "", "runnableInfo", "onModalityChanged", "purgeExpiredItems", "push", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "runnable", "Ljava/lang/Runnable;", "isRunningUnderWriteIntent", "isExpired", "Lcom/intellij/openapi/util/Condition;", "toString", "", "isFlushNow", "Companion", "WriteIntentLockMode", "FlushQueueCommand", "RunnableInfo", "WriteActionFinished", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class NonBlockingFlushQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadingSupport threadingSupport;
    @NotNull
    private final BulkArrayQueue<RunnableInfo> writeIntentQueue;
    @NotNull
    private final Ref<ObjectArrayList<RunnableInfo>> skippedWriteIntentQueue;
    @NotNull
    private final BulkArrayQueue<FlushQueueCommand> uiQueue;
    @NotNull
    private final Ref<ObjectArrayList<RunnableInfo>> skippedUiQueue;
    @NotNull
    private final Object lockObject;
    @NotNull
    private final AtomicLong timeCounter;
    private boolean FLUSH_SCHEDULED;
    @NotNull
    private final ContextAwareRunnable FLUSH_NOW;
    @NotNull
    private WriteIntentLockMode currentWriteIntentLockMode;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ThrottledLogger THROTTLED_LOG;

    public NonBlockingFlushQueue(@NotNull ThreadingSupport threadingSupport) {
        Intrinsics.checkNotNullParameter((Object)threadingSupport, (String)"threadingSupport");
        this.threadingSupport = threadingSupport;
        this.writeIntentQueue = new BulkArrayQueue();
        this.skippedWriteIntentQueue = new Ref((Object)new ObjectArrayList(100));
        this.uiQueue = new BulkArrayQueue();
        this.skippedUiQueue = new Ref((Object)new ObjectArrayList(100));
        this.lockObject = new Object();
        this.timeCounter = new AtomicLong();
        this.FLUSH_NOW = () -> NonBlockingFlushQueue.FLUSH_NOW$lambda$0(this);
        this.currentWriteIntentLockMode = WriteIntentLockMode.ALL;
    }

    private final void setFlushScheduledGuard(boolean value) {
        this.FLUSH_SCHEDULED = value;
    }

    private final boolean getFlushScheduledGuard() {
        return this.FLUSH_SCHEDULED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RunnableInfo pollNextEvent() {
        block28: {
            FlushQueueCommand incomingInfo;
            ThreadingAssertions.assertEventDispatchThread();
            ModalityStateEx modalityStateEx = LaterInvocator.getCurrentModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)modalityStateEx), (String)"getCurrentModalityState(...)");
            ModalityStateEx currentModality = modalityStateEx;
            while (true) {
                FlushQueueCommand flushQueueCommand;
                Ref<ObjectArrayList<RunnableInfo>> skippedQueue = null;
                BulkArrayQueue<FlushQueueCommand> selectedQueue = null;
                Object object = this.lockObject;
                synchronized (object) {
                    FlushQueueCommand flushQueueCommand2;
                    RunnableInfo topWiRunnable;
                    FlushQueueCommand topUiRunnable;
                    block27: {
                        boolean bl = false;
                        topUiRunnable = this.uiQueue.peekFirst();
                        RunnableInfo runnableInfo = topWiRunnable = this.currentWriteIntentLockMode == WriteIntentLockMode.ALL ? this.writeIntentQueue.peekFirst() : null;
                        if (topUiRunnable != null || topWiRunnable != null) break block27;
                        RunnableInfo runnableInfo2 = null;
                        return runnableInfo2;
                    }
                    if (topUiRunnable != null && topWiRunnable == null) {
                        skippedQueue = this.skippedUiQueue;
                        selectedQueue = this.uiQueue;
                        flushQueueCommand2 = topUiRunnable;
                    } else if (topUiRunnable == null) {
                        skippedQueue = this.skippedWriteIntentQueue;
                        selectedQueue = this.writeIntentQueue;
                        flushQueueCommand2 = topWiRunnable;
                    } else if (topWiRunnable == null) {
                        skippedQueue = this.skippedUiQueue;
                        selectedQueue = this.uiQueue;
                        flushQueueCommand2 = topUiRunnable;
                    } else if (topUiRunnable.getCreationTime() < topWiRunnable.getCreationTime()) {
                        skippedQueue = this.skippedUiQueue;
                        selectedQueue = this.uiQueue;
                        flushQueueCommand2 = topUiRunnable;
                    } else {
                        skippedQueue = this.skippedWriteIntentQueue;
                        selectedQueue = this.writeIntentQueue;
                        flushQueueCommand2 = topWiRunnable;
                    }
                    flushQueueCommand = flushQueueCommand2;
                }
                if (flushQueueCommand == null) {
                    return null;
                }
                FlushQueueCommand flushQueueCommand3 = incomingInfo;
                if (flushQueueCommand3 instanceof WriteActionFinished) {
                    if (!(this.currentWriteIntentLockMode == WriteIntentLockMode.UI_ONLY)) {
                        boolean bl = false;
                        String string = "Write action finished, but FlushQueue is unexpectedly allowed to run all runnables";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (this.threadingSupport.isWriteActionPending() || this.threadingSupport.isWriteActionInProgress()) {
                        this.threadingSupport.runWhenWriteActionIsCompleted(() -> NonBlockingFlushQueue.pollNextEvent$lambda$2(this));
                        return null;
                    }
                    object = this.lockObject;
                    synchronized (object) {
                        boolean $i$a$-synchronized-NonBlockingFlushQueue$pollNextEvent$62 = false;
                        FlushQueueCommand $i$a$-synchronized-NonBlockingFlushQueue$pollNextEvent$62 = this.uiQueue.pollFirst();
                    }
                    this.currentWriteIntentLockMode = WriteIntentLockMode.ALL;
                    continue;
                }
                if (!(flushQueueCommand3 instanceof RunnableInfo)) break block28;
                if (!currentModality.accepts(((RunnableInfo)incomingInfo).getModalityState())) {
                    ((ObjectArrayList)skippedQueue.get()).add((Object)incomingInfo);
                    ((RunnableInfo)incomingInfo).setWasInSkippedItems(true);
                    object = this.lockObject;
                    synchronized (object) {
                        boolean $i$a$-synchronized-NonBlockingFlushQueue$pollNextEvent$72 = false;
                        FlushQueueCommand $i$a$-synchronized-NonBlockingFlushQueue$pollNextEvent$72 = selectedQueue.pollFirst();
                    }
                }
                if (!((RunnableInfo)incomingInfo).isExpired().value(null)) break;
                object = this.lockObject;
                synchronized (object) {
                    boolean bl = false;
                    FlushQueueCommand flushQueueCommand4 = selectedQueue.pollFirst();
                }
            }
            this.requestFlush();
            return (RunnableInfo)incomingInfo;
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reincludeSkippedItems(Ref<ObjectArrayList<RunnableInfo>> list, BulkArrayQueue<? super RunnableInfo> mainQueue) {
        ThreadingAssertions.assertEventDispatchThread();
        int size = ((ObjectArrayList)list.get()).size();
        if (size != 0) {
            Object object = this.lockObject;
            synchronized (object) {
                boolean bl = false;
                mainQueue.bulkEnqueueFirst((ObjectArrayList<? super RunnableInfo>)((ObjectArrayList)list.get()));
                Unit unit = Unit.INSTANCE;
            }
            if (size < 100) {
                ((ObjectArrayList)list.get()).clear();
            } else {
                list.set((Object)new ObjectArrayList(100));
            }
        }
        this.requestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestFlush() {
        Object object = this.lockObject;
        synchronized (object) {
            block7: {
                block8: {
                    boolean bl = false;
                    if (this.getFlushScheduledGuard()) {
                        return;
                    }
                    if (!this.uiQueue.isEmpty()) break block7;
                    if (this.currentWriteIntentLockMode == WriteIntentLockMode.UI_ONLY) break block8;
                    if (!this.writeIntentQueue.isEmpty()) break block7;
                }
                return;
            }
            this.setFlushScheduledGuard(true);
            Unit unit = Unit.INSTANCE;
        }
        SwingUtilities.invokeLater((Runnable)this.FLUSH_NOW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushNow() {
        RunnableInfo nextRunnable;
        ThreadingAssertions.assertEventDispatchThread();
        Object object = this.lockObject;
        synchronized (object) {
            boolean $i$a$-synchronized-NonBlockingFlushQueue$flushNow$22 = false;
            this.setFlushScheduledGuard(false);
            Unit $i$a$-synchronized-NonBlockingFlushQueue$flushNow$22 = Unit.INSTANCE;
        }
        long startTime = System.nanoTime();
        while ((nextRunnable = this.pollNextEvent()) != null) {
            this.runNextEvent(nextRunnable);
            if (!InvocationUtil.priorityEventPending() && System.nanoTime() - startTime <= 5000000L) continue;
            this.requestFlush();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runNextEvent(RunnableInfo nextRunnable) {
        block15: {
            EventWatcher watcher = EventWatcher.getInstanceOrNull();
            long waitingFinishedNs = System.nanoTime();
            try {
                if (nextRunnable.getNeedWriteIntent()) {
                    boolean success;
                    if (!(this.currentWriteIntentLockMode == WriteIntentLockMode.ALL)) {
                        boolean bl = false;
                        String string = "Execution of Write-Intent-Locked runnables is not allowed in UI_ONLY mode";
                        throw new IllegalArgumentException(string.toString());
                    }
                    boolean bl = success = !this.threadingSupport.isWriteActionPending() && !this.threadingSupport.isWriteActionInProgress() && this.threadingSupport.tryRunWriteIntentReadAction(() -> NonBlockingFlushQueue.runNextEvent$lambda$1(this, nextRunnable));
                    if (!success) {
                        this.currentWriteIntentLockMode = WriteIntentLockMode.UI_ONLY;
                        this.threadingSupport.runWhenWriteActionIsCompleted(() -> NonBlockingFlushQueue.runNextEvent$lambda$2(this));
                    }
                    break block15;
                }
                Object object = this.lockObject;
                synchronized (object) {
                    boolean bl = false;
                    FlushQueueCommand flushQueueCommand = this.uiQueue.pollFirst();
                }
                ThreadContext.resetThreadContext(() -> NonBlockingFlushQueue.runNextEvent$lambda$4(nextRunnable));
            }
            catch (ProcessCanceledException success) {
            }
            catch (Throwable e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    ExceptionUtil.rethrow((Throwable)e);
                }
                if (!Logger.shouldRethrow((Throwable)e)) {
                    LOG.error(e);
                }
            }
            finally {
                this.reportStatistics(watcher, waitingFinishedNs, nextRunnable);
            }
        }
    }

    private final void reportStatistics(EventWatcher watcher, long waitingFinishedNs, RunnableInfo runnableInfo) {
        if (watcher == null) {
            return;
        }
        Runnable runnable = runnableInfo.getRunnable();
        long executionFinishedNs = System.nanoTime();
        long waitedInQueueNs = waitingFinishedNs - runnableInfo.getQueuedTimeNs();
        long executionDurationNs = executionFinishedNs - waitingFinishedNs;
        long waitedTimeInQueueNs_safe = waitedInQueueNs >= 0L ? waitedInQueueNs : 0L;
        long executionDurationNs_safe = executionDurationNs >= 0L ? executionDurationNs : 0L;
        watcher.runnableTaskFinished(runnable, waitedTimeInQueueNs_safe, runnableInfo.getQueueSize(), executionDurationNs_safe, runnableInfo.getWasInSkippedItems());
        if (waitedInQueueNs < 0L || executionDurationNs < 0L) {
            THROTTLED_LOG.info("waitedInQueueNs(" + waitedInQueueNs + ") | executionDurationNs(" + executionDurationNs + ") is negative -> unexpected state");
        }
    }

    public final void onModalityChanged() {
        ThreadingAssertions.assertEventDispatchThread();
        this.reincludeSkippedItems(this.skippedUiQueue, this.uiQueue);
        this.reincludeSkippedItems(this.skippedWriteIntentQueue, this.writeIntentQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void purgeExpiredItems() {
        ThreadingAssertions.assertEventDispatchThread();
        Object object = this.lockObject;
        synchronized (object) {
            boolean bl = false;
            Object object2 = this.skippedUiQueue.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            CollectionsKt.removeAll((List)((List)object2), NonBlockingFlushQueue::purgeExpiredItems$lambda$0$0);
            Object object3 = this.skippedWriteIntentQueue.get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            CollectionsKt.removeAll((List)((List)object3), NonBlockingFlushQueue::purgeExpiredItems$lambda$0$1);
            this.writeIntentQueue.removeAll(arg_0 -> NonBlockingFlushQueue.purgeExpiredItems$lambda$0$3(NonBlockingFlushQueue::purgeExpiredItems$lambda$0$2, arg_0));
            this.uiQueue.removeAll(arg_0 -> NonBlockingFlushQueue.purgeExpiredItems$lambda$0$5(NonBlockingFlushQueue::purgeExpiredItems$lambda$0$4, arg_0));
            this.requestFlush();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void push(@NotNull ModalityState modalityState, @NotNull Runnable runnable, boolean isRunningUnderWriteIntent, @NotNull Condition<?> isExpired) {
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        Intrinsics.checkNotNullParameter(isExpired, (String)"isExpired");
        long creationTime = this.timeCounter.getAndIncrement();
        long stamp = System.nanoTime();
        Object object = this.lockObject;
        synchronized (object) {
            boolean bl = false;
            int queueSize = this.writeIntentQueue.size() + this.uiQueue.size();
            RunnableInfo info = new RunnableInfo(runnable, modalityState, isExpired, isRunningUnderWriteIntent, creationTime, stamp, queueSize, false);
            if (isRunningUnderWriteIntent) {
                this.writeIntentQueue.enqueue(info);
            } else {
                this.uiQueue.enqueue(info);
            }
            this.requestFlush();
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public String toString() {
        return "NonBlockingFlushQueue(currentWriteIntentLockMode=" + (Object)((Object)this.currentWriteIntentLockMode) + ", wiQueue=" + this.writeIntentQueue.size() + " elements, uiQueue=" + this.uiQueue.size() + ", skippedWriteIntentQueue=" + ((ObjectArrayList)this.skippedWriteIntentQueue.get()).size() + " elements, skippedUiQueue=" + ((ObjectArrayList)this.skippedUiQueue.get()).size() + " elements; flush scheduled: " + this.FLUSH_SCHEDULED + ')';
    }

    public final boolean isFlushNow(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return runnable == this.FLUSH_NOW;
    }

    private static final void FLUSH_NOW$lambda$0(NonBlockingFlushQueue this$0) {
        this$0.flushNow();
    }

    private static final Unit pollNextEvent$lambda$2(NonBlockingFlushQueue this$0) {
        this$0.requestFlush();
        return Unit.INSTANCE;
    }

    private static final Unit runNextEvent$lambda$1$1$0(RunnableInfo $nextRunnable) {
        $nextRunnable.getRunnable().run();
        return Unit.INSTANCE;
    }

    private static final Unit runNextEvent$lambda$1$1(RunnableInfo $nextRunnable) {
        ProgressManager progressManager = ProgressManager.getInstanceOrNull();
        if (progressManager != null) {
            progressManager.computePrioritized(() -> NonBlockingFlushQueue.runNextEvent$lambda$1$1$0($nextRunnable));
        } else {
            $nextRunnable.getRunnable().run();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit runNextEvent$lambda$1(NonBlockingFlushQueue this$0, RunnableInfo $nextRunnable) {
        Object object = this$0.lockObject;
        synchronized (object) {
            boolean bl = false;
            RunnableInfo runnableInfo = this$0.writeIntentQueue.pollFirst();
        }
        ThreadContext.resetThreadContext(() -> NonBlockingFlushQueue.runNextEvent$lambda$1$1($nextRunnable));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit runNextEvent$lambda$2(NonBlockingFlushQueue this$0) {
        Object object = this$0.lockObject;
        synchronized (object) {
            boolean bl = false;
            this$0.uiQueue.enqueue(new WriteActionFinished(this$0.timeCounter.getAndIncrement()));
            this$0.requestFlush();
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Unit runNextEvent$lambda$4(RunnableInfo $nextRunnable) {
        $nextRunnable.getRunnable().run();
        return Unit.INSTANCE;
    }

    private static final boolean purgeExpiredItems$lambda$0$0(RunnableInfo it) {
        return it.isExpired().value(null);
    }

    private static final boolean purgeExpiredItems$lambda$0$1(RunnableInfo it) {
        return it.isExpired().value(null);
    }

    private static final boolean purgeExpiredItems$lambda$0$2(RunnableInfo it) {
        return it.isExpired().value(null);
    }

    private static final boolean purgeExpiredItems$lambda$0$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean purgeExpiredItems$lambda$0$4(FlushQueueCommand it) {
        return it instanceof RunnableInfo && ((RunnableInfo)it).isExpired().value(null);
    }

    private static final boolean purgeExpiredItems$lambda$0$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(NonBlockingFlushQueue.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        THROTTLED_LOG = new ThrottledLogger(LOG, TimeUnit.MINUTES.toMillis(1L));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "THROTTLED_LOG", "Lcom/intellij/openapi/diagnostic/ThrottledLogger;", "intellij.platform.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue$FlushQueueCommand;", "", "creationTime", "", "getCreationTime", "()J", "Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue$RunnableInfo;", "Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue$WriteActionFinished;", "intellij.platform.core.impl"})
    private static interface FlushQueueCommand {
        public long getCreationTime();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\n\u0010!\u001a\u00020\"H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u000f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0018\"\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue$RunnableInfo;", "Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue$FlushQueueCommand;", "runnable", "Ljava/lang/Runnable;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "isExpired", "Lcom/intellij/openapi/util/Condition;", "needWriteIntent", "", "creationTime", "", "queuedTimeNs", "queueSize", "", "wasInSkippedItems", "<init>", "(Ljava/lang/Runnable;Lcom/intellij/openapi/application/ModalityState;Lcom/intellij/openapi/util/Condition;ZJJIZ)V", "getRunnable", "()Ljava/lang/Runnable;", "getModalityState", "()Lcom/intellij/openapi/application/ModalityState;", "()Lcom/intellij/openapi/util/Condition;", "getNeedWriteIntent", "()Z", "getCreationTime", "()J", "getQueuedTimeNs", "getQueueSize", "()I", "getWasInSkippedItems", "setWasInSkippedItems", "(Z)V", "toString", "", "intellij.platform.core.impl"})
    private static final class RunnableInfo
    implements FlushQueueCommand {
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final ModalityState modalityState;
        @NotNull
        private final Condition<?> isExpired;
        private final boolean needWriteIntent;
        private final long creationTime;
        private final long queuedTimeNs;
        private final int queueSize;
        private boolean wasInSkippedItems;

        public RunnableInfo(@NotNull Runnable runnable, @NotNull ModalityState modalityState, @NotNull Condition<?> isExpired, boolean needWriteIntent, long creationTime, long queuedTimeNs, int queueSize, boolean wasInSkippedItems) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
            Intrinsics.checkNotNullParameter(isExpired, (String)"isExpired");
            this.runnable = runnable;
            this.modalityState = modalityState;
            this.isExpired = isExpired;
            this.needWriteIntent = needWriteIntent;
            this.creationTime = creationTime;
            this.queuedTimeNs = queuedTimeNs;
            this.queueSize = queueSize;
            this.wasInSkippedItems = wasInSkippedItems;
        }

        @NotNull
        public final Runnable getRunnable() {
            return this.runnable;
        }

        @NotNull
        public final ModalityState getModalityState() {
            return this.modalityState;
        }

        @NotNull
        public final Condition<?> isExpired() {
            return this.isExpired;
        }

        public final boolean getNeedWriteIntent() {
            return this.needWriteIntent;
        }

        @Override
        public long getCreationTime() {
            return this.creationTime;
        }

        public final long getQueuedTimeNs() {
            return this.queuedTimeNs;
        }

        public final int getQueueSize() {
            return this.queueSize;
        }

        public final boolean getWasInSkippedItems() {
            return this.wasInSkippedItems;
        }

        public final void setWasInSkippedItems(boolean bl) {
            this.wasInSkippedItems = bl;
        }

        @NotNull
        public String toString() {
            return "RunnableInfo[modalityState=" + this.modalityState + ", needWi=" + this.needWriteIntent + ", runnable=" + this.runnable + ']';
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u00020\tH\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue$WriteActionFinished;", "Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue$FlushQueueCommand;", "creationTime", "", "<init>", "(J)V", "getCreationTime", "()J", "toString", "", "intellij.platform.core.impl"})
    private static final class WriteActionFinished
    implements FlushQueueCommand {
        private final long creationTime;

        public WriteActionFinished(long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public long getCreationTime() {
            return this.creationTime;
        }

        @NotNull
        public String toString() {
            return "WriteActionFinished";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/application/impl/NonBlockingFlushQueue$WriteIntentLockMode;", "", "<init>", "(Ljava/lang/String;I)V", "ALL", "UI_ONLY", "intellij.platform.core.impl"})
    private static final class WriteIntentLockMode
    extends Enum<WriteIntentLockMode> {
        public static final /* enum */ WriteIntentLockMode ALL = new WriteIntentLockMode();
        public static final /* enum */ WriteIntentLockMode UI_ONLY = new WriteIntentLockMode();
        private static final /* synthetic */ WriteIntentLockMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static WriteIntentLockMode[] values() {
            return (WriteIntentLockMode[])$VALUES.clone();
        }

        public static WriteIntentLockMode valueOf(String value) {
            return Enum.valueOf(WriteIntentLockMode.class, value);
        }

        @NotNull
        public static EnumEntries<WriteIntentLockMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = writeIntentLockModeArray = new WriteIntentLockMode[]{WriteIntentLockMode.ALL, WriteIntentLockMode.UI_ONLY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

