/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.VarHandleWrapper;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

class LockFreeCOWSortedArray<T> {
    @NotNull
    private final Comparator<? super T> comparator;
    @NotNull
    private final ArrayFactory<? extends T> arrayFactory;
    private volatile T @NotNull [] array;
    private static final VarHandleWrapper ARRAY_HANDLE = VarHandleWrapper.getFactory().create(LockFreeCOWSortedArray.class, "array", Object[].class);

    LockFreeCOWSortedArray(@NotNull Comparator<? super T> comparator, @NotNull ArrayFactory<? extends T> arrayFactory) {
        if (comparator == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(0);
        }
        if (arrayFactory == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(1);
        }
        this.comparator = comparator;
        this.arrayFactory = arrayFactory;
        this.array = arrayFactory.create(0);
    }

    void add(@NotNull T element) {
        int i;
        Object[] newArray;
        Object[] oldArray;
        if (element == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(2);
        }
        while (!ARRAY_HANDLE.compareAndSet((Object)this, (Object)(oldArray = this.getArray()), (Object)(newArray = ArrayUtil.insert((Object[])oldArray, (int)(i = this.insertionIndex(oldArray, element)), element)))) {
        }
    }

    boolean remove(@NotNull T listener) {
        Object[] newArray;
        Object[] oldArray;
        if (listener == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(3);
        }
        do {
            if ((oldArray = this.getArray()) != (newArray = ArrayUtil.remove((Object[])oldArray, listener, this.arrayFactory))) continue;
            return false;
        } while (!ARRAY_HANDLE.compareAndSet((Object)this, (Object)oldArray, (Object)newArray));
        return true;
    }

    private int insertionIndex(T @NotNull [] elements, @NotNull T e) {
        if (e == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(5);
        }
        for (int i = 0; i < elements.length; ++i) {
            T element = elements[i];
            if (this.comparator.compare(e, element) >= 0) continue;
            return i;
        }
        return elements.length;
    }

    T @NotNull [] getArray() {
        if (this.array == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(6);
        }
        return this.array;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/LockFreeCOWSortedArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/LockFreeCOWSortedArray";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertionIndex";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

