/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.pico.AmbiguousComponentResolutionException;
import com.intellij.util.pico.CyclicDependencyException;
import com.intellij.util.pico.DefaultPicoContainer;
import com.intellij.util.pico.PicoInitializationException;
import com.intellij.util.pico.PicoIntrospectionException;
import com.intellij.util.pico.TooManySatisfiableConstructorsException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;

@Deprecated
@ApiStatus.ScheduledForRemoval
final class CachingConstructorInjectionComponentAdapter
implements ComponentAdapter {
    private static final ThreadLocal<Set<Class<?>>> ourGuard = new ThreadLocal();
    private final PicoContainer container;
    @NotNull
    private final Object key;
    @NotNull
    private final Class<?> componentImplementation;
    private Object myInstance;

    CachingConstructorInjectionComponentAdapter(@NotNull PicoContainer container, @NotNull Object key, @NotNull Class<?> componentImplementation) {
        if (container == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(0);
        }
        if (key == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(1);
        }
        if (componentImplementation == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(2);
        }
        this.container = container;
        this.key = key;
        this.componentImplementation = componentImplementation;
    }

    @NotNull
    public Object getComponentKey() {
        Object object = this.key;
        if (object == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(3);
        }
        return object;
    }

    @NotNull
    public Class<?> getComponentImplementation() {
        Class<?> clazz = this.componentImplementation;
        if (clazz == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(4);
        }
        return clazz;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.key + "]";
    }

    @NotNull
    public Object getComponentInstance() {
        Object instance = this.myInstance;
        if (instance == null) {
            this.myInstance = instance = CachingConstructorInjectionComponentAdapter.instantiateGuarded(this, this.container, this.getComponentImplementation());
        }
        Object object = instance;
        if (object == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(5);
        }
        return object;
    }

    @NotNull
    private static Object instantiateGuarded(@Nullable CachingConstructorInjectionComponentAdapter adapter, @NotNull PicoContainer container, @NotNull Class<?> componentImplementation) {
        Object object;
        Set<Class<Object>> currentStack;
        if (container == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(6);
        }
        if (componentImplementation == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(7);
        }
        if ((currentStack = ourGuard.get()) == null) {
            currentStack = Collections.newSetFromMap(new IdentityHashMap(1));
            ourGuard.set(currentStack);
        }
        if (!currentStack.add(componentImplementation)) {
            throw new CyclicDependencyException(componentImplementation);
        }
        try {
            Object object2 = CachingConstructorInjectionComponentAdapter.doGetComponentInstance(adapter, (DefaultPicoContainer)container, componentImplementation);
            object = object2;
        }
        catch (CyclicDependencyException e) {
            e.push(componentImplementation);
            throw e;
        }
        finally {
            currentStack.remove(componentImplementation);
        }
        if (object == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(8);
        }
        return object;
    }

    private static ComponentAdapter resolveAdapter(@NotNull DefaultPicoContainer container, @Nullable ComponentAdapter excludeAdapter, @NotNull Class<?> expectedType) {
        if (container == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(9);
        }
        if (expectedType == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(10);
        }
        if (excludeAdapter == null) {
            return container.getComponentAdapter(expectedType);
        }
        ComponentAdapter result = container.getComponentAdapterOfType(expectedType, excludeAdapter.getComponentKey());
        return result == null ? null : (expectedType.isAssignableFrom(result.getComponentImplementation()) ? result : null);
    }

    @NotNull
    private static Object doGetComponentInstance(@Nullable ComponentAdapter adapter, @NotNull DefaultPicoContainer container, @NotNull Class<?> componentImplementation) {
        Object obj;
        Constructor<?> constructor;
        block12: {
            if (container == null) {
                CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(11);
            }
            if (componentImplementation == null) {
                CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(12);
            }
            try {
                constructor = CachingConstructorInjectionComponentAdapter.getGreediestSatisfiableConstructor(adapter, container, componentImplementation);
            }
            catch (AmbiguousComponentResolutionException e) {
                e.setComponent(componentImplementation);
                throw e;
            }
            constructor.setAccessible(true);
            if (constructor.getParameterCount() != 0) break block12;
            Object obj2 = constructor.newInstance(new Object[0]);
            if (obj2 == null) {
                CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(13);
            }
            return obj2;
        }
        try {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Object[] result = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                ComponentAdapter componentAdapter = CachingConstructorInjectionComponentAdapter.resolveAdapter(container, adapter, parameterTypes[i]);
                if (componentAdapter == null) continue;
                result[i] = container.getComponentInstance(componentAdapter.getComponentKey());
            }
            obj = constructor.newInstance(result);
        }
        catch (InvocationTargetException e) {
            ExceptionUtilRt.rethrowUnchecked((Throwable)e.getTargetException());
            Throwable cause = e.getTargetException();
            throw new PicoInitializationException("InvocationTargetException: " + cause.getClass().getName() + " " + cause.getMessage(), cause);
        }
        catch (InstantiationException e) {
            throw new PicoInitializationException("Should never get here");
        }
        catch (IllegalAccessException e) {
            throw new PicoInitializationException(e);
        }
        if (obj == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(14);
        }
        return obj;
    }

    @NotNull
    private static Constructor<?> getGreediestSatisfiableConstructor(@Nullable ComponentAdapter adapter, @NotNull DefaultPicoContainer container, @NotNull Class<?> componentImplementation) throws PicoIntrospectionException {
        if (container == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(15);
        }
        if (componentImplementation == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(16);
        }
        HashSet conflicts = new HashSet();
        HashSet<Class<?>[]> unsatisfiableDependencyTypes = new HashSet<Class<?>[]>();
        Constructor<?>[] constructors = componentImplementation.getDeclaredConstructors();
        Arrays.sort(constructors, (arg0, arg1) -> arg1.getParameterCount() - arg0.getParameterCount());
        Constructor<?> greediestConstructor = null;
        int lastSatisfiableConstructorSize = -1;
        Class<?> unsatisfiedDependencyType = null;
        for (Constructor<?> constructor : constructors) {
            Class<?>[] parameterTypes;
            if (constructor.isSynthetic() || CachingConstructorInjectionComponentAdapter.isNonInjectable(constructor)) continue;
            boolean failedDependency = false;
            for (Class<?> type : parameterTypes = constructor.getParameterTypes()) {
                if (CachingConstructorInjectionComponentAdapter.resolveAdapter(container, adapter, type) != null) continue;
                unsatisfiableDependencyTypes.add(parameterTypes);
                unsatisfiedDependencyType = type;
                failedDependency = true;
                break;
            }
            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                if (conflicts.isEmpty()) {
                    Constructor<?> constructor2 = greediestConstructor;
                    if (constructor2 == null) {
                        CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(17);
                    }
                    return constructor2;
                }
                conflicts.add(constructor);
                continue;
            }
            if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                conflicts.add(constructor);
                conflicts.add(greediestConstructor);
                continue;
            }
            if (failedDependency) continue;
            greediestConstructor = constructor;
            lastSatisfiableConstructorSize = parameterTypes.length;
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(conflicts);
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new PicoIntrospectionException(componentImplementation.getName() + " has unsatisfied dependency: " + unsatisfiedDependencyType + " among unsatisfiable dependencies: (" + StringUtil.join(unsatisfiableDependencyTypes, a -> Arrays.toString(a), (String)", ") + ") where " + container + " was the leaf container being asked for dependencies.");
        }
        if (greediestConstructor == null) {
            throw new PicoInitializationException("Either do the specified parameters not match any of the following constructors: " + Arrays.toString(componentImplementation.getDeclaredConstructors()) + " or the constructors were not accessible for '" + componentImplementation + "'");
        }
        Constructor<?> constructor = greediestConstructor;
        if (constructor == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(18);
        }
        return constructor;
    }

    private static boolean isNonInjectable(@NotNull Constructor<?> constructor) {
        if (constructor == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(19);
        }
        for (Annotation o : constructor.getAnnotations()) {
            String name = o.annotationType().getName();
            if (!"com.intellij.serviceContainer.NonInjectable".equals(name) && !"java.lang.Deprecated".equals(name)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentImplementation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/pico/CachingConstructorInjectionComponentAdapter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/pico/CachingConstructorInjectionComponentAdapter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentImplementation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateGuarded";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetComponentInstance";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getGreediestSatisfiableConstructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "instantiateGuarded";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveAdapter";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doGetComponentInstance";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getGreediestSatisfiableConstructor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isNonInjectable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

