/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SwingUndoUtil {
    private static final Key<UndoManager> UNDO_MANAGER = Key.create((String)"undoManager");
    private static final Action REDO_ACTION = new AbstractAction(){

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Object source;
            UndoManager manager;
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((manager = ClientProperty.get((source = e.getSource()) instanceof Component ? (Component)source : null, UNDO_MANAGER)) != null && manager.canRedo()) {
                manager.redo();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/SwingUndoUtil$1", "actionPerformed"));
        }
    };
    private static final Action UNDO_ACTION = new AbstractAction(){

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Object source;
            UndoManager manager;
            if (e == null) {
                2.$$$reportNull$$$0(0);
            }
            if ((manager = ClientProperty.get((source = e.getSource()) instanceof Component ? (Component)source : null, UNDO_MANAGER)) != null && manager.canUndo()) {
                manager.undo();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/SwingUndoUtil$2", "actionPerformed"));
        }
    };
    private static final DocumentListener SET_TEXT_CHECKER = new DocumentAdapter(){

        @Override
        protected void textChanged(@NotNull DocumentEvent e) {
            Document document;
            if (e == null) {
                3.$$$reportNull$$$0(0);
            }
            if ((document = e.getDocument()) instanceof AbstractDocument) {
                StackTraceElement[] stackTrace;
                for (StackTraceElement element : stackTrace = new Throwable().getStackTrace()) {
                    UndoableEditListener[] undoableEditListeners;
                    if (!element.getClassName().equals(JTextComponent.class.getName()) || !element.getMethodName().equals("setText")) continue;
                    for (UndoableEditListener listener2 : undoableEditListeners = ((AbstractDocument)document).getUndoableEditListeners()) {
                        if (!(listener2 instanceof UndoManager)) continue;
                        Runnable runnable = ((UndoManager)listener2)::discardAllEdits;
                        SwingUtilities.invokeLater(runnable);
                        return;
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/SwingUndoUtil$3", "textChanged"));
        }
    };

    @Nullable
    public static UndoManager getUndoManager(Component component) {
        Object o;
        if (component instanceof JTextComponent && (o = ((JTextComponent)component).getClientProperty(UNDO_MANAGER)) instanceof UndoManager) {
            return (UndoManager)o;
        }
        return null;
    }

    public static void addUndoRedoActions(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            SwingUndoUtil.$$$reportNull$$$0(0);
        }
        if (textComponent.getClientProperty(UNDO_MANAGER) instanceof UndoManager) {
            return;
        }
        UndoManager undoManager = new UndoManager();
        textComponent.putClientProperty(UNDO_MANAGER, undoManager);
        textComponent.getDocument().addUndoableEditListener(undoManager);
        textComponent.getDocument().addDocumentListener(SET_TEXT_CHECKER);
        textComponent.getInputMap().put(KeyStroke.getKeyStroke(90, SystemInfoRt.isMac ? 4 : 2), "undoKeystroke");
        textComponent.getActionMap().put("undoKeystroke", UNDO_ACTION);
        textComponent.getInputMap().put(KeyStroke.getKeyStroke(90, (SystemInfoRt.isMac ? 4 : 2) | 1), "redoKeystroke");
        textComponent.getActionMap().put("redoKeystroke", REDO_ACTION);
    }

    public static void resetUndoRedoActions(@NotNull JTextComponent textComponent) {
        UndoManager undoManager;
        if (textComponent == null) {
            SwingUndoUtil.$$$reportNull$$$0(1);
        }
        if ((undoManager = ClientProperty.get((Component)textComponent, UNDO_MANAGER)) != null) {
            undoManager.discardAllEdits();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTextWithUndo(@NotNull JTextComponent field, @NotNull String text) {
        if (field == null) {
            SwingUndoUtil.$$$reportNull$$$0(2);
        }
        if (text == null) {
            SwingUndoUtil.$$$reportNull$$$0(3);
        }
        if (field.getText().equals(text)) {
            return;
        }
        SwingUndoUtil.addUndoRedoActions(field);
        Document doc = field.getDocument();
        UndoManager undoManager = Objects.requireNonNull(ClientProperty.get((Component)field, UNDO_MANAGER));
        final CompoundEdit edits = new CompoundEdit();
        UndoableEditListener tempListener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                edits.addEdit(e.getEdit());
            }
        };
        doc.removeUndoableEditListener(undoManager);
        doc.addUndoableEditListener(tempListener);
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, text, null);
            edits.end();
            undoManager.addEdit(edits);
        }
        catch (BadLocationException e) {
            UIManager.getLookAndFeel().provideErrorFeedback(field);
        }
        finally {
            doc.removeUndoableEditListener(tempListener);
            doc.addUndoableEditListener(undoManager);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/SwingUndoUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addUndoRedoActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resetUndoRedoActions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setTextWithUndo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

