/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.html;

import com.intellij.util.ui.html.BorderColors;
import com.intellij.util.ui.html.UtilsKt;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.InlineView;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 H\u0016\u00a2\u0006\u0002\u0010\"J \u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020!H\u0016J\b\u0010&\u001a\u00020'H\u0014J\u0018\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001aH\u0016J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u001aH\u0016J\u001a\u0010-\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J \u00100\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0016J(\u00102\u001a\u0002032\u0006\u0010,\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0016J\u0018\u00105\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0018\u00106\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u000bH\u0002J\u0018\u00107\u001a\u00020'2\u0006\u00108\u001a\u0002092\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010:\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u001aH\u0016J$\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\b\u0010=\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001eH\u0002J\"\u0010A\u001a\u0004\u0018\u0001032\u0006\u0010B\u001a\u0002032\u0006\u0010C\u001a\u00020\u001a2\u0006\u0010D\u001a\u00020\u001aH\u0002J\u0010\u0010E\u001a\u00020'2\u0006\u0010F\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00078\u0004@\u0004X\u0085\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0004@\u0004X\u0085\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\rR\u0018\u0010\u0013\u001a\u00020\u00148\u0004@\u0004X\u0085\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\rR\u0018\u0010\u0016\u001a\u00020\u00148\u0004@\u0004X\u0085\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0017\u0010\rR\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/intellij/util/ui/html/InlineViewEx;", "Ljavax/swing/text/html/InlineView;", "elem", "Ljavax/swing/text/Element;", "<init>", "(Ljavax/swing/text/Element;)V", "padding", "Ljava/awt/Insets;", "margin", "insets", "borderRadius", "", "getBorderRadius$annotations", "()V", "borderWidths", "getBorderWidths$annotations", "borderColors", "Lcom/intellij/util/ui/html/BorderColors;", "getBorderColors$annotations", "startView", "", "getStartView$annotations", "endView", "getEndView$annotations", "paintingInTextBounds", "viewToModel", "", "x", "y", "a", "Ljava/awt/Shape;", "biasReturn", "", "Ljavax/swing/text/Position$Bias;", "(FFLjava/awt/Shape;[Ljavax/swing/text/Position$Bias;)I", "modelToView", "pos", "b", "setPropertiesFromAttributes", "", "getPartialSpan", "p0", "p1", "getPreferredSpan", "axis", "getTabbedSpan", "e", "Ljavax/swing/text/TabExpander;", "getBreakWeight", "len", "breakView", "Ljavax/swing/text/View;", "offset", "adjustedBreakPos", "adjustedBreakLen", "paint", "g", "Ljava/awt/Graphics;", "getAlignment", "getToolTipText", "", "allocation", "applyInsets", "Ljava/awt/Rectangle;", "shape", "getSibling", "parentView", "curIndex", "direction", "updatePaddingsAndMargins", "force", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nInlineViewEx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineViewEx.kt\ncom/intellij/util/ui/html/InlineViewEx\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n18#2:235\n1#3:236\n296#4,2:237\n*S KotlinDebug\n*F\n+ 1 InlineViewEx.kt\ncom/intellij/util/ui/html/InlineViewEx\n*L\n154#1:235\n192#1:237,2\n*E\n"})
public final class InlineViewEx
extends InlineView {
    private Insets padding;
    private Insets margin;
    @NotNull
    private Insets insets;
    @JvmField
    protected float borderRadius;
    @JvmField
    @Nullable
    protected Insets borderWidths;
    @JvmField
    @Nullable
    protected BorderColors borderColors;
    @JvmField
    protected boolean startView;
    @JvmField
    protected boolean endView;
    private boolean paintingInTextBounds;

    public InlineViewEx(@NotNull Element elem) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        super(elem);
        this.insets = new Insets(0, 0, 0, 0);
        this.borderRadius = -1.0f;
    }

    protected static /* synthetic */ void getBorderRadius$annotations() {
    }

    protected static /* synthetic */ void getBorderWidths$annotations() {
    }

    protected static /* synthetic */ void getBorderColors$annotations() {
    }

    protected static /* synthetic */ void getStartView$annotations() {
    }

    protected static /* synthetic */ void getEndView$annotations() {
    }

    @Override
    public int viewToModel(float x, float y, @NotNull Shape a, @NotNull Position.Bias[] biasReturn) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)biasReturn, (String)"biasReturn");
        return super.viewToModel(x, y, this.applyInsets(a), biasReturn);
    }

    @Override
    @NotNull
    public Shape modelToView(int pos, @NotNull Shape a, @NotNull Position.Bias b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Shape shape = super.modelToView(pos, a, b);
        if (this.paintingInTextBounds) {
            Intrinsics.checkNotNull((Object)shape);
            return shape;
        }
        Rectangle rect = shape.getBounds();
        rect.x += this.insets.left;
        rect.y += this.insets.top;
        Intrinsics.checkNotNull((Object)rect);
        return rect;
    }

    @Override
    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        this.borderRadius = UtilsKt.getCssBorderRadius(this);
        this.borderWidths = UtilsKt.getCssBorderWidths(this);
        this.borderColors = UtilsKt.getCssBorderColors(this);
        this.updatePaddingsAndMargins(true);
    }

    @Override
    public float getPartialSpan(int p0, int p1) {
        int offset = 0;
        if (p0 == this.getStartOffset() && p0 != p1) {
            offset += this.insets.left;
        }
        if (p1 == this.getEndOffset() && p0 != p1) {
            offset += this.insets.right;
        }
        return (float)offset + super.getPartialSpan(p0, p1);
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updatePaddingsAndMargins(false);
        float f = super.getPreferredSpan(axis);
        return f + (float)(switch (axis) {
            case 0 -> UtilsKt.getWidth(this.insets);
            case 1 -> UtilsKt.getHeight(this.insets);
            default -> throw new IllegalArgumentException("Invalid axis: " + axis);
        });
    }

    @Override
    public float getTabbedSpan(float x, @Nullable TabExpander e) {
        return super.getTabbedSpan(x, e) + (float)UtilsKt.getWidth(this.insets);
    }

    @Override
    public int getBreakWeight(int axis, float pos, float len) {
        return super.getBreakWeight(axis, this.adjustedBreakPos(axis, pos), this.adjustedBreakLen(axis, len));
    }

    @Override
    @NotNull
    public View breakView(int axis, int offset, float pos, float len) {
        View view = super.breakView(axis, offset, this.adjustedBreakPos(axis, pos), this.adjustedBreakLen(axis, len));
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"breakView(...)");
        return view;
    }

    private final float adjustedBreakPos(int axis, float pos) {
        return Math.max(pos - (float)(axis == 0 ? this.insets.left : this.insets.top), 0.0f);
    }

    private final float adjustedBreakLen(int axis, float pos) {
        return Math.max(pos - (float)(axis == 0 ? UtilsKt.getWidth(this.insets) : UtilsKt.getHeight(this.insets)), 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(@NotNull Graphics g, @NotNull Shape a) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Color bg = this.getBackground();
        Rectangle rectangle = (Rectangle)a;
        float f = this.borderRadius;
        Insets insets = this.margin;
        if (insets == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"margin");
            insets = null;
        }
        Insets insets2 = insets;
        Insets insets3 = this.borderWidths;
        BorderColors borderColors = this.borderColors;
        boolean bl = !this.endView;
        boolean bl2 = !this.startView;
        UtilsKt.paintControlBackgroundAndBorder(g, rectangle, bg, f, insets2, insets3, borderColors, bl2, bl);
        try {
            this.setBackground(null);
            this.paintingInTextBounds = true;
            super.paint(g, this.applyInsets(a));
        }
        finally {
            this.paintingInTextBounds = false;
            this.setBackground(bg);
        }
    }

    @Override
    public float getAlignment(int axis) {
        this.checkPainter();
        if (axis == 1) {
            GlyphView.GlyphPainter painter = this.getGlyphPainter();
            boolean sup = this.isSuperscript();
            boolean sub = this.isSubscript();
            float h = painter.getHeight(this);
            float d = painter.getDescent(this);
            float a = painter.getAscent(this);
            float contentsAlign = sup ? 1.0f : (sub ? (h > 0.0f ? (h - (d + a / (float)2)) / h : 0.0f) : (h > 0.0f ? (h - d) / h : 0.0f));
            return ((float)this.insets.top + contentsAlign * h) / ((float)UtilsKt.getHeight(this.insets) + h);
        }
        return super.getAlignment(axis);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public String getToolTipText(float x, float y, @Nullable Shape allocation) {
        Object object;
        Object object2 = this.getElement().getAttributes().getAttribute(HTML.Attribute.TITLE);
        if (object2 != null) {
            String string;
            void $this$asSafely$iv;
            Object object3 = object2;
            boolean $i$f$asSafely = false;
            Object v0 = $this$asSafely$iv;
            if (!(v0 instanceof String)) {
                v0 = null;
            }
            if ((string = (String)v0) != null) {
                String string2;
                String it = string2 = string;
                boolean bl = false;
                Object object4 = object3 = ((CharSequence)it).length() > 0 ? string2 : null;
                if (object3 != null) {
                    object = object3;
                    return object;
                }
            }
        }
        object = super.getToolTipText(x, y, allocation);
        return object;
    }

    private final Rectangle applyInsets(Shape shape) {
        Rectangle result = shape.getBounds();
        result.x += this.insets.left;
        result.y += this.insets.top;
        result.width -= UtilsKt.getWidth(this.insets);
        result.height -= UtilsKt.getHeight(this.insets);
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    private final View getSibling(View parentView, int curIndex, int direction) {
        int siblingIndex = curIndex + direction;
        int viewCount = parentView.getViewCount();
        while (true) {
            View view;
            View view2;
            boolean bl = 0 <= siblingIndex ? siblingIndex < viewCount : false;
            if (!bl) break;
            View it = view2 = parentView.getView(siblingIndex);
            boolean bl2 = false;
            Object object = it.getElement();
            View view3 = view = !(object != null && (object = object.getName()) != null ? StringsKt.equals((String)object, (String)"wbr", (boolean)true) : false) ? view2 : null;
            if (view != null) {
                it = view;
                boolean bl3 = false;
                return it;
            }
            siblingIndex += direction;
        }
        return null;
    }

    private final void updatePaddingsAndMargins(boolean force) {
        View parentView = this.getParent();
        Insets cssPadding = UtilsKt.getCssPadding(this);
        Insets cssMargin = UtilsKt.getCssMargin(this);
        boolean startView = false;
        boolean endView = false;
        if (parentView == null) {
            startView = true;
            endView = true;
        } else {
            Object v0;
            block12: {
                Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)0, (int)parentView.getViewCount());
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    if (!(parentView.getView(it) == this)) continue;
                    v0 = element$iv;
                    break block12;
                }
                v0 = null;
            }
            Integer n = v0;
            int index = n != null ? n : -1;
            View prevSibling = this.getSibling(parentView, index, -1);
            View nextSibling = this.getSibling(parentView, index, 1);
            View view = prevSibling;
            startView = !Intrinsics.areEqual((Object)(view != null ? UtilsKt.getCssPadding(view) : null), (Object)cssPadding) || !Intrinsics.areEqual((Object)UtilsKt.getCssMargin(prevSibling), (Object)cssMargin);
            View view2 = nextSibling;
            boolean bl = endView = !Intrinsics.areEqual((Object)(view2 != null ? UtilsKt.getCssPadding(view2) : null), (Object)cssPadding) || !Intrinsics.areEqual((Object)UtilsKt.getCssMargin(nextSibling), (Object)cssMargin);
        }
        if (!force && startView == this.startView && endView == this.endView) {
            return;
        }
        this.startView = startView;
        this.endView = endView;
        this.padding = new Insets(cssPadding.top, startView ? cssPadding.left : 0, cssPadding.bottom, endView ? cssPadding.right : 0);
        this.margin = new Insets(cssMargin.top, startView ? cssMargin.left : 0, cssMargin.bottom, endView ? cssMargin.right : 0);
        Insets insets = this.padding;
        if (insets == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"padding");
            insets = null;
        }
        int n = insets.top;
        Insets insets2 = this.margin;
        if (insets2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"margin");
            insets2 = null;
        }
        int n2 = n + insets2.top;
        Insets insets3 = this.padding;
        if (insets3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"padding");
            insets3 = null;
        }
        int n3 = insets3.left;
        Insets insets4 = this.margin;
        if (insets4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"margin");
            insets4 = null;
        }
        int n4 = n3 + insets4.left;
        Insets insets5 = this.padding;
        if (insets5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"padding");
            insets5 = null;
        }
        int n5 = insets5.bottom;
        Insets insets6 = this.margin;
        if (insets6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"margin");
            insets6 = null;
        }
        int n6 = n5 + insets6.bottom;
        Insets insets7 = this.padding;
        if (insets7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"padding");
            insets7 = null;
        }
        int n7 = insets7.right;
        Insets insets8 = this.margin;
        if (insets8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"margin");
            insets8 = null;
        }
        this.insets = new Insets(n2, n4, n6, n7 + insets8.right);
    }
}

