/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.ui.BaseChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserIgnoredFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilePathsNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.ChangesViewModelBuilder;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TagChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilderKeys;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.VcsUtil;
import com.intellij.platform.vcs.changes.ChangesUtil;
import com.intellij.platform.vcs.impl.shared.changes.ChangesTreeNodeFactory;
import com.intellij.platform.vcs.impl.shared.changes.TreeModelBuilderEx;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder
implements ChangesViewModelBuilder {
    public static final Key<Function<StaticFilePath, ChangesBrowserNode<?>>> PATH_NODE_BUILDER = Key.create((String)"ChangesTree.PathNodeBuilder");
    public static final NotNullLazyKey<Map<String, ChangesBrowserNode<?>>, ChangesBrowserNode<?>> DIRECTORY_CACHE = TreeModelBuilderKeys.DIRECTORY_CACHE;
    private static final Key<ChangesGroupingPolicy> GROUPING_POLICY = Key.create((String)"ChangesTree.GroupingPolicy");
    @NotNull
    private static final List<Key<?>> TEMP_CACHE_KEYS = Arrays.asList(DIRECTORY_CACHE, TreeModelBuilderKeys.IS_CACHING_ROOT, SimpleChangesGroupingPolicy.GROUP_NODE_CACHE);
    @Nullable
    public final Project myProject;
    @NotNull
    public final DefaultTreeModel myModel;
    @NotNull
    public final ChangesBrowserNode<?> myRoot;
    @NotNull
    private final ChangesGroupingPolicyFactory myGroupingPolicyFactory;
    private static final Comparator<ChangesBrowserNode> BROWSER_NODE_COMPARATOR = (node1, node2) -> {
        Class<?> clazz2;
        int sortWeightDiff = Integer.compare(node1.getSortWeight(), node2.getSortWeight());
        if (sortWeightDiff != 0) {
            return sortWeightDiff;
        }
        Class<?> clazz1 = node1.getClass();
        if (!clazz1.equals(clazz2 = node2.getClass())) {
            return Comparing.compare((Comparable)((Object)clazz1.getName()), (Comparable)((Object)clazz2.getName()));
        }
        if (node1 instanceof Comparable) {
            return ((Comparable)((Object)node1)).compareTo(node2);
        }
        return node1.compareUserObjects(node2.getUserObject());
    };
    public static final Comparator<FilePath> PATH_COMPARATOR = Comparator.comparingInt(path -> path.getPath().length());
    public static final Comparator<Change> CHANGE_COMPARATOR = Comparator.comparing(ChangesUtil::getFilePath, PATH_COMPARATOR);
    public static final Comparator<VirtualFile> FILE_COMPARATOR = VirtualFileHierarchicalComparator.getInstance();

    public TreeModelBuilder(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping) {
        if (grouping == null) {
            TreeModelBuilder.$$$reportNull$$$0(0);
        }
        this.myProject = project != null && !project.isDefault() ? project : null;
        this.myRoot = ChangesBrowserNode.createRoot();
        this.myModel = new ChangesTreeModel(this.myRoot);
        this.myGroupingPolicyFactory = grouping;
    }

    @NotNull
    public static DefaultTreeModel buildEmpty() {
        return new ChangesTreeModel(ChangesBrowserNode.createRoot());
    }

    @NotNull
    public static DefaultTreeModel buildFromChanges(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (grouping == null) {
            TreeModelBuilder.$$$reportNull$$$0(1);
        }
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(2);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, grouping).setChanges(changes, changeNodeDecorator).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(3);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromFilePaths(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping, @NotNull Collection<? extends FilePath> filePaths) {
        if (grouping == null) {
            TreeModelBuilder.$$$reportNull$$$0(4);
        }
        if (filePaths == null) {
            TreeModelBuilder.$$$reportNull$$$0(5);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, grouping).setFilePaths(filePaths).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(6);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping, @NotNull Collection<? extends ChangeList> changeLists) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(7);
        }
        if (grouping == null) {
            TreeModelBuilder.$$$reportNull$$$0(8);
        }
        if (changeLists == null) {
            TreeModelBuilder.$$$reportNull$$$0(9);
        }
        return TreeModelBuilder.buildFromChangeLists(project, grouping, changeLists, false);
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping, @NotNull Collection<? extends ChangeList> changeLists, boolean skipSingleDefaultChangelist) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(10);
        }
        if (grouping == null) {
            TreeModelBuilder.$$$reportNull$$$0(11);
        }
        if (changeLists == null) {
            TreeModelBuilder.$$$reportNull$$$0(12);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, grouping).setChangeLists(changeLists, skipSingleDefaultChangelist, null).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(13);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromVirtualFiles(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (grouping == null) {
            TreeModelBuilder.$$$reportNull$$$0(14);
        }
        if (virtualFiles == null) {
            TreeModelBuilder.$$$reportNull$$$0(15);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, grouping).setVirtualFiles(virtualFiles, null).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(16);
        }
        return defaultTreeModel;
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(17);
        }
        TreeModelBuilder treeModelBuilder = this.setChanges(changes, changeNodeDecorator, null);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(18);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator, @Nullable ChangesBrowserNode.Tag tag) {
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(19);
        }
        this.insertChanges(changes, this.createTagNode(tag), changeNodeDecorator);
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(20);
        }
        return treeModelBuilder;
    }

    @Override
    public void insertChanges(@NotNull Collection<? extends Change> changes, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(21);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(22);
        }
        this.insertChanges(changes, subtreeRoot, null);
    }

    public void insertChanges(@NotNull Collection<? extends Change> changes, @NotNull ChangesBrowserNode<?> subtreeRoot, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(23);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(24);
        }
        for (Change change : ContainerUtil.sorted(changes, CHANGE_COMPARATOR)) {
            this.insertChangeNode(change, subtreeRoot, this.createChangeNode(change, changeNodeDecorator));
        }
    }

    @NotNull
    public TreeModelBuilder setUnversioned(@Nullable List<? extends FilePath> unversionedFiles) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(unversionedFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(25);
            }
            return treeModelBuilder;
        }
        ChangesBrowserUnversionedFilesNode node = new ChangesBrowserUnversionedFilesNode(this.myProject, unversionedFiles);
        return this.insertSpecificFilePathNodeToModel(unversionedFiles, node, FileStatus.UNKNOWN);
    }

    @NotNull
    public TreeModelBuilder setIgnored(@Nullable List<? extends FilePath> ignoredFiles) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(ignoredFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(26);
            }
            return treeModelBuilder;
        }
        ChangesBrowserIgnoredFilesNode node = new ChangesBrowserIgnoredFilesNode(this.myProject, ignoredFiles);
        return this.insertSpecificFilePathNodeToModel(ignoredFiles, node, FileStatus.IGNORED);
    }

    @NotNull
    private TreeModelBuilder insertSpecificFilePathNodeToModel(@NotNull List<? extends FilePath> specificFiles, @NotNull ChangesBrowserSpecificFilePathsNode<?> node, @NotNull FileStatus status) {
        if (specificFiles == null) {
            TreeModelBuilder.$$$reportNull$$$0(27);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(28);
        }
        if (status == null) {
            TreeModelBuilder.$$$reportNull$$$0(29);
        }
        this.insertSubtreeRoot(node);
        if (!node.isManyFiles()) {
            node.markAsHelperNode();
            this.insertLocalFilePathIntoNode(specificFiles, node, status);
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(30);
        }
        return treeModelBuilder;
    }

    @ApiStatus.Internal
    @NotNull
    public TreeModelBuilder insertSpecificFileNodeToModel(@NotNull List<? extends VirtualFile> specificFiles, @NotNull ChangesBrowserSpecificFilesNode<?> node) {
        if (specificFiles == null) {
            TreeModelBuilder.$$$reportNull$$$0(31);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(32);
        }
        this.insertSubtreeRoot(node);
        if (!node.isManyFiles()) {
            node.markAsHelperNode();
            this.insertLocalFileIntoNode(specificFiles, node);
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(33);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setChangeLists(@NotNull Collection<? extends ChangeList> changeLists, boolean skipSingleDefaultChangeList, @Nullable Function<? super ChangeNodeDecorator, ? extends ChangeNodeDecorator> changeDecoratorProvider) {
        if (changeLists == null) {
            TreeModelBuilder.$$$reportNull$$$0(34);
        }
        assert (this.myProject != null);
        TreeModelBuilderEx modelBuilderEx = TreeModelBuilderEx.getInstanceOrNull(this.myProject);
        boolean skipChangeListNode = skipSingleDefaultChangeList && TreeModelBuilder.isSingleBlankChangeList(changeLists);
        Object conflictsRoot = null;
        for (ChangeList changeList : changeLists) {
            ChangesBrowserChangeListNode changesParent;
            List changes = ContainerUtil.sorted((Collection)changeList.getChanges(), CHANGE_COMPARATOR);
            ChangeListRemoteState listRemoteState = new ChangeListRemoteState();
            if (!skipChangeListNode) {
                ChangesBrowserChangeListNode listNode = Objects.requireNonNullElseGet(ChangesTreeNodeFactory.Companion.createChangeListNode(this.myProject, changeList, listRemoteState), () -> new ChangesBrowserChangeListNode(this.myProject, list, listRemoteState));
                listNode.markAsHelperNode();
                this.insertSubtreeRoot((ChangesBrowserNode)listNode);
                changesParent = listNode;
            } else {
                changesParent = this.myRoot;
            }
            for (int i = 0; i < changes.size(); ++i) {
                Change change = (Change)changes.get(i);
                ChangeNodeDecorator baseDecorator = modelBuilderEx != null ? modelBuilderEx.getChangeNodeInChangelistBaseDecorator(listRemoteState, change, i) : null;
                ChangeNodeDecorator decorator = changeDecoratorProvider != null ? changeDecoratorProvider.apply(baseDecorator) : baseDecorator;
                ChangesBrowserNode changeNode = Objects.requireNonNullElseGet(ChangesTreeNodeFactory.Companion.createChangeNode(this.myProject, change, decorator, changesParent), () -> this.createChangeNode(change, decorator));
                this.insertChangeNode(change, changesParent, changeNode);
            }
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(35);
        }
        return treeModelBuilder;
    }

    @ApiStatus.Internal
    public static boolean isSingleBlankChangeList(Collection<? extends ChangeList> lists) {
        if (lists.size() != 1) {
            return false;
        }
        ChangeList single = lists.iterator().next();
        if (!(single instanceof LocalChangeList)) {
            return false;
        }
        return ((LocalChangeList)single).isBlank();
    }

    @NotNull
    public ChangesBrowserNode<?> createChangeNode(@NotNull Change change, @Nullable ChangeNodeDecorator decorator) {
        if (change == null) {
            TreeModelBuilder.$$$reportNull$$$0(36);
        }
        return new ChangesBrowserChangeNode(this.myProject, change, decorator);
    }

    @NotNull
    private TreeModelBuilder setVirtualFiles(@Nullable Collection<? extends VirtualFile> files, @Nullable ChangesBrowserNode.Tag tag) {
        if (ContainerUtil.isEmpty(files)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(37);
            }
            return treeModelBuilder;
        }
        this.insertFilesIntoNode(files, this.createTagNode(tag));
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(38);
        }
        return treeModelBuilder;
    }

    @NotNull
    public ChangesBrowserNode<?> createTagNode(@NotNull @Nls String tag) {
        if (tag == null) {
            TreeModelBuilder.$$$reportNull$$$0(39);
        }
        ChangesBrowserNode<?> changesBrowserNode = this.createTagNode(new ChangesBrowserNode.TagImpl(tag));
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(40);
        }
        return changesBrowserNode;
    }

    @NotNull
    public ChangesBrowserNode<?> createTagNode(@Nullable ChangesBrowserNode.Tag tag) {
        ChangesBrowserNode<?> changesBrowserNode = this.createTagNode(tag, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(41);
        }
        return changesBrowserNode;
    }

    @NotNull
    public ChangesBrowserNode<?> createTagNode(@NotNull @Nls String tag, boolean expandByDefault) {
        if (tag == null) {
            TreeModelBuilder.$$$reportNull$$$0(42);
        }
        ChangesBrowserNode<?> changesBrowserNode = this.createTagNode(tag, SimpleTextAttributes.REGULAR_ATTRIBUTES, expandByDefault);
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(43);
        }
        return changesBrowserNode;
    }

    @NotNull
    public ChangesBrowserNode<?> createTagNode(@NotNull @Nls String tag, @NotNull SimpleTextAttributes attributes, boolean expandByDefault) {
        if (tag == null) {
            TreeModelBuilder.$$$reportNull$$$0(44);
        }
        if (attributes == null) {
            TreeModelBuilder.$$$reportNull$$$0(45);
        }
        ChangesBrowserNode<?> changesBrowserNode = this.createTagNode(new ChangesBrowserNode.TagImpl(tag), attributes, expandByDefault);
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(46);
        }
        return changesBrowserNode;
    }

    @NotNull
    public ChangesBrowserNode<?> createTagNode(@Nullable ChangesBrowserNode.Tag tag, @NotNull SimpleTextAttributes attributes, boolean expandByDefault) {
        if (attributes == null) {
            TreeModelBuilder.$$$reportNull$$$0(47);
        }
        if (tag == null) {
            ChangesBrowserNode<?> changesBrowserNode = this.myRoot;
            if (changesBrowserNode == null) {
                TreeModelBuilder.$$$reportNull$$$0(48);
            }
            return changesBrowserNode;
        }
        TagChangesBrowserNode subtreeRoot = new TagChangesBrowserNode(tag, attributes, expandByDefault);
        ChangesBrowserNode<?> changesBrowserNode = this.insertTagNode(subtreeRoot);
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(49);
        }
        return changesBrowserNode;
    }

    @NotNull
    public ChangesBrowserNode<?> insertTagNode(@NotNull ChangesBrowserNode<?> subtreeRoot) {
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(50);
        }
        subtreeRoot.markAsHelperNode();
        this.insertSubtreeRoot((ChangesBrowserNode)subtreeRoot);
        ChangesBrowserNode<?> changesBrowserNode = subtreeRoot;
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(51);
        }
        return changesBrowserNode;
    }

    @Override
    public void insertFilesIntoNode(@NotNull Collection<? extends VirtualFile> files, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        if (files == null) {
            TreeModelBuilder.$$$reportNull$$$0(52);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(53);
        }
        List sortedFiles = ContainerUtil.sorted(files, FILE_COMPARATOR);
        for (VirtualFile file : sortedFiles) {
            this.insertChangeNode(file, subtreeRoot, ChangesBrowserNode.createFile(this.myProject, file));
        }
    }

    private void insertLocalFilePathIntoNode(@NotNull Collection<? extends FilePath> files, @NotNull ChangesBrowserNode<?> subtreeRoot, @NotNull FileStatus status) {
        if (files == null) {
            TreeModelBuilder.$$$reportNull$$$0(54);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(55);
        }
        if (status == null) {
            TreeModelBuilder.$$$reportNull$$$0(56);
        }
        List sortedFilePaths = ContainerUtil.sorted(files, PATH_COMPARATOR);
        for (FilePath filePath : sortedFilePaths) {
            this.insertChangeNode(filePath, subtreeRoot, ChangesBrowserNode.createFilePath(filePath, status));
        }
    }

    private void insertLocalFileIntoNode(@NotNull Collection<? extends VirtualFile> files, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        if (files == null) {
            TreeModelBuilder.$$$reportNull$$$0(57);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(58);
        }
        List sortedFiles = ContainerUtil.sorted(files, FILE_COMPARATOR);
        for (VirtualFile file : sortedFiles) {
            this.insertChangeNode(file, subtreeRoot, ChangesBrowserNode.createFile(this.myProject, file));
        }
    }

    @NotNull
    public TreeModelBuilder setFilePaths(@NotNull Collection<? extends FilePath> filePaths) {
        if (filePaths == null) {
            TreeModelBuilder.$$$reportNull$$$0(59);
        }
        TreeModelBuilder treeModelBuilder = this.setFilePaths(filePaths, this.myRoot);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(60);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setFilePaths(@NotNull Collection<? extends FilePath> filePaths, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        if (filePaths == null) {
            TreeModelBuilder.$$$reportNull$$$0(61);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(62);
        }
        for (FilePath file : ContainerUtil.sorted(filePaths, PATH_COMPARATOR)) {
            assert (file != null);
            this.insertChangeNode(file, subtreeRoot, ChangesBrowserNode.createFilePath(file));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(63);
        }
        return treeModelBuilder;
    }

    @Override
    @NotNull
    public TreeModelBuilder insertSubtreeRoot(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(64);
        }
        this.insertSubtreeRoot(node, this.myRoot);
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(65);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder insertSubtreeRoot(@NotNull ChangesBrowserNode<?> node, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(66);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(67);
        }
        this.myModel.insertNodeInto(node, subtreeRoot, subtreeRoot.getChildCount());
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(68);
        }
        return treeModelBuilder;
    }

    public void insertChangeNode(@NotNull FilePath nodePath, @NotNull ChangesBrowserNode<?> subtreeRoot, @NotNull ChangesBrowserNode<?> node) {
        if (nodePath == null) {
            TreeModelBuilder.$$$reportNull$$$0(69);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(70);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(71);
        }
        this.insertChangeNode(TreeModelBuilder.staticFrom(nodePath), subtreeRoot, node);
    }

    public void insertChangeNode(@NotNull VirtualFile nodePath, @NotNull ChangesBrowserNode<?> subtreeRoot, @NotNull ChangesBrowserNode<?> node) {
        if (nodePath == null) {
            TreeModelBuilder.$$$reportNull$$$0(72);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(73);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(74);
        }
        this.insertChangeNode(TreeModelBuilder.staticFrom(nodePath), subtreeRoot, node);
    }

    public void insertChangeNode(@NotNull Change nodePath, @NotNull ChangesBrowserNode<?> subtreeRoot, @NotNull ChangesBrowserNode<?> node) {
        if (nodePath == null) {
            TreeModelBuilder.$$$reportNull$$$0(75);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(76);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(77);
        }
        this.insertChangeNode(TreeModelBuilder.staticFrom(nodePath), subtreeRoot, node);
    }

    public void insertChangeNode(@NotNull StaticFilePath pathKey, @NotNull ChangesBrowserNode<?> subtreeRoot, @NotNull ChangesBrowserNode<?> node) {
        if (pathKey == null) {
            TreeModelBuilder.$$$reportNull$$$0(78);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(79);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(80);
        }
        this.insertChangeNode(pathKey, subtreeRoot, node, TreeModelBuilder::createPathNode);
    }

    protected void insertChangeNode(@NotNull StaticFilePath pathKey, @NotNull ChangesBrowserNode<?> subtreeRoot, @NotNull ChangesBrowserNode<?> node, @NotNull Function<StaticFilePath, ChangesBrowserNode<?>> nodeBuilder) {
        if (pathKey == null) {
            TreeModelBuilder.$$$reportNull$$$0(81);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(82);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(83);
        }
        if (nodeBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(84);
        }
        ProgressManager.checkCanceled();
        PATH_NODE_BUILDER.set(subtreeRoot, nodeBuilder);
        if (!GROUPING_POLICY.isIn(subtreeRoot)) {
            NoneChangesGroupingPolicy policy = this.myProject != null ? this.myGroupingPolicyFactory.createGroupingPolicy(this.myProject, this.myModel) : NoneChangesGroupingPolicy.INSTANCE;
            GROUPING_POLICY.set(subtreeRoot, (Object)policy);
        }
        ChangesBrowserNode parentNode = (ChangesBrowserNode)ReadAction.compute(() -> (ChangesBrowserNode)ObjectUtils.notNull(((ChangesGroupingPolicy)GROUPING_POLICY.getRequired((UserDataHolder)subtreeRoot)).getParentNodeFor(pathKey, node, subtreeRoot), (Object)subtreeRoot));
        ChangesBrowserNode<?> cachingRoot = BaseChangesGroupingPolicy.getCachingRoot(parentNode, subtreeRoot);
        this.myModel.insertNodeInto(node, parentNode, this.myModel.getChildCount(parentNode));
        if (pathKey.isDirectory()) {
            ((Map)DIRECTORY_CACHE.getValue(cachingRoot)).put(pathKey.getKey(), node);
        }
    }

    @NotNull
    public DefaultTreeModel build() {
        DefaultTreeModel defaultTreeModel = this.build(false);
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(85);
        }
        return defaultTreeModel;
    }

    @ApiStatus.Experimental
    @NotNull
    public DefaultTreeModel build(boolean forcePrepareCaches) {
        TreeUtil.sort((DefaultTreeModel)this.myModel, BROWSER_NODE_COMPARATOR);
        TreeModelBuilder.collapseDirectories(this.myModel, this.myRoot);
        if (!(this.myProject == null || ApplicationManager.getApplication().isDispatchThread() || TreeUtil.hasManyNodes(this.myRoot, (int)1000) && !forcePrepareCaches)) {
            ReadAction.nonBlocking(() -> TreeModelBuilder.precalculateFileColors(this.myProject, this.myRoot)).executeSynchronously();
        }
        this.myRoot.traverse().forEach(node -> {
            for (Key<?> key : TEMP_CACHE_KEYS) {
                node.putUserData(key, null);
            }
        });
        this.myModel.nodeStructureChanged((TreeNode)this.myModel.getRoot());
        DefaultTreeModel defaultTreeModel = this.myModel;
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(86);
        }
        return defaultTreeModel;
    }

    @RequiresReadLock
    private static void precalculateFileColors(@NotNull Project project, @NotNull ChangesBrowserNode<?> root) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(87);
        }
        if (root == null) {
            TreeModelBuilder.$$$reportNull$$$0(88);
        }
        ThreadingAssertions.softAssertReadAccess();
        root.traverse().forEach(node -> {
            node.cacheBackgroundColor(project);
            ProgressManager.checkCanceled();
        });
    }

    private static void collapseDirectories(@NotNull DefaultTreeModel model, @NotNull ChangesBrowserNode<?> node) {
        ChangesBrowserNode child2;
        ChangesBrowserNode<?> collapsed;
        if (model == null) {
            TreeModelBuilder.$$$reportNull$$$0(89);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(90);
        }
        ChangesBrowserNode<?> collapsedNode = node;
        while (collapsedNode.getChildCount() == 1 && (collapsed = TreeModelBuilder.collapseParentWithOnlyChild(collapsedNode, child2 = (ChangesBrowserNode)collapsedNode.getChildAt(0))) != null) {
            collapsedNode = collapsed;
        }
        if (collapsedNode != node) {
            TreeNode parent = node.getParent();
            int idx = ((DefaultMutableTreeNode)parent).getIndex(node);
            model.removeNodeFromParent(node);
            model.insertNodeInto(collapsedNode, (MutableTreeNode)parent, idx);
            node = collapsedNode;
        }
        node.iterateNodeChildren().forEach(child -> TreeModelBuilder.collapseDirectories(model, child));
    }

    @Nullable
    private static ChangesBrowserNode<?> collapseParentWithOnlyChild(@NotNull ChangesBrowserNode<?> parent, @NotNull ChangesBrowserNode<?> child) {
        if (parent == null) {
            TreeModelBuilder.$$$reportNull$$$0(91);
        }
        if (child == null) {
            TreeModelBuilder.$$$reportNull$$$0(92);
        }
        if (child.isLeaf()) {
            return null;
        }
        Object parentUserObject = parent.getUserObject();
        Object childUserObject = child.getUserObject();
        if (parentUserObject instanceof FilePath && childUserObject instanceof FilePath) {
            TreeModelBuilder.appendCollapsedParent(child, parent);
            return child;
        }
        if (parent instanceof ChangesBrowserNode.NodeWithFilePath) {
            ChangesBrowserNode.NodeWithFilePath parentWithPath = (ChangesBrowserNode.NodeWithFilePath)((Object)parent);
            if (childUserObject instanceof FilePath) {
                FilePath childPath = (FilePath)childUserObject;
                FilePath parentPath = parentWithPath.getNodeFilePath();
                if (!parentPath.equals((Object)childPath)) {
                    return null;
                }
                parent.remove(0);
                List children = child.iterateNodeChildren().toList();
                for (ChangesBrowserNode childNode : children) {
                    parent.add(childNode);
                    TreeModelBuilder.appendCollapsedParent(childNode, child);
                }
                return parent;
            }
        }
        return null;
    }

    private static void appendCollapsedParent(@NotNull ChangesBrowserNode<?> child, ChangesBrowserNode<?> parent) {
        if (child == null) {
            TreeModelBuilder.$$$reportNull$$$0(93);
        }
        if (child instanceof ChangesBrowserNode.NodeWithCollapsedParents) {
            ChangesBrowserNode.NodeWithCollapsedParents childWithCollapsedParents = (ChangesBrowserNode.NodeWithCollapsedParents)((Object)child);
            childWithCollapsedParents.addCollapsedParent(parent);
        }
    }

    @NotNull
    public static StaticFilePath staticFrom(@NotNull FilePath fp) {
        if (fp == null) {
            TreeModelBuilder.$$$reportNull$$$0(94);
        }
        return new StaticFilePath(fp);
    }

    @NotNull
    public static StaticFilePath staticFrom(@NotNull VirtualFile vf) {
        if (vf == null) {
            TreeModelBuilder.$$$reportNull$$$0(95);
        }
        return new StaticFilePath(VcsUtil.getFilePath((VirtualFile)vf));
    }

    @NotNull
    public static StaticFilePath staticFrom(@NotNull Change change) {
        if (change == null) {
            TreeModelBuilder.$$$reportNull$$$0(96);
        }
        return TreeModelBuilder.staticFrom(ChangesUtil.getFilePath((Change)change));
    }

    @NotNull
    public static FilePath getPathForObject(@NotNull Object o) {
        if (o == null) {
            TreeModelBuilder.$$$reportNull$$$0(97);
        }
        if (o instanceof Change) {
            Change change = (Change)o;
            FilePath filePath = ChangesUtil.getFilePath((Change)change);
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(98);
            }
            return filePath;
        }
        if (o instanceof VirtualFile) {
            VirtualFile virtualFile = (VirtualFile)o;
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile);
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(99);
            }
            return filePath;
        }
        if (o instanceof FilePath) {
            FilePath filePath = (FilePath)o;
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(100);
            }
            return filePath;
        }
        if (o instanceof LocallyDeletedChange) {
            LocallyDeletedChange locallyDeletedChange = (LocallyDeletedChange)o;
            FilePath filePath = locallyDeletedChange.getPath();
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(101);
            }
            return filePath;
        }
        throw new IllegalArgumentException("Unknown type - " + String.valueOf(o.getClass()));
    }

    @NotNull
    private static ChangesBrowserNode<?> createPathNode(@NotNull StaticFilePath path) {
        if (path == null) {
            TreeModelBuilder.$$$reportNull$$$0(102);
        }
        ChangesBrowserNode<?> changesBrowserNode = ChangesBrowserNode.createFilePath(path.getFilePath());
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(103);
        }
        return changesBrowserNode;
    }

    public boolean isEmpty() {
        return this.myModel.getChildCount(this.myRoot) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 13, 16, 18, 20, 25, 26, 30, 33, 35, 37, 38, 40, 41, 43, 46, 48, 49, 51, 60, 63, 65, 68, 85, 86, 98, 99, 100, 101, 103 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouping";
                break;
            }
            case 2: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 26: 
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 60: 
            case 63: 
            case 65: 
            case 68: 
            case 85: 
            case 86: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder";
                break;
            }
            case 5: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 7: 
            case 10: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 12: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 22: 
            case 24: 
            case 50: 
            case 53: 
            case 55: 
            case 58: 
            case 62: 
            case 67: 
            case 70: 
            case 73: 
            case 76: 
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtreeRoot";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificFiles";
                break;
            }
            case 28: 
            case 32: 
            case 64: 
            case 66: 
            case 71: 
            case 74: 
            case 77: 
            case 80: 
            case 83: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 29: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 36: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 39: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 52: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 69: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePath";
                break;
            }
            case 78: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathKey";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeBuilder";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fp";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromChanges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromFilePaths";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromChangeLists";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromVirtualFiles";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "setChanges";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "setUnversioned";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "setIgnored";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "insertSpecificFilePathNodeToModel";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "insertSpecificFileNodeToModel";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "setChangeLists";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "setVirtualFiles";
                break;
            }
            case 40: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagNode";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "insertTagNode";
                break;
            }
            case 60: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "setFilePaths";
                break;
            }
            case 65: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "insertSubtreeRoot";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForObject";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildFromChanges";
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 26: 
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 60: 
            case 63: 
            case 65: 
            case 68: 
            case 85: 
            case 86: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildFromFilePaths";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildFromChangeLists";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildFromVirtualFiles";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "insertChanges";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "insertSpecificFilePathNodeToModel";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "insertSpecificFileNodeToModel";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setChangeLists";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createChangeNode";
                break;
            }
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createTagNode";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "insertTagNode";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "insertFilesIntoNode";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "insertLocalFilePathIntoNode";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "insertLocalFileIntoNode";
                break;
            }
            case 59: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setFilePaths";
                break;
            }
            case 64: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "insertSubtreeRoot";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "insertChangeNode";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "precalculateFileColors";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "collapseDirectories";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "collapseParentWithOnlyChild";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "appendCollapsedParent";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "staticFrom";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getPathForObject";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "createPathNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 13, 16, 18, 20, 25, 26, 30, 33, 35, 37, 38, 40, 41, 43, 46, 48, 49, 51, 60, 63, 65, 68, 85, 86, 98, 99, 100, 101, 103 -> new IllegalStateException(string);
        };
    }
}

