/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.services;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.scripting.compiler.plugin.definitions.ScriptRefinedCompilationConfigurationCacheKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.fir.FirScriptCompilationComponent;
import org.jetbrains.kotlin.scripting.compiler.plugin.fir.FirScriptCompilationComponentKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.services.FirScriptDefinitionProviderService;
import org.jetbrains.kotlin.scripting.compiler.plugin.services.FirScriptDefinitionProviderServiceKt;
import org.jetbrains.kotlin.scripting.resolve.RefineCompilationConfigurationKt;

@Metadata(mv={2, 4, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0007"}, d2={"getOrLoadConfiguration", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "file", "Lorg/jetbrains/kotlin/KtSourceFile;", "kotlin-scripting-compiler"})
public final class FirScriptConfigurationExtensionImplKt {
    @Nullable
    public static final ResultWithDiagnostics<ScriptCompilationConfiguration> getOrLoadConfiguration(@NotNull FirSession session, @NotNull KtSourceFile file) {
        ResultWithDiagnostics<ScriptCompilationConfiguration> resultWithDiagnostics;
        ScriptingHostConfiguration hostConfiguration;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SourceCode sourceCode = RefineCompilationConfigurationKt.toSourceCode((KtSourceFile)file);
        FirScriptCompilationComponent firScriptCompilationComponent = FirScriptCompilationComponentKt.getScriptCompilationComponent(session);
        Object object = hostConfiguration = firScriptCompilationComponent != null ? firScriptCompilationComponent.getHostConfiguration() : null;
        if (hostConfiguration != null) {
            resultWithDiagnostics = ScriptRefinedCompilationConfigurationCacheKt.getRefinedOrBaseCompilationConfiguration(hostConfiguration, sourceCode);
        } else {
            FirScriptDefinitionProviderService firScriptDefinitionProviderService = FirScriptDefinitionProviderServiceKt.getScriptDefinitionProviderService(session);
            if (firScriptDefinitionProviderService != null) {
                FirScriptDefinitionProviderService it = firScriptDefinitionProviderService;
                boolean bl = false;
                resultWithDiagnostics = it.getRefinedConfiguration(sourceCode);
                if (resultWithDiagnostics == null) {
                    resultWithDiagnostics = it.getBaseConfiguration(sourceCode);
                }
            } else {
                resultWithDiagnostics = null;
            }
        }
        return resultWithDiagnostics;
    }
}

