/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.JavaErrorFixProvider;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.AllowedApiFilterExtension;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationBundle;
import com.intellij.refactoring.typeMigration.TypeMigrationVariableTypeFixProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertFieldToAtomicIntention
extends BaseElementAtCaretIntentionAction
implements PriorityAction {
    private static final Logger LOG = Logger.getInstance(ConvertFieldToAtomicIntention.class);
    private final Map<PsiType, String> myFromToMap = Map.of(PsiTypes.intType(), AtomicInteger.class.getName(), PsiTypes.longType(), AtomicLong.class.getName(), PsiTypes.booleanType(), AtomicBoolean.class.getName(), PsiTypes.intType().createArrayType(), AtomicIntegerArray.class.getName(), PsiTypes.longType().createArrayType(), AtomicLongArray.class.getName());

    @NotNull
    public String getText() {
        String string = TypeMigrationBundle.message("convert.to.atomic.family.name", new Object[0]);
        if (string == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.LOW;
        if (priority == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(2);
        }
        return priority;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        String modifiedText;
        PsiVariable variable;
        if (project == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(5);
        }
        if ((variable = this.getVariable(this.getElement(editor, psiFile))) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                ConvertFieldToAtomicIntention.$$$reportNull$$$0(6);
            }
            return intentionPreviewInfo;
        }
        PsiType type = variable.getType();
        String toType = this.myFromToMap.get(type);
        String variableName = variable.getName();
        if (toType == null) {
            Class atomicClass;
            if (type instanceof PsiArrayType) {
                PsiArrayType arrayType = (PsiArrayType)type;
                type = arrayType.getComponentType();
                atomicClass = AtomicReferenceArray.class;
            } else {
                atomicClass = AtomicReference.class;
            }
            String presentableText = StringUtil.getShortName((String)atomicClass.getName());
            modifiedText = presentableText + "<" + type.getPresentableText() + "> " + variableName + " = new " + presentableText + "<>(...)";
        } else {
            String presentableText = StringUtil.getShortName((String)toType);
            modifiedText = presentableText + " " + variableName + " = new " + presentableText + "(...)";
        }
        return new IntentionPreviewInfo.CustomDiff((FileType)JavaFileType.INSTANCE, type.getPresentableText() + " " + variableName, modifiedText);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        String qualifiedName;
        PsiVariable psiVariable;
        if (project == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(8);
        }
        if (element == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(9);
        }
        if ((psiVariable = this.getVariable(element)) == null || psiVariable instanceof PsiResourceVariable) {
            return false;
        }
        if (psiVariable.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        if (psiVariable.getTypeElement() == null) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiVariable)) {
            return false;
        }
        PsiType psiType = psiVariable.getType();
        PsiClass psiTypeClass = PsiUtil.resolveClassInType((PsiType)psiType);
        if (psiTypeClass != null ? (qualifiedName = psiTypeClass.getQualifiedName()) != null && (this.myFromToMap.containsValue(qualifiedName) || qualifiedName.equals(AtomicReference.class.getName()) || qualifiedName.equals(AtomicReferenceArray.class.getName())) : !this.myFromToMap.containsKey(psiType)) {
            return false;
        }
        return AllowedApiFilterExtension.isClassAllowed((String)AtomicReference.class.getName(), (PsiElement)element);
    }

    PsiVariable getVariable(PsiElement element) {
        PsiElement parent;
        if (element instanceof PsiIdentifier && ((parent = element.getParent()) instanceof PsiLocalVariable || parent instanceof PsiField)) {
            return (PsiVariable)parent;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiVariable var;
        if (project == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(11);
        }
        if (element == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(12);
        }
        LOG.assertTrue((var = this.getVariable(element)) != null);
        PsiType fromType = var.getType();
        PsiClassType toType = this.getMigrationTargetType(element, fromType);
        if (toType == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{var})) {
            return;
        }
        ConvertFieldToAtomicIntention.addExplicitInitializer(var);
        String toTypeCanonicalText = toType.getCanonicalText();
        TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable(var, (PsiType)toType, editor, false, false);
        ConvertFieldToAtomicIntention.postProcessVariable(var, toTypeCanonicalText);
    }

    static void addExplicitInitializer(@NotNull PsiVariable var) {
        PsiExpression currentInitializer;
        if (var == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(13);
        }
        if ((currentInitializer = var.getInitializer()) != null) {
            return;
        }
        PsiType type = var.getType();
        String initializerText = PsiTypesUtil.getDefaultValueOfType((PsiType)type);
        if (!"null".equals(initializerText)) {
            WriteAction.run(() -> {
                PsiExpression initializer = JavaPsiFacade.getElementFactory((Project)var.getProject()).createExpressionFromText(initializerText, (PsiElement)var);
                var.setInitializer(initializer);
            });
        }
    }

    static void postProcessVariable(@NotNull PsiVariable var, @NotNull String toType) {
        if (var == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(14);
        }
        if (toType == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(15);
        }
        Project project = var.getProject();
        if (var instanceof PsiField || JavaCodeStyleSettings.getInstance((PsiFile)var.getContainingFile()).GENERATE_FINAL_LOCALS) {
            PsiModifierList modifierList = Objects.requireNonNull(var.getModifierList());
            WriteAction.run(() -> {
                if (var.getInitializer() == null) {
                    PsiExpression newInitializer = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("new " + toType + "()", (PsiElement)var);
                    var.setInitializer(newInitializer);
                }
                modifierList.setModifierProperty("final", true);
                modifierList.setModifierProperty("volatile", false);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)var);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)var);
            });
        }
    }

    @Nullable
    private PsiClassType getMigrationTargetType(@NotNull PsiElement element, @NotNull PsiType fromType) {
        if (element == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(16);
        }
        if (fromType == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(17);
        }
        Project project = element.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        GlobalSearchScope scope = element.getResolveScope();
        String atomicQualifiedName = this.myFromToMap.get(fromType);
        if (atomicQualifiedName != null) {
            PsiClass atomicClass = psiFacade.findClass(atomicQualifiedName, scope);
            if (atomicClass == null) {
                return null;
            }
            return factory.createType(atomicClass);
        }
        if (fromType instanceof PsiArrayType) {
            PsiClass atomicReferenceArrayClass = psiFacade.findClass(AtomicReferenceArray.class.getName(), scope);
            if (atomicReferenceArrayClass == null) {
                return null;
            }
            HashMap<PsiTypeParameter, PsiType> substitutor = new HashMap<PsiTypeParameter, PsiType>();
            PsiTypeParameter[] typeParameters = atomicReferenceArrayClass.getTypeParameters();
            if (typeParameters.length == 1) {
                PsiType componentType = ((PsiArrayType)fromType).getComponentType();
                if (componentType instanceof PsiPrimitiveType) {
                    componentType = ((PsiPrimitiveType)componentType).getBoxedType(element);
                }
                substitutor.put(typeParameters[0], componentType);
            }
            return factory.createType(atomicReferenceArrayClass, factory.createSubstitutor(substitutor));
        }
        PsiClass atomicReferenceClass = psiFacade.findClass(AtomicReference.class.getName(), scope);
        if (atomicReferenceClass == null) {
            return null;
        }
        HashMap<PsiTypeParameter, PsiType> substitutor = new HashMap<PsiTypeParameter, PsiType>();
        PsiTypeParameter[] typeParameters = atomicReferenceClass.getTypeParameters();
        if (typeParameters.length == 1) {
            PsiType type = fromType;
            if (type instanceof PsiPrimitiveType) {
                type = ((PsiPrimitiveType)fromType).getBoxedType(element);
            }
            substitutor.put(typeParameters[0], type);
        }
        return factory.createType(atomicReferenceClass, factory.createSubstitutor(substitutor));
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitInitializer";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "postProcessVariable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMigrationTargetType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }

    public static final class ConvertToAtomicFixProvider
    implements JavaErrorFixProvider {
        public void registerFixes(@NotNull JavaCompilationError<?, ?> error, @NotNull @NotNull Consumer<? super @NotNull CommonIntentionAction> sink) {
            if (error == null) {
                ConvertToAtomicFixProvider.$$$reportNull$$$0(0);
            }
            if (sink == null) {
                ConvertToAtomicFixProvider.$$$reportNull$$$0(1);
            }
            error.psiForKind(new JavaErrorKind[]{JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL_LAMBDA}).map(ConvertNonFinalLocalToAtomicFix::new).ifPresent(sink);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "error";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sink";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention$ConvertToAtomicFixProvider";
            objectArray[2] = "registerFixes";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ConvertNonFinalLocalToAtomicFix
    extends ConvertFieldToAtomicIntention
    implements HighPriorityAction {
        private final PsiElement myContext;

        public ConvertNonFinalLocalToAtomicFix(PsiElement context) {
            this.myContext = context;
        }

        @Override
        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = PriorityAction.Priority.HIGH;
            if (priority == null) {
                ConvertNonFinalLocalToAtomicFix.$$$reportNull$$$0(0);
            }
            return priority;
        }

        @Override
        public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
            if (project == null) {
                ConvertNonFinalLocalToAtomicFix.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                ConvertNonFinalLocalToAtomicFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ConvertNonFinalLocalToAtomicFix.$$$reportNull$$$0(3);
            }
            return this.getVariable(element) != null;
        }

        @Override
        PsiVariable getVariable(PsiElement element) {
            PsiElement psiElement = this.myContext;
            if (psiElement instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)psiElement;
                if (this.myContext.isValid() && PsiUtil.isAccessedForWriting((PsiExpression)ref)) {
                    return (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiLocalVariable.class);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention$ConvertNonFinalLocalToAtomicFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention$ConvertNonFinalLocalToAtomicFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

