/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.rules.guava.FluentIterableConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GuavaPredicatesUtil {
    private static final Logger LOG = Logger.getInstance(GuavaPredicatesUtil.class);
    private static final Set<String> PREDICATES_AND_OR = ContainerUtil.newHashSet((Object[])new String[]{"or", "and"});
    private static final String PREDICATES_NOT = "not";
    public static final Set<String> PREDICATES_METHOD_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"alwaysTrue", "alwaysFalse", "isNull", "notNull", "equalTo", "not", "or", "and"});

    GuavaPredicatesUtil() {
    }

    @Nullable
    static TypeConversionDescriptorBase tryConvertIfPredicates(PsiMethod method, PsiExpression context) {
        String name;
        switch (name = method.getName()) {
            case "alwaysTrue": 
            case "alwaysFalse": {
                return GuavaPredicatesUtil.createConstantPredicate(name, name.contains("True"));
            }
            case "isNull": 
            case "notNull": {
                String operation = name.equals("isNull") ? "==" : "!=";
                return new TypeConversionDescriptorWithLocalVariable(name, "$x$ -> $x$" + operation + " null");
            }
            case "equalTo": {
                return new TypeConversionDescriptorWithLocalVariable("equalTo", "$x$ -> java.util.Objects.equals($x$, $v$)");
            }
        }
        if (!GuavaPredicatesUtil.isConvertablePredicatesMethod(method, (PsiMethodCallExpression)context)) {
            return null;
        }
        if (((PsiMethodCallExpression)context).getArgumentList().isEmpty()) {
            return GuavaPredicatesUtil.createConstantPredicate(name, name.equals("and"));
        }
        if (PREDICATES_AND_OR.contains(name) && GuavaPredicatesUtil.canMigrateAndOrOr((PsiMethodCallExpression)context)) {
            return new AndOrOrConversionDescriptor(GuavaConversionUtil.addTypeParameters(GuavaLambda.PREDICATE.getJavaAnalogueClassQName(), context.getType(), (PsiElement)context));
        }
        if (PREDICATES_NOT.equals(name)) {
            return new NotConversionDescriptor(GuavaConversionUtil.addTypeParameters(GuavaLambda.PREDICATE.getJavaAnalogueClassQName(), context.getType(), (PsiElement)context));
        }
        return null;
    }

    @NotNull
    private static TypeConversionDescriptorWithLocalVariable createConstantPredicate(String methodName, boolean value) {
        return new TypeConversionDescriptorWithLocalVariable(methodName, "$x$ -> " + value);
    }

    public static boolean isConvertablePredicatesMethod(@NotNull PsiMethod method, PsiMethodCallExpression context) {
        PsiParameter parameter;
        PsiClass psiClass;
        if (method == null) {
            GuavaPredicatesUtil.$$$reportNull$$$0(0);
        }
        if (method.getParameterList().getParametersCount() == 1 && ((psiClass = PsiTypesUtil.getPsiClass((PsiType)(parameter = method.getParameterList().getParameters()[0]).getType().getDeepComponentType())) == null || "java.lang.Iterable".equals(psiClass.getQualifiedName()))) {
            return false;
        }
        PsiExpression[] expressions = context.getArgumentList().getExpressions();
        return expressions.length != 1 || !(expressions[0].getType() instanceof PsiArrayType);
    }

    private static boolean canMigrateAndOrOr(PsiMethodCallExpression expr) {
        PsiMethod method = expr.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiParameterList parameters = method.getParameterList();
        if (parameters.getParametersCount() != 1) {
            return !parameters.isEmpty();
        }
        PsiParameter parameter = parameters.getParameters()[0];
        PsiType type = parameter.getType();
        return type instanceof PsiEllipsisType;
    }

    private static PsiExpression replaceTypeCast(PsiExpression expression, PsiElement parent) {
        PsiType type;
        PsiClass aClass;
        PsiTypeElement typeElement;
        PsiElement parParent = parent.getParent();
        if (parParent instanceof PsiTypeCastExpression && (typeElement = ((PsiTypeCastExpression)parParent).getCastType()) != null && (aClass = PsiTypesUtil.getPsiClass((PsiType)(type = typeElement.getType()))) != null && GuavaLambda.PREDICATE.getClassQName().equals(aClass.getQualifiedName())) {
            expression = (PsiExpression)parParent.replace((PsiElement)expression);
        }
        return expression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicatesUtil", "isConvertablePredicatesMethod"));
    }

    private static class TypeConversionDescriptorWithLocalVariable
    extends TypeConversionDescriptor {
        private final String myReplaceByStringTemplate;

        TypeConversionDescriptorWithLocalVariable(@NlsSafe String methodName, @NonNls String replaceByString) {
            super("'_Predicates?." + methodName + "(" + (methodName.equals("equalTo") ? "$v$" : "") + ")", null);
            this.myReplaceByStringTemplate = replaceByString;
        }

        @Override
        public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
            if (evaluator == null) {
                TypeConversionDescriptorWithLocalVariable.$$$reportNull$$$0(0);
            }
            String chosenName = FluentIterableConversionUtil.chooseName(expression, TypeConversionDescriptorWithLocalVariable.getIntroducedVariableType(expression));
            this.setReplaceByString(StringUtil.replace((String)this.myReplaceByStringTemplate, (String)"$x$", (String)chosenName));
            return super.replace(expression, evaluator);
        }

        private static PsiType getIntroducedVariableType(PsiExpression expression) {
            PsiType parameter;
            PsiType[] parameters;
            PsiType type = expression.getType();
            if (type instanceof PsiClassType && (parameters = ((PsiClassType)type).getParameters()).length == 1 && (parameter = parameters[0]) instanceof PsiClassType) {
                return parameter;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicatesUtil$TypeConversionDescriptorWithLocalVariable", "replace"));
        }
    }

    private static class AndOrOrConversionDescriptor
    extends TypeConversionDescriptorBase {
        private final PsiType myTargetType;

        AndOrOrConversionDescriptor(PsiType targetType) {
            this.myTargetType = targetType;
        }

        public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
            PsiMethodCallExpression methodCall;
            PsiExpression[] arguments;
            if (evaluator == null) {
                AndOrOrConversionDescriptor.$$$reportNull$$$0(0);
            }
            if ((arguments = (methodCall = (PsiMethodCallExpression)expression).getArgumentList().getExpressions()).length == 1) {
                return (PsiExpression)expression.replace((PsiElement)GuavaConversionUtil.adjustLambdaContainingExpression(arguments[0], true, this.myTargetType, evaluator));
            }
            LOG.assertTrue(arguments.length != 0);
            @NonNls StringBuilder replaceBy = new StringBuilder();
            String methodName = methodCall.getMethodExpression().getReferenceName();
            for (int i = 1; i < arguments.length; ++i) {
                PsiExpression argument = arguments[i];
                replaceBy.append(".").append(methodName).append("(").append(GuavaConversionUtil.adjustLambdaContainingExpression(argument, false, this.myTargetType, evaluator).getText()).append(")");
            }
            replaceBy.insert(0, GuavaConversionUtil.adjustLambdaContainingExpression(arguments[0], true, this.myTargetType, evaluator).getText());
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiMethodReferenceExpression) {
                expression = GuavaPredicatesUtil.replaceTypeCast(expression, parent);
            } else if (!GuavaConversionUtil.isJavaLambda(parent, evaluator)) {
                replaceBy.append("::test");
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
            return (PsiExpression)expression.replace((PsiElement)elementFactory.createExpressionFromText(replaceBy.toString(), (PsiElement)expression));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicatesUtil$AndOrOrConversionDescriptor", "replace"));
        }
    }

    private static class NotConversionDescriptor
    extends TypeConversionDescriptorBase {
        private final PsiType myTargetType;

        NotConversionDescriptor(PsiType targetType) {
            this.myTargetType = targetType;
        }

        public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
            if (evaluator == null) {
                NotConversionDescriptor.$$$reportNull$$$0(0);
            }
            @NonNls String newExpressionString = GuavaConversionUtil.adjustLambdaContainingExpression(((PsiMethodCallExpression)expression).getArgumentList().getExpressions()[0], true, this.myTargetType, evaluator).getText() + ".negate()";
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiMethodReferenceExpression) {
                expression = GuavaPredicatesUtil.replaceTypeCast(expression, parent);
            } else if (!GuavaConversionUtil.isJavaLambda(parent, evaluator)) {
                newExpressionString = newExpressionString + "::test";
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
            PsiExpression convertedExpression = (PsiExpression)expression.replace((PsiElement)elementFactory.createExpressionFromText(newExpressionString, (PsiElement)expression));
            convertedExpression = convertedExpression.getParent() instanceof PsiMethodReferenceExpression ? (PsiExpression)convertedExpression.getParent().replace((PsiElement)convertedExpression) : convertedExpression;
            PsiElement maybeTypeCast = convertedExpression.getParent();
            if (maybeTypeCast instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)maybeTypeCast))) {
                convertedExpression = (PsiExpression)maybeTypeCast.replace((PsiElement)((PsiTypeCastExpression)maybeTypeCast).getOperand());
            }
            return convertedExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicatesUtil$NotConversionDescriptor", "replace"));
        }
    }
}

