/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.AutoPopupControllerHelper;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaParenthesesInsertHandler;
import com.intellij.codeInsight.completion.util.CompletionStyleUtil;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.lookup.EqTailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.ThreeState;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007J0\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0012\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/codeInsight/completion/JavaFrontendCompletionUtil;", "", "<init>", "()V", "insertParentheses", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "overloadsMatter", "", "hasParams", "Lcom/intellij/util/ThreeState;", "forceClosingParenthesis", "isVoidMethod", "insertTail", "tailType", "Lcom/intellij/codeInsight/TailType;", "hasTail", "insertSemicolonAfter", "lambdaExpression", "Lcom/intellij/psi/PsiLambdaExpression;", "insertSemicolon", "parent", "Lcom/intellij/psi/PsiElement;", "intellij.java.frontback.impl"})
public final class JavaFrontendCompletionUtil {
    @NotNull
    public static final JavaFrontendCompletionUtil INSTANCE = new JavaFrontendCompletionUtil();

    private JavaFrontendCompletionUtil() {
    }

    @JvmStatic
    public static final void insertParentheses(@NotNull InsertionContext context, @NotNull LookupElement item, boolean overloadsMatter, @NotNull ThreeState hasParams, boolean forceClosingParenthesis, boolean isVoidMethod) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)hasParams, (String)"hasParams");
        ThreeState hasParams2 = hasParams;
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        char completionChar = context.getCompletionChar();
        PsiFile psiFile = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        TailType tailType = switch (completionChar) {
            case '(' -> TailTypes.noneType();
            case ':' -> TailTypes.conditionalExpressionColonType();
            default -> LookupItem.handleCompletionChar((Editor)context.getEditor(), (LookupElement)item, (char)completionChar);
        };
        boolean hasTail = tailType != TailTypes.noneType() && tailType != TailTypes.unknownType();
        boolean smart = completionChar == '\r';
        switch (completionChar) {
            case ' ': 
            case '(': 
            case ',': 
            case '.': 
            case ':': 
            case ';': {
                context.setAddCompletionChar(false);
            }
        }
        if (hasTail) {
            hasParams2 = ThreeState.NO;
        }
        boolean needRightParenth = forceClosingParenthesis || !smart && (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET || hasParams2 == ThreeState.NO && completionChar != '(');
        context.commitDocument();
        CommonCodeStyleSettings styleSettings = CompletionStyleUtil.getCodeStyleSettings((InsertionContext)context);
        PsiElement elementAt = file.findElementAt(context.getStartOffset());
        if (elementAt == null || !(elementAt.getParent() instanceof PsiMethodReferenceExpression)) {
            ThreeState hasParameters = hasParams2;
            boolean spaceBetweenParentheses = hasParams2 == ThreeState.YES && styleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES || hasParams2 == ThreeState.UNSURE && styleSettings.SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES;
            JavaParenthesesInsertHandler parenthesesInsertHandler = new JavaParenthesesInsertHandler(styleSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES, spaceBetweenParentheses, needRightParenth, styleSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE, hasParameters != ThreeState.NO);
            parenthesesInsertHandler.handleInsert(context, item);
        }
        if (hasParams2 != ThreeState.NO) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            AutoPopupControllerHelper.Companion.getInstance(project).autoPopupParameterInfoAfterCompletion(editor2, overloadsMatter ? null : item);
        }
        if (smart || !needRightParenth || !EditorSettingsExternalizable.getInstance().isInsertParenthesesAutomatically()) {
            return;
        }
        Intrinsics.checkNotNull((Object)tailType);
        if (!INSTANCE.insertTail(context, item, tailType, hasTail, isVoidMethod)) {
            return;
        }
        switch (completionChar) {
            case '.': {
                AutoPopupController.getInstance((Project)file.getProject()).scheduleAutoPopup(context.getEditor());
                break;
            }
            case ',': {
                AutoPopupController.getInstance((Project)file.getProject()).autoPopupParameterInfo(context.getEditor(), null);
            }
        }
    }

    private final boolean insertTail(InsertionContext context, LookupElement item, TailType tailType, boolean hasTail, boolean isVoidMethod) {
        LookupItem lookupItem;
        TailType toInsert = tailType;
        if (toInsert == EqTailType.INSTANCE) {
            TailType tailType2 = TailTypes.unknownType();
            Intrinsics.checkNotNullExpressionValue((Object)tailType2, (String)"unknownType(...)");
            toInsert = tailType2;
        }
        if (((lookupItem = (LookupItem)item.as(LookupItem.CLASS_CONDITION_KEY)) == null || lookupItem.getAttribute(LookupItem.TAIL_TYPE_ATTR) != TailTypes.unknownType()) && !hasTail && isVoidMethod) {
            PsiElement composite;
            PsiElement leaf;
            PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
            if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().beforeLeaf((ElementPattern)PlatformPatterns.psiElement().withText("."))).accepts((Object)context.getFile().findElementAt(context.getTailOffset() - 1))) {
                return false;
            }
            boolean insertAdditionalSemicolon = true;
            PsiElement psiElement = leaf = context.getFile().findElementAt(context.getStartOffset());
            Object object = composite = psiElement != null ? psiElement.getParent() : null;
            if (composite instanceof PsiReferenceExpression) {
                PsiElement parent = ((PsiReferenceExpression)composite).getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    parent = ((PsiMethodCallExpression)parent).getParent();
                }
                if (parent instanceof PsiLambdaExpression && !JavaFrontendCompletionUtil.insertSemicolonAfter((PsiLambdaExpression)parent)) {
                    insertAdditionalSemicolon = false;
                }
                if (parent instanceof PsiExpressionStatement) {
                    PsiElement psiElement2 = ((PsiExpressionStatement)parent).getParent();
                    PsiForStatement psiForStatement = psiElement2 instanceof PsiForStatement ? (PsiForStatement)psiElement2 : null;
                    if ((psiForStatement != null ? psiForStatement.getUpdate() : null) == parent) {
                        insertAdditionalSemicolon = false;
                    }
                }
            }
            if (insertAdditionalSemicolon) {
                TailType tailType3 = TailTypes.semicolonType();
                Intrinsics.checkNotNullExpressionValue((Object)tailType3, (String)"semicolonType(...)");
                toInsert = tailType3;
            }
        }
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        int tailOffset = context.getTailOffset();
        int afterTailOffset = toInsert.processTail(editor2, tailOffset);
        int caretOffset = editor2.getCaretModel().getOffset();
        boolean bl = caretOffset + 1 <= tailOffset ? tailOffset < afterTailOffset : false;
        if (bl && TabOutScopesTracker.getInstance().removeScopeEndingAt(editor2, caretOffset) > 0) {
            TabOutScopesTracker.getInstance().registerEmptyScope(editor2, caretOffset, afterTailOffset);
        }
        return true;
    }

    @JvmStatic
    public static final boolean insertSemicolonAfter(@NotNull PsiLambdaExpression lambdaExpression) {
        Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
        return lambdaExpression.getBody() instanceof PsiCodeBlock || JavaFrontendCompletionUtil.insertSemicolon(lambdaExpression.getParent());
    }

    @JvmStatic
    public static final boolean insertSemicolon(@Nullable PsiElement parent) {
        return !(parent instanceof PsiExpressionList) && !(parent instanceof PsiExpression);
    }
}

