/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class DoWhileConditionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            DoWhileConditionFixer.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement stmt = (PsiDoWhileStatement)psiElement;
            Document doc = editor.getDocument();
            if (stmt.getBody() == null || !(stmt.getBody() instanceof PsiBlockStatement) && stmt.getWhileKeyword() == null) {
                int startOffset = stmt.getTextRange().getStartOffset();
                doc.replaceString(startOffset, startOffset + "do".length(), (CharSequence)"do {} while()");
                return;
            }
            if (stmt.getCondition() == null) {
                if (stmt.getWhileKeyword() == null) {
                    int endOffset = stmt.getTextRange().getEndOffset();
                    doc.insertString(endOffset, (CharSequence)"while()");
                } else if (stmt.getLParenth() == null || stmt.getRParenth() == null) {
                    TextRange whileRange = stmt.getWhileKeyword().getTextRange();
                    doc.replaceString(whileRange.getStartOffset(), whileRange.getEndOffset(), (CharSequence)"while()");
                } else {
                    processor.registerUnresolvedError(stmt.getLParenth().getTextRange().getEndOffset());
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/DoWhileConditionFixer", "apply"));
    }
}

