/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MissingCommaFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        PsiParameterList list;
        int count;
        PsiMethod method;
        if (psiElement == null) {
            MissingCommaFixer.$$$reportNull$$$0(0);
        }
        if (!(psiElement instanceof PsiErrorElement) || !((PsiErrorElement)psiElement).getErrorDescription().equals(JavaPsiBundle.message("expected.comma.or.rparen", new Object[0]))) {
            return;
        }
        PsiElement parent = psiElement.getParent();
        if (!(parent instanceof PsiExpressionList)) {
            return;
        }
        if (!MissingCommaFixer.hasRParenth(psiElement, parent)) {
            return;
        }
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)psiElement);
        if (!(next instanceof PsiExpression)) {
            return;
        }
        PsiElement call = parent.getParent();
        if (call instanceof PsiCall && (method = ((PsiCall)call).resolveMethod()) != null && ((count = (list = method.getParameterList()).getParametersCount()) == 0 || count == 1 && !method.isVarArgs())) {
            return;
        }
        editor.getDocument().insertString(psiElement.getTextOffset(), (CharSequence)",");
    }

    private static boolean hasRParenth(PsiElement psiElement, PsiElement parent) {
        for (PsiElement sibling = parent.getLastChild(); sibling != psiElement; sibling = sibling.getPrevSibling()) {
            if (!PsiUtil.isJavaToken(sibling, JavaTokenType.RPARENTH)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/MissingCommaFixer", "apply"));
    }
}

