/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingLoopBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        PsiJavaToken eltToInsertAfter;
        PsiLoopStatement loopStatement;
        if (psiElement == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(0);
        }
        if ((loopStatement = MissingLoopBodyFixer.getLoopParent(psiElement)) == null) {
            return;
        }
        Document doc = editor.getDocument();
        PsiStatement body = loopStatement.getBody();
        if (body instanceof PsiBlockStatement) {
            return;
        }
        if (body != null && MissingLoopBodyFixer.startLine(doc, body) == MissingLoopBodyFixer.startLine(doc, loopStatement)) {
            return;
        }
        if (loopStatement instanceof PsiWhileStatement) {
            PsiWhileStatement psiWhileStatement = (PsiWhileStatement)loopStatement;
            eltToInsertAfter = psiWhileStatement.getRParenth();
        } else if (loopStatement instanceof PsiForStatement) {
            PsiForStatement psiForStatement = (PsiForStatement)loopStatement;
            eltToInsertAfter = psiForStatement.getRParenth();
        } else if (loopStatement instanceof PsiForeachStatement) {
            PsiForeachStatement psiForeachStatement = (PsiForeachStatement)loopStatement;
            eltToInsertAfter = psiForeachStatement.getRParenth();
        } else {
            return;
        }
        MissingLoopBodyFixer.fixLoopBody(editor, processor, loopStatement, doc, body, eltToInsertAfter);
    }

    @Nullable
    private static PsiLoopStatement getLoopParent(@NotNull PsiElement element) {
        PsiLoopStatement statement;
        if (element == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(1);
        }
        if ((statement = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class)) == null) {
            return null;
        }
        if (statement instanceof PsiForeachStatement) {
            return MissingLoopBodyFixer.isForEachApplicable((PsiForeachStatement)statement, element) ? statement : null;
        }
        if (statement instanceof PsiForStatement) {
            return MissingLoopBodyFixer.isForApplicable((PsiForStatement)statement, element) ? statement : null;
        }
        if (statement instanceof PsiWhileStatement) {
            return statement;
        }
        return null;
    }

    private static boolean isForApplicable(PsiForStatement statement, PsiElement psiElement) {
        PsiStatement init = statement.getInitialization();
        PsiStatement update = statement.getUpdate();
        PsiExpression check = statement.getCondition();
        return MissingLoopBodyFixer.isValidChild(init, psiElement) || MissingLoopBodyFixer.isValidChild(update, psiElement) || MissingLoopBodyFixer.isValidChild(check, psiElement);
    }

    private static boolean isValidChild(PsiElement ancestor, PsiElement psiElement) {
        if (ancestor != null && PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)psiElement, (boolean)false)) {
            return !PsiTreeUtil.hasErrorElements((PsiElement)ancestor);
        }
        return false;
    }

    private static boolean isForEachApplicable(PsiForeachStatement statement, PsiElement psiElement) {
        PsiExpression iterated = statement.getIteratedValue();
        PsiParameter parameter = statement.getIterationParameter();
        return PsiTreeUtil.isAncestor((PsiElement)iterated, (PsiElement)psiElement, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)parameter, (PsiElement)psiElement, (boolean)false);
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }

    private static void fixLoopBody(@NotNull Editor editor, @NotNull JavaSmartEnterProcessor processor, @NotNull PsiLoopStatement loop, @NotNull Document doc, @Nullable PsiStatement body, @Nullable PsiElement eltToInsertAfter) {
        if (editor == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(3);
        }
        if (loop == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(4);
        }
        if (doc == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(5);
        }
        if (body != null && eltToInsertAfter != null && MissingLoopBodyFixer.bodyIsIndented(loop, body)) {
            int endOffset = body.getTextRange().getEndOffset();
            doc.insertString(endOffset, (CharSequence)"\n}");
            int offset = eltToInsertAfter.getTextRange().getEndOffset();
            doc.insertString(offset, (CharSequence)"{");
            editor.getCaretModel().moveToOffset(endOffset + "{".length());
            processor.setSkipEnter(true);
            processor.reformat(loop);
            return;
        }
        boolean needToClose = false;
        if (eltToInsertAfter == null) {
            eltToInsertAfter = loop;
            needToClose = true;
        }
        int offset = eltToInsertAfter.getTextRange().getEndOffset();
        if (needToClose) {
            if (MissingLoopBodyFixer.getLParenth(loop) == null) {
                doc.insertString(offset, (CharSequence)"()");
                offset += 2;
            } else {
                doc.insertString(offset, (CharSequence)")");
                ++offset;
            }
        }
        doc.insertString(offset, (CharSequence)"{}");
        editor.getCaretModel().moveToOffset(offset);
    }

    private static boolean bodyIsIndented(@NotNull PsiElement loop, @NotNull PsiElement body) {
        PsiWhiteSpace beforeBody;
        if (loop == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(6);
        }
        if (body == null) {
            MissingLoopBodyFixer.$$$reportNull$$$0(7);
        }
        if ((beforeBody = (PsiWhiteSpace)ObjectUtils.tryCast((Object)body.getPrevSibling(), PsiWhiteSpace.class)) == null) {
            return false;
        }
        PsiWhiteSpace beforeLoop = (PsiWhiteSpace)ObjectUtils.tryCast((Object)loop.getPrevSibling(), PsiWhiteSpace.class);
        if (beforeLoop == null) {
            return false;
        }
        String beforeBodyText = beforeBody.getText();
        String beforeLoopText = beforeLoop.getText();
        int beforeBodyLineBreak = beforeBodyText.lastIndexOf(10);
        if (beforeBodyLineBreak == -1) {
            return false;
        }
        int beforeLoopLineBreak = beforeLoopText.lastIndexOf(10);
        if (beforeLoopLineBreak == -1) {
            return false;
        }
        return beforeBodyText.length() - beforeBodyLineBreak > beforeLoopText.length() - beforeLoopLineBreak;
    }

    private static PsiElement getLParenth(@Nullable PsiElement loopStatement) {
        if (loopStatement instanceof PsiWhileStatement) {
            PsiWhileStatement psiWhileStatement = (PsiWhileStatement)loopStatement;
            return psiWhileStatement.getLParenth();
        }
        if (loopStatement instanceof PsiForStatement) {
            PsiForStatement psiForStatement = (PsiForStatement)loopStatement;
            return psiForStatement.getLParenth();
        }
        if (loopStatement instanceof PsiForeachStatement) {
            PsiForeachStatement psiForeachStatement = (PsiForeachStatement)loopStatement;
            return psiForeachStatement.getLParenth();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loop";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/MissingLoopBodyFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLoopParent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fixLoopBody";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "bodyIsIndented";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

