/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.IncompleteDependenciesService;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IncompleteModelUtil {
    public static boolean isHierarchyResolved(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            IncompleteModelUtil.$$$reportNull$$$0(0);
        }
        HashSet<PsiClass> processed = new HashSet<PsiClass>();
        ArrayDeque<PsiClass> stack = new ArrayDeque<PsiClass>();
        stack.push(psiClass);
        while (!stack.isEmpty()) {
            PsiClass currentClass = (PsiClass)stack.pop();
            if (!processed.add(currentClass)) continue;
            for (PsiClassType type : currentClass.getSuperTypes()) {
                PsiClass resolved = type.resolve();
                if (resolved == null) {
                    return false;
                }
                stack.push(resolved);
            }
        }
        return true;
    }

    @Contract(value="null -> false")
    public static boolean isUnresolvedClassType(@Nullable PsiType psiType) {
        ArrayDeque<PsiType> stack = new ArrayDeque<PsiType>();
        if (psiType != null) {
            stack.push(psiType);
        }
        while (!stack.isEmpty()) {
            PsiClass resolved;
            PsiType currentType = (PsiType)stack.pop();
            if (currentType instanceof PsiLambdaParameterType) {
                return true;
            }
            if (currentType instanceof PsiIntersectionType) {
                Collections.addAll(stack, ((PsiIntersectionType)currentType).getConjuncts());
            }
            if (currentType instanceof PsiDisjunctionType) {
                stack.addAll(((PsiDisjunctionType)currentType).getDisjunctions());
            }
            if (!(currentType instanceof PsiClassType) || (resolved = ((PsiClassType)currentType).resolve()) != null && IncompleteModelUtil.isHierarchyResolved(resolved)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean hasUnresolvedComponent(@Nullable PsiType psiType) {
        return IncompleteModelUtil.hasUnresolvedComponentRecursively(psiType, new HashSet<PsiClass>());
    }

    private static boolean hasUnresolvedComponentRecursively(@Nullable PsiType psiType, @NotNull HashSet<PsiClass> visited) {
        if (visited == null) {
            IncompleteModelUtil.$$$reportNull$$$0(1);
        }
        if (psiType == null) {
            return false;
        }
        PsiType type = psiType.getDeepComponentType();
        if (IncompleteModelUtil.isUnresolvedClassType(psiType)) {
            return true;
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type);
            if (psiClass != null && !visited.add(psiClass)) {
                return false;
            }
            for (PsiType parameter : ((PsiClassType)type).getParameters()) {
                if (!IncompleteModelUtil.hasUnresolvedComponentRecursively(parameter, visited)) continue;
                return true;
            }
        }
        if (type instanceof PsiWildcardType) {
            return IncompleteModelUtil.hasUnresolvedComponentRecursively(((PsiWildcardType)type).getBound(), visited);
        }
        if (type instanceof PsiCapturedWildcardType) {
            return IncompleteModelUtil.hasUnresolvedComponentRecursively(((PsiCapturedWildcardType)type).getLowerBound(), visited) || IncompleteModelUtil.hasUnresolvedComponentRecursively(((PsiCapturedWildcardType)type).getUpperBound(), visited);
        }
        return false;
    }

    public static boolean isIncompleteModel(@NotNull PsiElement context) {
        if (context == null) {
            IncompleteModelUtil.$$$reportNull$$$0(2);
        }
        return !((IncompleteDependenciesService)context.getProject().getService(IncompleteDependenciesService.class)).getState().isComplete();
    }

    public static boolean isPotentiallyConvertible(@Nullable PsiType targetType, @NotNull PsiExpression expression) {
        if (expression == null) {
            IncompleteModelUtil.$$$reportNull$$$0(3);
        }
        PsiType rightType = expression.getType();
        return IncompleteModelUtil.isPotentiallyConvertible(targetType, expression, rightType, expression);
    }

    public static boolean isPotentiallyConvertible(@Nullable PsiType leftType, @NotNull PsiType rightType, @NotNull PsiElement context) {
        if (rightType == null) {
            IncompleteModelUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            IncompleteModelUtil.$$$reportNull$$$0(5);
        }
        return IncompleteModelUtil.isPotentiallyConvertible(leftType, null, rightType, context);
    }

    private static boolean isPotentiallyConvertible(@Nullable PsiType leftType, @Nullable PsiExpression rightExpr, @Nullable PsiType rightType, @NotNull PsiElement context) {
        boolean pendingRight;
        boolean pendingLeft;
        if (context == null) {
            IncompleteModelUtil.$$$reportNull$$$0(6);
        }
        if (leftType instanceof PsiLambdaParameterType || rightType instanceof PsiLambdaParameterType) {
            return true;
        }
        boolean bl = pendingLeft = leftType == null || IncompleteModelUtil.hasUnresolvedComponent(leftType);
        boolean bl2 = rightType == null || (rightExpr == null ? IncompleteModelUtil.hasUnresolvedComponent(rightType) : IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference(rightExpr)) ? true : (pendingRight = false);
        if (pendingLeft && pendingRight) {
            return true;
        }
        if (!pendingLeft && !pendingRight) {
            return leftType.isConvertibleFrom(rightType);
        }
        if (pendingLeft && IncompleteModelUtil.isStrictlyInconvertible(leftType, rightType, context)) {
            return false;
        }
        return !pendingRight || !IncompleteModelUtil.isStrictlyInconvertible(rightType, leftType, context);
    }

    private static boolean isStrictlyInconvertible(@Nullable PsiType pendingType, @Nullable PsiType resolvedType, @NotNull PsiElement context) {
        if (context == null) {
            IncompleteModelUtil.$$$reportNull$$$0(7);
        }
        if (pendingType != null) {
            if (resolvedType instanceof PsiPrimitiveType && ((PsiPrimitiveType)resolvedType).getBoxedType(context) != null) {
                return true;
            }
            PsiClass rightTypeClass = PsiUtil.resolveClassInClassTypeOnly(resolvedType);
            if (rightTypeClass != null && rightTypeClass.hasModifierProperty("final") && rightTypeClass.getTypeParameters().length == 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean mayHaveUnknownTypeDueToPendingReference(@NotNull PsiExpression expression) {
        PsiType type;
        if (expression == null) {
            IncompleteModelUtil.$$$reportNull$$$0(8);
        }
        if ((type = expression.getType()) != null && !(type instanceof PsiMethodReferenceType)) {
            return IncompleteModelUtil.hasUnresolvedComponent(type);
        }
        if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiMethodCallExpression && IncompleteModelUtil.canBePendingReference(((PsiMethodCallExpression)expression).getMethodExpression())) {
            return true;
        }
        if (expression instanceof PsiReferenceExpression && IncompleteModelUtil.canBePendingReference((PsiReferenceExpression)expression)) {
            return true;
        }
        if (expression instanceof PsiArrayAccessExpression) {
            return IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference(((PsiArrayAccessExpression)expression).getArrayExpression());
        }
        return false;
    }

    private static boolean mayHaveNullTypeDueToPendingReference(@NotNull PsiExpression expression) {
        if (expression == null) {
            IncompleteModelUtil.$$$reportNull$$$0(9);
        }
        if (!(expression instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement target = ((PsiReferenceExpression)expression).resolve();
        if (!(target instanceof PsiLocalVariable)) {
            return false;
        }
        PsiLocalVariable local = (PsiLocalVariable)target;
        if (!local.getTypeElement().isInferredType()) {
            return false;
        }
        PsiExpression initializer = local.getInitializer();
        if (initializer == null) {
            return false;
        }
        PsiType initializerType = initializer.getType();
        return initializerType == null && IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference(initializer) || PsiTypes.nullType().equals(initializerType) && IncompleteModelUtil.mayHaveNullTypeDueToPendingReference(initializer);
    }

    @NotNull
    public static List<PsiImportStatementBase> getPotentialImports(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            IncompleteModelUtil.$$$reportNull$$$0(10);
        }
        return IncompleteModelUtil.getPotentialImports(ref, true);
    }

    @NotNull
    public static List<PsiImportStatementBase> getPotentialImports(@NotNull PsiJavaCodeReferenceElement ref, boolean ignoreResolvableStaticImports) {
        PsiElement parent;
        if (ref == null) {
            IncompleteModelUtil.$$$reportNull$$$0(11);
        }
        if ((parent = ref.getParent()) instanceof PsiImportStatementBase || ref.isQualified()) {
            List<PsiImportStatementBase> list = Collections.emptyList();
            if (list == null) {
                IncompleteModelUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        boolean maybeClass = IncompleteModelUtil.canBeClassReference(ref);
        if (!(ref.getContainingFile() instanceof PsiJavaFile)) {
            List<PsiImportStatementBase> list = Collections.emptyList();
            if (list == null) {
                IncompleteModelUtil.$$$reportNull$$$0(13);
            }
            return list;
        }
        PsiImportList list = ((PsiJavaFile)ref.getContainingFile()).getImportList();
        ArrayList<PsiImportStatementBase> imports = new ArrayList<PsiImportStatementBase>();
        if (list != null) {
            for (PsiImportStatementBase statement : list.getAllImportStatements()) {
                String name;
                PsiJavaCodeReferenceElement reference;
                if (statement instanceof PsiImportStaticStatement && ((PsiImportStaticStatement)statement).resolveTargetClass() != null && ignoreResolvableStaticImports || !statement.isOnDemand() && ((reference = statement.getImportReference()) == null || (name = reference.getReferenceName()) == null || !name.equals(ref.getReferenceName()) || reference.resolve() != null) || !maybeClass && !(statement instanceof PsiImportStaticStatement)) continue;
                imports.add(statement);
            }
        }
        ArrayList<PsiImportStatementBase> arrayList = imports;
        if (arrayList == null) {
            IncompleteModelUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public static boolean canBeClassReference(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent;
        if (ref == null) {
            IncompleteModelUtil.$$$reportNull$$$0(15);
        }
        if ((parent = ref.getParent()) instanceof PsiMethodCallExpression) {
            return false;
        }
        if (!(ref instanceof PsiReferenceExpression)) {
            return true;
        }
        return parent instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).getQualifierExpression() == ref;
    }

    public static boolean canBePendingReference(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            IncompleteModelUtil.$$$reportNull$$$0(16);
        }
        if (ref instanceof PsiReferenceExpression) {
            PsiType qualifierType;
            PsiExpression qualifier = ((PsiReferenceExpression)ref).getQualifierExpression();
            if (qualifier == null) {
                PsiClass psiClass = PsiUtil.getContainingClass((PsiElement)ref);
                while (psiClass != null) {
                    if (!IncompleteModelUtil.isHierarchyResolved(psiClass)) {
                        return true;
                    }
                    psiClass = PsiUtil.getContainingClass(psiClass);
                }
                return !IncompleteModelUtil.getPotentialImports(ref).isEmpty();
            }
            if (qualifier instanceof PsiReferenceExpression) {
                PsiElement qualifierTarget = ((PsiReferenceExpression)qualifier).resolve();
                if (qualifierTarget == null && IncompleteModelUtil.canBePendingReference((PsiReferenceExpression)qualifier)) {
                    return true;
                }
                if (qualifierTarget instanceof PsiClass && IncompleteModelUtil.isHierarchyResolved((PsiClass)qualifierTarget)) {
                    return false;
                }
            }
            return IncompleteModelUtil.isUnresolvedClassType(qualifierType = qualifier.getType()) || qualifierType == null && IncompleteModelUtil.mayHaveUnknownTypeDueToPendingReference(qualifier) || PsiTypes.nullType().equals(qualifierType) && IncompleteModelUtil.mayHaveNullTypeDueToPendingReference(qualifier);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightType";
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/IncompleteModelUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/IncompleteModelUtil";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPotentialImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isHierarchyResolved";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedComponentRecursively";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isIncompleteModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPotentiallyConvertible";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isStrictlyInconvertible";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveUnknownTypeDueToPendingReference";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveNullTypeDueToPendingReference";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPotentialImports";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canBeClassReference";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canBePendingReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

