/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TypeNullability;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.ImplicitlyImportedElement;
import com.intellij.psi.ImplicitlyImportedModule;
import com.intellij.psi.ImplicitlyImportedStaticMember;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.ThreadLocalTypes;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PsiImplUtil {
    private static final Logger LOG = Logger.getInstance(PsiImplUtil.class);
    private static final String JAVA_IO_IO = "java.io.IO";
    private static final String JAVA_BASE = "java.base";
    private static final Key<Boolean> TYPE_ANNO_MARK = Key.create((String)"type.annotation.mark");

    private PsiImplUtil() {
    }

    public static PsiMethod @NotNull [] getConstructors(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiImplUtil.$$$reportNull$$$0(0);
        }
        if (aClass instanceof PsiAnonymousClass) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(1);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        List result = null;
        for (PsiMethod method : aClass.getMethods()) {
            if (!method.isConstructor()) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add(method);
        }
        PsiMethod[] psiMethodArray = result == null ? PsiMethod.EMPTY_ARRAY : result.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            PsiImplUtil.$$$reportNull$$$0(2);
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiAnnotationMemberValue findDeclaredAttributeValue(@NotNull PsiAnnotation annotation, @NonNls @Nullable String attributeName) {
        PsiNameValuePair attribute;
        if (annotation == null) {
            PsiImplUtil.$$$reportNull$$$0(3);
        }
        return (attribute = AnnotationUtil.findDeclaredAttribute(annotation, attributeName)) == null ? null : attribute.getValue();
    }

    @Nullable
    public static PsiAnnotationMemberValue findAttributeValue(@NotNull PsiAnnotation annotation, @Nullable @NonNls String attributeName) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            PsiImplUtil.$$$reportNull$$$0(4);
        }
        if ((value = PsiImplUtil.findDeclaredAttributeValue(annotation, attributeName)) != null) {
            return value;
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        if ((referenceElement = annotation.getNameReferenceElement()) != null && (resolved = referenceElement.resolve()) != null) {
            return PsiImplUtil.findAttributeValue((PsiClass)resolved, attributeName);
        }
        return null;
    }

    @Nullable
    public static PsiAnnotationMemberValue findAttributeValue(@NotNull PsiClass annotationClass, @Nullable @NonNls String attributeName) {
        PsiMethod[] methods;
        if (annotationClass == null) {
            PsiImplUtil.$$$reportNull$$$0(5);
        }
        for (PsiMethod method : methods = annotationClass.findMethodsByName(attributeName, false)) {
            if (!PsiUtil.isAnnotationMethod(method)) continue;
            return ((PsiAnnotationMethod)method).getDefaultValue();
        }
        return null;
    }

    public static PsiTypeParameter @NotNull [] getTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        PsiTypeParameterList typeParameterList;
        if (owner == null) {
            PsiImplUtil.$$$reportNull$$$0(6);
        }
        if ((typeParameterList = owner.getTypeParameterList()) != null) {
            PsiTypeParameter[] psiTypeParameterArray = typeParameterList.getTypeParameters();
            if (psiTypeParameterArray == null) {
                PsiImplUtil.$$$reportNull$$$0(7);
            }
            return psiTypeParameterArray;
        }
        if (PsiTypeParameter.EMPTY_ARRAY == null) {
            PsiImplUtil.$$$reportNull$$$0(8);
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    public static PsiJavaCodeReferenceElement @NotNull [] namesToPackageReferences(@NotNull PsiManager manager, String @NotNull [] names) {
        if (manager == null) {
            PsiImplUtil.$$$reportNull$$$0(9);
        }
        if (names == null) {
            PsiImplUtil.$$$reportNull$$$0(10);
        }
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                refs[i] = JavaPsiFacade.getElementFactory(manager.getProject()).createPackageReferenceElement(name);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (refs == null) {
            PsiImplUtil.$$$reportNull$$$0(11);
        }
        return refs;
    }

    public static int getParameterIndex(@NotNull PsiParameter parameter, @NotNull PsiParameterList parameterList) {
        if (parameter == null) {
            PsiImplUtil.$$$reportNull$$$0(12);
        }
        if (parameterList == null) {
            PsiImplUtil.$$$reportNull$$$0(13);
        }
        PsiElement parameterParent = parameter.getParent();
        assert (parameterParent == parameterList) : parameterList + "; " + parameterParent;
        Object[] parameters = parameterList.getParameters();
        int i = ArrayUtil.indexOf((Object[])parameters, (Object)parameter);
        if (i != -1) {
            return i;
        }
        String name = parameter.getName();
        Object suspect = null;
        for (i = parameters.length - 1; i >= 0; --i) {
            Object paramInList = parameters[i];
            if (!Objects.equals(name, paramInList.getName())) continue;
            suspect = paramInList;
            break;
        }
        String message = parameter + ":" + parameter.getClass() + " not found among parameters: " + Arrays.asList(parameters) + ". parameterList' parent: " + parameterList.getParent() + "; parameter.isValid()=" + parameter.isValid() + "; parameterList.isValid()= " + parameterList.isValid() + "; parameterList stub: " + (parameterList instanceof StubBasedPsiElement ? ((StubBasedPsiElement)parameterList).getStub() : "---") + ";  parameter stub: " + (parameter instanceof StubBasedPsiElement ? ((StubBasedPsiElement)parameter).getStub() : "---") + "; suspect: " + suspect + " (index=" + i + "); " + (suspect == null ? null : suspect.getClass()) + " suspect stub: " + (suspect instanceof StubBasedPsiElement ? ((StubBasedPsiElement)suspect).getStub() : (suspect == null ? "-null-" : "---" + suspect.getClass())) + "; parameter.equals(suspect) = " + parameter.equals(suspect) + ";  parameter.getNode() == suspect.getNode():  " + (parameter.getNode() == (suspect == null ? null : suspect.getNode())) + "; .";
        LOG.error(message);
        return i;
    }

    public static int getTypeParameterIndex(@NotNull PsiTypeParameter typeParameter, @NotNull PsiTypeParameterList typeParameterList) {
        if (typeParameter == null) {
            PsiImplUtil.$$$reportNull$$$0(14);
        }
        if (typeParameterList == null) {
            PsiImplUtil.$$$reportNull$$$0(15);
        }
        PsiTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!typeParameter.equals(typeParameters[i])) continue;
            return i;
        }
        LOG.error(typeParameter + " in " + typeParameterList);
        return -1;
    }

    public static Object @NotNull [] getReferenceVariantsByFilter(@NotNull PsiJavaCodeReferenceElement reference, @NotNull ElementFilter filter) {
        if (reference == null) {
            PsiImplUtil.$$$reportNull$$$0(16);
        }
        if (filter == null) {
            PsiImplUtil.$$$reportNull$$$0(17);
        }
        FilterScopeProcessor processor = new FilterScopeProcessor(filter);
        PsiScopesUtil.resolveAndWalk(processor, reference, null, true);
        Object[] objectArray = processor.getResults().toArray();
        if (objectArray == null) {
            PsiImplUtil.$$$reportNull$$$0(18);
        }
        return objectArray;
    }

    public static boolean processDeclarationsInMethod(@NotNull PsiMethod method, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (method == null) {
            PsiImplUtil.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            PsiImplUtil.$$$reportNull$$$0(20);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(21);
        }
        if (place == null) {
            PsiImplUtil.$$$reportNull$$$0(22);
        }
        if (lastParent instanceof DummyHolder) {
            lastParent = lastParent.getFirstChild();
        }
        boolean fromBody = lastParent instanceof PsiCodeBlock;
        PsiTypeParameterList typeParameterList = method.getTypeParameterList();
        return PsiImplUtil.processDeclarationsInMethodLike(method, processor, state, place, fromBody, typeParameterList);
    }

    public static boolean processDeclarationsInLambda(@NotNull PsiLambdaExpression lambda, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiElement firstChild;
        if (lambda == null) {
            PsiImplUtil.$$$reportNull$$$0(23);
        }
        if (processor == null) {
            PsiImplUtil.$$$reportNull$$$0(24);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(25);
        }
        if (place == null) {
            PsiImplUtil.$$$reportNull$$$0(26);
        }
        boolean fromBody = lastParent instanceof DummyHolder ? (firstChild = lastParent.getFirstChild()) instanceof PsiExpression || firstChild instanceof PsiCodeBlock : lastParent != null && lastParent == lambda.getBody();
        return PsiImplUtil.processDeclarationsInMethodLike(lambda, processor, state, place, fromBody, null);
    }

    private static boolean processDeclarationsInMethodLike(@NotNull PsiParameterListOwner element, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, boolean fromBody, @Nullable PsiTypeParameterList typeParameterList) {
        ElementClassHint hint;
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(27);
        }
        if (processor == null) {
            PsiImplUtil.$$$reportNull$$$0(28);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(29);
        }
        if (place == null) {
            PsiImplUtil.$$$reportNull$$$0(30);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)element);
        if (typeParameterList != null && ((hint = (ElementClassHint)processor.getHint(ElementClassHint.KEY)) == null || hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && !typeParameterList.processDeclarations(processor, state, null, place)) {
            return false;
        }
        if (fromBody) {
            PsiParameter[] parameters;
            for (PsiParameter parameter : parameters = element.getParameterList().getParameters()) {
                if (parameter.isUnnamed() && !Boolean.TRUE.equals(processor.getHint(ElementClassHint.PROCESS_UNNAMED_VARIABLES)) || processor.execute((PsiElement)parameter, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processDeclarationsInResourceList(@NotNull PsiResourceList resourceList, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent) {
        PsiResourceListElement resource;
        ElementClassHint hint;
        if (resourceList == null) {
            PsiImplUtil.$$$reportNull$$$0(31);
        }
        if (processor == null) {
            PsiImplUtil.$$$reportNull$$$0(32);
        }
        if (state == null) {
            PsiImplUtil.$$$reportNull$$$0(33);
        }
        if ((hint = (ElementClassHint)processor.getHint(ElementClassHint.KEY)) != null && !hint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext() && (resource = (PsiResourceListElement)iterator.next()) != lastParent) {
            if (!(resource instanceof PsiResourceVariable) || ((PsiResourceVariable)resource).isUnnamed() && !Boolean.TRUE.equals(processor.getHint(ElementClassHint.PROCESS_UNNAMED_VARIABLES)) || processor.execute((PsiElement)resource, state)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        PsiTypeParameterList typeParameterList;
        if (owner == null) {
            PsiImplUtil.$$$reportNull$$$0(34);
        }
        return (typeParameterList = owner.getTypeParameterList()) != null && typeParameterList.getTypeParameters().length != 0;
    }

    public static PsiType @NotNull [] typesByReferenceParameterList(@NotNull PsiReferenceParameterList parameterList) {
        if (parameterList == null) {
            PsiImplUtil.$$$reportNull$$$0(35);
        }
        PsiTypeElement[] typeElements = parameterList.getTypeParameterElements();
        return PsiImplUtil.typesByTypeElements(typeElements);
    }

    public static PsiType @NotNull [] typesByTypeElements(PsiTypeElement @NotNull [] typeElements) {
        if (typeElements == null) {
            PsiImplUtil.$$$reportNull$$$0(36);
        }
        PsiType[] types = PsiType.createArray(typeElements.length);
        for (int i = 0; i < types.length; ++i) {
            types[i] = typeElements[i].getType();
        }
        if (types.length == 1 && types[0] instanceof PsiDiamondType) {
            PsiType[] psiTypeArray = ((PsiDiamondType)types[0]).resolveInferredTypes().getTypes();
            if (psiTypeArray == null) {
                PsiImplUtil.$$$reportNull$$$0(37);
            }
            return psiTypeArray;
        }
        if (types == null) {
            PsiImplUtil.$$$reportNull$$$0(38);
        }
        return types;
    }

    @NotNull
    public static PsiType getType(@NotNull PsiClassObjectAccessExpression classAccessExpression) {
        PsiTypeParameter[] typeParameters;
        if (classAccessExpression == null) {
            PsiImplUtil.$$$reportNull$$$0(39);
        }
        GlobalSearchScope resolveScope = classAccessExpression.getResolveScope();
        PsiManager manager = classAccessExpression.getManager();
        PsiClass classClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Class", resolveScope);
        if (classClass == null) {
            return new PsiClassReferenceType(new LightClassReference(manager, "Class", "java.lang.Class", resolveScope), null);
        }
        if (!PsiUtil.isAvailable(JavaFeature.GENERICS, classAccessExpression)) {
            PsiClassType psiClassType = JavaPsiFacade.getElementFactory(manager.getProject()).createType(classClass);
            if (psiClassType == null) {
                PsiImplUtil.$$$reportNull$$$0(40);
            }
            return psiClassType;
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiType operandType = classAccessExpression.getOperand().getType();
        if (operandType instanceof PsiPrimitiveType && !PsiTypes.nullType().equals(operandType)) {
            operandType = PsiTypes.voidType().equals(operandType) ? JavaPsiFacade.getElementFactory(manager.getProject()).createTypeByFQClassName("java.lang.Void", classAccessExpression.getResolveScope()) : ((PsiPrimitiveType)operandType).getBoxedType(classAccessExpression);
        }
        if ((typeParameters = classClass.getTypeParameters()).length == 1) {
            substitutor = substitutor.put(typeParameters[0], operandType instanceof PsiClassType ? ((PsiClassType)operandType).rawType() : operandType);
        }
        PsiClassType psiClassType = new PsiImmediateClassType(classClass, substitutor).withNullability(TypeNullability.NOT_NULL_MANDATED);
        if (psiClassType == null) {
            PsiImplUtil.$$$reportNull$$$0(41);
        }
        return psiClassType;
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiAnnotationOwner annotationOwner, @NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiImplUtil.$$$reportNull$$$0(42);
        }
        if (annotationOwner == null) {
            return null;
        }
        PsiAnnotation[] annotations = annotationOwner.getAnnotations();
        if (annotations.length == 0) {
            return null;
        }
        String shortName = StringUtil.getShortName((String)qualifiedName);
        for (PsiAnnotation annotation : annotations) {
            PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
            if (referenceElement == null || !shortName.equals(referenceElement.getReferenceName()) || !qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static ASTNode findDocComment(@NotNull CompositeElement element) {
        TreeElement node;
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(43);
        }
        for (node = element.getFirstChildNode(); node != null && PsiImplUtil.isWhitespaceOrComment((ASTNode)node) && !(node.getPsi() instanceof PsiDocComment); node = node.getTreeNext()) {
        }
        return node == null || !JavaDocElementType.DOC_COMMENT_TOKENS.contains(node.getElementType()) ? null : node;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static PsiType normalizeWildcardTypeByPosition(@NotNull PsiType type, @NotNull PsiExpression expression) {
        PsiExpression topLevel;
        if (type == null) {
            PsiImplUtil.$$$reportNull$$$0(44);
        }
        if (expression == null) {
            PsiImplUtil.$$$reportNull$$$0(45);
        }
        PsiUtil.ensureValidType(type);
        for (topLevel = expression; topLevel.getParent() instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)topLevel.getParent()).getArrayExpression() == topLevel; topLevel = (PsiExpression)topLevel.getParent()) {
        }
        if (topLevel instanceof PsiArrayAccessExpression && !PsiUtil.isAccessedForWriting(topLevel)) {
            return PsiUtil.captureToplevelWildcards(type, expression);
        }
        PsiType normalized = PsiImplUtil.doNormalizeWildcardByPosition(type, expression, topLevel);
        LOG.assertTrue(normalized.isValid(), (Object)type);
        if (normalized instanceof PsiClassType && !PsiUtil.isAccessedForWriting(topLevel)) {
            return PsiUtil.captureToplevelWildcards(normalized, expression);
        }
        return normalized;
    }

    private static PsiType doNormalizeWildcardByPosition(PsiType type, @NotNull PsiExpression expression, @NotNull PsiExpression topLevel) {
        PsiType componentType;
        PsiType normalizedComponentType;
        if (expression == null) {
            PsiImplUtil.$$$reportNull$$$0(46);
        }
        if (topLevel == null) {
            PsiImplUtil.$$$reportNull$$$0(47);
        }
        if (type instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            if (PsiUtil.isAccessedForWriting(topLevel)) {
                return wildcardType.isSuper() ? wildcardType.getBound() : PsiCapturedWildcardType.create(wildcardType, expression);
            }
            if (wildcardType.isExtends()) {
                return wildcardType.getBound();
            }
            return PsiType.getJavaLangObject(expression.getManager(), expression.getResolveScope());
        }
        if (type instanceof PsiArrayType && (normalizedComponentType = PsiImplUtil.doNormalizeWildcardByPosition(componentType = ((PsiArrayType)type).getComponentType(), expression, topLevel)) != componentType) {
            return normalizedComponentType.createArrayType();
        }
        return type;
    }

    @NotNull
    public static SearchScope getMemberUseScope(@NotNull PsiMember member) {
        int accessLevel;
        PsiFile file;
        if (member == null) {
            PsiImplUtil.$$$reportNull$$$0(48);
        }
        PsiMember topElement = (file = member.getContainingFile()) == null ? member : file;
        Project project = topElement.getProject();
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getInstance((Project)project).getUseScope((PsiElement)topElement);
        if (PsiImplUtil.isInServerPage((PsiElement)file)) {
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                PsiImplUtil.$$$reportNull$$$0(49);
            }
            return globalSearchScope;
        }
        PsiClass aClass = member.getContainingClass();
        if (aClass instanceof PsiImplicitClass) {
            return new LocalSearchScope((PsiElement)aClass);
        }
        if (!(!(aClass instanceof PsiAnonymousClass) || aClass instanceof PsiEnumConstantInitializer && member instanceof PsiMethod && member.hasModifierProperty("public") && ((PsiMethod)member).findSuperMethods().length > 0)) {
            PsiElement[] elements;
            PsiElement scope;
            PsiElement psiElement = scope = PsiUtil.isLanguageLevel8OrHigher(aClass) ? PsiTreeUtil.getTopmostParentOfType((PsiElement)aClass, PsiStatement.class) : PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiMethodCallExpression.class);
            if (scope instanceof PsiDeclarationStatement && (elements = ((PsiDeclarationStatement)scope).getDeclaredElements()).length == 1 && elements[0] instanceof PsiLocalVariable && ((PsiLocalVariable)elements[0]).getTypeElement().isInferredType()) {
                scope = scope.getParent();
            }
            return new LocalSearchScope((PsiElement)(scope != null ? scope : aClass));
        }
        if (aClass != null) {
            PsiElement parent = aClass.getParent();
            while (parent instanceof PsiClass && !(parent instanceof PsiAnonymousClass) && !(parent instanceof PsiImplicitClass)) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiAnonymousClass) {
                return new LocalSearchScope(parent);
            }
            if (parent instanceof PsiDeclarationStatement) {
                return new LocalSearchScope(parent.getParent());
            }
            if (parent instanceof PsiImplicitClass) {
                return new LocalSearchScope(parent);
            }
        }
        PsiModifierList modifierList = member instanceof PsiRecordComponent && aClass != null ? aClass.getModifierList() : member.getModifierList();
        int n = accessLevel = modifierList == null ? 4 : PsiUtil.getAccessLevel(modifierList);
        if (accessLevel == 4 || accessLevel == 3) {
            SearchScope classScope = PsiImplUtil.getClassUseScopeIfApplicable(member, aClass, accessLevel);
            Object object = classScope != null ? classScope : maximalUseScope;
            if (object == null) {
                PsiImplUtil.$$$reportNull$$$0(50);
            }
            return object;
        }
        if (accessLevel == 1) {
            PsiClass topClass = PsiUtil.getTopLevelClass(member);
            return topClass != null ? new LocalSearchScope((PsiElement)topClass) : (file == null ? maximalUseScope : new LocalSearchScope((PsiElement)file));
        }
        if (file instanceof PsiJavaFile) {
            PsiPackage aPackage = JavaPsiFacade.getInstance(project).findPackage(((PsiJavaFile)file).getPackageName());
            SearchScope classScope = PsiImplUtil.getClassUseScopeIfApplicable(member, aClass, accessLevel);
            if (classScope != null) {
                SearchScope searchScope = classScope;
                if (searchScope == null) {
                    PsiImplUtil.$$$reportNull$$$0(51);
                }
                return searchScope;
            }
            if (aPackage != null) {
                GlobalSearchScope scope = PackageScope.packageScope(aPackage, false);
                SearchScope searchScope = scope.intersectWith((SearchScope)maximalUseScope);
                if (searchScope == null) {
                    PsiImplUtil.$$$reportNull$$$0(52);
                }
                return searchScope;
            }
        }
        GlobalSearchScope globalSearchScope = maximalUseScope;
        if (globalSearchScope == null) {
            PsiImplUtil.$$$reportNull$$$0(53);
        }
        return globalSearchScope;
    }

    private static SearchScope getClassUseScopeIfApplicable(PsiMember member, PsiClass aClass, int accessLevel) {
        if (aClass == null) {
            return null;
        }
        PsiModifierList classModifierList = aClass.getModifierList();
        if (classModifierList == null) {
            return null;
        }
        if (classModifierList.hasModifierProperty("final") || member instanceof PsiMethod && ((PsiMethod)member).isConstructor()) {
            return PsiUtil.getAccessLevel(classModifierList) < accessLevel ? aClass.getUseScope() : null;
        }
        if (!PsiImplUtil.mayHaveScopeWideningSubclass(aClass)) {
            return aClass.getUseScope();
        }
        return null;
    }

    private static boolean mayHaveScopeWideningSubclass(PsiClass aClass) {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> CachedValueProvider.Result.create((Object)PsiImplUtil.mayHaveScopeWideningSubclass(aClass, new HashSet<PsiClass>()), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean mayHaveScopeWideningSubclass(PsiClass aClass, Set<PsiClass> visited) {
        if (!aClass.hasModifierProperty("private")) {
            return true;
        }
        if (aClass instanceof PsiCompiledElement) {
            return true;
        }
        if (!visited.add(aClass)) {
            return true;
        }
        PsiClass context = PsiUtil.getTopLevelClass(aClass);
        if (context == null) {
            return false;
        }
        class LocalInheritorVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final Set<PsiClass> subclasses = new HashSet<PsiClass>();
            final /* synthetic */ PsiClass val$aClass;

            LocalInheritorVisitor(PsiClass psiClass) {
                this.val$aClass = psiClass;
            }

            @Override
            public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
                PsiElement parent;
                if (reference == null) {
                    LocalInheritorVisitor.$$$reportNull$$$0(0);
                }
                if (!((parent = reference.getParent()) instanceof PsiReferenceList)) {
                    return;
                }
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof PsiClass)) {
                    return;
                }
                if (reference.isReferenceTo(this.val$aClass)) {
                    this.subclasses.add((PsiClass)grandParent);
                }
            }

            @Override
            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    LocalInheritorVisitor.$$$reportNull$$$0(1);
                }
            }

            public boolean isExtended() {
                return !this.subclasses.isEmpty();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/PsiImplUtil$1LocalInheritorVisitor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        LocalInheritorVisitor visitor = new LocalInheritorVisitor(aClass);
        context.accept(visitor);
        return visitor.isExtended() && ContainerUtil.exists((Iterable)visitor.subclasses, subclass -> PsiImplUtil.mayHaveScopeWideningSubclass(subclass, visited));
    }

    public static boolean isInServerPage(@Nullable PsiElement element) {
        return PsiImplUtil.getServerPageFile(element) != null;
    }

    @Nullable
    private static ServerPageFile getServerPageFile(PsiElement element) {
        PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)element);
        return psiFile instanceof ServerPageFile ? (ServerPageFile)psiFile : null;
    }

    public static PsiElement setName(@NotNull PsiElement element, @NotNull String name) throws IncorrectOperationException {
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(54);
        }
        if (name == null) {
            PsiImplUtil.$$$reportNull$$$0(55);
        }
        PsiManager manager = element.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(manager.getProject());
        PsiIdentifier newNameIdentifier = factory.createIdentifier(name);
        return element.replace((PsiElement)newNameIdentifier);
    }

    public static boolean isDeprecatedByAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            PsiImplUtil.$$$reportNull$$$0(56);
        }
        return AnnotationUtil.findAnnotation(owner, "java.lang.Deprecated") != null;
    }

    public static boolean isDeprecatedByDocTag(@NotNull PsiJavaDocumentedElement owner) {
        PsiDocComment docComment;
        if (owner == null) {
            PsiImplUtil.$$$reportNull$$$0(57);
        }
        return (docComment = owner.getDocComment()) != null && docComment.findTagByName("deprecated") != null;
    }

    public static boolean isDeprecated(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PsiImplUtil.$$$reportNull$$$0(58);
        }
        if (psiElement instanceof PsiDocCommentOwner) {
            return ((PsiDocCommentOwner)psiElement).isDeprecated();
        }
        if (psiElement instanceof PsiModifierListOwner && PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)psiElement)) {
            return true;
        }
        if (psiElement instanceof PsiJavaDocumentedElement) {
            return PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)psiElement);
        }
        return false;
    }

    @Nullable
    public static PsiJavaDocumentedElement findDocCommentOwner(@NotNull PsiDocComment comment) {
        PsiJavaDocumentedElement owner;
        PsiElement parent;
        if (comment == null) {
            PsiImplUtil.$$$reportNull$$$0(59);
        }
        if ((parent = comment.getParent()) instanceof PsiJavaDocumentedElement && (owner = (PsiJavaDocumentedElement)parent).getDocComment() == comment) {
            return owner;
        }
        return null;
    }

    @Nullable
    public static PsiAnnotationMemberValue setDeclaredAttributeValue(@NotNull PsiAnnotation psiAnnotation, @Nullable String attributeName, @Nullable PsiAnnotationMemberValue value, @NotNull PairFunction<? super Project, ? super String, ? extends PsiAnnotation> annotationCreator) {
        if (psiAnnotation == null) {
            PsiImplUtil.$$$reportNull$$$0(60);
        }
        if (annotationCreator == null) {
            PsiImplUtil.$$$reportNull$$$0(61);
        }
        PsiAnnotationMemberValue existing = psiAnnotation.findDeclaredAttributeValue(attributeName);
        if (value == null) {
            if (existing == null) {
                return null;
            }
            existing.getParent().delete();
        } else if (existing != null) {
            ((PsiNameValuePair)existing.getParent()).setValue(value);
        } else {
            PsiNameValuePair attribute;
            PsiNameValuePair[] attributes = psiAnnotation.getParameterList().getAttributes();
            if (attributes.length == 1 && (attribute = attributes[0]).getName() == null) {
                PsiAnnotationMemberValue defValue = attribute.getValue();
                assert (defValue != null) : attribute;
                attribute.replace(PsiImplUtil.createNameValuePair(defValue, "value=", annotationCreator));
            }
            boolean allowNoName = attributes.length == 0 && ("value".equals(attributeName) || null == attributeName);
            String namePrefix = allowNoName ? "" : attributeName + "=";
            psiAnnotation.getParameterList().addBefore(PsiImplUtil.createNameValuePair(value, namePrefix, annotationCreator), null);
        }
        return psiAnnotation.findDeclaredAttributeValue(attributeName);
    }

    private static PsiNameValuePair createNameValuePair(@NotNull PsiAnnotationMemberValue value, @NotNull String namePrefix, @NotNull PairFunction<? super Project, ? super String, ? extends PsiAnnotation> annotationCreator) {
        if (value == null) {
            PsiImplUtil.$$$reportNull$$$0(62);
        }
        if (namePrefix == null) {
            PsiImplUtil.$$$reportNull$$$0(63);
        }
        if (annotationCreator == null) {
            PsiImplUtil.$$$reportNull$$$0(64);
        }
        return ((PsiAnnotation)annotationCreator.fun((Object)value.getProject(), (Object)("@A(" + namePrefix + value.getText() + ")"))).getParameterList().getAttributes()[0];
    }

    @Nullable
    public static ASTNode skipWhitespaceAndComments(ASTNode node) {
        return TreeUtil.skipWhitespaceAndComments((ASTNode)node, (boolean)true);
    }

    @Nullable
    public static ASTNode skipWhitespaceCommentsAndTokens(ASTNode node, @NotNull TokenSet alsoSkip) {
        if (alsoSkip == null) {
            PsiImplUtil.$$$reportNull$$$0(65);
        }
        return TreeUtil.skipWhitespaceCommentsAndTokens((ASTNode)node, (TokenSet)alsoSkip, (boolean)true);
    }

    public static boolean isWhitespaceOrComment(ASTNode element) {
        return TreeUtil.isWhitespaceOrComment((ASTNode)element);
    }

    @Nullable
    public static ASTNode skipWhitespaceAndCommentsBack(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (!PsiImplUtil.isWhitespaceOrComment(node)) {
            return node;
        }
        ASTNode parent = node.getTreeParent();
        ASTNode prev = node;
        while (prev instanceof CompositeElement) {
            if (!PsiImplUtil.isWhitespaceOrComment(prev)) {
                return prev;
            }
            prev = prev.getTreePrev();
        }
        if (prev == null) {
            return null;
        }
        ASTNode lastRelevant = null;
        for (ASTNode firstChildNode = parent.getFirstChildNode(); firstChildNode != prev; firstChildNode = firstChildNode.getTreeNext()) {
            if (PsiImplUtil.isWhitespaceOrComment(firstChildNode)) continue;
            lastRelevant = firstChildNode;
        }
        return lastRelevant;
    }

    @Nullable
    public static ASTNode findStatementChild(@NotNull CompositePsiElement statement) {
        if (statement == null) {
            PsiImplUtil.$$$reportNull$$$0(66);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (TreeElement element = statement.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!(element.getPsi() instanceof PsiStatement)) continue;
            return element;
        }
        return null;
    }

    public static PsiStatement @NotNull [] getChildStatements(@NotNull CompositeElement psiCodeBlock) {
        if (psiCodeBlock == null) {
            PsiImplUtil.$$$reportNull$$$0(67);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = 0;
        for (TreeElement child1 = psiCodeBlock.getFirstChildNode(); child1 != null; child1 = child1.getTreeNext()) {
            if (!(child1.getPsi() instanceof PsiStatement)) continue;
            ++count;
        }
        PsiStatement[] result = (PsiStatement[])PsiStatement.ARRAY_FACTORY.create(count);
        if (count == 0) {
            if (result == null) {
                PsiImplUtil.$$$reportNull$$$0(68);
            }
            return result;
        }
        int idx = 0;
        for (TreeElement child = psiCodeBlock.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            PsiElement element = child.getPsi();
            if (!(element instanceof PsiStatement)) continue;
            result[idx++] = (PsiStatement)element;
        }
        if (result == null) {
            PsiImplUtil.$$$reportNull$$$0(69);
        }
        return result;
    }

    public static boolean isVarArgs(@NotNull PsiMethod method) {
        PsiParameter[] parameters;
        if (method == null) {
            PsiImplUtil.$$$reportNull$$$0(70);
        }
        return (parameters = method.getParameterList().getParameters()).length > 0 && parameters[parameters.length - 1].isVarArgs();
    }

    public static PsiElement handleMirror(PsiElement element) {
        return element instanceof PsiMirrorElement ? ((PsiMirrorElement)element).getPrototype() : element;
    }

    @Nullable
    public static PsiModifierList findNeighbourModifierList(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement grandParent;
        PsiElement parent;
        if (ref == null) {
            PsiImplUtil.$$$reportNull$$$0(71);
        }
        if ((parent = PsiTreeUtil.skipParentsOfType((PsiElement)ref, (Class[])new Class[]{PsiJavaCodeReferenceElement.class})) instanceof PsiTypeElement && (grandParent = parent.getParent()) instanceof PsiModifierListOwner) {
            return ((PsiModifierListOwner)grandParent).getModifierList();
        }
        return null;
    }

    public static boolean isTypeAnnotation(@Nullable PsiElement element) {
        return element instanceof PsiAnnotation && AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)element);
    }

    public static void collectTypeUseAnnotations(@NotNull PsiModifierList modifierList, @NotNull List<? super PsiAnnotation> annotations) {
        if (modifierList == null) {
            PsiImplUtil.$$$reportNull$$$0(72);
        }
        if (annotations == null) {
            PsiImplUtil.$$$reportNull$$$0(73);
        }
        AnnotationTargetUtil.collectStrictlyTypeUseAnnotations(modifierList, annotations);
    }

    public static void markTypeAnnotations(@NotNull PsiTypeElement typeElement) {
        PsiElement left;
        if (typeElement == null) {
            PsiImplUtil.$$$reportNull$$$0(74);
        }
        if ((left = PsiTreeUtil.skipSiblingsBackward((PsiElement)typeElement, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class})) instanceof PsiModifierList) {
            for (PsiAnnotation annotation : ((PsiModifierList)left).getAnnotations()) {
                if (!AnnotationTargetUtil.isTypeAnnotation(annotation)) continue;
                annotation.putUserData(TYPE_ANNO_MARK, Boolean.TRUE);
            }
        }
    }

    public static void deleteTypeAnnotations(@NotNull PsiTypeElement typeElement) {
        PsiElement left;
        if (typeElement == null) {
            PsiImplUtil.$$$reportNull$$$0(75);
        }
        if ((left = PsiTreeUtil.skipSiblingsBackward((PsiElement)typeElement, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class})) instanceof PsiModifierList) {
            for (PsiAnnotation annotation : ((PsiModifierList)left).getAnnotations()) {
                if (TYPE_ANNO_MARK.get((UserDataHolder)annotation) != Boolean.TRUE) continue;
                annotation.delete();
            }
        }
    }

    @Nullable
    public static PsiLoopStatement findEnclosingLoop(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(76);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiLoopStatement) {
                return (PsiLoopStatement)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiStatement findEnclosingSwitchOrLoop(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(77);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiSwitchStatement || e instanceof PsiLoopStatement) {
                return (PsiStatement)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiSwitchExpression findEnclosingSwitchExpression(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(78);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiSwitchExpression) {
                return (PsiSwitchExpression)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiLabeledStatement findEnclosingLabeledStatement(@NotNull PsiElement start, @NotNull String label) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(79);
        }
        if (label == null) {
            PsiImplUtil.$$$reportNull$$$0(80);
        }
        PsiElement e = start;
        while (!PsiImplUtil.isCodeBoundary(e)) {
            if (e instanceof PsiLabeledStatement && label.equals(((PsiLabeledStatement)e).getName())) {
                return (PsiLabeledStatement)e;
            }
            e = e.getParent();
        }
        return null;
    }

    @NotNull
    public static @Unmodifiable List<String> findAllEnclosingLabels(@NotNull PsiElement start) {
        if (start == null) {
            PsiImplUtil.$$$reportNull$$$0(81);
        }
        SmartList result = new SmartList();
        PsiElement context = start;
        while (!PsiImplUtil.isCodeBoundary(context)) {
            if (context instanceof PsiLabeledStatement) {
                result.add(((PsiLabeledStatement)context).getName());
            }
            context = context.getContext();
        }
        SmartList smartList = result;
        if (smartList == null) {
            PsiImplUtil.$$$reportNull$$$0(82);
        }
        return smartList;
    }

    private static boolean isCodeBoundary(@Nullable PsiElement e) {
        return e == null || e instanceof PsiMethod || e instanceof PsiClassInitializer || e instanceof PsiLambdaExpression;
    }

    @Nullable
    public static PsiSwitchLabelStatementBase getSwitchLabel(@NotNull PsiCaseLabelElement labelElement) {
        PsiElement grand;
        PsiElement parent;
        if (labelElement == null) {
            PsiImplUtil.$$$reportNull$$$0(83);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp(labelElement.getParent())) instanceof PsiCaseLabelElementList && (grand = parent.getParent()) instanceof PsiSwitchLabelStatementBase) {
            return (PsiSwitchLabelStatementBase)grand;
        }
        return null;
    }

    public static boolean isLeafElementOfType(@Nullable PsiElement element, @NotNull IElementType type) {
        if (type == null) {
            PsiImplUtil.$$$reportNull$$$0(84);
        }
        return element instanceof LeafElement && ((LeafElement)element).getElementType() == type;
    }

    public static boolean isLeafElementOfType(PsiElement element, @NotNull TokenSet tokenSet) {
        if (tokenSet == null) {
            PsiImplUtil.$$$reportNull$$$0(85);
        }
        return element instanceof LeafElement && tokenSet.contains(((LeafElement)element).getElementType());
    }

    public static PsiType buildTypeFromTypeString(@NotNull String typeName, @NotNull PsiElement context, @NotNull PsiFile psiFile) {
        PsiClassType resultType;
        PsiClass aClass;
        if (typeName == null) {
            PsiImplUtil.$$$reportNull$$$0(86);
        }
        if (context == null) {
            PsiImplUtil.$$$reportNull$$$0(87);
        }
        if (psiFile == null) {
            PsiImplUtil.$$$reportNull$$$0(88);
        }
        PsiManager psiManager = psiFile.getManager();
        if (typeName.indexOf(60) != -1 || typeName.indexOf(91) != -1 || typeName.indexOf(46) == -1) {
            try {
                return JavaPsiFacade.getElementFactory(psiManager.getProject()).createTypeFromText(typeName, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((aClass = JavaPsiFacade.getInstance(psiManager.getProject()).findClass(typeName, context.getResolveScope())) == null) {
            LightClassReference ref = new LightClassReference(psiManager, PsiNameHelper.getShortClassName(typeName), typeName, PsiSubstitutor.EMPTY, (PsiElement)psiFile);
            resultType = new PsiClassReferenceType(ref, null);
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(psiManager.getProject());
            PsiSubstitutor substitutor = factory.createRawSubstitutor(aClass);
            resultType = factory.createType(aClass, substitutor);
        }
        return resultType;
    }

    public static <T extends PsiJavaCodeReferenceElement> JavaResolveResult @NotNull [] multiResolveImpl(@NotNull T element, boolean incompleteCode, @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver) {
        FileASTNode fileElement;
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(89);
        }
        if (resolver == null) {
            PsiImplUtil.$$$reportNull$$$0(90);
        }
        if ((fileElement = SharedImplUtil.findFileElement((ASTNode)element.getNode())) == null) {
            PsiUtilCore.ensureValid(element);
            LOG.error("fileElement == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(91);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiFile psiFile = SharedImplUtil.getContainingFile((ASTNode)fileElement);
        return PsiImplUtil.multiResolveImpl(element, psiFile, incompleteCode, resolver);
    }

    @NotNull
    public static <T extends PsiJavaCodeReferenceElement> @NotNull JavaResolveResult @NotNull [] multiResolveImpl(@NotNull T element, PsiFile psiFile, boolean incompleteCode, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver) {
        PsiManager manager;
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(92);
        }
        if (resolver == null) {
            PsiImplUtil.$$$reportNull$$$0(93);
        }
        PsiManager psiManager = manager = psiFile == null ? null : psiFile.getManager();
        if (manager == null) {
            PsiUtilCore.ensureValid(element);
            LOG.error("getManager() == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(94);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        boolean valid = psiFile.isValid();
        if (!valid) {
            PsiUtilCore.ensureValid(element);
            LOG.error("psiFile.isValid() == false!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiImplUtil.$$$reportNull$$$0(95);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        if (element instanceof PsiMethodReferenceExpression && ThreadLocalTypes.hasBindingFor(element)) {
            JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])resolver.resolve(element, psiFile, incompleteCode);
            if (javaResolveResultArray == null) {
                PsiImplUtil.$$$reportNull$$$0(96);
            }
            return javaResolveResultArray;
        }
        return PsiImplUtil.multiResolveImpl(manager.getProject(), psiFile, element, incompleteCode, resolver);
    }

    public static <T extends PsiJavaCodeReferenceElement> JavaResolveResult @NotNull [] multiResolveImpl(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull T element, boolean incompleteCode, @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver) {
        ResolveResult[] results;
        if (project == null) {
            PsiImplUtil.$$$reportNull$$$0(97);
        }
        if (psiFile == null) {
            PsiImplUtil.$$$reportNull$$$0(98);
        }
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(99);
        }
        if (resolver == null) {
            PsiImplUtil.$$$reportNull$$$0(100);
        }
        JavaResolveResult[] javaResolveResultArray = (results = ResolveCache.getInstance((Project)project).resolveWithCaching(element, resolver, true, incompleteCode, psiFile)).length == 0 ? JavaResolveResult.EMPTY_ARRAY : (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            PsiImplUtil.$$$reportNull$$$0(101);
        }
        return javaResolveResultArray;
    }

    @NotNull
    public static VirtualFile getModuleVirtualFile(@NotNull PsiJavaModule module) {
        if (module == null) {
            PsiImplUtil.$$$reportNull$$$0(102);
        }
        if (module instanceof LightJavaModule) {
            VirtualFile virtualFile = ((LightJavaModule)module).getRootVirtualFile();
            if (virtualFile == null) {
                PsiImplUtil.$$$reportNull$$$0(103);
            }
            return virtualFile;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)module);
        if (file == null) {
            throw new IllegalArgumentException("Module '" + module + "' lost its VF; file=" + module.getContainingFile() + "; valid=" + module.isValid());
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            PsiImplUtil.$$$reportNull$$$0(104);
        }
        return virtualFile;
    }

    @ApiStatus.Experimental
    @NotNull
    public static @NotNull ImplicitlyImportedElement @NotNull [] getImplicitImports(@NotNull PsiFile file) {
        PsiClass[] classes;
        if (file == null) {
            PsiImplUtil.$$$reportNull$$$0(105);
        }
        ArrayList<ImplicitlyImportedElement> implicitImports = new ArrayList<ImplicitlyImportedElement>();
        Project project = file.getProject();
        if (PsiUtil.isAvailable(JavaFeature.STRING_TEMPLATES, (PsiElement)file)) {
            implicitImports.add(ImplicitlyImportedStaticMember.create(project, "java.lang.StringTemplate", "STR"));
        }
        if (PsiUtil.isAvailable(JavaFeature.IMPLICIT_IMPORT_IN_IMPLICIT_CLASSES, (PsiElement)file) && !PsiUtil.isAvailable(JavaFeature.JAVA_LANG_IO, (PsiElement)file) && file instanceof PsiJavaFile && (classes = ((PsiJavaFile)file).getClasses()).length == 1 && classes[0] instanceof PsiImplicitClass) {
            implicitImports.add(ImplicitlyImportedStaticMember.create(project, JAVA_IO_IO, "*"));
        }
        if (PsiUtil.isAvailable(JavaFeature.IMPLICIT_IMPORT_IN_IMPLICIT_CLASSES, (PsiElement)file) && PsiUtil.isAvailable(JavaFeature.MODULE_IMPORT_DECLARATIONS, (PsiElement)file) && file instanceof PsiJavaFile && (classes = ((PsiJavaFile)file).getClasses()).length == 1 && classes[0] instanceof PsiImplicitClass) {
            implicitImports.add(ImplicitlyImportedModule.create(project, JAVA_BASE));
        }
        ImplicitlyImportedElement[] implicitlyImportedElementArray = implicitImports.toArray(ImplicitlyImportedElement.EMPTY_ARRAY);
        if (implicitlyImportedElementArray == null) {
            PsiImplUtil.$$$reportNull$$$0(106);
        }
        return implicitlyImportedElementArray;
    }

    @NotNull
    public static <T extends PsiElement> T getCorrespondingOriginalElementOfType(@NotNull T element, @NotNull Class<T> cls) {
        long index;
        PsiElement original;
        PsiElement parent;
        if (element == null) {
            PsiImplUtil.$$$reportNull$$$0(107);
        }
        if (cls == null) {
            PsiImplUtil.$$$reportNull$$$0(108);
        }
        if ((parent = element.getParent()) != null && (original = parent.getOriginalElement()) != parent && (index = StreamEx.of((Object[])parent.getChildren()).select(cls).indexOf(element).orElse(-1L)) != -1L) {
            T t = ((StreamEx)StreamEx.of((Object[])original.getChildren()).select(cls).skip(index)).findFirst().orElse(element);
            if (t == null) {
                PsiImplUtil.$$$reportNull$$$0(109);
            }
            return t;
        }
        T t = element;
        if (t == null) {
            PsiImplUtil.$$$reportNull$$$0(110);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 68: 
            case 69: 
            case 82: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 109: 
            case 110: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 68: 
            case 69: 
            case 82: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 109: 
            case 110: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 68: 
            case 69: 
            case 82: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 109: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiImplUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 6: 
            case 34: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 13: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterList";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 19: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 20: 
            case 24: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: 
            case 25: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 22: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 27: 
            case 43: 
            case 54: 
            case 89: 
            case 92: 
            case 99: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceList";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElements";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classAccessExpression";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 44: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevel";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationCreator";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePrefix";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alsoSkip";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiCodeBlock";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelElement";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 88: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 90: 
            case 93: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiImplUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "namesToPackageReferences";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceVariantsByFilter";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "typesByTypeElements";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberUseScope";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildStatements";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllEnclosingLabels";
                break;
            }
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveImpl";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleVirtualFile";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitImports";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingOriginalElementOfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConstructors";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 68: 
            case 69: 
            case 82: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 109: 
            case 110: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredAttributeValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameters";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "namesToPackageReferences";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParameterIndex";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterIndex";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceVariantsByFilter";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInMethod";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInLambda";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInMethodLike";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInResourceList";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeParameters";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "typesByReferenceParameterList";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "typesByTypeElements";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "normalizeWildcardTypeByPosition";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "doNormalizeWildcardByPosition";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getMemberUseScope";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedByAnnotation";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedByDocTag";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecated";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "findDocCommentOwner";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "setDeclaredAttributeValue";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createNameValuePair";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceCommentsAndTokens";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findStatementChild";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getChildStatements";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isVarArgs";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "findNeighbourModifierList";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeUseAnnotations";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "markTypeAnnotations";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "deleteTypeAnnotations";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingLoop";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingSwitchOrLoop";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingSwitchExpression";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingLabeledStatement";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "findAllEnclosingLabels";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchLabel";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isLeafElementOfType";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromTypeString";
                break;
            }
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveImpl";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getModuleVirtualFile";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitImports";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingOriginalElementOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 68: 
            case 69: 
            case 82: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 109: 
            case 110: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

