/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.AffectionScopeMetaUsage;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.CompositeBackDependencyIndex;
import org.jetbrains.jps.dependency.CompositeGraph;
import org.jetbrains.jps.dependency.Delta;
import org.jetbrains.jps.dependency.DependencyGraph;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.DifferentiateParameters;
import org.jetbrains.jps.dependency.DifferentiateResult;
import org.jetbrains.jps.dependency.DifferentiateStrategy;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.MapletFactory;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.impl.Containers;
import org.jetbrains.jps.dependency.impl.DeltaImpl;
import org.jetbrains.jps.dependency.impl.DifferentiateParametersBuilder;
import org.jetbrains.jps.dependency.impl.GraphImpl;
import org.jetbrains.jps.dependency.impl.SourceOnlyDelta;
import org.jetbrains.jps.dependency.java.GeneralJvmDifferentiateStrategy;
import org.jetbrains.jps.dependency.kotlin.KotlinSourceOnlyDifferentiateStrategy;
import org.jetbrains.jps.util.Iterators;

public final class DependencyGraphImpl
extends GraphImpl
implements DependencyGraph {
    private static final List<DifferentiateStrategy> ourDifferentiateStrategies = List.of(new KotlinSourceOnlyDifferentiateStrategy(), new GeneralJvmDifferentiateStrategy());

    public DependencyGraphImpl(MapletFactory containerFactory) {
        this(containerFactory, GraphImpl.IndexFactory.mandatoryIndices());
    }

    public DependencyGraphImpl(MapletFactory containerFactory, GraphImpl.IndexFactory idxFactory) {
        super(containerFactory, idxFactory);
    }

    @Override
    public Delta createDelta(Iterable<NodeSource> compiledSources, Iterable<NodeSource> deletedSources, boolean isSourceOnly) {
        if (isSourceOnly) {
            return new SourceOnlyDelta(Iterators.map(this.getIndices(), BackDependencyIndex::getName), compiledSources, deletedSources);
        }
        return new DeltaImpl(compiledSources, deletedSources, this.getIndexFactory());
    }

    @Override
    public DifferentiateResult differentiate(final Delta delta, final DifferentiateParameters params, Iterable<Graph> extParts) {
        List deletedNodes;
        Set<Node<?, ?>> nodesWithErrors;
        Set allProcessedSources;
        boolean isIntegrable;
        Graph graphView;
        if (Iterators.isEmpty(extParts)) {
            graphView = this;
            isIntegrable = true;
        } else {
            graphView = CompositeGraph.create(Iterators.flat(List.of(this), extParts));
            isIntegrable = false;
        }
        final String sessionName = params.getSessionName();
        final Iterable<NodeSource> deltaSources = delta.getSources();
        Set set = allProcessedSources = delta.isSourceOnly() ? delta.getDeletedSources() : (Set)Iterators.collect(Iterators.flat(List.of(delta.getBaseSources(), deltaSources, delta.getDeletedSources())), new HashSet());
        Set<Node<Object, Object>> set2 = params.isCompiledWithErrors() ? Iterators.collect(Iterators.flat(Iterators.map(Iterators.filter(delta.getBaseSources(), s -> !Iterators.contains(deltaSources, s)), graphView::getNodes)), Containers.createCustomPolicySet(DiffCapable::isSame, DiffCapable::diffHashCode)) : (nodesWithErrors = Set.of());
        Set<Node<?, ?>> nodesBefore = Iterators.collect(Iterators.flat(Iterators.map(params.isCompiledWithErrors() ? Iterators.flat(List.of(deltaSources, delta.getDeletedSources())) : allProcessedSources, graphView::getNodes)), Containers.createCustomPolicySet(DiffCapable::isSame, DiffCapable::diffHashCode));
        Set<Node<?, ?>> nodesAfter = delta.isSourceOnly() ? Collections.emptySet() : Iterators.collect(Iterators.flat(Iterators.map(deltaSources, delta::getNodes)), Containers.createCustomPolicySet(DiffCapable::isSame, DiffCapable::diffHashCode));
        List list = deletedNodes = nodesBefore.isEmpty() ? Collections.emptyList() : (List)Iterators.collect(Iterators.filter(nodesBefore, n -> !nodesAfter.contains(n)), new ArrayList());
        if (!params.isCalculateAffected()) {
            return new DifferentiateResult(){

                @Override
                public boolean isIntegrable() {
                    return isIntegrable;
                }

                @Override
                public String getSessionName() {
                    return sessionName;
                }

                @Override
                public DifferentiateParameters getParameters() {
                    return params;
                }

                @Override
                public Delta getDelta() {
                    return delta;
                }

                @Override
                public Iterable<Node<?, ?>> getDeletedNodes() {
                    return deletedNodes;
                }

                @Override
                public Iterable<NodeSource> getAffectedSources() {
                    return Collections.emptyList();
                }
            };
        }
        var diffContext = new DifferentiateContext(){
            private final Predicate<Node<?, ?>> ANY_CONSTRAINT = node -> true;
            final Set<NodeSource> compiledSources = deltaSources instanceof Set ? (Set)deltaSources : (Set)Iterators.collect(deltaSources, new HashSet());
            final Set<ReferenceID> deleted = Iterators.collect(Iterators.map(deletedNodes, Node::getReferenceID), new HashSet());
            final Map<Usage, Predicate<Node<?, ?>>> affectedUsages = new HashMap();
            final Set<Predicate<Node<?, ?>>> usageQueries = new HashSet();
            final Set<NodeSource> affectedSources = new HashSet<NodeSource>();

            @Override
            public DifferentiateParameters getParams() {
                return params;
            }

            @Override
            @NotNull
            public Graph getGraph() {
                Graph graph = graphView;
                if (graph == null) {
                    2.$$$reportNull$$$0(0);
                }
                return graph;
            }

            @Override
            @NotNull
            public Delta getDelta() {
                Delta delta2 = delta;
                if (delta2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return delta2;
            }

            @Override
            public boolean isCompiled(NodeSource src) {
                return this.compiledSources.contains(src);
            }

            @Override
            public boolean isDeleted(ReferenceID id) {
                return this.deleted.contains(id);
            }

            @Override
            public void affectUsage(@NotNull Usage usage) {
                if (usage == null) {
                    2.$$$reportNull$$$0(2);
                }
                this.affectedUsages.put(usage, this.ANY_CONSTRAINT);
            }

            @Override
            public void affectUsage(@NotNull Usage usage, @NotNull Predicate<Node<?, ?>> constraint) {
                Predicate<Node<?, ?>> prevConstraint;
                if (usage == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (constraint == null) {
                    2.$$$reportNull$$$0(4);
                }
                if ((prevConstraint = this.affectedUsages.put(usage, constraint)) != null && constraint != this.ANY_CONSTRAINT) {
                    this.affectedUsages.put(usage, prevConstraint == this.ANY_CONSTRAINT ? this.ANY_CONSTRAINT : prevConstraint.or(constraint));
                }
            }

            @Override
            public void affectUsage(Iterable<? extends ReferenceID> affectionScopeNodes, @NotNull Predicate<Node<?, ?>> usageQuery) {
                if (usageQuery == null) {
                    2.$$$reportNull$$$0(5);
                }
                for (Usage usage : Iterators.map(affectionScopeNodes, AffectionScopeMetaUsage::new)) {
                    this.affectUsage(usage);
                }
                this.usageQueries.add(usageQuery);
            }

            @Override
            public void affectNodeSource(@NotNull NodeSource source) {
                if (source == null) {
                    2.$$$reportNull$$$0(6);
                }
                this.affectedSources.add(source);
            }

            boolean isNodeAffected(Node<?, ?> node) {
                if (!this.affectedUsages.isEmpty()) {
                    ArrayList<Predicate> deferred = new ArrayList<Predicate>();
                    for (Predicate predicate : Iterators.filter(Iterators.map(node.getUsages(), this.affectedUsages::get), Objects::nonNull)) {
                        if (predicate == this.ANY_CONSTRAINT) {
                            return true;
                        }
                        deferred.add(predicate);
                    }
                    for (Predicate<Object> predicate : deferred) {
                        if (!predicate.test(node)) continue;
                        return true;
                    }
                }
                return !this.usageQueries.isEmpty() && Iterators.find(this.usageQueries, query -> query.test(node)) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/jps/dependency/impl/DependencyGraphImpl$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "usage";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "constraint";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "usageQuery";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getGraph";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDelta";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/jps/dependency/impl/DependencyGraphImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "affectUsage";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "affectNodeSource";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        boolean incremental = true;
        for (DifferentiateStrategy diffStrategy : ourDifferentiateStrategies) {
            if (diffStrategy.differentiate(diffContext, nodesBefore, nodesAfter, nodesWithErrors)) continue;
            incremental = false;
            break;
        }
        if (!incremental) {
            return DifferentiateResult.createNonIncremental("", params, delta, isIntegrable, deletedNodes);
        }
        Set dependingOnDeleted = Iterators.collect(Iterators.flat(Iterators.map(diffContext.deleted, graphView::getDependingNodes)), new HashSet());
        final Set affectedSources = Iterators.collect(Iterators.flat(Iterators.map(dependingOnDeleted, graphView::getSources)), new HashSet());
        Map affectedNodeCache = Containers.createCustomPolicyMap(DiffCapable::isSame, DiffCapable::diffHashCode);
        Function<Node, Boolean> checkAffected = k -> affectedNodeCache.computeIfAbsent((Node)k, n -> {
            if (!diffContext.isNodeAffected((Node<?, ?>)n)) {
                return Boolean.FALSE;
            }
            for (DifferentiateStrategy strategy : ourDifferentiateStrategies) {
                if (strategy.isIncremental(diffContext, (Node<?, ?>)n)) continue;
                return null;
            }
            return Boolean.TRUE;
        });
        Iterable<ReferenceID> scopeNodes = Iterators.unique(Iterators.map(diffContext.affectedUsages.keySet(), Usage::getElementOwner));
        Set candidates = Iterators.collect(Iterators.filter(Iterators.flat(Iterators.map(scopeNodes, graphView::getDependingNodes)), id -> !dependingOnDeleted.contains(id)), new HashSet());
        for (NodeSource depSrc : Iterators.unique(Iterators.flat(Iterators.map(candidates, graphView::getSources)))) {
            if (affectedSources.contains(depSrc) || diffContext.affectedSources.contains(depSrc) || allProcessedSources.contains(depSrc) || !params.affectionFilter().test(depSrc)) continue;
            boolean affectSource = false;
            for (Node depNode : Iterators.filter(graphView.getNodes(depSrc), n -> candidates.contains(n.getReferenceID()))) {
                Boolean isAffected = checkAffected.apply(depNode);
                if (isAffected == null) {
                    return DifferentiateResult.createNonIncremental("", params, delta, isIntegrable, deletedNodes);
                }
                if (!isAffected.booleanValue()) continue;
                affectSource = true;
            }
            if (!affectSource) continue;
            affectedSources.add(depSrc);
        }
        if (delta.isSourceOnly()) {
            Set<NodeSource> inputSources = delta.getBaseSources();
            Set<NodeSource> deleted = delta.getDeletedSources();
            Predicate<Object> srcFilter = DifferentiateParameters.affectableInCurrentChunk(diffContext.getParams()).and(s -> !deleted.contains(s));
            for (Node node : Iterators.flat(Iterators.map(Iterators.flat(inputSources, deleted), graphView::getNodes))) {
                Iterable<NodeSource> nodeSources = graphView.getSources(node.getReferenceID());
                if (Iterators.count(nodeSources) <= 1) continue;
                List filteredNodeSources = Iterators.collect(Iterators.filter(nodeSources, srcFilter::test), new ArrayList());
                if (Iterators.find(filteredNodeSources, s -> !inputSources.contains(s)) == null) continue;
                for (NodeSource s2 : filteredNodeSources) {
                    diffContext.affectNodeSource(s2);
                }
            }
        }
        affectedSources.removeAll(allProcessedSources);
        affectedSources.addAll(diffContext.affectedSources);
        if (!delta.isSourceOnly()) {
            Delta affectedSourceDelta = this.createDelta(Iterators.filter(affectedSources, params.belongsToCurrentCompilationChunk()::test), Collections.emptyList(), true);
            DifferentiateParameters srcDeltaParams = DifferentiateParametersBuilder.create(params).compiledWithErrors(false).get();
            Iterators.collect(this.differentiate(affectedSourceDelta, srcDeltaParams).getAffectedSources(), affectedSources);
        }
        return new DifferentiateResult(){

            @Override
            public boolean isIntegrable() {
                return isIntegrable;
            }

            @Override
            public String getSessionName() {
                return sessionName;
            }

            @Override
            public DifferentiateParameters getParameters() {
                return params;
            }

            @Override
            public Delta getDelta() {
                return delta;
            }

            @Override
            public Iterable<Node<?, ?>> getDeletedNodes() {
                return deletedNodes;
            }

            @Override
            public Iterable<NodeSource> getAffectedSources() {
                return affectedSources;
            }
        };
    }

    @Override
    public void integrate(@NotNull DifferentiateResult diffResult) {
        Map<String, BackDependencyIndex> shadowedNodesIndices;
        if (diffResult == null) {
            DependencyGraphImpl.$$$reportNull$$$0(0);
        }
        if (!diffResult.isIntegrable()) {
            throw new RuntimeException("The differentiate result cannot be safely integrated");
        }
        DifferentiateParameters params = diffResult.getParameters();
        Delta delta = diffResult.getDelta();
        Set differentiatedSources = Iterators.collect(Iterators.flat(List.of(params.isCompiledWithErrors() ? List.of() : delta.getBaseSources(), delta.getSources(), delta.getDeletedSources())), new HashSet());
        if (!Iterators.isEmpty(diffResult.getDeletedNodes())) {
            for (Node node : diffResult.getDeletedNodes()) {
                Set nodeSources = Iterators.collect(this.myNodeToSourcesMap.get(node.getReferenceID()), new HashSet());
                nodeSources.removeAll(differentiatedSources);
                if (nodeSources.isEmpty()) {
                    this.myNodeToSourcesMap.remove(node.getReferenceID());
                    continue;
                }
                this.myNodeToSourcesMap.put(node.getReferenceID(), nodeSources);
            }
        }
        for (NodeSource nodeSource : delta.getDeletedSources()) {
            this.mySourceToNodesMap.remove(nodeSource);
        }
        Set<Node> updatedNodes = Iterators.collect(Iterators.flat(Iterators.map(delta.getSources(), this::getNodes)), Containers.createCustomPolicySet(DiffCapable::isSame, DiffCapable::diffHashCode));
        HashSet hashSet = new HashSet();
        Set differentiatedNodeIds = Iterators.collect(Iterators.map(Iterators.flat(updatedNodes, diffResult.getDeletedNodes()), Node::getReferenceID), new HashSet());
        for (NodeSource nodeSource : Iterators.unique(Iterators.filter(Iterators.flat(Iterators.map(differentiatedNodeIds, this.myNodeToSourcesMap::get)), src -> !differentiatedSources.contains(src)))) {
            Iterators.collect(Iterators.filter(this.mySourceToNodesMap.get(nodeSource), n -> differentiatedNodeIds.contains(n.getReferenceID())), hashSet);
        }
        if (hashSet.isEmpty()) {
            shadowedNodesIndices = Map.of();
        } else {
            shadowedNodesIndices = new HashMap();
            for (BackDependencyIndex index : this.getIndexFactory().createIndices(Containers.MEMORY_CONTAINER_FACTORY)) {
                shadowedNodesIndices.put(index.getName(), index);
            }
        }
        for (BackDependencyIndex index : this.getIndices()) {
            BackDependencyIndex deltaIndex = delta.getIndex(index.getName());
            assert (deltaIndex != null);
            BackDependencyIndex snIndex = (BackDependencyIndex)shadowedNodesIndices.get(index.getName());
            if (snIndex != null) {
                for (Node shadowedNode : hashSet) {
                    snIndex.indexNode(shadowedNode);
                }
                deltaIndex = CompositeBackDependencyIndex.create(deltaIndex.getName(), List.of(deltaIndex, snIndex));
            }
            index.integrate(diffResult.getDeletedNodes(), Iterators.flat(updatedNodes, hashSet), deltaIndex);
        }
        Iterable<ReferenceID> iterable = Iterators.unique(Iterators.map(Iterators.flat(Iterators.map(delta.getSources(), delta::getNodes)), Node::getReferenceID));
        for (ReferenceID nodeID : iterable) {
            Set sourcesAfter = Iterators.collect(this.myNodeToSourcesMap.get(nodeID), new HashSet());
            sourcesAfter.removeAll(delta.getBaseSources());
            Iterators.collect(delta.getSources(nodeID), sourcesAfter);
            this.myNodeToSourcesMap.update(nodeID, sourcesAfter, Difference::diff);
        }
        for (NodeSource src2 : delta.getSources()) {
            this.mySourceToNodesMap.update(src2, delta.getNodes(src2), (past, now) -> new Difference.Specifier<Node<?, ?>, Difference>((Iterable)past, (Iterable)now){
                private final Difference.Specifier<Node, ?> diff;
                final /* synthetic */ Iterable val$past;
                final /* synthetic */ Iterable val$now;
                {
                    this.val$past = iterable;
                    this.val$now = iterable2;
                    this.diff = Difference.deepDiff(Graph.getNodesOfType(this.val$past, Node.class), Graph.getNodesOfType(this.val$now, Node.class));
                }

                @Override
                public Iterable<Node<?, ?>> added() {
                    return Iterators.map(this.diff.added(), n -> n);
                }

                @Override
                public Iterable<Node<?, ?>> removed() {
                    return Iterators.map(this.diff.removed(), n -> n);
                }

                @Override
                public Iterable<Difference.Change<Node<?, ?>, Difference>> changed() {
                    return Iterators.map(this.diff.changed(), ch -> new DiffChangeAdapter((Difference.Change<Node, ?>)ch));
                }

                @Override
                public boolean unchanged() {
                    return this.diff.unchanged();
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffResult", "org/jetbrains/jps/dependency/impl/DependencyGraphImpl", "integrate"));
    }

    private static final class DiffChangeAdapter
    implements Difference.Change<Node<?, ?>, Difference> {
        private final Difference.Change<Node, ?> myDelegate;

        DiffChangeAdapter(Difference.Change<Node, ?> delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Node<?, ?> getPast() {
            return this.myDelegate.getPast();
        }

        @Override
        public Node<?, ?> getNow() {
            return this.myDelegate.getNow();
        }

        @Override
        public Difference getDiff() {
            return this.myDelegate.getDiff();
        }
    }
}

