/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import java.lang.annotation.RetentionPolicy;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.impl.RW;
import org.jetbrains.jps.dependency.java.ElemType;
import org.jetbrains.jps.dependency.java.ElementAnnotation;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMetadata;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.util.Iterators;

public final class JvmClass
extends JVMClassNode<JvmClass, Diff> {
    public static final String OBJECT_CLASS_NAME = "java/lang/Object";
    private final String myOuterFqName;
    private final String mySuperFqName;
    private final Iterable<String> myInterfaces;
    private final Iterable<JvmField> myFields;
    private final Iterable<JvmMethod> myMethods;
    private final Iterable<ElemType> myAnnotationTargets;
    @Nullable
    private final RetentionPolicy myRetentionPolicy;

    public JvmClass(JVMFlags flags, String signature, String fqName, String outFilePath, String superFqName, String outerFqName, Iterable<String> interfaces, Iterable<JvmField> fields, Iterable<JvmMethod> methods, Iterable<ElementAnnotation> annotations, Iterable<ElemType> annotationTargets, @Nullable RetentionPolicy retentionPolicy, @NotNull Iterable<Usage> usages, @NotNull Iterable<JvmMetadata<?, ?>> metadata) {
        if (usages == null) {
            JvmClass.$$$reportNull$$$0(0);
        }
        if (metadata == null) {
            JvmClass.$$$reportNull$$$0(1);
        }
        super(flags, signature, fqName, outFilePath, annotations, usages, metadata);
        this.mySuperFqName = superFqName == null || OBJECT_CLASS_NAME.equals(superFqName) ? "" : superFqName;
        this.myOuterFqName = outerFqName == null ? "" : outerFqName;
        this.myInterfaces = interfaces;
        this.myFields = fields;
        this.myMethods = methods;
        this.myAnnotationTargets = annotationTargets;
        this.myRetentionPolicy = retentionPolicy;
    }

    public JvmClass(GraphDataInput in) throws IOException {
        super(in);
        Iterator<RetentionPolicy> iterator;
        this.myOuterFqName = in.readUTF();
        this.mySuperFqName = in.readUTF();
        this.myInterfaces = RW.readCollection(in, () -> in.readUTF());
        this.myFields = RW.readCollection(in, () -> new JvmField(in));
        this.myMethods = RW.readCollection(in, () -> new JvmMethod(in));
        this.myAnnotationTargets = RW.readCollection(in, () -> ElemType.fromOrdinal(in.readInt()));
        RetentionPolicy policy = null;
        int policyOrdinal = in.readInt();
        if (policyOrdinal >= 0 && (iterator = Iterators.filter(Iterators.asIterable(RetentionPolicy.values()), v -> v.ordinal() == policyOrdinal).iterator()).hasNext()) {
            RetentionPolicy value;
            policy = value = iterator.next();
        }
        this.myRetentionPolicy = policy;
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.myOuterFqName);
        out.writeUTF(this.mySuperFqName);
        RW.writeCollection(out, this.myInterfaces, s -> out.writeUTF((String)s));
        RW.writeCollection(out, this.myFields, f -> f.write(out));
        RW.writeCollection(out, this.myMethods, m -> m.write(out));
        RW.writeCollection(out, this.myAnnotationTargets, t -> out.writeInt(t.ordinal()));
        out.writeInt(this.myRetentionPolicy == null ? -1 : this.myRetentionPolicy.ordinal());
    }

    @NotNull
    public String getPackageName() {
        return JvmClass.getPackageName(this.getName());
    }

    @NotNull
    public static String getPackageName(@NotNull String jvmClassName) {
        int index;
        if (jvmClassName == null) {
            JvmClass.$$$reportNull$$$0(2);
        }
        return (index = jvmClassName.lastIndexOf(47)) >= 0 ? jvmClassName.substring(0, index) : "";
    }

    @NotNull
    public String getShortName() {
        String fqName = this.getName();
        if (this.isInnerClass() && fqName.startsWith(this.myOuterFqName) && fqName.length() > this.myOuterFqName.length()) {
            String string = fqName.substring(this.myOuterFqName.length() + 1);
            if (string == null) {
                JvmClass.$$$reportNull$$$0(3);
            }
            return string;
        }
        int index = fqName.lastIndexOf(47);
        String string = index >= 0 ? fqName.substring(index + 1) : fqName;
        if (string == null) {
            JvmClass.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isInterface() {
        return this.getFlags().isInterface();
    }

    public boolean isAnonymous() {
        return this.getFlags().isAnonymous();
    }

    public boolean isSealed() {
        return this.getFlags().isSealed();
    }

    public boolean isLocal() {
        return this.getFlags().isLocal();
    }

    public String getSuperFqName() {
        return this.mySuperFqName;
    }

    public String getOuterFqName() {
        return this.myOuterFqName;
    }

    public boolean isInnerClass() {
        return this.myOuterFqName != null && !this.myOuterFqName.isBlank();
    }

    public Iterable<String> getInterfaces() {
        return this.myInterfaces;
    }

    public Iterable<String> getSuperTypes() {
        return this.mySuperFqName.isEmpty() || OBJECT_CLASS_NAME.equals(this.mySuperFqName) ? this.getInterfaces() : Iterators.flat(Iterators.asIterable(this.mySuperFqName), this.getInterfaces());
    }

    public Iterable<JvmField> getFields() {
        return this.myFields;
    }

    public Iterable<JvmMethod> getMethods() {
        return this.myMethods;
    }

    public Iterable<ElemType> getAnnotationTargets() {
        return this.myAnnotationTargets;
    }

    @Nullable
    public RetentionPolicy getRetentionPolicy() {
        return this.myRetentionPolicy;
    }

    @Override
    public Diff difference(JvmClass past) {
        return new Diff(past);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmClassName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/java/JvmClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/java/JvmClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public final class Diff
    extends JVMClassNode.Diff {
        private final Supplier<Difference.Specifier<String, ?>> myInterfacesDiff;
        private final Supplier<Difference.Specifier<JvmMethod, JvmMethod.Diff>> myMethodsDiff;
        private final Supplier<Difference.Specifier<JvmField, JvmField.Diff>> myFieldsDiff;
        private final Supplier<Difference.Specifier<ElemType, ?>> myAnnotationTargetsDiff;

        public Diff(JvmClass past) {
            super((JVMClassNode)JvmClass.this, (JVMClassNode)past);
            this.myInterfacesDiff = Utils.lazyValue(() -> Difference.diff(((JvmClass)this.myPast).getInterfaces(), JvmClass.this.getInterfaces()));
            this.myMethodsDiff = Utils.lazyValue(() -> Difference.deepDiff(((JvmClass)this.myPast).getMethods(), JvmClass.this.getMethods()));
            this.myFieldsDiff = Utils.lazyValue(() -> Difference.deepDiff(((JvmClass)this.myPast).getFields(), JvmClass.this.getFields()));
            this.myAnnotationTargetsDiff = Utils.lazyValue(() -> Difference.diff(((JvmClass)this.myPast).getAnnotationTargets(), JvmClass.this.getAnnotationTargets()));
        }

        @Override
        public boolean unchanged() {
            return super.unchanged() && !this.superClassChanged() && !this.outerClassChanged() && this.interfaces().unchanged() && this.methods().unchanged() && this.fields().unchanged() && !this.retentionPolicyChanged() && this.annotationTargets().unchanged();
        }

        public boolean superClassChanged() {
            return !Objects.equals(((JvmClass)this.myPast).getSuperFqName(), JvmClass.this.getSuperFqName());
        }

        public boolean extendsAdded() {
            String pastSuper = ((JvmClass)this.myPast).getSuperFqName();
            return (pastSuper.isEmpty() || JvmClass.OBJECT_CLASS_NAME.equals(pastSuper)) && this.superClassChanged();
        }

        public boolean extendsRemoved() {
            String currentSuper = JvmClass.this.getSuperFqName();
            return (currentSuper.isEmpty() || JvmClass.OBJECT_CLASS_NAME.equals(currentSuper)) && this.superClassChanged();
        }

        public boolean outerClassChanged() {
            return !Objects.equals(((JvmClass)this.myPast).getOuterFqName(), JvmClass.this.getOuterFqName());
        }

        public Difference.Specifier<String, ?> interfaces() {
            return this.myInterfacesDiff.get();
        }

        public Difference.Specifier<JvmMethod, JvmMethod.Diff> methods() {
            return this.myMethodsDiff.get();
        }

        public Difference.Specifier<JvmField, JvmField.Diff> fields() {
            return this.myFieldsDiff.get();
        }

        public boolean retentionPolicyChanged() {
            return !Objects.equals((Object)((JvmClass)this.myPast).getRetentionPolicy(), (Object)JvmClass.this.getRetentionPolicy());
        }

        public Difference.Specifier<ElemType, ?> annotationTargets() {
            return this.myAnnotationTargetsDiff.get();
        }

        public boolean targetAttributeCategoryMightChange() {
            Difference.Specifier<ElemType, ?> targetsDiff = this.annotationTargets();
            if (!targetsDiff.unchanged()) {
                for (ElemType elemType : Set.of(ElemType.TYPE_USE, ElemType.RECORD_COMPONENT)) {
                    if (!Iterators.contains(targetsDiff.added(), elemType) && !Iterators.contains(targetsDiff.removed(), elemType) && !Iterators.contains(((JvmClass)this.myPast).getAnnotationTargets(), elemType)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

