/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.metadata.Attributes;
import kotlin.metadata.ClassKind;
import kotlin.metadata.KmClass;
import kotlin.metadata.KmConstructor;
import kotlin.metadata.KmDeclarationContainer;
import kotlin.metadata.KmFunction;
import kotlin.metadata.KmPackage;
import kotlin.metadata.KmProperty;
import kotlin.metadata.KmPropertyAccessorAttributes;
import kotlin.metadata.KmTypeAlias;
import kotlin.metadata.jvm.JvmExtensionsKt;
import kotlin.metadata.jvm.JvmMethodSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.AnnotationGroup;
import org.jetbrains.jps.dependency.java.AnnotationInstance;
import org.jetbrains.jps.dependency.java.ClassNewUsage;
import org.jetbrains.jps.dependency.java.ClassUsage;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmDifferentiateStrategyImpl;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.KotlinMeta;
import org.jetbrains.jps.dependency.java.LookupNameUsage;
import org.jetbrains.jps.dependency.java.MethodUsage;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.dependency.kotlin.KJvmUtils;
import org.jetbrains.jps.util.Iterators;
import org.jetbrains.jps.util.Pair;

public final class KotlinJvmDifferentiateStrategy
extends JvmDifferentiateStrategyImpl {
    private static final TypeRepr.ClassType JVM_OVERLOADS_ANNOTATION = new TypeRepr.ClassType("kotlin/jvm/JvmOverloads");
    private static final List<AnnotationGroup> ourTrackedAnnotations = List.of(AnnotationGroup.of("Nullability annotations", EnumSet.of(AnnotationGroup.AnnTarget.field, AnnotationGroup.AnnTarget.method, AnnotationGroup.AnnTarget.method_parameter), EnumSet.of(AnnotationGroup.AffectionKind.added, AnnotationGroup.AffectionKind.removed), EnumSet.of(AnnotationGroup.AffectionScope.usages), Set.of(new TypeRepr.ClassType("org/jetbrains/annotations/Nullable"), new TypeRepr.ClassType("androidx/annotation/Nullable"), new TypeRepr.ClassType("android/support/annotation/Nullable"), new TypeRepr.ClassType("android/annotation/Nullable"), new TypeRepr.ClassType("com/android/annotations/Nullable"), new TypeRepr.ClassType("org/eclipse/jdt/annotation/Nullable"), new TypeRepr.ClassType("org/checkerframework/checker/nullness/qual/Nullable"), new TypeRepr.ClassType("javax/annotation/Nullable"), new TypeRepr.ClassType("javax/annotation/CheckForNull"), new TypeRepr.ClassType("edu/umd/cs/findbugs/annotations/CheckForNull"), new TypeRepr.ClassType("edu/umd/cs/findbugs/annotations/Nullable"), new TypeRepr.ClassType("edu/umd/cs/findbugs/annotations/PossiblyNull"), new TypeRepr.ClassType("io/reactivex/annotations/Nullable"), new TypeRepr.ClassType("io/reactivex/rxjava3/annotations/Nullable"), new TypeRepr.ClassType("javax/annotation/Nonnull"), new TypeRepr.ClassType("org/jetbrains/annotations/NotNull"), new TypeRepr.ClassType("edu/umd/cs/findbugs/annotations/NonNull"), new TypeRepr.ClassType("androidx/annotation/NonNull"), new TypeRepr.ClassType("android/support/annotation/NonNull"), new TypeRepr.ClassType("android/annotation/NonNull"), new TypeRepr.ClassType("com/android/annotations/NonNull"), new TypeRepr.ClassType("org/eclipse/jdt/annotation/NonNull"), new TypeRepr.ClassType("org/checkerframework/checker/nullness/qual/NonNull"), new TypeRepr.ClassType("lombok/NonNull"), new TypeRepr.ClassType("io/reactivex/annotations/NonNull"), new TypeRepr.ClassType("io/reactivex/rxjava3/annotations/NonNull"))), AnnotationGroup.of("Deprecation annotations", EnumSet.of(AnnotationGroup.AnnTarget.type, AnnotationGroup.AnnTarget.field, AnnotationGroup.AnnTarget.method), EnumSet.of(AnnotationGroup.AffectionKind.added, AnnotationGroup.AffectionKind.changed), EnumSet.of(AnnotationGroup.AffectionScope.usages), Set.of(new TypeRepr.ClassType("kotlin/Deprecated"), new TypeRepr.ClassType("kotlin/DeprecatedSinceKotlin"))), AnnotationGroup.of("Kotlin JVM specific annotations", EnumSet.of(AnnotationGroup.AnnTarget.type), EnumSet.of(AnnotationGroup.AffectionKind.added, AnnotationGroup.AffectionKind.changed), EnumSet.of(AnnotationGroup.AffectionScope.usages), Set.of(new TypeRepr.ClassType("kotlin/jvm/PurelyImplements"))));

    @Override
    protected Iterable<AnnotationGroup> getTrackedAnnotations() {
        return ourTrackedAnnotations;
    }

    @Override
    public boolean processAddedClasses(DifferentiateContext context, Iterable<JvmClass> addedClasses, Utils future, Utils present) {
        for (JvmClass sealedClass : Utils.uniqueBy(Iterators.filter(Iterators.flat(Iterators.map(addedClasses, future::allDirectSupertypes)), KJvmUtils::isSealed), JVMClassNode::isSame, JVMClassNode::diffHashCode)) {
            if (!sealedClass.isLibrary()) {
                this.affectSealedClass(context, sealedClass.getReferenceID(), "Subclass of a sealed class was added, affecting ", future, false);
            }
            this.affectSealedSubclassUsages(context, sealedClass.getReferenceID(), "Subclass of a sealed class was added, affecting usages of a sealed class' subclass ", present);
        }
        return super.processAddedClasses(context, addedClasses, future, present);
    }

    @Override
    public boolean processAddedClass(DifferentiateContext context, JvmClass addedClass, Utils future, Utils present) {
        if (!addedClass.isPrivate()) {
            KmDeclarationContainer container = KJvmUtils.getDeclarationContainer(addedClass);
            if (container == null || container instanceof KmClass) {
                this.debug(context, "Affecting lookup usages for added class ", addedClass.getName());
                this.affectClassLookupUsages(context, addedClass);
                if (!addedClass.isAnonymous() && !addedClass.isLocal() && !addedClass.isInnerClass() && this.affectConflictingTypeAliasDeclarations(context, addedClass.getReferenceID(), present)) {
                    this.affectSources(context, context.getDelta().getSources(addedClass.getReferenceID()), "Found conflicting type alias declarations", true);
                }
            } else {
                this.debug(context, "Affecting lookup usages for top-level functions properties and type aliases in a newly added file ", addedClass.getName());
                String scopeName = addedClass.getPackageName();
                for (String symbolName : Iterators.unique(Iterators.flat(List.of(Iterators.map(Iterators.filter(container.getFunctions(), f -> !KJvmUtils.isPrivate(f)), KmFunction::getName), Iterators.map(Iterators.filter(container.getProperties(), p -> !KJvmUtils.isPrivate(p)), KmProperty::getName), Iterators.map(Iterators.filter(container.getTypeAliases(), ta -> !KJvmUtils.isPrivate(ta)), KmTypeAlias::getName))))) {
                    context.affectUsage(new LookupNameUsage(scopeName, symbolName));
                    this.debug(context, "Affect ", "lookup '" + symbolName + "'", " usage owned by node '", addedClass.getName(), "'");
                }
                boolean conflictsFound = false;
                for (KmTypeAlias alias : Iterators.filter(container.getTypeAliases(), ta -> !KJvmUtils.isPrivate(ta))) {
                    JvmNodeReferenceID conflictingNodeId = new JvmNodeReferenceID((String)(scopeName.isBlank() ? alias.getName() : scopeName + "." + alias.getName()));
                    conflictsFound |= this.affectConflictingTypeAliasDeclarations(context, conflictingNodeId, present);
                    conflictsFound |= this.affectNodeSourcesIfNotCompiled(context, Iterators.asIterable(conflictingNodeId), present, "Possible conflict with an equally named class in the same compilation chunk; Scheduling for recompilation sources: ");
                }
                if (conflictsFound) {
                    this.affectSources(context, context.getDelta().getSources(addedClass.getReferenceID()), "Found conflicting type alias / class declarations", true);
                }
            }
        }
        return true;
    }

    @Override
    public boolean processRemovedClasses(DifferentiateContext context, Iterable<JvmClass> removedClasses, Utils future, Utils present) {
        for (JvmClass sealedClass : Utils.uniqueBy(Iterators.filter(Iterators.flat(Iterators.map(removedClasses, future::allDirectSupertypes)), KJvmUtils::isSealed), JVMClassNode::isSame, JVMClassNode::diffHashCode)) {
            if (!sealedClass.isLibrary()) {
                this.affectSealedClass(context, sealedClass.getReferenceID(), "Subclass of a sealed class was removed, affecting ", future, false);
            }
            this.affectSealedSubclassUsages(context, sealedClass.getReferenceID(), "Subclass of a sealed class was removed, affecting usages of a sealed class' subclass ", present);
        }
        return super.processRemovedClasses(context, removedClasses, future, present);
    }

    @Override
    public boolean processRemovedClass(DifferentiateContext context, JvmClass removedClass, Utils future, Utils present) {
        KmDeclarationContainer container = KJvmUtils.getDeclarationContainer(removedClass);
        if (!removedClass.isInnerClass() && (container == null && !removedClass.isPrivate() || container instanceof KmClass && !KJvmUtils.isPrivate((KmClass)container))) {
            this.debug(context, "Affecting lookup usages for removed class ", removedClass.getName());
            this.affectClassLookupUsages(context, removedClass);
        }
        if (!removedClass.isPrivate()) {
            HashMap<JvmNodeReferenceID, Iterable<JvmNodeReferenceID>> cache = new HashMap<JvmNodeReferenceID, Iterable<JvmNodeReferenceID>>();
            boolean isDeclarationImportable = container instanceof KmPackage || container instanceof KmClass && Attributes.getKind((KmClass)((KmClass)container)) == ClassKind.COMPANION_OBJECT;
            for (KmFunction kmFunction : Iterators.filter(KJvmUtils.allKmFunctions(removedClass), f -> !KJvmUtils.isPrivate(f))) {
                if (!isDeclarationImportable && !Attributes.isInline((KmFunction)kmFunction)) continue;
                this.debug(context, "Function in a removed class was either importable (a top-level one or a companion object member) or inlineable, affecting method usages ", kmFunction.getName());
                this.affectMemberLookupUsages(context, removedClass, kmFunction.getName(), present, cache);
            }
            for (KmProperty prop : Iterators.filter(KJvmUtils.allKmProperties(removedClass), p -> !KJvmUtils.isPrivate(p))) {
                if (!isDeclarationImportable && !KJvmUtils.isInlinable(prop)) continue;
                this.debug(context, "Property in a removed class was a constant or had inlineable accessors or was importable (a top-level one or a companion object member), affecting property usages ", prop.getName());
                this.affectMemberLookupUsages(context, removedClass, prop.getName(), present, cache);
            }
        }
        return true;
    }

    @Override
    public boolean processChangedClass(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Utils future, Utils present) {
        boolean hierarchyChanged;
        JvmClass changedClass = change.getPast();
        JvmClass.Diff diff = change.getDiff();
        Iterable<JvmMethod> removedMethods = diff.methods().removed();
        Iterable<JvmField> addedNonPrivateFields = Iterators.filter(diff.fields().added(), f -> !f.isPrivate());
        Iterable<JvmField> exposedFields = Iterators.filter(Iterators.map(diff.fields().changed(), ch -> ((JvmField.Diff)ch.getDiff()).accessExpanded() ? (JvmField)ch.getPast() : null), Objects::nonNull);
        boolean bl = hierarchyChanged = diff.superClassChanged() || !diff.interfaces().unchanged();
        if (hierarchyChanged) {
            boolean extendsChanged;
            boolean bl2 = extendsChanged = diff.superClassChanged() && !diff.extendsAdded();
            if (extendsChanged || !Iterators.isEmpty(diff.interfaces().removed())) {
                this.debug(context, "Affecting class lookups due to changes in class hierarchy");
                for (JvmClass jvmClass : Iterators.flat(Iterators.map(future.withAllSubclasses(change.getNow().getReferenceID()), id -> future.getNodes((ReferenceID)id, JvmClass.class)))) {
                    this.affectClassLookupUsages(context, jvmClass);
                }
            }
        }
        if (KJvmUtils.isKotlinNode(changedClass)) {
            if (hierarchyChanged && !changedClass.isLibrary()) {
                Difference.Specifier<JvmNodeReferenceID, ?> sealedDiff = Difference.diff(Iterators.map(Iterators.filter(present.allDirectSupertypes(change.getPast()), KJvmUtils::isSealed), JVMClassNode::getReferenceID), Iterators.map(Iterators.filter(future.allDirectSupertypes(change.getNow()), KJvmUtils::isSealed), JVMClassNode::getReferenceID));
                for (JvmNodeReferenceID jvmNodeReferenceID : sealedDiff.added()) {
                    this.affectSealedClass(context, jvmNodeReferenceID, "Subclass of a sealed class was added, affecting ", future, true);
                }
                for (JvmNodeReferenceID jvmNodeReferenceID : sealedDiff.removed()) {
                    this.affectSealedClass(context, jvmNodeReferenceID, "Subclass of a sealed class was removed, affecting ", future, true);
                }
            }
            if (KJvmUtils.isSealed(change.getNow())) {
                KmClass kmClass = (KmClass)KJvmUtils.getDeclarationContainer(change.getNow());
                assert (kmClass != null);
                Difference.Specifier<String, ?> subclassesDiff = Difference.diff(Iterators.filter(Iterators.map(future.directSubclasses(changedClass.getReferenceID()), subId -> subId instanceof JvmNodeReferenceID ? KJvmUtils.getKotlinName((JvmNodeReferenceID)subId, future) : null), Objects::nonNull), Iterators.map(kmClass.getSealedSubclasses(), name -> name.replace('.', '/')));
                if (!subclassesDiff.unchanged()) {
                    this.affectSealedClass(context, changedClass.getReferenceID(), "Subclasses registered in the metadata of a sealed class differ from the list of subclasses found in the dependency graph. Recompiling the sealed class with its subclasses", future, false);
                }
            } else if (KJvmUtils.isSealed(change.getPast())) {
                this.affectSealedSubclassUsages(context, changedClass.getReferenceID(), "A sealed class is not sealed anymore, affecting its subclass usages ", present);
            }
        }
        if (!(Iterators.isEmpty(removedMethods) && Iterators.isEmpty(addedNonPrivateFields) && Iterators.isEmpty(exposedFields))) {
            block3: for (PropertyDescriptor property : KotlinJvmDifferentiateStrategy.findProperties(changedClass)) {
                for (JvmMethod jvmMethod : removedMethods) {
                    if (!jvmMethod.isSame(property.getter) || property.setter == null) continue;
                    this.debug(context, "Kotlin interop: a property getter ", jvmMethod.getName(), " was removed => affecting usages of corresponding setter ", property.setter.getName());
                    this.affectMemberUsages(context, changedClass.getReferenceID(), property.setter, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), property.setter));
                    break;
                }
                for (JvmField jvmField : Iterators.flat(addedNonPrivateFields, exposedFields)) {
                    if (!Objects.equals(jvmField.getName(), property.getter.getName()) && !property.name.equalsIgnoreCase(jvmField.getName())) continue;
                    this.debug(context, "Kotlin interop: a non-private field with name ", jvmField.getName(), " was added, or the field became more accessible");
                    this.debug(context, " => affecting usages of corresponding property getter ", property.getter.getName());
                    this.affectMemberUsages(context, changedClass.getReferenceID(), property.getter, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), property.getter));
                    if (property.setter == null) continue block3;
                    this.debug(context, " => affecting usages of corresponding property setter ", property.setter.getName());
                    this.affectMemberUsages(context, changedClass.getReferenceID(), property.setter, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), property.setter));
                    continue block3;
                }
            }
        }
        if (!present.isLambdaTarget(change.getPast()) && future.isLambdaTarget(change.getNow())) {
            TypeRepr.ClassType samType = new TypeRepr.ClassType(changedClass.getName());
            for (JvmClass jvmClass : Iterators.flat(Iterators.map(context.getGraph().getDependingNodes(changedClass.getReferenceID()), dep -> present.getNodes((ReferenceID)dep, JvmClass.class)))) {
                for (JvmMethod methodWithSAMType : Iterators.filter(jvmClass.getMethods(), m -> Iterators.contains(m.getArgTypes(), samType))) {
                    this.affectConflictingCallExpressions(context, jvmClass, methodWithSAMType, present, null);
                }
            }
        }
        HashMap<JvmNodeReferenceID, Iterable<JvmNodeReferenceID>> cache = new HashMap<JvmNodeReferenceID, Iterable<JvmNodeReferenceID>>();
        for (Difference.Change change2 : diff.metadata(KotlinMeta.class).changed()) {
            int n;
            KmDeclarationContainer container;
            KotlinMeta.Diff diff2 = (KotlinMeta.Diff)change2.getDiff();
            if (diff2.typeParametersVarianceChanged()) {
                this.debug(context, "Kotlin class' type parameters' variance changed; affecting class usage ", changedClass.getName());
                this.affectSubclasses(context, future, change.getNow().getReferenceID(), true);
            }
            if (diff2.containerAccessRestricted()) {
                this.debug(context, "Kotlin class' visibility restricted; affecting class lookup usage ", changedClass.getName());
                this.affectClassLookupUsages(context, changedClass);
            }
            if ((container = ((KotlinMeta)change2.getPast()).getDeclarationContainer()) != null && diff2.kindChanged() && ((KotlinMeta)change2.getPast()).isTopLevelDeclarationContainer() != ((KotlinMeta)change2.getNow()).isTopLevelDeclarationContainer()) {
                this.debug(context, "Declaration container has changed its kind => affecting lookup usages of containing declarations ", changedClass.getName());
                for (KmFunction kmFunction : Iterators.filter(container.getFunctions(), f -> !KJvmUtils.isPrivate(f))) {
                    this.affectMemberLookupUsages(context, changedClass, kmFunction.getName(), present, cache);
                }
                for (KmProperty kmProperty : Iterators.filter(container.getProperties(), p -> !KJvmUtils.isPrivate(p))) {
                    this.affectMemberLookupUsages(context, changedClass, kmProperty.getName(), present, cache);
                }
                for (KmTypeAlias kmTypeAlias : Iterators.filter(container.getTypeAliases(), ta -> !KJvmUtils.isPrivate(ta))) {
                    this.affectMemberLookupUsages(context, changedClass, kmTypeAlias.getName(), present, cache);
                }
            }
            boolean isDeclarationImportable = container instanceof KmPackage || container instanceof KmClass && Attributes.getKind((KmClass)((KmClass)container)) == ClassKind.COMPANION_OBJECT;
            for (KmFunction kmFunction : diff2.functions().removed()) {
                JvmMethod jvmMethod;
                if (KJvmUtils.isPrivate(kmFunction)) continue;
                if (isDeclarationImportable || Attributes.isInline((KmFunction)kmFunction)) {
                    this.debug(context, "Removed function was either importable (a top-level one or a companion object member) or inlineable, affecting function usages ", kmFunction.getName());
                    this.affectMemberLookupUsages(context, changedClass, kmFunction.getName(), present, cache);
                }
                if ((jvmMethod = KotlinJvmDifferentiateStrategy.getJvmMethod(change.getNow(), JvmExtensionsKt.getSignature((KmFunction)kmFunction))) == null) continue;
                for (JvmClass subClass : Iterators.filter(Iterators.flat(Iterators.map(future.allSubclasses(changedClass.getReferenceID()), id -> future.getNodes((ReferenceID)id, JvmClass.class))), KJvmUtils::isKotlinNode)) {
                    if (Iterators.find(subClass.getMethods(), m -> !m.isPrivate() && method.isSameByJavaRules((JvmMethod)m)) == null) continue;
                    this.affectNodeSources(context, subClass.getReferenceID(), "Kotlin function " + kmFunction.getName() + " has been removed. Affecting corresponding method in subclasses: ", future);
                }
            }
            for (KmFunction kmFunction : Iterators.flat(diff2.functions().removed(), diff2.functions().added())) {
                if (KJvmUtils.isPrivate(kmFunction) || Iterators.find(kmFunction.getValueParameters(), Attributes::getDeclaresDefaultValue) == null) continue;
                this.debug(context, "Removed or added function declares default values: ", changedClass.getName());
                this.affectMemberLookupUsages(context, changedClass, kmFunction.getName(), future, cache);
            }
            for (Difference.Change<KmFunction, KotlinMeta.KmFunctionsDiff> change3 : diff2.functions().changed()) {
                KmFunction kmFunction = change3.getPast();
                if (KJvmUtils.isPrivate(kmFunction)) continue;
                KotlinMeta.KmFunctionsDiff funDiff = change3.getDiff();
                if (funDiff.accessRestricted() || funDiff.becameNullable() || funDiff.argsBecameNotNull() || funDiff.parameterArgumentsChanged()) {
                    this.debug(context, "One of function's parameters or return value has become non-nullable, or the function has become less accessible or type parameter's arguments changed ", kmFunction.getName());
                    JvmMethod jvmMethod = KotlinJvmDifferentiateStrategy.getJvmMethod(changedClass, JvmExtensionsKt.getSignature((KmFunction)kmFunction));
                    if (jvmMethod != null) {
                        for (JvmMethod method : KotlinJvmDifferentiateStrategy.withJvmOverloads(changedClass, jvmMethod)) {
                            for (Pair<JvmClass, JvmMethod> pair : future.getOverridingMethods(changedClass, method, method::isSameByJavaRules)) {
                                this.affectNodeSources(context, ((JvmClass)pair.first).getReferenceID(), "Affect class where the function is overridden: ", future);
                            }
                            this.affectMemberUsages(context, changedClass.getReferenceID(), method, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), method));
                        }
                    }
                    if (KJvmUtils.isDeclaresDefaultValue(kmFunction)) {
                        this.debug(context, "One of method's parameters or method's return value has become non-nullable; or function has become less accessible: ", kmFunction.getName());
                        this.affectMemberLookupUsages(context, changedClass, kmFunction.getName(), future, cache);
                    }
                }
                if (!funDiff.receiverParameterChanged() && !funDiff.hasDefaultDeclarationChanges()) continue;
                this.debug(context, "Function's receiver parameter changed or function has breaking changes in default value declarations: ", kmFunction.getName());
                this.affectMemberLookupUsages(context, changedClass, kmFunction.getName(), future, cache);
            }
            for (KmConstructor kmConstructor : Iterators.flat(diff2.constructors().removed(), diff2.constructors().added())) {
                if (KJvmUtils.isPrivate(Attributes.getVisibility((KmConstructor)kmConstructor)) || Iterators.find(kmConstructor.getValueParameters(), Attributes::getDeclaresDefaultValue) == null) continue;
                this.debug(context, "Removed or added constructor declares default values: ", changedClass.getName());
                this.affectClassLookupUsages(context, changedClass);
            }
            for (Difference.Change<KmConstructor, KotlinMeta.KmConstructorsDiff> change4 : diff2.constructors().changed()) {
                KotlinMeta.KmConstructorsDiff conDiff;
                KmConstructor kmConstructor = change4.getPast();
                if (KJvmUtils.isPrivate(Attributes.getVisibility((KmConstructor)kmConstructor)) || !(conDiff = change4.getDiff()).argsBecameNotNull() && !conDiff.accessRestricted() && !conDiff.hasDefaultDeclarationChanges()) continue;
                this.debug(context, "Constructor's args became non-nullable; or the constructor has become less accessible or has breaking changes in default value declarations: ", changedClass.getName());
                this.affectClassLookupUsages(context, changedClass);
            }
            for (KmProperty kmProperty : diff2.properties().removed()) {
                List<JvmMethodSignature> list;
                List accessorMethods;
                if (KJvmUtils.isPrivate(kmProperty)) continue;
                if (KJvmUtils.isInlinable(kmProperty)) {
                    this.debug(context, "Removed property was inlineable, affecting property usages ", kmProperty.getName());
                    this.affectMemberLookupUsages(context, changedClass, kmProperty.getName(), present, cache);
                }
                if ((accessorMethods = (List)Iterators.collect(Iterators.filter(Iterators.map(list = Arrays.asList(JvmExtensionsKt.getGetterSignature((KmProperty)kmProperty), JvmExtensionsKt.getSetterSignature((KmProperty)kmProperty)), acc -> acc != null ? KotlinJvmDifferentiateStrategy.getJvmMethod((JvmClass)change.getNow(), acc) : null), m -> m != null && !m.isPrivate()), new ArrayList())).isEmpty()) continue;
                for (JvmClass subClass : Iterators.filter(Iterators.flat(Iterators.map(future.allSubclasses(changedClass.getReferenceID()), id -> future.getNodes((ReferenceID)id, JvmClass.class))), KJvmUtils::isKotlinNode)) {
                    if (Iterators.find(subClass.getMethods(), m -> {
                        if (m.isPrivate()) return false;
                        if (Iterators.find(accessorMethods, m::isSameByJavaRules) == null) return false;
                        return true;
                    }) == null) continue;
                    this.affectNodeSources(context, subClass.getReferenceID(), "Kotlin property " + kmProperty.getName() + " has been removed. Affecting corresponding accessor method(s) in subclasses: ", future);
                }
            }
            for (Difference.Change<KmProperty, KotlinMeta.KmPropertiesDiff> change5 : diff2.properties().changed()) {
                JvmMethod setter;
                KmPropertyAccessorAttributes propSetter;
                JvmMethod getter;
                KmProperty kmProperty = change5.getPast();
                KotlinMeta.KmPropertiesDiff propDiff = change5.getDiff();
                String affectLookupUsagesReason = null;
                if (propDiff.accessRestricted()) {
                    affectLookupUsagesReason = "Property has become less accessible; affecting its lookup usages ";
                } else if (propDiff.customAccessorAdded()) {
                    affectLookupUsagesReason = "Custom accessors were added to a property; affecting its lookup usages ";
                } else if (propDiff.mutabilityChanged()) {
                    affectLookupUsagesReason = "Property mutability has changed (val <=> var); affecting its lookup usages ";
                }
                if (affectLookupUsagesReason != null) {
                    this.debug(context, affectLookupUsagesReason, kmProperty.getName());
                    this.affectMemberLookupUsages(context, changedClass, kmProperty.getName(), future, cache);
                }
                if (!KJvmUtils.isPrivate(Attributes.getVisibility((KmPropertyAccessorAttributes)kmProperty.getGetter())) && (propDiff.becameNullable() || propDiff.getterAccessRestricted()) && (getter = KotlinJvmDifferentiateStrategy.getJvmMethod(changedClass, JvmExtensionsKt.getGetterSignature((KmProperty)kmProperty))) != null && !getter.getFlags().isPrivate()) {
                    this.debug(context, "A property has become nullable or its getter has become less accessible; affecting getter usages ", getter);
                    this.affectMemberUsages(context, changedClass.getReferenceID(), getter, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), getter));
                }
                if ((propSetter = kmProperty.getSetter()) == null || KJvmUtils.isPrivate(Attributes.getVisibility((KmPropertyAccessorAttributes)propSetter)) || !propDiff.becameNotNull() && !propDiff.setterAccessRestricted() || (setter = KotlinJvmDifferentiateStrategy.getJvmMethod(changedClass, JvmExtensionsKt.getSetterSignature((KmProperty)kmProperty))) == null) continue;
                this.debug(context, "A property has become not-null or its setter has become less accessible; affecting setter usages ", setter);
                this.affectMemberUsages(context, changedClass.getReferenceID(), setter, future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), setter));
            }
            for (KmTypeAlias kmTypeAlias : Iterators.filter(diff2.typeAliases().removed(), ta -> !KJvmUtils.isPrivate(ta))) {
                this.debug(context, "A type alias declaration was removed; affecting lookup usages ", kmTypeAlias.getName());
                this.affectMemberLookupUsages(context, changedClass, kmTypeAlias.getName(), future, cache);
            }
            boolean bl3 = false;
            for (KmTypeAlias kmTypeAlias : Iterators.filter(diff2.typeAliases().added(), ta -> !KJvmUtils.isPrivate(ta))) {
                this.debug(context, "A type alias declaration was added; affecting lookup usages ", kmTypeAlias.getName());
                this.affectMemberLookupUsages(context, changedClass, kmTypeAlias.getName(), future, cache);
                String scopeName = changedClass.getPackageName();
                JvmNodeReferenceID conflictingNodeId = new JvmNodeReferenceID((String)(scopeName.isBlank() ? kmTypeAlias.getName() : scopeName + "." + kmTypeAlias.getName()));
                n |= this.affectConflictingTypeAliasDeclarations(context, conflictingNodeId, present);
                n |= this.affectNodeSourcesIfNotCompiled(context, Iterators.asIterable(conflictingNodeId), present, "Possible conflict with an equally named class in the same compilation chunk; Scheduling for recompilation sources: ");
            }
            if (n != 0) {
                this.affectSources(context, context.getDelta().getSources(changedClass.getReferenceID()), "Found conflicting type alias declarations", true);
            }
            for (Difference.Change<KmTypeAlias, KotlinMeta.KmTypeAliasDiff> change6 : diff2.typeAliases().changed()) {
                KotlinMeta.KmTypeAliasDiff aDiff = change6.getDiff();
                if (!aDiff.accessRestricted() && !aDiff.underlyingTypeChanged()) continue;
                KmTypeAlias changedAlias = change6.getPast();
                this.debug(context, "A type alias declaration has access restricted or underlying type has changed; affecting lookup usages ", changedAlias.getName());
                this.affectMemberLookupUsages(context, changedClass, changedAlias.getName(), future, cache);
            }
        }
        return super.processChangedClass(context, change, future, present);
    }

    @Override
    public boolean processAddedMethod(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, JvmMethod addedMethod, Utils future, Utils present) {
        KmFunction kmFunction;
        JvmClass changedClass = change.getNow();
        MethodUsage addedMethodUsage = addedMethod.createUsage(changedClass.getReferenceID());
        this.affectConflictingCallExpressions(context, changedClass, addedMethod, future, n -> !Iterators.contains(n.getUsages(), addedMethodUsage));
        if (!changedClass.isPrivate() && "invoke".equals(addedMethod.getName()) && (kmFunction = KotlinJvmDifferentiateStrategy.getKmFunction(changedClass, addedMethod)) != null && Attributes.isOperator((KmFunction)kmFunction)) {
            this.debug(context, "Operator method invoke() has been added. Affecting classes instantiations '", changedClass.getName());
            context.affectUsage(new ClassNewUsage(changedClass.getReferenceID()), KJvmUtils::isKotlinNode);
        }
        return true;
    }

    @Override
    public boolean processChangedMethod(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> clsChange, Difference.Change<JvmMethod, JvmMethod.Diff> methodChange, Utils future, Utils present) {
        JvmClass changedClass = clsChange.getPast();
        JvmMethod changedMethod = methodChange.getPast();
        if (!changedMethod.isPrivate() && methodChange.getDiff().valueChanged()) {
            String name = KJvmUtils.getMethodKotlinName(changedClass, changedMethod);
            this.debug(context, "Function was inlineable, or has become inlineable or a body of inline method has changed; affecting method usages ", name);
            this.affectMemberLookupUsages(context, changedClass, name, future, null);
        }
        return super.processChangedMethod(context, clsChange, methodChange, future, present);
    }

    @Override
    public boolean processRemovedField(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, JvmField removedField, Utils future, Utils present) {
        if (!removedField.isPrivate() && removedField.isInlinable() && removedField.getValue() != null) {
            this.debug(context, "Field had value and was (non-private) final; affecting usages in Kotlin sources ");
            JvmClass changedClass = change.getPast();
            this.affectLookupUsages(context, Iterators.flat(Iterators.asIterable(changedClass.getReferenceID()), present.collectSubclassesWithoutField(changedClass.getReferenceID(), removedField)), removedField.getName(), present, null);
        }
        return true;
    }

    @Override
    public boolean processChangedField(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> clsChange, Difference.Change<JvmField, JvmField.Diff> fieldChange, Utils future, Utils present) {
        JvmField.Diff diff;
        JvmClass changedClass = clsChange.getPast();
        JvmField changedField = fieldChange.getPast();
        if (!changedField.isPrivate() && changedField.isInlinable() && changedField.getValue() != null && ((diff = fieldChange.getDiff()).valueChanged() || diff.accessRestricted() || Iterators.find(List.of(diff.getAddedFlags(), diff.getRemovedFlags()), f -> f.isStatic() || f.isFinal()) != null)) {
            this.debug(context, "Potentially inlined field changed its access or value; affecting usages in Kotlin sources ");
            this.affectLookupUsages(context, Iterators.flat(Iterators.asIterable(changedClass.getReferenceID()), present.collectSubclassesWithoutField(changedClass.getReferenceID(), changedField)), changedField.getName(), present, null);
        }
        return super.processChangedField(context, clsChange, fieldChange, future, present);
    }

    @Override
    public boolean processNodesWithErrors(DifferentiateContext context, Iterable<JVMClassNode<?, ?>> nodes, Utils present) {
        HashMap<JvmNodeReferenceID, Iterable<JvmNodeReferenceID>> cache = new HashMap<JvmNodeReferenceID, Iterable<JvmNodeReferenceID>>();
        for (JvmClass jvmClass : Graph.getNodesOfType(nodes, JvmClass.class)) {
            for (JvmField field : Iterators.filter(jvmClass.getFields(), f -> !f.isPrivate() && f.isInlinable() && f.getValue() != null)) {
                this.debug(context, "Potentially inlined field is contained in a source compiled with errors; affecting lookup usages in Kotlin sources ");
                this.affectLookupUsages(context, Iterators.flat(Iterators.asIterable(jvmClass.getReferenceID()), present.collectSubclassesWithoutField(jvmClass.getReferenceID(), field)), field.getName(), present, null);
            }
            for (JvmMethod method : Iterators.filter(jvmClass.getMethods(), m -> !m.isPrivate() && m.getValue() != null)) {
                String name = KJvmUtils.getMethodKotlinName(jvmClass, method);
                this.debug(context, "Inlinable function is contained in a source compiled with errors; affecting lookup usages in Kotlin sources ", name);
                this.affectMemberLookupUsages(context, jvmClass, name, present, cache);
            }
            for (KmFunction kmFunction : Iterators.filter(KJvmUtils.allKmFunctions(jvmClass), f -> !KJvmUtils.isPrivate(f))) {
                if (!Attributes.isInline((KmFunction)kmFunction)) continue;
                this.debug(context, "Inlinable function is contained in a source compiled with errors; affecting lookup usages ", kmFunction.getName());
                this.affectMemberLookupUsages(context, jvmClass, kmFunction.getName(), present, cache);
            }
            for (KmProperty prop : Iterators.filter(KJvmUtils.allKmProperties(jvmClass), p -> !KJvmUtils.isPrivate(p))) {
                if (!KJvmUtils.isInlinable(prop)) continue;
                this.debug(context, "Inlinable property or its accessors is contained in a source compiled with errors; affecting property lookup usages ", prop.getName());
                this.affectMemberLookupUsages(context, jvmClass, prop.getName(), present, cache);
            }
            KotlinMeta meta = KJvmUtils.getKotlinMeta(jvmClass);
            for (KmTypeAlias alias : Iterators.filter(meta != null ? meta.getKmTypeAliases() : List.of(), a -> !KJvmUtils.isPrivate(Attributes.getVisibility((KmTypeAlias)a)))) {
                this.debug(context, "A type alias declaration is contained in a source compiled with errors; affecting lookup usages ", alias.getName());
                this.affectMemberLookupUsages(context, jvmClass, alias.getName(), present, cache);
            }
        }
        return true;
    }

    @Override
    protected void affectMethodAnnotationUsages(DifferentiateContext context, Set<AnnotationGroup.AffectionScope> toRecompile, Difference.Change<JvmClass, JvmClass.Diff> clsChange, JvmMethod changedMethod, Utils future, Utils present) {
        super.affectMethodAnnotationUsages(context, toRecompile, clsChange, changedMethod, future, present);
        if (toRecompile.contains((Object)AnnotationGroup.AffectionScope.usages)) {
            JvmClass changedClass = clsChange.getPast();
            this.affectMemberLookupUsages(context, changedClass, KJvmUtils.getMethodKotlinName(changedClass, changedMethod), present, null);
        }
    }

    @Override
    protected void affectClassAnnotationUsages(DifferentiateContext context, Set<AnnotationGroup.AffectionScope> toRecompile, Difference.Change<JvmClass, JvmClass.Diff> change, Utils future, Utils present) {
        super.affectClassAnnotationUsages(context, toRecompile, change, future, present);
        if (toRecompile.contains((Object)AnnotationGroup.AffectionScope.usages)) {
            this.affectClassLookupUsages(context, change.getPast());
        }
    }

    private void affectConflictingCallExpressions(DifferentiateContext context, JvmClass cls, JvmMethod clsMethod, Utils utils, @Nullable Predicate<Node<?, ?>> constraint) {
        if (clsMethod.isPrivate() || clsMethod.isStaticInitializer()) {
            return;
        }
        if (clsMethod.isConstructor()) {
            this.affectClassLookupUsages(context, cls);
        } else {
            Set targets = Iterators.collect(Iterators.flat(utils.allSupertypes(cls.getReferenceID()), utils.collectSubclassesWithoutMethod(cls.getReferenceID(), clsMethod)), new HashSet());
            targets.add(cls.getReferenceID());
            this.affectLookupUsages(context, targets, KJvmUtils.getMethodKotlinName(cls, clsMethod), utils, constraint);
        }
    }

    private static Iterable<PropertyDescriptor> findProperties(JvmClass cls) {
        HashMap<String, JvmMethod> getters = new HashMap<String, JvmMethod>();
        HashMap<String, List> setters = new HashMap<String, List>();
        for (JvmMethod method : cls.getMethods()) {
            String methodName = method.getName();
            if (KotlinJvmDifferentiateStrategy.isGetter(method)) {
                getters.put(methodName.substring(methodName.startsWith("is") ? 2 : 3), method);
                continue;
            }
            if (!KotlinJvmDifferentiateStrategy.isSetter(method)) continue;
            setters.computeIfAbsent(methodName.substring(3), k -> new ArrayList()).add(method);
        }
        return Iterators.map(getters.entrySet(), e -> {
            String propName = (String)e.getKey();
            JvmMethod getter = (JvmMethod)e.getValue();
            Iterator<JvmMethod> iterator = Iterators.filter((Iterable)setters.get(propName), s -> Objects.equals(s.getArgTypes().iterator().next(), getter.getType())).iterator();
            if (iterator.hasNext()) {
                JvmMethod setter = iterator.next();
                return new PropertyDescriptor(propName, getter, setter);
            }
            return new PropertyDescriptor(propName, getter, null);
        });
    }

    private static boolean isSetter(JvmMethod method) {
        String name = method.getName();
        return name.length() > 3 && name.startsWith("set") && "V".equals(method.getType().getDescriptor()) && KotlinJvmDifferentiateStrategy.sizeEqual(method.getArgTypes(), 1);
    }

    private static boolean isGetter(JvmMethod method) {
        if (!Iterators.isEmpty(method.getArgTypes())) {
            return false;
        }
        String name = method.getName();
        if (name.length() > 3 && name.startsWith("get")) {
            return true;
        }
        if (name.length() > 2 && name.startsWith("is")) {
            TypeRepr returnType = method.getType();
            return TypeRepr.PrimitiveType.BOOLEAN.equals(returnType) || TypeRepr.ClassType.BOOLEAN.equals(returnType);
        }
        return false;
    }

    private static boolean sizeEqual(Iterable<?> it, int expectedSize) {
        if (it instanceof Collection) {
            return expectedSize == ((Collection)it).size();
        }
        Iterator<?> iterator = it.iterator();
        while (expectedSize-- > 0) {
            if (!iterator.hasNext()) {
                return false;
            }
            iterator.next();
        }
        return !iterator.hasNext();
    }

    private void affectClassLookupUsages(DifferentiateContext context, JvmClass cls) {
        String name;
        String scope;
        String ktName;
        KmDeclarationContainer container = KJvmUtils.getDeclarationContainer(cls);
        if (container != null && !(container instanceof KmClass)) {
            return;
        }
        String string = ktName = container != null ? KJvmUtils.getKotlinName(cls) : null;
        if (ktName != null) {
            scope = JvmClass.getPackageName(ktName);
            name = scope.isEmpty() ? ktName : ktName.substring(scope.length() + 1);
        } else {
            scope = cls.isInnerClass() ? cls.getOuterFqName().replace('$', '/') : cls.getPackageName();
            name = cls.getShortName();
        }
        this.affectUsages(context, "lookup '" + name + "'", Iterators.asIterable(new JvmNodeReferenceID(scope)), id -> new LookupNameUsage((JvmNodeReferenceID)id, name), null);
    }

    private void affectMemberLookupUsages(DifferentiateContext context, JvmClass cls, String name, Utils utils, @Nullable Map<JvmNodeReferenceID, Iterable<JvmNodeReferenceID>> cache) {
        if (!"<init>".equals(name) && !"<clinit>".equals(name)) {
            Function<JvmNodeReferenceID, Iterable> mapper = clsId -> Iterators.collect(Iterators.filter(Iterators.map(utils.withAllSubclasses((ReferenceID)clsId), id -> id instanceof JvmNodeReferenceID ? (JvmNodeReferenceID)id : null), Objects::nonNull), new HashSet());
            this.affectLookupUsages(context, cache != null ? cache.computeIfAbsent(cls.getReferenceID(), mapper) : mapper.apply(cls.getReferenceID()), name, utils, null);
        }
    }

    private void affectLookupUsages(DifferentiateContext context, Iterable<JvmNodeReferenceID> symbolOwners, String symbolName, Utils utils, @Nullable Predicate<Node<?, ?>> constraint) {
        Iterable<JvmNodeReferenceID> owners = Iterators.filter(Iterators.flat(symbolOwners, Iterators.map(symbolOwners, o -> {
            String original = o.getNodeName();
            String normalized = original.replace('$', '/');
            return normalized.equals(original) ? null : new JvmNodeReferenceID(normalized);
        })), Objects::nonNull);
        this.affectUsages(context, "lookup '" + symbolName + "'", owners, id -> {
            String kotlinName = KJvmUtils.getKotlinName(id, utils);
            return new LookupNameUsage(kotlinName != null ? new JvmNodeReferenceID(kotlinName) : id, symbolName);
        }, constraint);
    }

    private void affectSealedClass(DifferentiateContext context, JvmNodeReferenceID sealedClassId, String affectReason, Utils utils, boolean affectSubclassUsages) {
        Set sourcesToAffect = Iterators.collect(Iterators.flat(Iterators.map(KJvmUtils.withAllSubclassesIfSealed(utils, sealedClassId), utils::getNodeSources)), new HashSet());
        if (Iterators.find(sourcesToAffect, src -> !context.isCompiled((NodeSource)src)) != null) {
            this.affectSources(context, sourcesToAffect, affectReason, true);
        }
        if (affectSubclassUsages) {
            this.affectSealedSubclassUsages(context, sealedClassId, "Affecting usages of a sealed class' subclass ", utils);
        }
    }

    private void affectSealedSubclassUsages(DifferentiateContext context, JvmNodeReferenceID sealedClassId, String affectReason, Utils utils) {
        for (ReferenceID id : utils.directSubclasses(sealedClassId)) {
            String nodeName = utils.getNodeName(id);
            if (nodeName == null) continue;
            this.debug(context, affectReason, nodeName);
            context.affectUsage(new ClassUsage(nodeName));
        }
    }

    private static KmFunction getKmFunction(JvmClass cls, JvmMethod method) {
        JvmMethodSignature methodSignature = new JvmMethodSignature(method.getName(), method.getDescriptor());
        return Iterators.find(KJvmUtils.allKmFunctions(cls), f -> methodSignature.equals((Object)JvmExtensionsKt.getSignature((KmFunction)f)));
    }

    @Nullable
    private static JvmMethod getJvmMethod(JvmClass cls, JvmMethodSignature sig) {
        return sig != null ? Iterators.find(cls.getMethods(), m -> Objects.equals(m.getName(), sig.getName()) && Objects.equals(m.getDescriptor(), sig.getDescriptor())) : null;
    }

    private static Iterable<JvmMethod> withJvmOverloads(JvmClass cls, JvmMethod method) {
        return Iterators.unique(Iterators.flat(Iterators.asIterable(method), Iterators.filter(cls.getMethods(), m -> Objects.equals(m.getName(), method.getName()) && Objects.equals(m.getType(), method.getType()) && Iterators.contains(Iterators.map(m.getAnnotations(), AnnotationInstance::getAnnotationClass), JVM_OVERLOADS_ANNOTATION))));
    }

    private boolean affectConflictingTypeAliasDeclarations(DifferentiateContext context, JvmNodeReferenceID typeAliasId, Utils utils) {
        BackDependencyIndex aliasIndex = Objects.requireNonNull(context.getGraph().getIndex("type-aliases"));
        return this.affectNodeSourcesIfNotCompiled(context, aliasIndex.getDependencies(typeAliasId), utils, "Possible conflict with an equally named type alias in the same compilation chunk; Scheduling for recompilation sources: ");
    }

    private static final class PropertyDescriptor {
        @NotNull
        final String name;
        @NotNull
        final JvmMethod getter;
        @Nullable
        final JvmMethod setter;

        PropertyDescriptor(@NotNull String name, @NotNull JvmMethod getter, @Nullable JvmMethod setter) {
            if (name == null) {
                PropertyDescriptor.$$$reportNull$$$0(0);
            }
            if (getter == null) {
                PropertyDescriptor.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.getter = getter;
            this.setter = setter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "getter";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/dependency/kotlin/KotlinJvmDifferentiateStrategy$PropertyDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

