/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiMethodTreeElement
extends JavaClassTreeElementBase<PsiMethod>
implements SortableTreeElement {
    public PsiMethodTreeElement(PsiMethod method, boolean isInherited) {
        super(isInherited, method);
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        List<StructureViewTreeElement> emptyResult = Collections.emptyList();
        PsiMethod element = (PsiMethod)this.getElement();
        if (element == null || element instanceof SyntheticElement || element instanceof LightElement) {
            List<StructureViewTreeElement> list = emptyResult;
            if (list == null) {
                PsiMethodTreeElement.$$$reportNull$$$0(0);
            }
            return list;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || psiFile instanceof PsiCompiledElement) {
            List<StructureViewTreeElement> list = emptyResult;
            if (list == null) {
                PsiMethodTreeElement.$$$reportNull$$$0(1);
            }
            return list;
        }
        final ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>();
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(aClass instanceof PsiAnonymousClass) && !(aClass instanceof PsiTypeParameter)) {
                    result.add(new JavaClassTreeElement(aClass, PsiMethodTreeElement.this.isInherited()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/ide/structureView/impl/java/PsiMethodTreeElement$1", "visitClass"));
            }
        });
        ArrayList<StructureViewTreeElement> arrayList = result;
        if (arrayList == null) {
            PsiMethodTreeElement.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public String getPresentableText() {
        PsiMethod method = (PsiMethod)this.getElement();
        if (method == null) {
            return "";
        }
        boolean dumb = DumbService.isDumb((Project)method.getProject());
        return PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)(0x105 | (dumb ? 0 : 2)), (int)(dumb ? 1 : 2));
    }

    @Override
    public String getLocationString() {
        if (!Registry.is((String)"show.method.base.class.in.java.file.structure")) {
            return null;
        }
        PsiMethod method = (PsiMethod)this.getElement();
        if (this.myLocation == null && method != null && !DumbService.isDumb((Project)method.getProject())) {
            if (this.isInherited()) {
                return super.getLocationString();
            }
            try {
                PsiMethod base;
                PsiClass baseClass;
                MethodSignatureBackedByPsiMethod baseMethod = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
                if (baseMethod != null && !method.isEquivalentTo((PsiElement)baseMethod.getMethod()) && (baseClass = (base = baseMethod.getMethod()).getContainingClass()) != null && baseClass.getMethods().length > 1) {
                    this.myLocation = baseClass.getName();
                }
            }
            catch (IndexNotReadyException baseMethod) {
                // empty catch block
            }
            if (StringUtil.isEmpty((String)this.myLocation)) {
                this.myLocation = "";
            } else {
                char upArrow = '\u2191';
                this.myLocation = StartupUiUtil.getLabelFont().canDisplay(upArrow) ? upArrow + this.myLocation : this.myLocation;
            }
        }
        return StringUtil.isEmpty((String)this.myLocation) ? null : this.myLocation;
    }

    public PsiMethod getMethod() {
        return (PsiMethod)this.getElement();
    }

    @NotNull
    public String getAlphaSortKey() {
        PsiMethod method = (PsiMethod)this.getElement();
        if (method != null) {
            String string = method.getName() + " " + StringUtil.join((Object[])method.getParameterList().getParameters(), psiParameter -> {
                PsiTypeElement typeElement = psiParameter.getTypeElement();
                return typeElement != null ? typeElement.getText() : "";
            }, (String)" ");
            if (string == null) {
                PsiMethodTreeElement.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "";
    }

    @Override
    public String getLocationPrefix() {
        return " ";
    }

    @Override
    public String getLocationSuffix() {
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/structureView/impl/java/PsiMethodTreeElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlphaSortKey";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

