/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.structureView.impl.java.AccessLevelProvider;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuperTypeGroup
implements Group,
ItemPresentation,
AccessLevelProvider {
    private final SmartPsiElementPointer mySuperClassPointer;
    private final OwnershipType myOverrides;
    private final Collection<TreeElement> myChildren = new ArrayList<TreeElement>();

    public SuperTypeGroup(PsiClass superClass, OwnershipType type) {
        this.myOverrides = type;
        this.mySuperClassPointer = SmartPointerManager.getInstance((Project)superClass.getProject()).createSmartPsiElementPointer((PsiElement)superClass);
    }

    @NotNull
    public Collection<TreeElement> getChildren() {
        Collection<TreeElement> collection = this.myChildren;
        if (collection == null) {
            SuperTypeGroup.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @Nullable
    private PsiClass getSuperClass() {
        return (PsiClass)this.mySuperClassPointer.getElement();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        SuperTypeGroup superTypeGroup = this;
        if (superTypeGroup == null) {
            SuperTypeGroup.$$$reportNull$$$0(1);
        }
        return superTypeGroup;
    }

    public Icon getIcon(boolean open) {
        return switch (this.myOverrides.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> AllIcons.General.ImplementingMethod;
            case 2 -> AllIcons.General.InheritedMethod;
            case 1 -> AllIcons.General.OverridingMethod;
        };
    }

    public String getPresentableText() {
        return this.toString();
    }

    public String toString() {
        PsiClass superClass = this.getSuperClass();
        return superClass != null ? superClass.getName() : StructureViewBundle.message((String)"node.structureview.invalid", (Object[])new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SuperTypeGroup)) return false;
        SuperTypeGroup superTypeGroup = (SuperTypeGroup)o;
        if (this.myOverrides != superTypeGroup.myOverrides) return false;
        if (!Objects.equals(this.getSuperClass(), superTypeGroup.getSuperClass())) return false;
        return true;
    }

    public int hashCode() {
        PsiClass superClass = this.getSuperClass();
        return superClass != null ? superClass.hashCode() : 0;
    }

    public Object getValue() {
        return this;
    }

    @Override
    public int getAccessLevel() {
        PsiClass superClass = this.getSuperClass();
        PsiModifierList modifierList = superClass == null ? null : superClass.getModifierList();
        return modifierList == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList);
    }

    @Override
    public int getSubLevel() {
        return 1;
    }

    public void addMethod(TreeElement superMethod) {
        this.myChildren.add(superMethod);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/structureView/impl/java/SuperTypeGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static enum OwnershipType {
        IMPLEMENTS,
        OVERRIDES,
        INHERITS;

    }
}

