/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ThreeState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightVirtualFile
extends LightVirtualFileBase {
    private CharSequence myContent;
    private Language myLanguage;
    private long myCachedLength;

    public LightVirtualFile() {
        this("");
    }

    public LightVirtualFile(@NlsSafe @NotNull String name) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(0);
        }
        this(name, "");
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @NotNull CharSequence content) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(1);
        }
        if (content == null) {
            LightVirtualFile.$$$reportNull$$$0(2);
        }
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @Nullable FileType fileType, @NotNull CharSequence text) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(3);
        }
        if (text == null) {
            LightVirtualFile.$$$reportNull$$$0(4);
        }
        this(name, fileType, text, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(@NotNull VirtualFile original, @NotNull CharSequence text, long modificationStamp) {
        if (original == null) {
            LightVirtualFile.$$$reportNull$$$0(5);
        }
        if (text == null) {
            LightVirtualFile.$$$reportNull$$$0(6);
        }
        this(original.getName(), original.getFileType(), text, modificationStamp);
        this.setCharset(original.getCharset());
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @Nullable FileType fileType, @NotNull CharSequence text, long modificationStamp) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(7);
        }
        if (text == null) {
            LightVirtualFile.$$$reportNull$$$0(8);
        }
        this(name, fileType, text, CharsetUtil.extractCharsetFromFileContent(null, null, fileType, text), modificationStamp);
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @Nullable FileType fileType, @NlsSafe @NotNull CharSequence text, @Nullable Charset charset, long modificationStamp) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(9);
        }
        if (text == null) {
            LightVirtualFile.$$$reportNull$$$0(10);
        }
        this(name, fileType, text, charset, modificationStamp, DEFAULT_CREATION_TRACE);
    }

    public LightVirtualFile(@NlsSafe @NotNull String name, @NotNull Language language, @NlsSafe @NotNull CharSequence text) {
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(11);
        }
        if (language == null) {
            LightVirtualFile.$$$reportNull$$$0(12);
        }
        if (text == null) {
            LightVirtualFile.$$$reportNull$$$0(13);
        }
        super(name, null, LocalTimeCounter.currentTime());
        this.myCachedLength = Long.MIN_VALUE;
        this.setContentImpl(text);
        this.setLanguage(language);
        this.setCharset(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    private LightVirtualFile(@NlsSafe @NotNull String name, @Nullable FileType fileType, @NlsSafe @NotNull CharSequence text, @Nullable Charset charset, long modificationStamp, @Nullable Object object) {
        void creationTrace;
        if (name == null) {
            LightVirtualFile.$$$reportNull$$$0(14);
        }
        if (text == null) {
            LightVirtualFile.$$$reportNull$$$0(15);
        }
        super(name, fileType, modificationStamp, creationTrace);
        this.myCachedLength = Long.MIN_VALUE;
        this.setContentImpl(text);
        this.setCharset(charset);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void storeCharset(Charset charset) {
        super.storeCharset(charset);
        this.myCachedLength = Long.MIN_VALUE;
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(@NotNull Language language) {
        if (language == null) {
            LightVirtualFile.$$$reportNull$$$0(16);
        }
        this.myLanguage = language;
        FileType type = language.getAssociatedFileType();
        if (type == null) {
            type = FileTypeRegistry.getInstance().getFileTypeByFileName(this.getNameSequence());
        }
        this.setFileType(type);
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = VfsUtilCore.byteStreamSkippingBOM(this.doGetContent(), this);
        if (inputStream == null) {
            LightVirtualFile.$$$reportNull$$$0(17);
        }
        return inputStream;
    }

    @Override
    public long getLength() {
        long cachedLength = this.myCachedLength;
        if (cachedLength == Long.MIN_VALUE) {
            this.myCachedLength = cachedLength = super.getLength();
        }
        return cachedLength;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        this.assertWritable();
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                assert (LightVirtualFile.this.isWritable());
                LightVirtualFile.this.setModificationStamp(newModificationStamp);
                try {
                    LightVirtualFile.this.setContentImpl(this.toString(LightVirtualFile.this.getCharset().name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }, this);
        if (outputStream == null) {
            LightVirtualFile.$$$reportNull$$$0(18);
        }
        return outputStream;
    }

    @Override
    public byte @NotNull [] contentsToByteArray() throws IOException {
        long cachedLength = this.myCachedLength;
        if (FileSizeLimit.isTooLargeForContentLoading(cachedLength, FileUtilRt.getExtension((CharSequence)this.getNameSequence()).toString())) {
            throw new FileTooBigException("file too big, length = " + cachedLength);
        }
        return this.doGetContent();
    }

    private byte @NotNull [] doGetContent() {
        Charset charset = this.getCharset();
        String s = this.getContent().toString();
        byte[] result = s.getBytes(charset);
        byte[] bom = this.getBOM();
        byte[] byArray = bom == null ? result : ArrayUtil.mergeArrays((byte[])bom, (byte[])result);
        if (byArray == null) {
            LightVirtualFile.$$$reportNull$$$0(19);
        }
        return byArray;
    }

    public void setContent(Object requestor, @NotNull CharSequence content, boolean fireEvent) {
        if (content == null) {
            LightVirtualFile.$$$reportNull$$$0(20);
        }
        this.assertWritable();
        this.setContentImpl(content);
        this.setModificationStamp(LocalTimeCounter.currentTime());
    }

    private void setContentImpl(@NotNull CharSequence content) {
        if (content == null) {
            LightVirtualFile.$$$reportNull$$$0(21);
        }
        this.myContent = content;
        this.myCachedLength = Long.MIN_VALUE;
    }

    @NotNull
    public CharSequence getContent() {
        CharSequence charSequence = this.myContent;
        if (charSequence == null) {
            LightVirtualFile.$$$reportNull$$$0(22);
        }
        return charSequence;
    }

    @NotNull
    public ThreeState isTooLargeForIntelligence() {
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            LightVirtualFile.$$$reportNull$$$0(23);
        }
        return threeState;
    }

    public boolean shouldSkipEventSystem() {
        return false;
    }

    @Override
    public String toString() {
        return "LightVirtualFile: " + this.getPresentableUrl();
    }

    @Contract(value="null -> false")
    public static boolean shouldSkipEventSystem(@Nullable VirtualFile virtualFile) {
        return virtualFile instanceof LightVirtualFile && ((LightVirtualFile)virtualFile).shouldSkipEventSystem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightVirtualFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetContent";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "isTooLargeForIntelligence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setLanguage";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setContentImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        @NlsSafe
        @NotNull
        private String name = "";
        @NotNull
        private CharSequence content = "";
        @Nullable
        private FileType fileType;
        @Nullable
        private Language language;
        @Nullable
        private Charset charset;
        private long modificationStamp = LocalTimeCounter.currentTime();
        @Nullable
        private Object creationTrace = LightVirtualFileBase.DEFAULT_CREATION_TRACE;

        private Builder() {
        }

        @NotNull
        public Builder name(@NlsSafe @NotNull String name) {
            if (name == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.name = name;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder content(@NotNull CharSequence content) {
            if (content == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.content = content;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder fileType(@Nullable FileType fileType) {
            this.fileType = fileType;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder language(@NotNull Language language) {
            if (language == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.language = language;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder charset(@Nullable Charset charset) {
            this.charset = charset;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder modificationStamp(long modificationStamp) {
            this.modificationStamp = modificationStamp;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder creationTrace(@Nullable Object creationTrace) {
            this.creationTrace = creationTrace;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public LightVirtualFile build() {
            Charset cs = this.charset != null ? this.charset : CharsetUtil.extractCharsetFromFileContent(null, null, this.fileType, this.content);
            LightVirtualFile file = new LightVirtualFile(this.name, this.fileType, this.content, cs, this.modificationStamp, this.creationTrace);
            if (this.language != null) {
                file.setLanguage(this.language);
            }
            LightVirtualFile lightVirtualFile = file;
            if (lightVirtualFile == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return lightVirtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/LightVirtualFile$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/LightVirtualFile$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "content";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "language";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "charset";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "modificationStamp";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "creationTrace";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "name";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "content";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "language";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

